<?php
/**
 * ContactApi
 * PHP version 5
 *
 * @category Class
 * @package  SMSGatewayMe\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
/**
 *  Copyright 2016 SmartBear Software
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program. 
 * https://github.com/swagger-api/swagger-codegen 
 * Do not edit the class manually.
 */

namespace SMSGatewayMe\Client\Api;

use \SMSGatewayMe\Client\Configuration;
use \SMSGatewayMe\Client\ApiClient;
use \SMSGatewayMe\Client\ApiException;
use \SMSGatewayMe\Client\ObjectSerializer;

/**
 * ContactApi Class Doc Comment
 *
 * @category Class
 * @package  SMSGatewayMe\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ContactApi
{

    /**
     * API Client
     * @var \SMSGatewayMe\Client\ApiClient instance of the ApiClient
     */
    protected $apiClient;
  
    /**
     * Constructor
     * @param \SMSGatewayMe\Client\ApiClient|null $apiClient The api client to use
     */
    function __construct($apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://smsgateway.me/api/v4');
        }
  
        $this->apiClient = $apiClient;
    }
  
    /**
     * Get API client
     * @return \SMSGatewayMe\Client\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }
  
    /**
     * Set the API client
     * @param \SMSGatewayMe\Client\ApiClient $apiClient set the API client
     * @return ContactApi
     */
    public function setApiClient(ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }
  
    
    /**
     * addPhoneNumber
     *
     * The phone number to add
     *
     * @param string $id  (required)
     * @param string $phoneNumber phone number to add (required)
     * @return \SMSGatewayMe\Client\Model\Contact
     * @throws \SMSGatewayMe\Client\ApiException on non-2xx response
     */
    public function addPhoneNumber($id, $phoneNumber)
    {
        list($response, $statusCode, $httpHeader) = $this->addPhoneNumberWithHttpInfo ($id, $phoneNumber);
        return $response; 
    }


    /**
     * addPhoneNumberWithHttpInfo
     *
     * The phone number to add
     *
     * @param string $id  (required)
     * @param string $phoneNumber phone number to add (required)
     * @return Array of \SMSGatewayMe\Client\Model\Contact, HTTP status code, HTTP response headers (array of strings)
     * @throws \SMSGatewayMe\Client\ApiException on non-2xx response
     */
    public function addPhoneNumberWithHttpInfo($id, $phoneNumber)
    {
        
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling addPhoneNumber');
        }
        // verify the required parameter 'phoneNumber' is set
        if ($phoneNumber === null) {
            throw new \InvalidArgumentException('Missing the required parameter $phoneNumber when calling addPhoneNumber');
        }
  
        // parse inputs
        $resourcePath = "/contact/{id}/phone-number/{phone-number}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array());
  
        
        
        // path params
        
        if ($id !== null) {
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        }// path params
        
        if ($phoneNumber !== null) {
            $resourcePath = str_replace(
                "{" . "phone-number" . "}",
                $this->apiClient->getSerializer()->toPathValue($phoneNumber),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires API key authentication
        $apiKey = $this->apiClient->getApiKeyWithPrefix('Authorization');
        if (strlen($apiKey) !== 0) {
            $headerParams['Authorization'] = $apiKey;
        }
        
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'PUT',
                $queryParams, $httpBody,
                $headerParams, '\SMSGatewayMe\Client\Model\Contact'
            );
            
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SMSGatewayMe\Client\ObjectSerializer::deserialize($response, '\SMSGatewayMe\Client\Model\Contact', $httpHeader), $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\Contact', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 400:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 401:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 403:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 500:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\FatalResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            default:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\FatalResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    
    /**
     * createContacts
     *
     * Create Contacts
     *
     * @param \SMSGatewayMe\Client\Model\CreateContactRequest[] $contacts contacts to create (required)
     * @return \SMSGatewayMe\Client\Model\Contact[]
     * @throws \SMSGatewayMe\Client\ApiException on non-2xx response
     */
    public function createContacts($contacts)
    {
        list($response, $statusCode, $httpHeader) = $this->createContactsWithHttpInfo ($contacts);
        return $response; 
    }


    /**
     * createContactsWithHttpInfo
     *
     * Create Contacts
     *
     * @param \SMSGatewayMe\Client\Model\CreateContactRequest[] $contacts contacts to create (required)
     * @return Array of \SMSGatewayMe\Client\Model\Contact[], HTTP status code, HTTP response headers (array of strings)
     * @throws \SMSGatewayMe\Client\ApiException on non-2xx response
     */
    public function createContactsWithHttpInfo($contacts)
    {
        
        // verify the required parameter 'contacts' is set
        if ($contacts === null) {
            throw new \InvalidArgumentException('Missing the required parameter $contacts when calling createContacts');
        }
  
        // parse inputs
        $resourcePath = "/contact";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array());
  
        
        
        
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // body params
        $_tempBody = null;
        if (isset($contacts)) {
            $_tempBody = $contacts;
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires API key authentication
        $apiKey = $this->apiClient->getApiKeyWithPrefix('Authorization');
        if (strlen($apiKey) !== 0) {
            $headerParams['Authorization'] = $apiKey;
        }
        
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\SMSGatewayMe\Client\Model\Contact[]'
            );
            
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SMSGatewayMe\Client\ObjectSerializer::deserialize($response, '\SMSGatewayMe\Client\Model\Contact[]', $httpHeader), $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\Contact[]', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 400:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 401:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 403:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 500:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\FatalResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            default:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\FatalResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    
    /**
     * deletePhoneNumber
     *
     * The phone number to delete
     *
     * @param string $id  (required)
     * @param string $phoneNumber phone number to add (required)
     * @return \SMSGatewayMe\Client\Model\Contact
     * @throws \SMSGatewayMe\Client\ApiException on non-2xx response
     */
    public function deletePhoneNumber($id, $phoneNumber)
    {
        list($response, $statusCode, $httpHeader) = $this->deletePhoneNumberWithHttpInfo ($id, $phoneNumber);
        return $response; 
    }


    /**
     * deletePhoneNumberWithHttpInfo
     *
     * The phone number to delete
     *
     * @param string $id  (required)
     * @param string $phoneNumber phone number to add (required)
     * @return Array of \SMSGatewayMe\Client\Model\Contact, HTTP status code, HTTP response headers (array of strings)
     * @throws \SMSGatewayMe\Client\ApiException on non-2xx response
     */
    public function deletePhoneNumberWithHttpInfo($id, $phoneNumber)
    {
        
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling deletePhoneNumber');
        }
        // verify the required parameter 'phoneNumber' is set
        if ($phoneNumber === null) {
            throw new \InvalidArgumentException('Missing the required parameter $phoneNumber when calling deletePhoneNumber');
        }
  
        // parse inputs
        $resourcePath = "/contact/{id}/phone-number/{phone-number}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array());
  
        
        
        // path params
        
        if ($id !== null) {
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        }// path params
        
        if ($phoneNumber !== null) {
            $resourcePath = str_replace(
                "{" . "phone-number" . "}",
                $this->apiClient->getSerializer()->toPathValue($phoneNumber),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires API key authentication
        $apiKey = $this->apiClient->getApiKeyWithPrefix('Authorization');
        if (strlen($apiKey) !== 0) {
            $headerParams['Authorization'] = $apiKey;
        }
        
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'DELETE',
                $queryParams, $httpBody,
                $headerParams, '\SMSGatewayMe\Client\Model\Contact'
            );
            
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SMSGatewayMe\Client\ObjectSerializer::deserialize($response, '\SMSGatewayMe\Client\Model\Contact', $httpHeader), $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\Contact', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 400:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 401:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 403:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 500:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\FatalResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            default:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\FatalResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    
    /**
     * getContact
     *
     * Get a specific contact
     *
     * @param string $id  (required)
     * @return \SMSGatewayMe\Client\Model\Contact
     * @throws \SMSGatewayMe\Client\ApiException on non-2xx response
     */
    public function getContact($id)
    {
        list($response, $statusCode, $httpHeader) = $this->getContactWithHttpInfo ($id);
        return $response; 
    }


    /**
     * getContactWithHttpInfo
     *
     * Get a specific contact
     *
     * @param string $id  (required)
     * @return Array of \SMSGatewayMe\Client\Model\Contact, HTTP status code, HTTP response headers (array of strings)
     * @throws \SMSGatewayMe\Client\ApiException on non-2xx response
     */
    public function getContactWithHttpInfo($id)
    {
        
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling getContact');
        }
  
        // parse inputs
        $resourcePath = "/contact/{id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array());
  
        
        
        // path params
        
        if ($id !== null) {
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires API key authentication
        $apiKey = $this->apiClient->getApiKeyWithPrefix('Authorization');
        if (strlen($apiKey) !== 0) {
            $headerParams['Authorization'] = $apiKey;
        }
        
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'GET',
                $queryParams, $httpBody,
                $headerParams, '\SMSGatewayMe\Client\Model\Contact'
            );
            
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SMSGatewayMe\Client\ObjectSerializer::deserialize($response, '\SMSGatewayMe\Client\Model\Contact', $httpHeader), $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\Contact', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 400:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 401:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 403:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 500:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\FatalResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            default:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\FatalResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    
    /**
     * searchContacts
     *
     * Search contacts
     *
     * @param \SMSGatewayMe\Client\Model\Search $search Search Criteria (optional)
     * @return \SMSGatewayMe\Client\Model\ContactSearchResult
     * @throws \SMSGatewayMe\Client\ApiException on non-2xx response
     */
    public function searchContacts($search = null)
    {
        list($response, $statusCode, $httpHeader) = $this->searchContactsWithHttpInfo ($search);
        return $response; 
    }


    /**
     * searchContactsWithHttpInfo
     *
     * Search contacts
     *
     * @param \SMSGatewayMe\Client\Model\Search $search Search Criteria (optional)
     * @return Array of \SMSGatewayMe\Client\Model\ContactSearchResult, HTTP status code, HTTP response headers (array of strings)
     * @throws \SMSGatewayMe\Client\ApiException on non-2xx response
     */
    public function searchContactsWithHttpInfo($search = null)
    {
        
  
        // parse inputs
        $resourcePath = "/contact/search";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array());
  
        
        
        
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // body params
        $_tempBody = null;
        if (isset($search)) {
            $_tempBody = $search;
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires API key authentication
        $apiKey = $this->apiClient->getApiKeyWithPrefix('Authorization');
        if (strlen($apiKey) !== 0) {
            $headerParams['Authorization'] = $apiKey;
        }
        
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\SMSGatewayMe\Client\Model\ContactSearchResult'
            );
            
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SMSGatewayMe\Client\ObjectSerializer::deserialize($response, '\SMSGatewayMe\Client\Model\ContactSearchResult', $httpHeader), $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ContactSearchResult', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 400:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 401:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 403:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 500:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\FatalResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            default:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\FatalResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    
    /**
     * updateContact
     *
     * Update contact
     *
     * @param string $id  (required)
     * @param \SMSGatewayMe\Client\Model\UpdateContactRequest $contact contacts details (required)
     * @return \SMSGatewayMe\Client\Model\Contact
     * @throws \SMSGatewayMe\Client\ApiException on non-2xx response
     */
    public function updateContact($id, $contact)
    {
        list($response, $statusCode, $httpHeader) = $this->updateContactWithHttpInfo ($id, $contact);
        return $response; 
    }


    /**
     * updateContactWithHttpInfo
     *
     * Update contact
     *
     * @param string $id  (required)
     * @param \SMSGatewayMe\Client\Model\UpdateContactRequest $contact contacts details (required)
     * @return Array of \SMSGatewayMe\Client\Model\Contact, HTTP status code, HTTP response headers (array of strings)
     * @throws \SMSGatewayMe\Client\ApiException on non-2xx response
     */
    public function updateContactWithHttpInfo($id, $contact)
    {
        
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling updateContact');
        }
        // verify the required parameter 'contact' is set
        if ($contact === null) {
            throw new \InvalidArgumentException('Missing the required parameter $contact when calling updateContact');
        }
  
        // parse inputs
        $resourcePath = "/contact/{id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array());
  
        
        
        // path params
        
        if ($id !== null) {
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // body params
        $_tempBody = null;
        if (isset($contact)) {
            $_tempBody = $contact;
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires API key authentication
        $apiKey = $this->apiClient->getApiKeyWithPrefix('Authorization');
        if (strlen($apiKey) !== 0) {
            $headerParams['Authorization'] = $apiKey;
        }
        
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'PUT',
                $queryParams, $httpBody,
                $headerParams, '\SMSGatewayMe\Client\Model\Contact'
            );
            
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SMSGatewayMe\Client\ObjectSerializer::deserialize($response, '\SMSGatewayMe\Client\Model\Contact', $httpHeader), $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\Contact', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 400:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 401:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 403:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 500:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\FatalResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            default:
                $data = \SMSGatewayMe\Client\ObjectSerializer::deserialize($e->getResponseBody(), '\SMSGatewayMe\Client\Model\FatalResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    
}
