<?php
    $color = isset($setting['color']) ? $setting['color'] : 'theme-3';
    $flag = isset($setting['color_flag']) ? $setting['color_flag'] : 'false';
?>


<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('System Settings ')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('System Settings')); ?></li>
<?php $__env->stopSection(); ?>

<?php if($color == 'theme-1'): ?>
    <style>
        .btn-check:checked+.btn-outline-success,
        .btn-check:active+.btn-outline-success,
        .btn-outline-success:active,
        .btn-outline-success.active,
        .btn-outline-success.dropdown-toggle.show {
            color: #ffffff;
            background: linear-gradient(141.55deg, rgba(81, 69, 157, 0) 3.46%, rgba(255, 58, 110, 0.6) 99.86%), #51459d !important;
            border-color: #51459d !important;

        }

        .btn-outline-success:hover {
            color: #ffffff;
            background: linear-gradient(141.55deg, rgba(81, 69, 157, 0) 3.46%, rgba(255, 58, 110, 0.6) 99.86%), #51459d !important;
            border-color: #51459d !important;
        }

        .btn.btn-outline-success {
            color: #51459d;
            border-color: #51459d !important;
        }
    </style>
<?php endif; ?>

<?php if($color == 'theme-2'): ?>
    <style>
        .btn-check:checked+.btn-outline-success,
        .btn-check:active+.btn-outline-success,
        .btn-outline-success:active,
        .btn-outline-success.active,
        .btn-outline-success.dropdown-toggle.show {
            color: #ffffff;
            background: linear-gradient(141.55deg, rgba(240, 244, 243, 0) 3.46%, #4ebbd3 99.86%)#1f3996 !important;
            border-color: #1F3996 !important;

        }

        .btn-outline-success:hover {
            color: #ffffff;
            background: linear-gradient(141.55deg, rgba(240, 244, 243, 0) 3.46%, #4ebbd3 99.86%)#1f3996 !important;
            border-color: #1F3996 !important;
        }

        .btn.btn-outline-success {
            color: #1F3996;
            border-color: #1F3996 !important;
        }
    </style>
<?php endif; ?>

<?php if($color == 'theme-4'): ?>
    <style>
        .btn-check:checked+.btn-outline-success,
        .btn-check:active+.btn-outline-success,
        .btn-outline-success:active,
        .btn-outline-success.active,
        .btn-outline-success.dropdown-toggle.show {
            color: #ffffff;
            background-color: #584ed2 !important;
            border-color: #584ed2 !important;

        }

        .btn-outline-success:hover {
            color: #ffffff;
            background-color: #584ed2 !important;
            border-color: #584ed2 !important;
        }

        .btn.btn-outline-success {
            color: #584ed2;
            border-color: #584ed2 !important;
        }
    </style>
<?php endif; ?>

<?php if($color == 'theme-3'): ?>
    <style>
        .btn-check:checked+.btn-outline-success,
        .btn-check:active+.btn-outline-success,
        .btn-outline-success:active,
        .btn-outline-success.active,
        .btn-outline-success.dropdown-toggle.show {
            color: #ffffff;
            background-color: #6fd943 !important;
            border-color: #6fd943 !important;

        }

        .btn-outline-success:hover {
            color: #ffffff;
            background-color: #6fd943 !important;
            border-color: #6fd943 !important;
        }

        .btn.btn-outline-success {
            color: #6fd943;
            border-color: #6fd943 !important;
        }
    </style>
    <style>
        .radio-button-group .radio-button {
            position: absolute;
            width: 1px;
            height: 1px;
            opacity: 0;
        }
    </style>
<?php endif; ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-sm-12">
            <div class="row">
                <div class="col-xl-3">
                    <div class="card sticky-top setting-sidebar" style="top:30px">
                        <div class="list-group list-group-flush" id="useradd-sidenav">
                            <?php echo getCompanySettingMenu(); ?>

                        </div>
                    </div>
                </div>
                <div class="col-xl-9 setting-menu-div">
                    
                    <div id="logo-settings" class="card">
                        <div class="card-header">
                            <h5><?php echo e(__('Brand settings')); ?></h5>
                        </div>
                        <form action="<?php echo e(route('admin.settings.store')); ?>" method="post" enctype="multipart/form-data"
                            class="needs-validation" novalidate>
                            <?php echo csrf_field(); ?>
                            <div class="card-body">
                                <div class="row row-gap-1 mb-4">
                                    <div class="col-lg-4 col-sm-6 col-12">
                                        <div class="card mb-0">
                                            <div class="card-header">
                                                <h5 class="small-title"><?php echo e(__('Dark Logo')); ?></h5>
                                            </div>
                                            <div class="card-body">
                                                <div class="setting-card setting-logo-box">
                                                    <a href="<?php echo e(isset($setting['dark_logo']) && checkFile($setting['dark_logo']) ? getFile($setting['dark_logo']) : getFile('uploads/logo/logo-dark.png') . '?' . time()); ?>"
                                                        target="_blank" class="logo-content">
                                                        <img id="blah2" alt="your image"
                                                            src="<?php echo e(isset($setting['dark_logo']) && checkFile($setting['dark_logo']) ? getFile($setting['dark_logo']) : getFile('uploads/logo/logo-dark.png') . '?' . time()); ?>"
                                                            width="150px" class="logo logo-sm">
                                                    </a>
                                                    <div class="choose-files mt-3">
                                                        <label for="logo" class="form-label d-block mb-0">
                                                            <div class="bg-primary m-auto">
                                                                <i
                                                                    class="ti ti-upload px-1"></i><?php echo e(__('Choose file here')); ?>

                                                                <input type="file" name="dark_logo" id="logo"
                                                                    class="form-control file"
                                                                    data-filename="company_logo_update"
                                                                    onchange="document.getElementById('blah2').src = window.URL.createObjectURL(this.files[0])">
                                                            </div>
                                                        </label>
                                                        <!-- <p class="edit-logo"></p> -->
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-sm-6 col-12">
                                        <div class="card mb-0">
                                            <div class="card-header">
                                                <h5 class="small-title"><?php echo e(__('Light Logo')); ?></h5>
                                            </div>
                                            <div class="card-body">
                                                <div class="setting-card setting-logo-box">
                                                    <a href="<?php echo e(isset($setting['light_logo']) && checkFile($setting['light_logo']) ? getFile($setting['light_logo']) : getFile('uploads/logo/logo-light.png') . '?' . time()); ?>"
                                                        target="_blank" class="logo-content">
                                                        <img id="blah3" alt="your image"
                                                            src="<?php echo e(isset($setting['light_logo']) && checkFile($setting['light_logo']) ? getFile($setting['light_logo']) : getFile('uploads/logo/logo-light.png') . '?' . time()); ?>"
                                                            width="150px" class="logo logo-sm img_setting"
                                                            style="filter: drop-shadow(2px 3px 7px #011c4b);">
                                                    </a>
                                                    <div class="choose-files mt-3">
                                                        <label for="white_logo" class="form-label d-block mb-0">
                                                            <div class=" bg-primary m-auto">
                                                                <i
                                                                    class="ti ti-upload px-1"></i><?php echo e(__('Choose file here')); ?>

                                                                <input type="file" name="light_logo" id="white_logo"
                                                                    class="form-control file"
                                                                    data-filename="company_logo_update"
                                                                    onchange="document.getElementById('blah3').src = window.URL.createObjectURL(this.files[0])">
                                                            </div>
                                                        </label>
                                                        <!-- <p class="edit-white_logo"></p> -->
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-sm-6 col-12">
                                        <div class="card mb-0">
                                            <div class="card-header">
                                                <h5 class="small-title"><?php echo e(__('Favicon')); ?></h5>
                                            </div>
                                            <div class="card-body ">
                                                <div class="setting-card setting-logo-box">
                                                    <a href="<?php echo e(isset($setting['favicon']) && checkFile($setting['favicon']) ? getFile($setting['favicon']) : getFile('uploads/logo/favicon.png') . '?' . time()); ?>"
                                                        target="_blank" class="logo-content">
                                                        <img id="blah" alt="your image"
                                                            src="<?php echo e(isset($setting['favicon']) && checkFile($setting['favicon']) ? getFile($setting['favicon']) : getFile('uploads/logo/favicon.png') . '?' . time()); ?>"
                                                            width="80px" class="big-logo img_setting">
                                                    </a>
                                                    <div class="choose-files mt-3">
                                                        <label for="favicon" class="form-label d-block mb-0">
                                                            <div class=" bg-primary m-auto">
                                                                <i
                                                                    class="ti ti-upload px-1"></i><?php echo e(__('Choose file here')); ?>

                                                                <input type="file" name="favicon" id="favicon"
                                                                    class="form-control file"
                                                                    data-filename="company_logo_update"
                                                                    onchange="document.getElementById('blah').src = window.URL.createObjectURL(this.files[0])">
                                                            </div>
                                                        </label>
                                                        <!-- <p class="edit-favicon"></p> -->
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row row-gap-1">
                                    <div class="col-md-6 col-12">
                                        <div class="form-group mb-0">
                                            <label for="app_name" class="form-label"><?php echo e(__('App Name')); ?></label>
                                            <input type="text" name="app_name" id="APP_NAME" class="form-control"
                                                placeholder="<?php echo e(__('App Name')); ?>"
                                                value="<?php echo e(isset($setting['app_name']) ? $setting['app_name'] : config('app.name')); ?>"
                                                required>

                                            <?php if($errors->has('app_name')): ?>
                                                <div class="text-danger my-2">
                                                    <?php echo e($errors->first('app_name')); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <div class="form-group mb-0">
                                            <label for="footer_text" class="form-label"><?php echo e(__('Footer Text')); ?></label>
                                            <input type="text" name="footer_text" id="footer_text" class="form-control"
                                                placeholder="<?php echo e(__('Footer Text')); ?>"
                                                value="<?php echo e(!empty($setting['footer_text']) ? $setting['footer_text'] : ''); ?>"
                                                required>

                                            <?php if($errors->has('footer_text')): ?>
                                                <div class="text-danger">
                                                    <?php echo e($errors->first('footer_text')); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <?php
                                        $defaultSelectedLang = isset($setting['default_language'])
                                            ? $setting['default_language']
                                            : 'en';
                                    ?>
                                    <div class="col-md-6 col-12">
                                        <div class="form-group mb-0">
                                            <label for="default_language"
                                                class="form-label"><?php echo e(__('Default Language')); ?></label>
                                            <div class="changeLanguage">
                                                <select name="default_language" id="default_language" class="form-select"
                                                    required>
                                                    <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option <?php if($defaultSelectedLang == $code): ?> selected <?php endif; ?>
                                                            value="<?php echo e($code); ?>">
                                                            <?php echo e(Str::ucfirst($language)); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <?php if($errors->has('default_language')): ?>
                                                <div class="text-danger">
                                                    <?php echo e($errors->first('default_language')); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <div class="form-group mb-0">
                                            <label for="timezone" class="form-label"><?php echo e(__('Timezone')); ?></label>
                                            <select name="timezone" id="timezone" class="form-control custom-select"
                                                required>
                                                <option value=""><?php echo e(__('Select Timezone')); ?>

                                                </option>
                                                <?php $__currentLoopData = $timezones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php echo e(isset($setting['timezone']) && $setting['timezone'] == $k ? 'selected' : ''); ?> value="<?php echo e($k); ?>">
                                                        <?php echo e($timezone); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <?php if($errors->has('timezone')): ?>
                                                <div class="text-danger my-2">
                                                    <?php echo e($errors->first('timezone')); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="card-body border-1 border-top ">
                                <div class="setting-card setting-logo-box">
                                    <h4 class="small-title h5 mb-3"><?php echo e(__('Theme Customizer')); ?></h4>
                                    <div class="row row-gap-1">
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="card h-100 mb-0">
                                                <div class="card-header">
                                                    <h6 class="d-flex align-items-center gap-2 mb-0">
                                                        <i data-feather="credit-card"></i><?php echo e(__('Primary color settings')); ?>

                                                    </h6>
                                                </div>
                                                <div class="card-body">
                                                    <div class="color-wrp m-0">
                                                        <div class="theme-color themes-color">
                                                            <a href="#!"
                                                                class="themes-color-change <?php echo e($color == 'theme-1' ? 'active_color' : ''); ?>"
                                                                data-value="theme-1"></a>
                                                            <input type="radio" class="theme_color d-none" name="color"
                                                                value="theme-1" <?php echo e($color == 'theme-1' ? 'checked' : ''); ?>>
                                                            <a href="#!"
                                                                class="themes-color-change <?php echo e($color == 'theme-2' ? 'active_color' : ''); ?>"
                                                                data-value="theme-2"></a>
                                                            <input type="radio" class="theme_color d-none" name="color"
                                                                value="theme-2" <?php echo e($color == 'theme-2' ? 'checked' : ''); ?>>
                                                            <a href="#!"
                                                                class="themes-color-change <?php echo e($color == 'theme-3' ? 'active_color' : ''); ?>"
                                                                data-value="theme-3"></a>
                                                            <input type="radio" class="theme_color d-none" name="color"
                                                                value="theme-3" <?php echo e($color == 'theme-3' ? 'checked' : ''); ?>>
                                                            <a href="#!"
                                                                class="themes-color-change <?php echo e($color == 'theme-4' ? 'active_color' : ''); ?>"
                                                                data-value="theme-4"></a>
                                                            <input type="radio" class="theme_color d-none" name="color"
                                                                value="theme-4" <?php echo e($color == 'theme-4' ? 'checked' : ''); ?>>
                                                            <a href="#!"
                                                                class="themes-color-change <?php echo e($color == 'theme-5' ? 'active_color' : ''); ?>"
                                                                data-value="theme-5"></a>
                                                            <input type="radio" class="theme_color d-none" name="color"
                                                                value="theme-5" <?php echo e($color == 'theme-5' ? 'checked' : ''); ?>>
                                                            <a href="#!"
                                                                class="themes-color-change <?php echo e($color == 'theme-6' ? 'active_color' : ''); ?>"
                                                                data-value="theme-6"></a>
                                                            <input type="radio" class="theme_color d-none" name="color"
                                                                value="theme-6" <?php echo e($color == 'theme-6' ? 'checked' : ''); ?>>
                                                            <a href="#!"
                                                                class="themes-color-change <?php echo e($color == 'theme-7' ? 'active_color' : ''); ?>"
                                                                data-value="theme-7"></a>
                                                            <input type="radio" class="theme_color d-none" name="color"
                                                                value="theme-7" <?php echo e($color == 'theme-7' ? 'checked' : ''); ?>>
                                                            <a href="#!"
                                                                class="themes-color-change <?php echo e($color == 'theme-8' ? 'active_color' : ''); ?>"
                                                                data-value="theme-8"></a>
                                                            <input type="radio" class="theme_color d-none" name="color"
                                                                value="theme-8" <?php echo e($color == 'theme-8' ? 'checked' : ''); ?>>
                                                            <a href="#!"
                                                                class="themes-color-change <?php echo e($color == 'theme-9' ? 'active_color' : ''); ?>"
                                                                data-value="theme-9"></a>
                                                            <input type="radio" class="theme_color d-none" name="color"
                                                                value="theme-9" <?php echo e($color == 'theme-9' ? 'checked' : ''); ?>>
                                                            <a href="#!"
                                                                class="themes-color-change <?php echo e($color == 'theme-10' ? 'active_color' : ''); ?>"
                                                                data-value="theme-10"></a>
                                                            <input type="radio" class="theme_color d-none" name="color"
                                                                value="theme-10" <?php echo e($color == 'theme-10' ? 'checked' : ''); ?>>
                                                        </div>
                                                        <div class="color-picker-wrp ">
                                                            <input type="color" value="<?php echo e($color ? $color : ''); ?>"
                                                                class="colorPicker <?php echo e(isset($flag) && $flag == 'true' ? 'active_color' : ''); ?>"
                                                                name="custom_color" id="color-picker">
                                                            <input type='hidden' name="color_flag" value=<?php echo e(isset($flag) && $flag == 'true' ? 'true' : 'false'); ?>>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="card h-100 mb-0">
                                                <div class="card-header">
                                                    <h6 class="d-flex align-items-center mb-0 gap-2">
                                                        <i data-feather="layout"></i><?php echo e(__('Sidebar settings')); ?>

                                                    </h6>
                                                </div>
                                                <div class="card-body">
                                                    <div class="form-check form-switch d-flex gap-2 flex-column p-0">
                                                        <label class="form-check-label f-w-600"
                                                            for="cust-theme-bg"><?php echo e(__('Transparent layout')); ?>

                                                        </label>

                                                        <input type="checkbox" class="form-check-input ms-0"
                                                            id="cust-theme-bg" name="cust_theme_bg" <?php echo e(isset($setting['cust_theme_bg']) && $setting['cust_theme_bg'] == 'on' ? 'checked' : ''); ?> />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="card h-100 mb-0">
                                                <div class="card-header">
                                                    <h6 class="d-flex align-items-center mb-0 gap-2">
                                                        <i data-feather="sun"></i><?php echo e(__('Layout settings')); ?>

                                                    </h6>
                                                </div>
                                                <div class="card-body">
                                                    <div class="form-check form-switch d-flex gap-2 flex-column p-0">
                                                        <label class="form-check-label f-w-600"
                                                            for="cust-darklayout"><?php echo e(__('Dark Layout')); ?>

                                                        </label>
                                                        <input type="checkbox" class="form-check-input ms-0"
                                                            id="cust-darklayout" name="cust_darklayout" <?php echo e(isset($setting['cust_darklayout']) && $setting['cust_darklayout'] == 'on' ? 'checked' : ''); ?> />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="card h-100 mb-0">
                                                <div class="card-header">
                                                    <h6 class="d-flex align-items-center mb-0 gap-2">
                                                        <i class="ti ti-align-right"></i>Enable RTL
                                                    </h6>
                                                </div>
                                                <div class="card-body">
                                                    <div class="form-check form-switch d-flex gap-2 flex-column p-0">
                                                        <label class="form-check-label f-w-600" for="site_rtl">RTL
                                                            Layout</label>
                                                        <input type="checkbox" class="form-check-input ms-0" name="site_rtl"
                                                            id="site_rtl" value='on' <?php echo e(isset($setting['site_rtl']) && $setting['site_rtl'] == 'on' ? 'checked="checked"' : ''); ?>>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="card h-100 mb-0">
                                                <div class="card-header">
                                                    <h6 class="d-flex align-items-center mb-0 gap-2">
                                                        <i class="ti ti-align-right"></i>Enable FAQ
                                                    </h6>
                                                </div>
                                                <div class="card-body">
                                                    <div class="form-check form-switch d-flex gap-2 flex-column p-0">
                                                        <label class="form-check-label f-w-600" for="faq">FAQ
                                                        </label>
                                                        <input type="checkbox" class="form-check-input ms-0" name="faq"
                                                            id="faq" <?php echo e(!empty($setting['faq']) && $setting['faq'] == 'on' ? 'checked="checked"' : ''); ?>>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="card h-100 mb-0">
                                                <div class="card-header">
                                                    <h6 class="d-flex align-items-center mb-0 gap-2">
                                                        <i class="ti ti-align-right"></i>Knowledge Base setting
                                                    </h6>
                                                </div>
                                                <div class="card-body">
                                                    <div class="form-check form-switch d-flex gap-2 flex-column p-0">
                                                        <label class="form-check-label f-w-600"
                                                            for="knowledge"><?php echo e(__('Knowledge Base')); ?>

                                                        </label>
                                                        <input type="checkbox" class="form-check-input ms-0"
                                                            name="knowledge_base" id="knowledge_base" <?php echo e(isset($setting['knowledge_base']) && $setting['knowledge_base'] == 'on' ? 'checked="checked"' : ''); ?>>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>



                                    </div>
                                </div>
                            </div>
                            <div class="card-footer text-end">
                                <button class="btn btn-primary" type="submit"><?php echo e(__('Save Changes')); ?></button>
                            </div>
                        </form>
                    </div>

                    
                    <div id="email-settings" class="card">
                        <div class="card-header">
                            <h5 class="mb-2"><?php echo e(__('Email Settings')); ?></h5>
                            <small><?php echo e(__('Edit your Email settings')); ?></small>
                        </div>
                        <form action="<?php echo e(route('admin.email.settings.store')); ?>" class="needs-validation" novalidate
                            method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="card-body">
                                <div class="row row-gap-1">
                                    <div class="col-md-4">
                                        <div class="form-group mb-0">
                                            <label class="form-label"><?php echo e(__('Mail Driver')); ?></label>
                                            <?php if (isset($component)) { $__componentOriginaleab1765d328ab3f8835fc5d78676a070 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaleab1765d328ab3f8835fc5d78676a070 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.required','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('required'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $attributes = $__attributesOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $component = $__componentOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__componentOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
                                            <input class="form-control" placeholder="<?php echo e(__('Mail Driver')); ?>"
                                                name="mail_driver" type="text"
                                                value="<?php echo e(isset($setting['mail_driver']) ? $setting['mail_driver'] : ''); ?>"
                                                id="mail_driver" required>

                                            <?php if($errors->has('mail_driver')): ?>
                                                <div class="text-danger my-2">
                                                    <?php echo e($errors->first('mail_driver')); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-0">
                                            <label class="form-label"><?php echo e(__('Mail Host')); ?></label>
                                            <?php if (isset($component)) { $__componentOriginaleab1765d328ab3f8835fc5d78676a070 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaleab1765d328ab3f8835fc5d78676a070 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.required','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('required'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $attributes = $__attributesOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $component = $__componentOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__componentOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
                                            <input class="form-control" placeholder="<?php echo e(__('Mail Host')); ?>" name="mail_host"
                                                type="text"
                                                value="<?php echo e(isset($setting['mail_host']) ? $setting['mail_host'] : ''); ?>"
                                                id="mail_host" required>
                                            <?php if($errors->has('mail_host')): ?>
                                                <div class="text-danger my-2">
                                                    <?php echo e($errors->first('mail_host')); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-0">
                                            <label class="form-label"><?php echo e(__('Mail Port')); ?></label>
                                            <?php if (isset($component)) { $__componentOriginaleab1765d328ab3f8835fc5d78676a070 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaleab1765d328ab3f8835fc5d78676a070 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.required','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('required'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $attributes = $__attributesOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $component = $__componentOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__componentOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
                                            <input class="form-control" placeholder="<?php echo e(__('Mail Port')); ?>" name="mail_port"
                                                type="text"
                                                value="<?php echo e(isset($setting['mail_port']) ? $setting['mail_port'] : ''); ?>"
                                                id="mail_port" required>
                                            <?php if($errors->has('mail_port')): ?>
                                                <div class="text-danger my-2">
                                                    <?php echo e($errors->first('mail_port')); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group mb-0">
                                            <label class="form-label"><?php echo e(__('Mail Username')); ?></label>
                                            <?php if (isset($component)) { $__componentOriginaleab1765d328ab3f8835fc5d78676a070 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaleab1765d328ab3f8835fc5d78676a070 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.required','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('required'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $attributes = $__attributesOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $component = $__componentOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__componentOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
                                            <input class="form-control" placeholder="<?php echo e(__('Mail Username')); ?>"
                                                name="mail_username" type="text"
                                                value="<?php echo e(isset($setting['mail_username']) ? $setting['mail_username'] : ''); ?>"
                                                id="mail_username" required>
                                            <?php if($errors->has('mail_username')): ?>
                                                <div class="text-danger my-2">
                                                    <?php echo e($errors->first('mail_username')); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-0">
                                            <label class="form-label"><?php echo e(__('Mail Password')); ?></label>
                                            <?php if (isset($component)) { $__componentOriginaleab1765d328ab3f8835fc5d78676a070 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaleab1765d328ab3f8835fc5d78676a070 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.required','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('required'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $attributes = $__attributesOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $component = $__componentOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__componentOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
                                            <input class="form-control" placeholder="<?php echo e(__('Mail Password')); ?>"
                                                name="mail_password" type="text"
                                                value="<?php echo e(isset($setting['mail_password']) ? $setting['mail_password'] : ''); ?>"
                                                id="mail_password" required>
                                            <?php if($errors->has('mail_password')): ?>
                                                <div class="text-danger my-2">
                                                    <?php echo e($errors->first('mail_password')); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-0">
                                            <label class="form-label"><?php echo e(__('Mail Encryption')); ?></label>
                                            <?php if (isset($component)) { $__componentOriginaleab1765d328ab3f8835fc5d78676a070 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaleab1765d328ab3f8835fc5d78676a070 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.required','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('required'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $attributes = $__attributesOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $component = $__componentOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__componentOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
                                            <input class="form-control" placeholder="<?php echo e(__('Mail Encryption')); ?>"
                                                name="mail_encryption" type="text"
                                                value="<?php echo e(isset($setting['mail_encryption']) ? $setting['mail_encryption'] : ''); ?>"
                                                id="mail_encryption" required>
                                            <?php if($errors->has('mail_encryption')): ?>
                                                <div class="text-danger my-2">
                                                    <?php echo e($errors->first('mail_encryption')); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group mb-0">
                                            <label class="form-label"><?php echo e(__('Mail From Address')); ?></label>
                                            <?php if (isset($component)) { $__componentOriginaleab1765d328ab3f8835fc5d78676a070 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaleab1765d328ab3f8835fc5d78676a070 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.required','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('required'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $attributes = $__attributesOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $component = $__componentOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__componentOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
                                            <input class="form-control" placeholder="<?php echo e(__('Mail From Address')); ?>"
                                                name="mail_from_address" type="text"
                                                value="<?php echo e(isset($setting['mail_from_address']) ? $setting['mail_from_address'] : ''); ?>"
                                                id="mail_from_address" required>
                                            <?php if($errors->has('mail_from_address')): ?>
                                                <div class="text-danger my-2">
                                                    <?php echo e($errors->first('mail_from_address')); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-0">
                                            <label class="form-label"><?php echo e(__('Mail From Name')); ?></label>
                                            <?php if (isset($component)) { $__componentOriginaleab1765d328ab3f8835fc5d78676a070 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaleab1765d328ab3f8835fc5d78676a070 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.required','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('required'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $attributes = $__attributesOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $component = $__componentOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__componentOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
                                            <input class="form-control" placeholder="<?php echo e(__('Mail From Name')); ?>"
                                                name="mail_from_name" type="text"
                                                value="<?php echo e(isset($setting['mail_from_name']) ? $setting['mail_from_name'] : ''); ?>"
                                                id="mail_from_name" required>
                                            <?php if($errors->has('mail_from_name')): ?>
                                                <div class="text-danger my-2">
                                                    <?php echo e($errors->first('mail_from_name')); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer d-flex justify-content-end gap-3 align-items-center flex-wrap">
                                <div class="form-group mb-0">
                                    <a href="#" data-url="<?php echo e(route('admin.test.email')); ?>"
                                        data-title="<?php echo e(__('Send Test Mail')); ?>" class="btn btn-primary send_email ">
                                        <?php echo e(__('Send Test Mail')); ?>

                                    </a>
                                </div>
                                <div class="form-group mb-0">
                                    <button class="btn btn-primary" type="submit"><?php echo e(__('Save Changes')); ?>

                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>


                    
                    <div id="email-notification-settings" class="card">
                        <form action="<?php echo e(route('status.email.language')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="col-md-12">
                                <div class="card-header ">
                                    <h5><?php echo e(__('Email Notification Settings')); ?></h5>
                                </div>

                                <div class="card-body   pb-0">
                                    <ul class="nav nav-pills gap-2 mb-3" id="pills-tab" role="tablist">
                                        <?php
                                            $active = 'active';
                                        ?>
                                        <?php $__currentLoopData = $email_notification_modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e_module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(
                                                    Laratrust::hasPermission($e_module . ' manage') ||
                                                    Laratrust::hasPermission(strtolower($e_module) . ' manage') ||
                                                    $e_module == 'General'
                                                ): ?>
                                                <li class="nav-item">
                                                    <a class="nav-link text-capitalize rounded-1 <?php echo e($active); ?>"
                                                        id="pills-<?php echo e(strtolower($e_module)); ?>-tab-email" data-bs-toggle="pill"
                                                        href="#pills-<?php echo e(strtolower($e_module)); ?>-email" role="tab"
                                                        aria-controls="pills-<?php echo e(strtolower($e_module)); ?>-email"
                                                        aria-selected="true"><?php echo e($e_module); ?></a>
                                                </li>
                                                <?php
                                                    $active = '';
                                                ?>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <div class="tab-content " id="pills-tabContent">
                                        <?php $__currentLoopData = $email_notification_modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e_module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="tab-pane fade <?php echo e($loop->index == 0 ? 'active' : ''); ?> show"
                                                id="pills-<?php echo e(strtolower($e_module)); ?>-email" role="tabpanel"
                                                aria-labelledby="pills-<?php echo e(strtolower($e_module)); ?>-tab-email">
                                                <div class="row">
                                                    <?php $__currentLoopData = $email_notify; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e_action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($e_action->module == $e_module): ?>
                                                            <div class="col-lg-4 col-sm-6 col-12 mb-3">
                                                                <div class="rounded-1 card   list_colume_notifi p-3 h-100 mb-0">
                                                                    <div
                                                                        class="card-body d-flex align-items-center justify-content-between gap-2 p-0">
                                                                        <h6 class="mb-0">
                                                                            <label for="<?php echo e($e_action->action); ?>"
                                                                                class="form-label mb-0"><?php echo e($e_action->action); ?></label>
                                                                        </h6>
                                                                        <div class="form-check form-switch d-inline-block text-end">
                                                                            <input type="hidden"
                                                                                name="mail_noti[<?php echo e($e_action->action); ?>]" value="0" />
                                                                            <input class="form-check-input" <?php echo e(isset($setting[$e_action->action]) && $setting[$e_action->action] == true ? 'checked' : ''); ?>

                                                                                id="mail_notificaation"
                                                                                name="mail_noti[<?php echo e($e_action->action); ?>]"
                                                                                type="checkbox" value="1">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                <div class="card-footer text-end pb-3">
                                    <input class="btn btn-print-invoice  btn-primary" type="submit"
                                        value="<?php echo e(__('Save Changes')); ?>">
                                </div>
                            </div>
                        </form>
                    </div>

                    
                    <?php
                        $local_storage_validation = $setting['local_storage_validation'];
                        $local_storage_validations = explode(',', $local_storage_validation);

                        $s3_storage_validation = isset($setting['s3_storage_validation'])
                            ? $setting['s3_storage_validation']
                            : '';
                        $s3_storage_validations = explode(',', $s3_storage_validation);

                        $wasabi_storage_validation = isset($setting['wasabi_storage_validation'])
                            ? $setting['wasabi_storage_validation']
                            : '';
                        $wasabi_storage_validations = explode(',', $wasabi_storage_validation);
                    ?>
                    <div id="storage-settings" class="card mb-3">
                        <form action="<?php echo e(route('storage.setting.store')); ?>" method="post" enctype="multipart/form-data"
                            class="needs-validation" novalidate>
                            <?php echo csrf_field(); ?>
                            <div class="card-header">
                                <h5><?php echo e(__('Storage Settings')); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="d-flex">
                                    <div class="pe-2">
                                        <input type="radio" class="btn-check" name="storage_setting" id="local-outlined"
                                            autocomplete="off" <?php echo e($setting['storage_setting'] == 'local' ? 'checked' : ''); ?>

                                            value="local" checked>
                                        <label class="btn btn-outline-primary"
                                            for="local-outlined"><?php echo e(__('Local')); ?></label>
                                    </div>
                                    <div class="pe-2">
                                        <input type="radio" class="btn-check" name="storage_setting" id="s3-outlined"
                                            autocomplete="off" <?php echo e($setting['storage_setting'] == 's3' ? 'checked' : ''); ?>

                                            value="s3">
                                        <label class="btn btn-outline-primary" for="s3-outlined">
                                            <?php echo e(__('AWS S3')); ?></label>
                                    </div>

                                    <div class="pe-2">
                                        <input type="radio" class="btn-check" name="storage_setting" id="wasabi-outlined"
                                            autocomplete="off" <?php echo e($setting['storage_setting'] == 'wasabi' ? 'checked' : ''); ?>

                                            value="wasabi">
                                        <label class="btn btn-outline-primary"
                                            for="wasabi-outlined"><?php echo e(__('Wasabi')); ?></label>
                                    </div>
                                </div>
                                <div class="mt-3">
                                    
                                    <div
                                        class="local-setting row row-gap-1 <?php echo e($setting['storage_setting'] == 'local' ? ' ' : 'd-none'); ?> ">
                                        <div class="form-group mb-0 col-lg-8 col-12 switch-width">
                                            <label for="local_storage_validation"
                                                class="form-label"><?php echo e(__('Only Upload Files')); ?></label>
                                            <select name="local_storage_validation[]" class="form-control"
                                                id="choices-multiple-remove-button" multiple>
                                                <?php $__currentLoopData = $file_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php echo e(in_array($f, $local_storage_validations) ? 'selected' : ''); ?>>
                                                        <?php echo e($f); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="col-lg-4 col-12">
                                            <div class="form-group mb-0">
                                                <label class="form-label"
                                                    for="local_storage_max_upload_size"><?php echo e(__('Max upload size ( In KB)')); ?></label>
                                                <input type="number" name="local_storage_max_upload_size"
                                                    class="form-control"
                                                    value="<?php echo e(isset($setting['local_storage_max_upload_size']) ? $setting['local_storage_max_upload_size'] : ''); ?>"
                                                    placeholder="<?php echo e(__('Max upload size')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    
                                    <div
                                        class="s3-setting row row-gap-1 <?php echo e($setting['storage_setting'] == 's3' ? ' ' : 'd-none'); ?>">
                                        <div class="col-md-6 col-12">
                                            <div class="form-group mb-0">
                                                <label class="form-label" for="s3_key"><?php echo e(__('S3 Key')); ?></label>
                                                <input type="text" name="s3_key" class="form-control"
                                                    value="<?php echo e(isset($setting['s3_key']) ? $setting['s3_key'] : ''); ?>"
                                                    placeholder="<?php echo e(__('S3 Key')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group mb-0">
                                                <label class="form-label" for="s3_secret"><?php echo e(__('S3 Secret')); ?></label>
                                                <input type="text" name="s3_secret" class="form-control"
                                                    value="<?php echo e(isset($setting['s3_secret']) ? $setting['s3_secret'] : ''); ?>"
                                                    placeholder="<?php echo e(__('S3 Secret')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group mb-0">
                                                <label class="form-label" for="s3_region"><?php echo e(__('S3 Region')); ?></label>
                                                <input type="text" name="s3_region" class="form-control"
                                                    value="<?php echo e(isset($setting['s3_region']) ? $setting['s3_region'] : ''); ?>"
                                                    placeholder="<?php echo e(__('S3 Region')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group mb-0">
                                                <label class="form-label" for="s3_bucket"><?php echo e(__('S3 Bucket')); ?></label>
                                                <input type="text" name="s3_bucket" class="form-control"
                                                    value="<?php echo e(isset($setting['s3_bucket']) ? $setting['s3_bucket'] : ''); ?>"
                                                    placeholder="<?php echo e(__('S3 Bucket')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group mb-0">
                                                <label class="form-label" for="s3_url"><?php echo e(__('S3 URL')); ?></label>
                                                <input type="text" name="s3_url" class="form-control"
                                                    value="<?php echo e(isset($setting['s3_url']) ? $setting['s3_url'] : ''); ?>"
                                                    placeholder="<?php echo e(__('S3 URL')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group mb-0">
                                                <label class="form-label" for="s3_endpoint"><?php echo e(__('S3 Endpoint')); ?></label>
                                                <input type="text" name="s3_endpoint" class="form-control"
                                                    value="<?php echo e(isset($setting['s3_endpoint']) ? $setting['s3_endpoint'] : ''); ?>"
                                                    placeholder="<?php echo e(__('S3 Bucket')); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group mb-0 col-md-6 col-12 switch-width">
                                            <div>
                                                <label class="form-label"
                                                    for="s3_storage_validation"><?php echo e(__('Only Upload Files')); ?></label>
                                            </div>
                                            <select class="form-control" name="s3_storage_validation[]"
                                                id="choices-multiple-remove-button1" placeholder="This is a placeholder"
                                                multiple>
                                                <?php $__currentLoopData = $file_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php echo e(in_array($f, $s3_storage_validations) ? 'selected' : ''); ?>>
                                                        <?php echo e($f); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group mb-0">
                                                <label class="form-label"
                                                    for="s3_max_upload_size"><?php echo e(__('Max upload size ( In KB)')); ?></label>
                                                <input type="number" name="s3_max_upload_size" class="form-control"
                                                    value="<?php echo e(isset($setting['s3_max_upload_size']) ? $setting['s3_max_upload_size'] : ''); ?>"
                                                    placeholder="<?php echo e(__('Max upload size')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    
                                    <div
                                        class="wasabi-setting row row-gap-1 <?php echo e($setting['storage_setting'] == 'wasabi' ? ' ' : 'd-none'); ?>">
                                        <div class="col-md-6">
                                            <div class="form-group mb-0">
                                                <label class="form-label" for="s3_key"><?php echo e(__('Wasabi Key')); ?></label>
                                                <input type="text" name="wasabi_key" class="form-control"
                                                    value="<?php echo e(isset($setting['wasabi_key']) ? $setting['wasabi_key'] : ''); ?>"
                                                    placeholder="<?php echo e(__('Wasabi Key')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-0">
                                                <label class="form-label" for="s3_secret"><?php echo e(__('Wasabi Secret')); ?></label>
                                                <input type="text" name="wasabi_secret" class="form-control"
                                                    value="<?php echo e(isset($setting['wasabi_secret']) ? $setting['wasabi_secret'] : ''); ?>"
                                                    placeholder="<?php echo e(__('Wasabi Secret')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-0">
                                                <label class="form-label" for="s3_region"><?php echo e(__('Wasabi Region')); ?></label>
                                                <input type="text" name="wasabi_region" class="form-control"
                                                    value="<?php echo e(isset($setting['wasabi_region']) ? $setting['wasabi_region'] : ''); ?>"
                                                    placeholder="<?php echo e(__('Wasabi Region')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-0">
                                                <label class="form-label"
                                                    for="wasabi_bucket"><?php echo e(__('Wasabi Bucket')); ?></label>
                                                <input type="text" name="wasabi_bucket" class="form-control"
                                                    value="<?php echo e(isset($setting['wasabi_bucket']) ? $setting['wasabi_bucket'] : ''); ?>"
                                                    placeholder="<?php echo e(__('Wasabi Bucket')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-0">
                                                <label class="form-label" for="wasabi_url"><?php echo e(__('Wasabi URL')); ?></label>
                                                <input type="text" name="wasabi_url" class="form-control"
                                                    value="<?php echo e(isset($setting['wasabi_url']) ? $setting['wasabi_url'] : ''); ?>"
                                                    placeholder="<?php echo e(__('Wasabi URL')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-0">
                                                <label class="form-label" for="wasabi_root"><?php echo e(__('Wasabi Root')); ?></label>
                                                <input type="text" name="wasabi_root" class="form-control"
                                                    value="<?php echo e(isset($setting['wasabi_root']) ? $setting['wasabi_root'] : ''); ?>"
                                                    placeholder="<?php echo e(__('Wasabi Bucket')); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group mb-0 col-md-6 col-12 switch-width">
                                            <label for="wasabi_storage_validation"
                                                class="form-label"><?php echo e(__('Only Upload Files')); ?></label>
                                            <select name="wasabi_storage_validation[]" class="form-control"
                                                id="choices-multiple-remove-button2" multiple>
                                                <?php $__currentLoopData = $file_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php echo e(in_array($f, $wasabi_storage_validations) ? 'selected' : ''); ?>>
                                                        <?php echo e($f); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group mb-0">
                                                <label class="form-label"
                                                    for="wasabi_root"><?php echo e(__('Max upload size ( In KB)')); ?></label>
                                                <input type="number" name="wasabi_max_upload_size" class="form-control"
                                                    value="<?php echo e(isset($setting['wasabi_max_upload_size']) ? $setting['wasabi_max_upload_size'] : ''); ?>"
                                                    placeholder="<?php echo e(__('Max upload size')); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="card-footer pb-3 text-end">
                                <input class="btn btn-print-invoice  btn-primary" type="submit"
                                    value="<?php echo e(__('Save Changes')); ?>">
                            </div>
                        </form>
                    </div>

                    
                    <div id="recaptcha-settings" class="card ">
                        <form method="POST" action="<?php echo e(route('admin.recaptcha.settings.store')); ?>" accept-charset="UTF-8"
                            class="needs-validation" novalidate>
                            <?php echo csrf_field(); ?>
                            <div class="card-header  d-flex align-items-center gap-2 justify-content-between flex-wrap">
                                <div class="d-flex flex-column">
                                    <h5 class="mb-1"><?php echo e(__('ReCaptcha Settings')); ?></h5>
                                    <a href="https://phppot.com/php/how-to-get-google-recaptcha-site-and-secret-key/"
                                        target="_blank" class="text-blue">
                                        <small>(<?php echo e(__('How to Get Google reCaptcha Site and Secret key')); ?>)</small>
                                    </a>
                                </div>
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" data-toggle="switchbutton" data-onstyle="primary" class=""
                                        name="recaptcha_module" id="recaptcha_module" <?php echo e(isset($setting['RECAPTCHA_MODULE']) && $setting['RECAPTCHA_MODULE'] == 'yes' ? 'checked="checked"' : ''); ?> value="yes">
                                    <label class="custom-control-label" for="recaptcha_module"></label>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row row-gap-1">
                                    <div class="col-12">
                                        <div class="row">
                                            <div class="col-md-6 col-12 form-group mb-0">
                                                <label for="google_recaptcha_version"
                                                    class="form-label"><?php echo e(__('Google Recaptcha Version')); ?></label>
                                                <select id="google_recaptcha_version" name="google_recaptcha_version"
                                                    class="form-control choices" required>
                                                    <?php $__currentLoopData = $google_recaptcha_version; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($key); ?>" <?php echo e(isset($setting['google_recaptcha_version']) && $setting['google_recaptcha_version'] == $key ? 'selected' : ''); ?>>
                                                            <?php echo e($value); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-12 form-group mb-0">
                                        <label for="google_recaptcha_key"
                                            class="form-label"><?php echo e(__('Google Recaptcha Key')); ?></label>
                                        <input class="form-control" placeholder="<?php echo e(__('Enter Google Recaptcha Key')); ?>"
                                            name="google_recaptcha_key" type="text"
                                            value="<?php echo e(isset($setting['NOCAPTCHA_SITEKEY']) ? $setting['NOCAPTCHA_SITEKEY'] : ''); ?>"
                                            id="google_recaptcha_key" required>
                                    </div>
                                    <div class="col-md-6 col-12 form-group mb-0">
                                        <label for="google_recaptcha_secret"
                                            class="form-label"><?php echo e(__('Google Recaptcha Secret')); ?></label>
                                        <input class="form-control " placeholder="<?php echo e(__('Enter Google Recaptcha Secret')); ?>"
                                            name="google_recaptcha_secret" type="text"
                                            value="<?php echo e(isset($setting['NOCAPTCHA_SECRET']) ? $setting['NOCAPTCHA_SECRET'] : ''); ?>"
                                            id="google_recaptcha_secret" required>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer pb-3 text-end">
                                <input type="submit" value="<?php echo e(__('Save Changes')); ?>"
                                    class="btn btn-primary btn-block btn-submit text-white">
                            </div>
                        </form>
                    </div>

                    
                    <div id="seo-settings" class="card mb-3">
                        <form action="<?php echo e(route('seo.settings')); ?>" method="POST" enctype="multipart/form-data"
                            class="needs-validation" novalidate>
                            <?php echo csrf_field(); ?>
                            <div class="card-header flex-wrap d-flex align-items-center gap-2 justify-content-between">
                                <h5><?php echo e(__('SEO Settings')); ?></h5>
                                <?php if(isset($setting['is_enabled']) && $setting['is_enabled'] == 'on'): ?>
                                    <a class="btn btn-primary btn-sm float-end" href="#" data-size="lg"
                                        data-ajax-popup-over="true" data-url="<?php echo e(route('generate', ['seo'])); ?>"
                                        data-bs-toggle="tooltip" data-bs-placement="top" title="Generate"
                                        data-title="Generate Content with AI">
                                        <i class="fas fa-robot me-1"></i> <?php echo e(__('Generate with AI')); ?>

                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="meta_keywords"
                                                class="col-form-label"><?php echo e(__('Meta Keywords')); ?></label>
                                            <input type="text" name="meta_keywords" id="meta_keywords" class="form-control"
                                                placeholder="Meta Keywords"
                                                value="<?php echo e(isset($setting['meta_keywords']) ? $setting['meta_keywords'] : ''); ?>"
                                                required>
                                        </div>
                                        <div class="form-group">
                                            <label for="meta_description"
                                                class="form-label"><?php echo e(__('Meta Description')); ?></label>
                                            <textarea name="meta_description" id="meta_description" class="form-control"
                                                rows="5" placeholder="Enter Meta Description"
                                                required><?php echo e(isset($setting['meta_description']) ? $setting['meta_description'] : ''); ?></textarea>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="meta_image" class="col-form-label"><?php echo e(__('Meta Image')); ?></label>
                                            <div>
                                                <a href="<?php echo e(isset($setting['meta_image']) && checkFile($setting['meta_image']) ? getFile($setting['meta_image']) : getFile('uploads/metaevent/meta.png') . '?' . time()); ?>"
                                                    target="_blank">
                                                    <div class="logo-content">
                                                        <img src="<?php echo e(isset($setting['meta_image']) && checkFile($setting['meta_image']) ? getFile($setting['meta_image']) : getFile('uploads/metaevent/meta.png') . '?' . time()); ?>"
                                                            id="meta_image_pre" class="img_setting seo_image" />
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                        <div class="choose-files mt-4">
                                            <label for="meta_image">
                                                <div class="bg-primary m-auto">
                                                    <i class="ti ti-upload px-1"></i><?php echo e(__('Select Image')); ?>

                                                    <input style="margin-top: -40px;" type="file" class="file"
                                                        name="meta_image" id="meta_image" data-filename="meta_image"
                                                        onchange="document.getElementById('meta_image_pre').src = window.URL.createObjectURL(this.files[0])" />
                                                </div>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer  text-end">
                                <button class="btn-submit btn btn-primary abcd"
                                    type="submit"><?php echo e(__('Save Changes')); ?></button>
                            </div>
                        </form>
                    </div>


                    
                    <div id="cookie-settings" class="card mb-3">
                        <form action="<?php echo e(route('cookie.setting')); ?>" method="POST" class="needs-validation" novalidate>
                            <?php echo csrf_field(); ?>
                            <div class="card-header flex-wrap d-flex align-items-center gap-3 justify-content-between">
                                <h5><?php echo e(__('Cookie Settings')); ?></h5>
                                <div class="d-flex align-items-center">
                                    <label for="enable_cookie"
                                        class="col-form-label p-0 fw-bold me-3"><?php echo e(__('Enable cookie')); ?></label>
                                    <div class="custom-control custom-switch" onclick="enablecookie()">
                                        <input type="checkbox" data-toggle="switchbutton" data-onstyle="primary"
                                            name="enable_cookie" class="form-check-input input-primary" id="enable_cookie"
                                            <?php echo e(isset($setting['enable_cookie']) && $setting['enable_cookie'] == 'on' ? 'checked' : ''); ?>>
                                        <label class="custom-control-label mb-1" for="enable_cookie"></label>
                                    </div>
                                </div>
                            </div>
                            <div
                                class="card-body cookieDiv <?php echo e(isset($setting['enable_cookie']) && $setting['enable_cookie'] == 'off' ? 'disabledCookie' : ''); ?>">
                                <?php if(isset($setting['is_enabled']) && $setting['is_enabled'] == 'on'): ?>
                                    <div class="d-flex justify-content-end mb-3">
                                        <a class="btn btn-primary btn-sm" href="#" data-size="lg" data-ajax-popup-over="true"
                                            data-url="<?php echo e(route('generate', ['cookie'])); ?>" data-bs-toggle="tooltip"
                                            data-bs-placement="top" title="Generate" data-title="Generate Content with AI">
                                            <i class="fas fa-robot me-1"> </i><?php echo e(__('Generate with AI')); ?>

                                        </a>
                                    </div>
                                <?php endif; ?>
                                <div class="row row-gap-1">
                                    <div class="col-md-6">
                                        <div class="card mb-3">
                                            <div class="card-body">
                                                <div class="form-check form-switch custom-switch-v1" id="cookie_log">
                                                    <input type="checkbox" name="cookie_logging"
                                                        class="form-check-input input-primary cookie_setting"
                                                        id="cookie_logging" <?php echo e(isset($setting['cookie_logging']) && $setting['cookie_logging'] == 'on' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" style="margin-left:5px"
                                                        for="cookie_logging"><?php echo e(__('Enable logging')); ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="cookie_title"
                                                class="col-form-label"><?php echo e(__('Cookie Title')); ?></label>
                                            <input type="text" name="cookie_title" id="cookie_title"
                                                value="<?php echo e(old('cookie_title', isset($setting['cookie_title']) ? $setting['cookie_title'] : '')); ?>"
                                                class="form-control cookie_setting" required>
                                        </div>
                                        <div class="form-group mb-0">
                                            <label for="cookie_description"
                                                class="form-label"><?php echo e(__('Cookie Description')); ?></label>
                                            <textarea name="cookie_description" id="cookie_description"
                                                class="form-control cookie_setting" rows="3"
                                                required><?php echo e(old('cookie_description', isset($setting['cookie_description']) ? $setting['cookie_description'] : '')); ?></textarea>
                                            <small
                                                class="text-danger d-block mt-1"><?php echo e(__('Please avoid to use enter key for new line. You can use &lt;br&gt; for new Line')); ?></small>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="card mb-3">
                                            <div class="card-body">
                                                <div class="form-check form-switch custom-switch-v1">
                                                    <input type="checkbox" name="necessary_cookies"
                                                        class="form-check-input input-primary" id="necessary_cookies"
                                                        checked onclick="return false">
                                                    <label class="form-check-label" style="margin-left:5px"
                                                        for="necessary_cookies"><?php echo e(__('Strictly necessary cookies')); ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="strictly_cookie_title"
                                                class="col-form-label"><?php echo e(__('Strictly Cookie Title')); ?></label>
                                            <input type="text" name="strictly_cookie_title" id="strictly_cookie_title"
                                                value="<?php echo e(old('strictly_cookie_title', isset($setting['strictly_cookie_title']) ? $setting['strictly_cookie_title'] : '')); ?>"
                                                class="form-control cookie_setting" required>
                                        </div>
                                        <div class="form-group mb-0">
                                            <label for="strictly_cookie_description"
                                                class="form-label"><?php echo e(__('Strictly Cookie Description')); ?></label>
                                            <textarea name="strictly_cookie_description" id="strictly_cookie_description"
                                                class="form-control cookie_setting" rows="3"
                                                required><?php echo e(old('strictly_cookie_description', isset($setting['strictly_cookie_description']) ? $setting['strictly_cookie_description'] : '')); ?></textarea>
                                            <small
                                                class="text-danger d-block mt-1"><?php echo e(__('Please avoid to use enter key for new line. You can use &lt;br&gt; for new Line')); ?></small>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <h5 class="mb-0"><?php echo e(__('More Information')); ?></h5>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group mb-0">
                                            <label for="more_information_description"
                                                class="col-form-label"><?php echo e(__('Contact Us Description')); ?></label>
                                            <input type="text" name="more_information_description"
                                                id="more_information_description"
                                                value="<?php echo e(old('more_information_description', isset($setting['more_information_description']) ? $setting['more_information_description'] : '')); ?>"
                                                class="form-control cookie_setting" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group mb-0">
                                            <label for="contactus_url"
                                                class="col-form-label"><?php echo e(__('Contact Us URL')); ?></label>
                                            <input type="text" name="contactus_url" id="contactus_url"
                                                value="<?php echo e(old('contactus_url', isset($setting['contactus_url']) ? $setting['contactus_url'] : '')); ?>"
                                                class="form-control cookie_setting" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer d-flex align-items-center gap-3 flex-wrap justify-content-between">
                                <div class="d-flex align-items-center gap-2 flex-wrap">
                                    <?php if(isset($setting['cookie_logging']) && $setting['cookie_logging'] == 'on'): ?>
                                        <label for="file"
                                            class="form-label mb-0"><?php echo e(__('Download cookie accepted data')); ?></label>
                                        <a href="<?php echo e(getFile('uploads/sample/data.csv')); ?>" class="btn btn-primary mr-2">
                                            <i class="ti ti-download"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                                <button type="submit" class="btn btn-primary"><?php echo e(__('Save Changes')); ?></button>
                            </div>
                        </form>
                    </div>


                    
                    <div id="chatgpt-settings" class="card mb-3">
                        <div class="col-xl-12 col-lg-12 col-md-12">
                            <form action="<?php echo e(route('settings.chatgptkey')); ?>" method="POST" class="needs-validation"
                                novalidate>
                                <?php echo csrf_field(); ?>
                                <div
                                    class="card-header flex-column flex-lg-row d-flex align-items-lg-center gap-2 justify-content-between">
                                    <h5><?php echo e(__('Chat GPT Key Settings')); ?></h5>
                                    <div class="d-flex align-items-center">
                                        <div class="form-check custom-control custom-switch p-0">
                                            <input type="checkbox" class="form-check-input form-control" name="is_enabled"
                                                data-toggle="switchbutton" data-onstyle="primary" id="is_enabled" <?php echo e(isset($setting['is_enabled']) && $setting['is_enabled'] == 'on' ? 'checked' : ''); ?>>
                                            <label class="custom-control-label form-label" for="is_enabled"></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row row-gap-1">
                                        <div class="form-group mb-0 col-md-12">
                                            <label for="chatgpt_key" class="col-form-label"><?php echo e(__('Chat GPT Key')); ?></label>
                                            <input type="text" name="chatgpt_key" id="chatgpt_key"
                                                value="<?php echo e(isset($setting['chatgpt_key']) ? $setting['chatgpt_key'] : ''); ?>"
                                                class="form-control" placeholder="Enter Chatgpt Key Here" required>
                                        </div>
                                        <div class="form-group mb-0 col-md-12">
                                            <label for="chat_gpt_model"
                                                class="col-form-label"><?php echo e(__('Chat GPT Model Name')); ?></label>
                                            <select name="chat_gpt_model" id="chat_gpt_model" class="form-control" required>
                                                <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupLabel => $options): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(is_array($options)): ?>
                                                        <optgroup label="<?php echo e($groupLabel); ?>">
                                                            <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($key); ?>" <?php echo e(isset($setting['chat_gpt_model']) && $setting['chat_gpt_model'] == $key ? 'selected' : ''); ?>>
                                                                    <?php echo e($model); ?>

                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </optgroup>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer pb-3 text-end">
                                    <button class="btn btn-primary" type="submit"><?php echo e(__('Save Changes')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>



                    
                    <div id="cache-settings" class="card mb-3">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-lg-8 col-md-8 col-sm-8">
                                    <h5 class="mb-1"><?php echo e(__('Cache Setting')); ?></h5>
                                    <small class="text-secondary font-weight-bold">
                                        <?php echo e(__('This is a page meant for more advanced users, Simply Ignore it if you do not understand what cache is.')); ?>

                                    </small>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group mb-0">
                                        <label for="size"><?php echo e(__('Current cache size')); ?></label>
                                        <div class="input-group mt-2">
                                            <input id="size" name="size" type="text" class="form-control"
                                                value="<?php echo e(getCacheSize()); ?>" disabled>
                                            <div class="input-group-append">
                                                <span class="input-group-text">
                                                    <?php echo e(__('MB')); ?>

                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer text-end">
                            <a href="<?php echo e(route('cache.clear')); ?>"
                                class="btn btn-print-invoice btn-primary m-r-10"><?php echo e(__('Clear Cache')); ?></a>
                        </div>
                    </div>

                    
                    <div id="pusher-settings" class="card">
                        <form method="POST" action="<?php echo e(route('admin.pusher.settings.store')); ?>" accept-charset="UTF-8"
                            class="needs-validation" novalidate>
                            <?php echo csrf_field(); ?>


                            <div class="card-header flex-wrap d-flex align-items-center gap-3 justify-content-between">
                                <div class="d-flex flex-column gap-1">
                                    <h5><?php echo e(__('Pusher Settings')); ?></h5>
                                    <small
                                        class="text-danger m-0"><?php echo e(__('Pusher settings provide real-time updates for ticket creation, replies, and live chat interactions')); ?></small>
                                </div>
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" data-toggle="switchbutton" data-onstyle="primary" class=""
                                        name="enable_chat" id="enable_chat" <?php echo e(isset($setting['CHAT_MODULE']) && $setting['CHAT_MODULE'] == 'yes' ? 'checked' : ''); ?>>
                                    <label class="custom-control-label" for="enable_chat"></label>
                                </div>
                            </div>

                            <div class="card-body">
                                <div class="row row-gap-1">
                                    <div class="col-md-6 col-12 form-group mb-0">
                                        <label for="pusher_app_id" class="form-label"><?php echo e(__('Pusher App Id')); ?></label>
                                        <input class="form-control" placeholder="Enter Pusher App Id" name="pusher_app_id"
                                            type="text"
                                            value="<?php echo e(isset($setting['PUSHER_APP_ID']) ? $setting['PUSHER_APP_ID'] : ''); ?>"
                                            id="pusher_app_id" required>
                                    </div>
                                    <div class="col-md-6 col-12 form-group mb-0">
                                        <label for="pusher_app_key" class="form-label"><?php echo e(__('Pusher App Key')); ?></label>
                                        <input class="form-control " placeholder="Enter Pusher App Key"
                                            name="pusher_app_key" type="text"
                                            value="<?php echo e(isset($setting['PUSHER_APP_KEY']) ? $setting['PUSHER_APP_KEY'] : ''); ?>"
                                            id="pusher_app_key" required>
                                    </div>
                                    <div class="col-md-6 col-12 form-group mb-0">
                                        <label for="pusher_app_secret"
                                            class="form-label"><?php echo e(__('Pusher App Secret')); ?></label>
                                        <input class="form-control " placeholder="Enter Pusher App Secret"
                                            name="pusher_app_secret" type="text"
                                            value="<?php echo e(isset($setting['PUSHER_APP_SECRET']) ? $setting['PUSHER_APP_SECRET'] : ''); ?>"
                                            id="pusher_app_secret" required>
                                    </div>
                                    <div class="col-md-6 col-12 form-group mb-0">
                                        <label for="pusher_app_cluster"
                                            class="form-label"><?php echo e(__('Pusher App Cluster')); ?></label>
                                        <input class="form-control " placeholder="Enter Pusher App Cluster"
                                            name="pusher_app_cluster" type="text"
                                            value="<?php echo e(isset($setting['PUSHER_APP_CLUSTER']) ? $setting['PUSHER_APP_CLUSTER'] : ''); ?>"
                                            id="pusher_app_cluster" required>
                                    </div>

                                </div>
                            </div>
                            <div class="card-footer text-end ">
                                <button type="submit"
                                    class="btn btn-primary btn-block btn-submit text-white"><?php echo e(__('Save Changes')); ?></button>
                            </div>
                        </form>
                    </div>
                    <?php echo getCompanySetting(); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('js/jquery-ui.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/repeater.js')); ?>"></script>
    <script>
        $('.colorPicker').on('click', function (e) {

            $('body').removeClass('custom-color');
            if (/^theme-\d+$/) {
                $('body').removeClassRegex(/^theme-\d+$/);
            }
            $('body').addClass('custom-color');
            $('.themes-color-change').removeClass('active_color');
            $(this).addClass('active_color');
            const input = document.getElementById("color-picker");
            setColor();
            input.addEventListener("input", setColor);

            function setColor() {
                $(':root').css('--color-customColor', input.value);
            }

            $(`input[name='color_flag`).val('true');
        });

        $('.themes-color-change').on('click', function () {

            $(`input[name='color_flag`).val('false');

            var color_val = $(this).data('value');
            $('body').removeClass('custom-color');
            if (/^theme-\d+$/) {
                $('body').removeClassRegex(/^theme-\d+$/);
            }
            $('body').addClass(color_val);
            $('.theme-color').prop('checked', false);
            $('.themes-color-change').removeClass('active_color');
            $('.colorPicker').removeClass('active_color');
            $(this).addClass('active_color');
            $(`input[value=${color_val}]`).prop('checked', true);
        });

        $.fn.removeClassRegex = function (regex) {
            return $(this).removeClass(function (index, classes) {
                return classes.split(/\s+/).filter(function (c) {
                    return regex.test(c);
                }).join(' ');
            });
        };
    </script>
    <script>
        var scrollSpy = new bootstrap.ScrollSpy(document.body, {
            target: '#useradd-sidenav',
            offset: 300,
        })

        $(".list-group-item").click(function () {
            $('.list-group-item').filter(function () {
                // return this.href == id;
            }).parent().removeClass('text-primary');
        });
    </script>
    <script>
        function myFunction() {
            var copyText = document.getElementById("myInput");
            copyText.select();
            copyText.setSelectionRange(0, 99999)
            document.execCommand("copy");
            show_toastr('Success', "<?php echo e(__('Link copied')); ?>", 'success');
        }


        function check_theme(color_val) {
            $('#theme_color').prop('checked', false);
            $('input[value="' + color_val + '"]').prop('checked', true);
        }
        var scrollSpy = new bootstrap.ScrollSpy(document.body, {
            target: '#useradd-sidenav',
            offset: 300
        })
    </script>

    <script>
        var multipleCancelButton = new Choices(
            '#choices-multiple-remove-button', {
            removeItemButton: true,
        }
        );

        var multipleCancelButton = new Choices(
            '#choices-multiple-remove-button1', {
            removeItemButton: true,
        }
        );

        var multipleCancelButton = new Choices(
            '#choices-multiple-remove-button2', {
            removeItemButton: true,
        }
        );
    </script>
    <script>
        var scrollSpy = new bootstrap.ScrollSpy(document.body, {
            target: '#useradd-sidenav',
            offset: 300,
        })
        $(".list-group-item").click(function () {
            $('.list-group-item').filter(function () {
                return this.href == id;
            }).parent().removeClass('text-primary');
        });

        function check_theme(color_val) {
            $('#theme_color').prop('checked', false);
            $('input[value="' + color_val + '"]').prop('checked', true);
        }

        $(document).on('change', '[name=storage_setting]', function () {
            if ($(this).val() == 's3') {
                $('.needs-validation').removeClass('was-validated');
                $('.s3-setting').removeClass('d-none').find('input,select').not('.choices__input').attr('required',
                    'required');
                $('.wasabi-setting').addClass('d-none').find('input,select').removeAttr('required');
                $('.local-setting').addClass('d-none').find('input,select').removeAttr('required');
            } else if ($(this).val() == 'wasabi') {
                $('.needs-validation').removeClass('was-validated');
                $('.s3-setting').addClass('d-none').find('input,select').removeAttr('required');
                $('.local-setting').addClass('d-none').find('input,select').removeAttr('required');
                $('.wasabi-setting').removeClass('d-none').find('input,select').not('.choices__input').attr(
                    'required', 'required');
            } else {
                $('.needs-validation').removeClass('was-validated');
                $('.s3-setting').addClass('d-none').find('input,select').removeAttr('required');
                $('.wasabi-setting').addClass('d-none').find('input,select').removeAttr('required');
                $('.local-setting').removeClass('d-none').find('input,select').not('.choices__input').attr(
                    'required', 'required');
            }
        });
    </script>

    <script>
        $(document).on("click", '.send_email', function (e) {

            e.preventDefault();
            var title = $(this).attr('data-title');

            var size = 'md';
            var url = $(this).attr('data-url');
            if (typeof url != 'undefined') {
                $("#commonModal .modal-title").html(title);
                $("#commonModal .modal-dialog").addClass('modal-' + size);
                $("#commonModal").modal('show');

                $.post(url, {
                    mail_driver: $("#mail_driver").val(),
                    mail_host: $("#mail_host").val(),
                    mail_port: $("#mail_port").val(),
                    mail_username: $("#mail_username").val(),
                    mail_password: $("#mail_password").val(),
                    mail_encryption: $("#mail_encryption").val(),
                    mail_from_address: $("#mail_from_address").val(),
                    mail_from_name: $("#mail_from_name").val(),
                }, function (data) {
                    $('#commonModal .modal-body').html(data);
                });
            }
        });
        $(document).on('submit', '#test_email', function (e) {
            e.preventDefault();
            $("#email_sending").show();
            var post = $(this).serialize();
            var url = $(this).attr('action');
            $.ajax({
                type: "post",
                url: url,
                data: post,
                cache: false,
                beforeSend: function () {
                    $('#test_email .btn-create').attr('disabled', 'disabled');
                },
                success: function (data) {
                    if (data.is_success) {
                        show_toastr('Success', data.message, 'success');
                    } else {
                        show_toastr('Error', data.message, 'error');
                    }
                    $("#email_sending").hide();
                },
                complete: function () {
                    $('#test_email .btn-create').removeAttr('disabled');
                },
            });
        });
    </script>

    <script type="text/javascript">
        function enablecookie() {
            const element = $('#enable_cookie').is(':checked');
            $('.cookieDiv').addClass('disabledCookie');
            if (element == true) {
                $('.cookieDiv').removeClass('disabledCookie');
                $("#cookie_logging").attr('checked', true);
            } else {
                $('.cookieDiv').addClass('disabledCookie');
                $("#cookie_logging").attr('checked', false);
            }
        }
    </script>

    <script type="text/javascript">
        $(document).on("click", ".email-template-checkbox", function () {
            var chbox = $(this);
            $.ajax({
                url: chbox.attr('data-url'),
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content'),
                    status: chbox.val()
                },
                type: 'post',
                success: function (response) {
                    if (response.is_success) {
                        show_toastr('Success', response.success, 'success');
                        if (chbox.val() == 1) {
                            $('#' + chbox.attr('id')).val(0);
                        } else {
                            $('#' + chbox.attr('id')).val(1);
                        }
                    } else {
                        show_toastr('Error', response.error, 'error');
                    }
                },
                error: function (response) {
                    response = response.responseJSON;
                    if (response.is_success) {
                        show_toastr('Error', response.error, 'error');
                    } else {
                        show_toastr('Error', response, 'error');
                    }
                }
            })
        });
    </script>


    <script>
        var custdarklayout = document.querySelector("#cust-darklayout");
        custdarklayout.addEventListener("click", function () {
            var lightLogo = document.getElementById("blah3").src;
            var site_rtl = <?php echo json_encode(isset($setting['site_rtl']) && $setting['site_rtl'] ? $setting['site_rtl'] : '', 15, 512) ?>;

            var darkLogo = document.getElementById("blah2").src;

            if (custdarklayout.checked) {
                if (site_rtl == 'on') {
                    document
                        .querySelector("#main-style-link")
                        .setAttribute("href", "<?php echo e(asset('assets/css/style-dark-rtl.css')); ?>");

                } else {
                    document
                        .querySelector("#main-style-link")
                        .setAttribute("href", "<?php echo e(asset('assets/css/style-dark.css')); ?>");
                }
                document.body.style.background = 'linear-gradient(141.55deg, #22242C 3.46%, #22242C 99.86%)';

                document
                    .querySelector(".m-header > .b-brand > .logo-lg")
                    .setAttribute("src", lightLogo);
            } else {
                if (site_rtl == 'on') {
                    document
                        .querySelector("#main-style-link")
                        .setAttribute("href", "<?php echo e(asset('assets/css/style-rtl.css')); ?>");
                } else {
                    document
                        .querySelector("#main-style-link")
                        .setAttribute("href", "<?php echo e(asset('assets/css/style.css')); ?>");
                }
                document
                    .querySelector(".m-header > .b-brand > .logo-lg")
                    .setAttribute("src", darkLogo);
                document.body.style.setProperty('background',
                    'linear-gradient(141.55deg, rgba(240, 244, 243, 0) 3.46%, #f0f4f3 99.86%)', 'important');
            }
        });


        var custthemebg = document.querySelector("#cust-theme-bg");
        custthemebg.addEventListener("click", function () {
            if (custthemebg.checked) {
                document.querySelector(".dash-sidebar").classList.add("transprent-bg");
                document
                    .querySelector(".dash-header:not(.dash-mob-header)")
                    .classList.add("transprent-bg");
                setting - menu - div
                    .querySelector(".dash-header:not(.dash-mob-header)")
                    .classList.remove("transprent-bg");
            } else {
                document.querySelector(".dash-sidebar").classList.remove("transprent-bg");
                document
                    .querySelector(".dash-header:not(.dash-mob-header)")
                    .classList.remove("transprent-bg");
            }
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/phoxag/dash.phoxago.com/resources/views/admin/users/setting.blade.php ENDPATH**/ ?>