<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Manage Roles')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('Roles')); ?></li>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('multiple-action-button'); ?>
    <?php if (app('laratrust')->hasPermission('user create')) : ?>
        <a href="#" data-url="<?php echo e(route('admin.role.create')); ?>" data-ajax-popup="true" data-size="xl"
            class="bg-primary btn btn-sm d-inline-flex align-items-center login_enable me-2"
            data-title="<?php echo e(__('Create New Role')); ?>" data-bs-toggle="tooltip"
            data-bs-original-title="<?php echo e(__('Create New Role')); ?>"> <span class="text-white">
                <i class="ti ti-plus text-white"></i></a>
    <?php endif; // app('laratrust')->permission ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table id="pc-dt-simple" class="table role-table">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th><?php echo e(__('Role')); ?></th>
                                    <th><?php echo e(__('Permissions')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($key + 1); ?></td>
                                        <td><?php echo e($role->name); ?></td>
                                        <td class="permission">
                                            <?php $__currentLoopData = $role->permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span
                                                    class="badge rounded p-2 m-1 px-3 bg-primary"><?php echo e($permission->name); ?></span>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </td>
                                        <td>
                                            <?php if (app('laratrust')->hasPermission('role edit')) : ?>
                                                <div class="action-btn me-2">
                                                    <a href="#"
                                                        class="mx-3 bg-info btn btn-sm d-inline-flex align-items-center"
                                                        data-size="xl"
                                                        data-url="<?php echo e(route('admin.role.edit', ['roleId' => $role->id])); ?>"
                                                        data-ajax-popup="true" data-title="<?php echo e(__('Edit Role')); ?>"
                                                        data-toggle="tooltip" title="<?php echo e(__('Edit Role')); ?>">
                                                        <span class="text-white"> <i class="ti ti-pencil"></i> </span>
                                                    </a>
                                                </div>
                                            <?php endif; // app('laratrust')->permission ?>
                                            <?php if(!in_array($role->name, \App\Models\User::$nonEditableRoles)): ?>
                                                <?php if (app('laratrust')->hasPermission('role delete')) : ?>
                                                    <div class="action-btn">
                                                        <form method="POST"
                                                            action="<?php echo e(route('admin.role.delete', $role->id)); ?>"
                                                            id="delete-form-<?php echo e($role->id); ?>">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('DELETE'); ?>
                                                            <input name="_method" type="hidden" value="DELETE">

                                                            <a class="mx-3 bg-danger btn btn-sm  align-items-center bs-pass-para show_confirm"
                                                                data-bs-toggle="tooltip" title=""
                                                                data-bs-original-title="Delete" aria-label="Delete"
                                                                data-confirm="<?php echo e(__('Are You Sure?')); ?>"
                                                                data-text="<?php echo e(__('This action can not be undone. Do you want to continue?')); ?>"
                                                                data-confirm-yes="delete-form-<?php echo e($role->id); ?>"><i
                                                                    class="ti ti-trash text-white text-white"></i></a>
                                                        </form>
                                                    </div>
                                                <?php endif; // app('laratrust')->permission ?>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        function Checkall(module = null) {

            var ischecked = $("#checkall-" + module).prop('checked');
            if (ischecked == true) {
                $('.checkbox-' + module).prop('checked', true);
            } else {
                $('.checkbox-' + module).prop('checked', false);
            }

            // Get all checkboxes with IDs that start with 'module_checkbox_' and include the module
            var checkboxes = document.querySelectorAll('input[id^="module_checkbox_"]');


            // Check or uncheck all checkboxes based on the 'checkall' checkbox state
            checkboxes.forEach(function(checkbox) {
                var check = $("#checkall-" + module).prop('checked');
                if (checkbox.id.includes(module)) {
                    checkbox.checked = check
                }
            });

            // Call CheckModule to update the module checkbox state
            CheckModule('module_checkbox_' + module);
        }

        function CheckModule(cl = null) {
            var ischecked = $("#" + cl).prop('checked');
            if (ischecked == true) {
                $('.' + cl).find("input[type=checkbox]").prop('checked', true);
            } else {
                $('.' + cl).find("input[type=checkbox]").prop('checked', false);
            }
        }


        function CheckPermission(cl = null, module = null) {
            var ischecked = $("#" + cl).prop('checked');
            var allChecked = true;

            // Check if all permissions for the given module are checked
            $('.' + module).find("input[type=checkbox]").each(function() {
                if (!$(this).prop('checked')) {
                    allChecked = false;
                    return false; // Exit the loop
                }
            });

            // Update the module checkbox based on the state of permissions
            if (allChecked) {
                $('#' + module).prop('checked', true);
            } else {
                $('#' + module).prop('checked', false);
            }
        }

        $(document).ready(function() {
            // Attach the CheckPermission function to all permission checkboxes
            $(document).on('change', 'input[type=checkbox]', function() {
                var id = $(this).attr('id');
                var module = $(this).data('module');
                CheckPermission(id, module);
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/phoxag/dash.phoxago.com/resources/views/admin/roles/index.blade.php ENDPATH**/ ?>