<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Edit Profile')); ?> (<?php echo e($user->name); ?>)
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.users')); ?>"><?php echo e(__('Users')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('Edit')); ?></li>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        var scrollSpy = new bootstrap.ScrollSpy(document.body, {
            target: '#useradd-sidenav',
            offset: 300
        })
    </script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-sm-12">
            <div class="row">
                <div class="col-xl-3">
                    <div class="card sticky-top" style="top:30px">
                        <div class="list-group list-group-flush" id="useradd-sidenav">
                            <a href="#useradd-1"
                                class="list-group-item list-group-item-action border-0"><?php echo e(__('Personal Info')); ?> <div
                                    class="float-end"><i class="ti ti-chevron-right"></i></div></a>
                            <a href="#useradd-2"
                                class="list-group-item list-group-item-action border-0"><?php echo e(__('Change Password')); ?> <div
                                    class="float-end"><i class="ti ti-chevron-right"></i></div></a>
                            <?php if(!Auth::user()->hasRole('customer') ): ?>
                            <a href="#authentication-sidenav" class="list-group-item border-0 list-group-item-action">
                                <?php echo e(__('Two Factor Authentication')); ?>

                                <div class="float-end"><i class="ti ti-chevron-right"></i></div>
                                <?php echo $__env->yieldPushContent('out_of_office_sidebar'); ?>
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>


                <div class="col-xl-9">
                    <div id="useradd-1">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0"><?php echo e(__('Personal Information')); ?></h5>
                                <small> <?php echo e(__('Details about your personal information')); ?></small>
                            </div>
                            <form action="<?php echo e(route('update.profile', $user->id)); ?>" class="needs-validation" method="POST" enctype="multipart/form-data" novalidate>
                            <?php echo csrf_field(); ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <div class="form-group edit-avatar-wrp">
                                            <img src="<?php echo e(!empty($user->avatar) && checkFile($user->avatar) ? getFile($user->avatar) : getFile('uploads/users-avatar/avatar.png') . '?' . time()); ?>"
                                                id="myAvatar" alt="user-image" class="img-thumbnail m-2"
                                                style="height:120px">
                                            <div class="choose-files mt-3">
                                                <label for="file">
                                                    <div class=" bg-primary "> <i class="ti ti-upload px-1"></i>Choose file
                                                        here</div>
                                                    <input type="file"
                                                        accept="image/png, image/gif, image/jpeg,  image/jpg"
                                                        class="form-control" name="avatar" id="file"
                                                        data-filename="avatar-logo">
                                                </label>
                                            </div>
                                        </div>
                                        <small class=""><?php echo e(__('Please upload a valid image file. Size of image should not be
                                            more than 2MB.')); ?></small>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="name" class="form-label"><?php echo e(__('Full Name')); ?></label>
                                            <input class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="name"
                                                type="text" id="fullname" placeholder="<?php echo e(__('Enter Your Name')); ?>"
                                                value="<?php echo e($user->name); ?>" required autocomplete="name">
                                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group">
                                            <label for="email" class="form-label"><?php echo e(__('Email')); ?></label>
                                            <input class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email"
                                                type="text" id="email"
                                                placeholder="<?php echo e(__('Enter Your Email Address')); ?>"
                                                value="<?php echo e($user->email); ?>" required autocomplete="email">
                                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group">
                                            <label for="email" class="form-label"><?php echo e(__('Mobile Number')); ?></label>
                                            <input class="form-control <?php $__errorArgs = ['mobile_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="mobile_number"
                                                type="text" id="mobile_number"
                                                placeholder="<?php echo e(__('Enter Your Mobile Number')); ?>"
                                                value="<?php echo e($user->mobile_number ?? ''); ?>" required autocomplete="mobile_number" pattern="^\+\d{1,3}\d{9,13}$">
                                            <?php $__errorArgs = ['mobile_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            <div class=" text-xs text-danger">
                                                <?php echo e(__('Please use with country code. (ex. +91)')); ?>

                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="card-footer text-end">
                                <input type="submit" class="btn btn-primary" value="<?php echo e(__('Save Changes')); ?>">
                            </div>
                            </form>
                        </div>
                    </div>

                    <div id="useradd-2">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-2"><?php echo e(__('Change Password')); ?></h5>
                                <small> <?php echo e(__('Details about your account password change')); ?></small>
                            </div>
                            <form action="<?php echo e(route('update.password', $user->id)); ?>" class="needs-validation mt-3" method="POST" novalidate>
                            <?php echo csrf_field(); ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="current_password" class="col-form-label"><?php echo e(__('Current Password')); ?></label>
                                            <input type="password" name="current_password" class="form-control" placeholder="<?php echo e(__('Enter Current Password')); ?>" required>
                                            <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-current_password" role="alert">
                                                    <strong class="text-danger"><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>


                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="new_password" class="col-form-label"><?php echo e(__('New Password')); ?></label>
                                            <input type="password" name="new_password" class="form-control" required placeholder="<?php echo e(__('Enter New Password')); ?>">
                                            <?php $__errorArgs = ['new_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-new_password" role="alert">
                                                    <strong class="text-danger"><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="confirm_password" class="col-form-label"><?php echo e(__('New Confirm Password')); ?></label>
                                            <input type="password" name="confirm_password" class="form-control" required placeholder="<?php echo e(__('Enter New Confirm Password')); ?>">
                                            <?php $__errorArgs = ['confirm_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-confirm_password" role="alert">
                                                    <strong class="text-danger"><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer text-end">
                                <input type="submit" class="btn btn-primary" value="<?php echo e(__('Save Changes')); ?>">
                            </div>
                            </form>
                        </div>
                    </div>
                    <?php if(!Auth::user()->hasRole('customer') ): ?>
                    <div class="card" id="authentication-sidenav">
                        <div class="card-header">
                            <h5 class="mb-0"><?php echo e(__('Two Factor Authentication')); ?></h5>
                        </div>
                        <div class="card-body">
                            <p><?php echo e(__('Two factor authentication (2FA) strengthens access security by requiring two methods (also referred to as factors) to verify your identity. Two factor authentication protects against phishing, social engineering and password brute force attacks and secures your logins from attackers exploiting weak or stolen credentials.')); ?>

                            </p>
                            <?php if($data['user']->google2fa_secret == null): ?>
                                <form class="form-horizontal" method="POST" action="<?php echo e(route('generate2faSecret')); ?>">
                                    <?php echo e(csrf_field()); ?>

                                    <div class="col-lg-12 text-center">
                                        <button type="submit" class="btn btn-primary">
                                            <?php echo e(__(' Generate Secret Key to Enable 2FA')); ?>

                                        </button>
                                    </div>
                                </form>
                            <?php elseif($data['user']->google2fa_enable == 0 && $data['user']->google2fa_secret != null): ?>
                                1. <?php echo e(__('Install “Google Authentication App” on your')); ?> <a
                                    href="https://apps.apple.com/us/app/google-authenticator/id388497605" target="_black">
                                    <?php echo e(__('IOS')); ?></a> <?php echo e(__('or')); ?> <a
                                    href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2"
                                    target="_black"><?php echo e(__('Android phone.')); ?></a><br />
                                2. <?php echo e(__('Open the Google Authentication App and scan the below QR code.')); ?><br />
                                <?php
                                    $f = finfo_open();
                                    $mime_type = finfo_buffer($f, $data['google2fa_url'], FILEINFO_MIME_TYPE);
                                ?>
                                <?php if($mime_type == 'text/plain'): ?>
                                    <img src="<?php echo e($data['google2fa_url']); ?>" alt="">
                                <?php else: ?>
                                    <?php echo $data['google2fa_url']; ?>

                                <?php endif; ?>
                                <br /><br />
                                <?php echo e(__('Alternatively, you can use the code:')); ?> <code><?php echo e($data['secret']); ?></code>.<br />
                                3. <?php echo e(__('Enter the 6-digit Google Authentication code from the app')); ?><br /><br />
                                <form class="form-horizontal needs-validation" novalidate method="POST"
                                    action="<?php echo e(route('enable2fa')); ?>">
                                    <?php echo e(csrf_field()); ?>

                                    <div class="form-group<?php echo e($errors->has('verify-code') ? ' has-error' : ''); ?>">
                                        <label for="secret"
                                            class="col-form-label"><?php echo e(__('Authenticator Code')); ?></label>
                                        <input id="secret" type="password" class="form-control" name="secret"
                                            required="required">
                                    </div>
                                    <div class="col-lg-12 text-center">
                                        <button type="submit" class="btn btn-primary">
                                            <?php echo e(__('Enable 2FA')); ?>

                                        </button>
                                    </div>
                                </form>
                            <?php elseif($data['user']->google2fa_enable == 1 && $data['user']->google2fa_secret != null): ?>
                                <div class="alert alert-success">
                                    <?php echo e(__('2FA is currently')); ?> <strong><?php echo e(__('Enabled')); ?></strong>
                                    <?php echo e(__('on your account.')); ?>

                                </div>
                                <p><?php echo e(__('If you are looking to disable Two Factor Authentication. Please confirm your password and Click Disable 2FA Button.')); ?>

                                </p>

                                <form class="form-horizontal needs-validation" novalidate method="POST"
                                    action="<?php echo e(route('disable2fa')); ?>">
                                    <?php echo e(csrf_field()); ?>


                                    <div class="form-group<?php echo e($errors->has('current-password') ? ' has-error' : ''); ?>">
                                        <label for="change-password"
                                            class="col-form-label"><?php echo e(__('Current Password')); ?></label>
                                        <input id="current-password" type="password" class="form-control"
                                            name="current-password" required="required">
                                        <?php if($errors->has('current-password')): ?>
                                            <span class="help-block">
                                                <strong
                                                    class="text-danger"><?php echo e($errors->first('current-password')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-lg-12 text-center">
                                        <button type="submit" class="btn btn-primary">
                                            <?php echo e(__('Disable 2FA')); ?>

                                        </button>
                                    </div>
                                </form>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    <?php echo $__env->yieldPushContent('out_of_office_sidebar_div'); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/phoxag/dash.phoxago.com/resources/views/admin/users/profile.blade.php ENDPATH**/ ?>