<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Manage User Log')); ?>

<?php $__env->stopSection(); ?>



<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.users')); ?>"><?php echo e(__('Users')); ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('User Log')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-sm-12">
            <div class="mt-2 " id="multiCollapseExample1">
                <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('userlog')); ?>" id="userlogin_filter" method="GET">
                        <?php echo csrf_field(); ?>
                        <div class="row align-items-center justify-content-end">
                            <div class="col-xl-5">
                                <div class="row">

                                    <div class="col-xl-6 col-lg-3 col-md-6 col-sm-12 col-12">
                                        <div class="btn-box">
                                            <label for="select_month" class="form-label"><?php echo e(__('Select Month')); ?></label>
                                            <input type="month" name="month" value="<?php echo e(isset($_GET['month']) ? $_GET['month'] : date('Y-m')); ?>"  class="form-control">
                                        </div>
                                    </div>

                                    <div class="col-xl-6 col-lg-3 col-md-6 col-sm-12 col-12">
                                        <div class="btn-box">
                                            <label for="user_id" class="form-label"><?php echo e(__('Select User')); ?></label>
                                            <select name="user" class="form-control select" id="user_id">
                                                <?php $__currentLoopData = $usersList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($key); ?>" <?php echo e(isset($_GET['user']) && $_GET['user'] == $key ? 'selected' : ''); ?>><?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-auto">
                                <div class="row">
                                    <div class="col-auto mt-4">
                                        <a href="#" class="btn btn-sm btn-primary me-2"
                                            onclick="document.getElementById('userlogin_filter').submit(); return false;"
                                            data-bs-toggle="tooltip" title="<?php echo e(__('Apply')); ?>"
                                            data-original-title="<?php echo e(__('apply')); ?>">
                                            <span class="btn-inner--icon"><i class="ti ti-search"></i></span>
                                        </a>
                                        <a href="<?php echo e(route('userlog')); ?>" class="btn btn-sm btn-danger"
                                            data-bs-toggle="tooltip" title="" data-bs-original-title="Reset">
                                            <span class="btn-inner--icon"><i
                                                    class="ti ti-refresh text-white-off "></i></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-body table-border-style">
                <div class="table-responsive">
                    <table id="pc-dt-simple" class="table">
                        <thead class="thead-light">
                            <tr>
                                <th> <?php echo e(__('Name')); ?></th>
                                <th><?php echo e(__('Role')); ?></th>
                                <th> <?php echo e(__('Email')); ?></th>
                                <th> <?php echo e(__('Ip')); ?></th>
                                <th> <?php echo e(__('Last Login')); ?></th>
                                <th><?php echo e(__('Country')); ?></th>
                                <th> <?php echo e(__('Device Type')); ?></th>
                                <th><?php echo e(__('OS Name')); ?></th>
                                <?php if(Laratrust::hasPermission('userlog show') || Laratrust::hasPermission('userlog delete')): ?>
                                    <th class="text-right"><?php echo e(__('Action')); ?></th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <?php
                                        $data = json_decode($user->details);
                                    ?>
                                        <td><?php echo e($user->user_name); ?></td>
                                        <th>
                                            <div class="badge bg-primary p-2 role-badge"><?php echo e($user->role); ?>

                                            </div>
                                        </th>
                                        <td><?php echo e($user->user_email); ?></td>
                                        <td><?php echo e($user->ip); ?></td>
                                        <td><?php echo e($user->date); ?></td>
                                        <td><?php echo e(isset($data->country) ? $data->country : ''); ?></td>
                                        <td><?php echo e($data->device_type); ?></td>
                                        <td><?php echo e($data->os_name); ?></td>
                                        <td>
                                            <?php if (app('laratrust')->hasPermission('userlog show')) : ?>
                                                <div class="action-btn me-2">
                                                    <a href="#" data-url="<?php echo e(route('userlog.display', $user->id)); ?>"
                                                        class="mx-3 bg-warning btn btn-sm d-inline-flex align-items-center"
                                                        title="<?php echo e(__('View Log Details')); ?>" data-ajax-popup="true"
                                                        data-size="xs" data-title="<?php echo e(__('View User Log')); ?>">
                                                        <span class="text-white"><i class="ti ti-eye"></i></span>
                                                    </a>
                                                </div>
                                            <?php endif; // app('laratrust')->permission ?>

                                            <?php if (app('laratrust')->hasPermission('userlog delete')) : ?>
                                                <div class="action-btn">
                                                    <form method="POST" action="<?php echo e(route('userlog.destroy', $user->id)); ?>"
                                                        id="user-form-<?php echo e($user->id); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <input name="_method" type="hidden" value="DELETE">
                                                        <a class="mx-3 bg-danger btn btn-sm  align-items-center bs-pass-para show_confirm"
                                                            data-bs-toggle="tooltip" title=""
                                                            data-bs-original-title="Delete" aria-label="Delete"
                                                            data-confirm="<?php echo e(__('Are You Sure?')); ?>"
                                                            data-text="<?php echo e(__('This action can not be undone. Do you want to continue?')); ?>"
                                                            data-confirm-yes="delete-form-<?php echo e($user->id); ?>"><i
                                                                class="ti ti-trash text-white text-white"></i></a>
                                                    </form>
                                                </div>
                                            <?php endif; // app('laratrust')->permission ?>
                                        </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/phoxag/dash.phoxago.com/resources/views/admin/users/userLog.blade.php ENDPATH**/ ?>