<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Notification Templates')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('title'); ?>
    <div class="d-inline-block">
        <h5 class="h4 d-inline-block font-weight-400 mb-0"><?php echo e(__('Notification Templates')); ?></h5>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Notification Templates')); ?></li>
<?php $__env->stopSection(); ?>

<?php
    $activeModule = '';
    foreach ($notifications as $key => $value) {
        $txt = moduleIsActive($key);
        if ($txt == true) {
            $activeModule = $key;
            break;
        }
    }
?>

<?php $__env->startSection('content'); ?>
    <?php
        $activeModules = [];
        foreach ($notifications as $key => $value) {
            if (moduleIsActive($key)) {
                $activeModules[$key] = $key;
            }
        }
    ?>
    <div class="information-tab-wrp ms-auto my-md-4 mb-4 mt-2">
        <?php if(count($activeModules) > 0): ?>
            <ul class="nav nav-pills nav-fill cust-nav information-tab p-2" id="pills-tab" role="tablist">
                <?php $__currentLoopData = $activeModules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(moduleIsActive($key) && $key == 'Slack'): ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="slack" data-bs-toggle="pill" data-bs-target="#slack-tab"
                                type="button"><?php echo e(__('Slack')); ?></button>
                        </li>
                    <?php endif; ?>
                    <?php if(moduleIsActive($key) && $key == 'Telegram'): ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="telegram" data-bs-toggle="pill" data-bs-target="#telegram-tab"
                                type="button"><?php echo e(__('Telegram')); ?></button>
                        </li>
                    <?php endif; ?>
                    <?php if(moduleIsActive($key) && $key == 'Twilio'): ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="twilio" data-bs-toggle="pill" data-bs-target="#twilio-tab"
                                type="button"><?php echo e(__('Twilio')); ?></button>
                        </li>
                    <?php endif; ?>
                    <?php if(moduleIsActive($key) && $key == 'Whatsapp'): ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="whatsapp" data-bs-toggle="pill" data-bs-target="#whatsapp-tab"
                                type="button"><?php echo e(__('Whatsapp')); ?></button>
                        </li>
                    <?php endif; ?>
                    <?php if(moduleIsActive($key) && $key == 'WhatsAppAPI'): ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="whatsappapi" data-bs-toggle="pill" data-bs-target="#whatsappapi-tab"
                                type="button"><?php echo e(__('WhatsApp API')); ?></button>
                        </li>
                    <?php endif; ?>
                    <?php if(moduleIsActive($key) && $key == 'SMS'): ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="sms" data-bs-toggle="pill" data-bs-target="#sms-tab"
                                type="button"><?php echo e(__('SMS')); ?></button>
                        </li>
                    <?php endif; ?>
                    <?php if(moduleIsActive($key) && $key == 'Discord'): ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="discord" data-bs-toggle="pill" data-bs-target="#discord-tab"
                                type="button"><?php echo e(__('Discord')); ?></button>
                        </li>
                    <?php endif; ?>
                    <?php if(moduleIsActive($key) && $key == 'Plivo'): ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="plivo" data-bs-toggle="pill" data-bs-target="#plivo-tab"
                                type="button"><?php echo e(__('Plivo')); ?></button>
                        </li>
                    <?php endif; ?>
                    <?php if(moduleIsActive($key) && $key == 'RocketChat'): ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="rocketchat" data-bs-toggle="pill" data-bs-target="#rocketchat-tab"
                                type="button"><?php echo e(__('RocketChat')); ?></button>
                        </li>
                    <?php endif; ?>
                    <?php if(moduleIsActive($key) && $key == 'Zitasms'): ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="zitasms" data-bs-toggle="pill" data-bs-target="#zitasms-tab"
                                type="button"><?php echo e(__('Zitasms')); ?></button>
                        </li>
                    <?php endif; ?>
                    <?php if(moduleIsActive($key) && $key == 'Msg91'): ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="msg91" data-bs-toggle="pill" data-bs-target="#msg91-tab"
                                type="button"><?php echo e(__('Msg91')); ?></button>
                        </li>
                    <?php endif; ?>
                    <?php if(moduleIsActive($key) && $key == 'SinchSMS'): ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="sinchsms" data-bs-toggle="pill" data-bs-target="#sinchsms-tab"
                                type="button"><?php echo e(__('SinchSMS')); ?></button>
                        </li>
                    <?php endif; ?>
                    <?php if(moduleIsActive($key) && $key == 'BulkSMS'): ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="bulksms" data-bs-toggle="pill" data-bs-target="#bulksms-tab"
                                type="button"><?php echo e(__('BulkSMS')); ?></button>
                        </li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        <?php endif; ?>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card overflow-auto">
                <div class="card-body">
                    <?php if($activeModule == ''): ?>
                        <div class="text-center">
                            <h5 class="text-danger">
                                <?php echo e(__('Make sure to activate at least one notification add-on. A notification template will be visible after that.')); ?>

                            </h5>
                        </div>
                    <?php endif; ?>
                    <div class="tab-content" id="pills-tabContent">
                        <div class="tab-pane fade show " id="slack-tab" role="tabpanel" aria-labelledby="pills-user-tab-1">
                            <table class="table mb-0 pc-dt-simple" id="slack-notify">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th><?php echo e(__('Module')); ?></th>
                                        <?php if(Laratrust::hasPermission('notification-template view')): ?>
                                            <th class="text-end"><?php echo e(__('Action')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(moduleIsActive($key) && $key == 'Slack'): ?>
                                            <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($value->action); ?></td>
                                                    <td class="text-capitalize"><?php echo e(moduleAliasName($value->module)); ?>

                                                    </td>
                                                    <?php if (app('laratrust')->hasPermission('notification-template view')) : ?>
                                                    <td class="text-end">
                                                        <div class="text-end">
                                                            <div class="action-btn me-2">
                                                                <a href="<?php echo e(route('manage.notification.language', [$value->id, getActiveLanguage()])); ?>"
                                                                    class="mx-3 bg-warning btn btn-sm d-inline-flex align-items-center"
                                                                    data-toggle="tooltip" title="<?php echo e(__('Manage Your Slack Message')); ?>">
                                                                    <span class="text-white"><i class="ti ti-eye"></i></span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <?php endif; // app('laratrust')->permission ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="tab-pane fade show " id="telegram-tab" role="tabpanel"
                            aria-labelledby="pills-user-tab-1">
                            <table class="table mb-0 pc-dt-simple" id="telegram-notify">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th><?php echo e(__('Module')); ?></th>
                                        <?php if(Laratrust::hasPermission('notification-template view')): ?>
                                            <th class="text-end"><?php echo e(__('Action')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(moduleIsActive($key) && $key == 'Telegram'): ?>
                                            <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($value->action); ?></td>
                                                    <td class="text-capitalize"><?php echo e(moduleAliasName($value->module)); ?>

                                                    </td>
                                                    <?php if (app('laratrust')->hasPermission('notification-template view')) : ?>
                                                    <td class="text-end">
                                                        <div class="text-end">
                                                            <div class="action-btn me-2">
                                                                <a href="<?php echo e(route('manage.notification.language', [$value->id, getActiveLanguage()])); ?>"
                                                                    class="mx-3 bg-warning btn btn-sm d-inline-flex align-items-center"
                                                                    data-toggle="tooltip"
                                                                    title="<?php echo e(__('Manage Your Telegram Message')); ?>">
                                                                    <span class="text-white"><i class="ti ti-eye"></i></span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <?php endif; // app('laratrust')->permission ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="tab-pane fade show " id="twilio-tab" role="tabpanel" aria-labelledby="pills-user-tab-1">
                            <table class="table mb-0 pc-dt-simple" id="twilio-notify">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th><?php echo e(__('Module')); ?></th>
                                        <?php if(Laratrust::hasPermission('notification-template view')): ?>
                                            <th class="text-end"><?php echo e(__('Action')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(moduleIsActive($key) && $key == 'Twilio'): ?>
                                            <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($value->action); ?></td>
                                                    <td class="text-capitalize"><?php echo e(moduleAliasName($value->module)); ?>

                                                    </td>
                                                    <?php if (app('laratrust')->hasPermission('notification-template view')) : ?>
                                                    <td class="text-end">
                                                        <div class="text-end">
                                                            <div class="action-btn me-2">
                                                                <a href="<?php echo e(route('manage.notification.language', [$value->id, getActiveLanguage()])); ?>"
                                                                    class="mx-3 bg-warning btn btn-sm d-inline-flex align-items-center"
                                                                    data-toggle="tooltip"
                                                                    title="<?php echo e(__('Manage Your Twilio Message')); ?>">
                                                                    <span class="text-white"><i class="ti ti-eye"></i></span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <?php endif; // app('laratrust')->permission ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="tab-pane fade show " id="whatsapp-tab" role="tabpanel"
                            aria-labelledby="pills-user-tab-1">
                            <table class="table mb-0 pc-dt-simple" id="whatsapp-notify">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th><?php echo e(__('Module')); ?></th>
                                        <?php if(Laratrust::hasPermission('notification-template view')): ?>
                                            <th class="text-end"><?php echo e(__('Action')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(moduleIsActive($key) && $key == 'Whatsapp'): ?>
                                            <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($value->action); ?></td>
                                                    <td class="text-capitalize"><?php echo e(moduleAliasName($value->module)); ?>

                                                    </td>
                                                    <?php if (app('laratrust')->hasPermission('notification-template view')) : ?>
                                                    <td class="text-end">
                                                        <div class="text-end">
                                                            <div class="action-btn me-2">
                                                                <a href="<?php echo e(route('manage.notification.language', [$value->id, getActiveLanguage()])); ?>"
                                                                    class="mx-3 bg-warning btn btn-sm d-inline-flex align-items-center"
                                                                    data-toggle="tooltip"
                                                                    title="<?php echo e(__('Manage Your Whatsapp Message')); ?>">
                                                                    <span class="text-white"><i class="ti ti-eye"></i></span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <?php endif; // app('laratrust')->permission ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="tab-pane fade show " id="whatsappapi-tab" role="tabpanel"
                            aria-labelledby="pills-user-tab-1">
                            <table class="table mb-0 pc-dt-simple" id="whatsappapi-notify">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th><?php echo e(__('Module')); ?></th>
                                        <?php if(Laratrust::hasPermission('notification-template view')): ?>
                                            <th class="text-end"><?php echo e(__('Action')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(moduleIsActive($key) && $key == 'WhatsAppAPI'): ?>
                                            <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($value->action); ?></td>
                                                    <td class="text-capitalize"><?php echo e(moduleAliasName($value->module)); ?>

                                                    </td>
                                                    <?php if (app('laratrust')->hasPermission('notification-template view')) : ?>
                                                    <td class="text-end">
                                                        <div class="text-end">
                                                            <div class="action-btn me-2">
                                                                <a href="<?php echo e(route('manage.notification.language', [$value->id, getActiveLanguage()])); ?>"
                                                                    class="mx-3 bg-warning btn btn-sm d-inline-flex align-items-center"
                                                                    data-toggle="tooltip"
                                                                    title="<?php echo e(__('Manage Your WhatsApp API Message')); ?>">
                                                                    <span class="text-white"><i class="ti ti-eye"></i></span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <?php endif; // app('laratrust')->permission ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="tab-pane fade show " id="sms-tab" role="tabpanel" aria-labelledby="pills-user-tab-1">
                            <table class="table mb-0 pc-dt-simple" id="sms-notify">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th><?php echo e(__('Module')); ?></th>
                                        <?php if(Laratrust::hasPermission('notification-template view')): ?>
                                            <th class="text-end"><?php echo e(__('Action')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(moduleIsActive($key) && $key == 'SMS'): ?>
                                            <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($value->action); ?></td>
                                                    <td class="text-capitalize"><?php echo e(moduleAliasName($value->module)); ?>

                                                    </td>
                                                    <?php if (app('laratrust')->hasPermission('notification-template view')) : ?>
                                                    <td class="text-end">
                                                        <div class="text-end">
                                                            <div class="action-btn me-2">
                                                                <a href="<?php echo e(route('manage.notification.language', [$value->id, getActiveLanguage()])); ?>"
                                                                    class="mx-3 bg-warning btn btn-sm d-inline-flex align-items-center"
                                                                    data-toggle="tooltip" title="<?php echo e(__('Manage Your SMS Message')); ?>">
                                                                    <span class="text-white"><i class="ti ti-eye"></i></span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <?php endif; // app('laratrust')->permission ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="tab-pane fade show " id="discord-tab" role="tabpanel"
                            aria-labelledby="pills-user-tab-1">
                            <table class="table mb-0 pc-dt-simple" id="discord-notify">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th><?php echo e(__('Module')); ?></th>
                                        <?php if(Laratrust::hasPermission('notification-template view')): ?>
                                            <th class="text-end"><?php echo e(__('Action')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(moduleIsActive($key) && $key == 'Discord'): ?>
                                            <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($value->action); ?></td>
                                                    <td class="text-capitalize"><?php echo e(moduleAliasName($value->module)); ?>

                                                    </td>
                                                    <?php if (app('laratrust')->hasPermission('notification-template view')) : ?>
                                                    <td class="text-end">
                                                        <div class="text-end">
                                                            <div class="action-btn me-2">
                                                                <a href="<?php echo e(route('manage.notification.language', [$value->id, getActiveLanguage()])); ?>"
                                                                    class="mx-3 bg-warning btn btn-sm d-inline-flex align-items-center"
                                                                    data-toggle="tooltip"
                                                                    title="<?php echo e(__('Manage Your Discord Message')); ?>">
                                                                    <span class="text-white"><i class="ti ti-eye"></i></span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <?php endif; // app('laratrust')->permission ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="tab-pane fade show " id="plivo-tab" role="tabpanel" aria-labelledby="pills-user-tab-1">
                            <table class="table mb-0 pc-dt-simple" id="plivo-notify">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th><?php echo e(__('Module')); ?></th>
                                        <?php if(Laratrust::hasPermission('notification-template view')): ?>
                                            <th class="text-end"><?php echo e(__('Action')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(moduleIsActive($key) && $key == 'Plivo'): ?>
                                            <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($value->action); ?></td>
                                                    <td class="text-capitalize"><?php echo e(moduleAliasName($value->module)); ?>

                                                    </td>
                                                    <?php if (app('laratrust')->hasPermission('notification-template view')) : ?>
                                                    <td class="text-end">
                                                        <div class="text-end">
                                                            <div class="action-btn me-2">
                                                                <a href="<?php echo e(route('manage.notification.language', [$value->id, getActiveLanguage()])); ?>"
                                                                    class="mx-3 bg-warning btn btn-sm d-inline-flex align-items-center"
                                                                    data-toggle="tooltip" title="<?php echo e(__('Manage Your Plivo Message')); ?>">
                                                                    <span class="text-white"><i class="ti ti-eye"></i></span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <?php endif; // app('laratrust')->permission ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="tab-pane fade show " id="rocketchat-tab" role="tabpanel"
                            aria-labelledby="pills-user-tab-1">
                            <table class="table mb-0 pc-dt-simple" id="rocketchat-notify">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th><?php echo e(__('Module')); ?></th>
                                        <?php if(Laratrust::hasPermission('notification-template view')): ?>
                                            <th class="text-end"><?php echo e(__('Action')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(moduleIsActive($key) && $key == 'RocketChat'): ?>
                                            <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($value->action); ?></td>
                                                    <td class="text-capitalize"><?php echo e(moduleAliasName($value->module)); ?>

                                                    </td>
                                                    <?php if (app('laratrust')->hasPermission('notification-template view')) : ?>
                                                    <td class="text-end">
                                                        <div class="text-end">
                                                            <div class="action-btn me-2">
                                                                <a href="<?php echo e(route('manage.notification.language', [$value->id, getActiveLanguage()])); ?>"
                                                                    class="mx-3 bg-warning btn btn-sm d-inline-flex align-items-center"
                                                                    data-toggle="tooltip"
                                                                    title="<?php echo e(__('Manage Your RocketChat Message')); ?>">
                                                                    <span class="text-white"><i class="ti ti-eye"></i></span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <?php endif; // app('laratrust')->permission ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="tab-pane fade show " id="zitasms-tab" role="tabpanel"
                            aria-labelledby="pills-user-tab-1">
                            <table class="table mb-0 pc-dt-simple" id="zitasms-notify">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th><?php echo e(__('Module')); ?></th>
                                        <?php if(Laratrust::hasPermission('notification-template view')): ?>
                                            <th class="text-end"><?php echo e(__('Action')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(moduleIsActive($key) && $key == 'Zitasms'): ?>
                                            <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($value->action); ?></td>
                                                    <td class="text-capitalize"><?php echo e(moduleAliasName($value->module)); ?>

                                                    </td>
                                                    <?php if (app('laratrust')->hasPermission('notification-template view')) : ?>
                                                    <td class="text-end">
                                                        <div class="text-end">
                                                            <div class="action-btn me-2">
                                                                <a href="<?php echo e(route('manage.notification.language', [$value->id, getActiveLanguage()])); ?>"
                                                                    class="mx-3 bg-warning btn btn-sm d-inline-flex align-items-center"
                                                                    data-toggle="tooltip"
                                                                    title="<?php echo e(__('Manage Your Zitasms Message')); ?>">
                                                                    <span class="text-white"><i class="ti ti-eye"></i></span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <?php endif; // app('laratrust')->permission ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="tab-pane fade show " id="msg91-tab" role="tabpanel" aria-labelledby="pills-user-tab-1">
                            <table class="table mb-0 pc-dt-simple" id="msg91-notify">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th><?php echo e(__('Module')); ?></th>
                                        <?php if(Laratrust::hasPermission('notification-template view')): ?>
                                            <th class="text-end"><?php echo e(__('Action')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(moduleIsActive($key) && $key == 'Msg91'): ?>
                                            <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($value->action); ?></td>
                                                    <td class="text-capitalize"><?php echo e(moduleAliasName($value->module)); ?>

                                                    </td>
                                                    <?php if (app('laratrust')->hasPermission('notification-template view')) : ?>
                                                    <td class="text-end">
                                                        <div class="text-end">
                                                            <div class="action-btn me-2">
                                                                <a href="<?php echo e(route('manage.notification.language', [$value->id, getActiveLanguage()])); ?>"
                                                                    class="mx-3 bg-warning btn btn-sm d-inline-flex align-items-center"
                                                                    data-toggle="tooltip" title="<?php echo e(__('Manage Your Msg91 Message')); ?>">
                                                                    <span class="text-white"><i class="ti ti-eye"></i></span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <?php endif; // app('laratrust')->permission ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="tab-pane fade show " id="sinchsms-tab" role="tabpanel"
                            aria-labelledby="pills-user-tab-1">
                            <table class="table mb-0 pc-dt-simple" id="sinchsms-notify">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th><?php echo e(__('Module')); ?></th>
                                        <?php if(Laratrust::hasPermission('notification-template view')): ?>
                                            <th class="text-end"><?php echo e(__('Action')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(moduleIsActive($key) && $key == 'SinchSMS'): ?>
                                            <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($value->action); ?></td>
                                                    <td class="text-capitalize"><?php echo e(moduleAliasName($value->module)); ?>

                                                    </td>
                                                    <?php if (app('laratrust')->hasPermission('notification-template view')) : ?>
                                                    <td class="text-end">
                                                        <div class="text-end">
                                                            <div class="action-btn me-2">
                                                                <a href="<?php echo e(route('manage.notification.language', [$value->id, getActiveLanguage()])); ?>"
                                                                    class="mx-3 bg-warning btn btn-sm d-inline-flex align-items-center"
                                                                    data-toggle="tooltip"
                                                                    title="<?php echo e(__('Manage Your SinchSMs Message')); ?>">
                                                                    <span class="text-white"><i class="ti ti-eye"></i></span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <?php endif; // app('laratrust')->permission ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="tab-pane fade show " id="bulksms-tab" role="tabpanel"
                            aria-labelledby="pills-user-tab-1">
                            <table class="table mb-0 pc-dt-simple" id="bulksms-notify">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th><?php echo e(__('Module')); ?></th>
                                        <?php if(Laratrust::hasPermission('notification-template view')): ?>
                                            <th class="text-end"><?php echo e(__('Action')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(moduleIsActive($key) && $key == 'BulkSMS'): ?>
                                            <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($value->action); ?></td>
                                                    <td class="text-capitalize"><?php echo e(moduleAliasName($value->module)); ?>

                                                    </td>
                                                    <?php if (app('laratrust')->hasPermission('notification-template view')) : ?>
                                                    <td class="text-end">
                                                        <div class="text-end">
                                                            <div class="action-btn me-2">
                                                                <a href="<?php echo e(route('manage.notification.language', [$value->id, getActiveLanguage()])); ?>"
                                                                    class="mx-3 bg-warning btn btn-sm d-inline-flex align-items-center"
                                                                    data-toggle="tooltip"
                                                                    title="<?php echo e(__('Manage Your BulkSMS Message')); ?>">
                                                                    <span class="text-white"><i class="ti ti-eye"></i></span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <?php endif; // app('laratrust')->permission ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function () {
            var moduleName = '<?php echo e($activeModule); ?>';
            if (moduleName == 'Slack') {
                $('#slack').addClass('active');
                $('#slack-tab').addClass('active');
            } else if (moduleName == 'Telegram') {
                $('#telegram').addClass('active');
                $('#telegram-tab').addClass('active');
            } else if (moduleName == 'Twilio') {
                $('#twilio').addClass('active');
                $('#twilio-tab').addClass('active');
            } else if (moduleName == 'Whatsapp') {
                $('#whatsapp').addClass('active');
                $('#whatsapp-tab').addClass('active');
            } else if (moduleName == 'WhatsAppAPI') {
                $('#whatsappapi').addClass('active');
                $('#whatsappapi-tab').addClass('active');
            } else if (moduleName == 'SMS') {
                $('#sms').addClass('active');
                $('#sms-tab').addClass('active');
            } else if (moduleName == 'Discord') {
                $('#discord').addClass('active');
                $('#discord-tab').addClass('active');
            } else if (moduleName == 'Plivo') {
                $('#plivo').addClass('active');
                $('#plivo-tab').addClass('active');
            } else if (moduleName == 'RocketChat') {
                $('#rocketchat').addClass('active');
                $('#rocketchat-tab').addClass('active');
            } else if (moduleName == 'Zitasms') {
                $('#zitasms').addClass('active');
                $('#zitasms-tab').addClass('active');
            } else if (moduleName == 'Msg91') {
                $('#msg91').addClass('active');
                $('#msg91-tab').addClass('active');
            } else if (moduleName == 'SinchSMS') {
                $('#sinchsms').addClass('active');
                $('#sinchsms-tab').addClass('active');
            } else if (moduleName == 'BulkSMS') {
                $('#bulksms').addClass('active');
                $('#bulksms-tab').addClass('active');
            }
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/phoxag/dash.phoxago.com/resources/views/notification_templates/index.blade.php ENDPATH**/ ?>