<?php $__env->startSection('page-title'); ?>
<?php echo e(__('Search Your Ticket')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('language-bar'); ?>
<div class="lang-dropdown-only-desk">
    <li class="dropdown dash-h-item drp-language">
        <a class="dash-head-link dropdown-toggle btn" href="#" data-bs-toggle="dropdown" aria-expanded="false">
            <span class="drp-text"> <?php echo e(ucfirst($language->fullName)); ?>

            </span>
        </a>
        <div class="dropdown-menu dash-h-dropdown dropdown-menu-end">
            <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route('search', $code)); ?>" tabindex="0"
                class="dropdown-item dropdown-item <?php echo e($lang == $code ? 'active' : ''); ?>">
                <span><?php echo e(ucFirst($language)); ?></span>
            </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </li>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="auth-wrapper login-page">
    <div class="bottom-bg">
        <svg width="69" height="129" viewBox="0 0 69 129" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path
                d="M2.6351 123.878C3.41663 123.079 4.68262 123.075 5.47146 123.847C6.2603 124.619 6.27396 125.895 5.50185 126.684C4.72031 127.482 3.45432 127.486 2.66548 126.714C1.87664 125.942 1.85356 124.676 2.6351 123.878Z"
                fill="white" />
            <path
                d="M10.2806 116.066C11.0527 115.277 12.3281 115.263 13.117 116.035C13.9058 116.808 13.9195 118.083 13.1474 118.872C12.3658 119.67 11.0904 119.684 10.3016 118.912C9.52215 118.13 9.50849 116.855 10.2806 116.066Z"
                fill="white" />
            <path
                d="M2.63314 108.58C3.40526 107.792 4.68067 107.778 5.46951 108.55C6.25835 109.322 6.27201 110.597 5.4999 111.386C4.71837 112.185 3.44295 112.198 2.65411 111.426C1.86507 110.635 1.86103 109.369 2.63314 108.58Z"
                fill="white" />
            <path
                d="M17.9265 108.255C18.6986 107.466 19.993 107.452 20.7722 108.215C21.5611 108.987 21.5747 110.262 20.7932 111.061C20.0211 111.849 18.7457 111.863 17.9568 111.091C17.168 110.319 17.1543 109.043 17.9265 108.255Z"
                fill="white" />
            <path
                d="M10.279 100.769C11.0511 99.98 12.3359 99.9567 13.1248 100.729C13.9136 101.501 13.9273 102.776 13.1458 103.575C12.3736 104.364 11.0982 104.377 10.3094 103.605C9.51092 102.824 9.50688 101.558 10.279 100.769Z"
                fill="white" />
            <path
                d="M2.62177 93.2737C3.39389 92.4848 4.67872 92.4616 5.46756 93.2337C6.25639 94.0058 6.27006 95.2812 5.48853 96.0797C4.71641 96.8685 3.45061 96.8916 2.65215 96.1101C1.85369 95.3285 1.84965 94.0625 2.62177 93.2737Z"
                fill="white" />
            <path
                d="M25.5814 100.433C26.3629 99.6349 27.6385 99.6403 28.4178 100.403C29.2066 101.175 29.2203 102.451 28.4481 103.239C27.676 104.028 26.3912 104.051 25.6024 103.279C24.8135 102.507 24.7999 101.232 25.5814 100.433Z"
                fill="white" />
            <path
                d="M17.9339 92.9479C18.7155 92.1494 19.9815 92.1454 20.7703 92.9175C21.5591 93.6896 21.5728 94.965 20.8007 95.7539C20.0286 96.5427 18.7437 96.566 17.9549 95.7939C17.1564 95.0124 17.1524 93.7464 17.9339 92.9479Z"
                fill="white" />
            <path
                d="M10.2757 85.4527C11.0573 84.6542 12.3232 84.6502 13.1121 85.4223C13.9009 86.1944 13.9146 87.4698 13.1425 88.2586C12.3704 89.0475 11.0951 89.0802 10.2967 88.2987C9.49823 87.5171 9.49419 86.2511 10.2757 85.4527Z"
                fill="white" />
            <path
                d="M2.62826 77.9668C3.40979 77.1684 4.66617 77.1549 5.46463 77.9364C6.25346 78.7086 6.26713 79.984 5.49502 80.7728C4.7229 81.5616 3.43807 81.5849 2.64923 80.8128C1.85077 80.0313 1.84673 78.7653 2.62826 77.9668Z"
                fill="white" />
            <path
                d="M33.2279 92.6221C34.0094 91.8236 35.285 91.829 36.0642 92.5917C36.8531 93.3638 36.8667 94.6392 36.0946 95.4281C35.3225 96.2169 34.0471 96.2306 33.2583 95.4585C32.4694 94.6863 32.4463 93.4206 33.2279 92.6221Z"
                fill="white" />
            <path
                d="M25.5794 85.1361C26.361 84.3377 27.627 84.3336 28.4158 85.1057C29.2046 85.8779 29.2183 87.1533 28.4462 87.9421C27.6741 88.731 26.3987 88.7446 25.6098 87.9725C24.8114 87.191 24.7979 85.9346 25.5794 85.1361Z"
                fill="white" />
            <path
                d="M17.9222 77.641C18.7037 76.8426 19.9697 76.8385 20.7586 77.6106C21.5474 78.3827 21.5611 79.6582 20.789 80.447C20.0168 81.2358 18.751 81.2589 17.9526 80.4774C17.1541 79.6959 17.1407 78.4395 17.9222 77.641Z"
                fill="white" />
            <path
                d="M10.2747 70.1555C11.0563 69.3571 12.3127 69.3436 13.1111 70.1252C13.8999 70.8973 13.9136 72.1727 13.1415 72.9615C12.3694 73.7504 11.094 73.764 10.3051 72.9919C9.50667 72.2104 9.49321 70.954 10.2747 70.1555Z"
                fill="white" />
            <path
                d="M2.60678 62.6507C3.38831 61.8522 4.65431 61.8482 5.44315 62.6203C6.23198 63.3924 6.24565 64.6678 5.47353 65.4566C4.70141 66.2455 3.426 66.2592 2.63716 65.487C1.84832 64.7149 1.82524 63.4491 2.60678 62.6507Z"
                fill="white" />
            <path
                d="M40.8734 84.8107C41.6455 84.0219 42.9209 84.0082 43.7097 84.7803C44.4986 85.5524 44.5122 86.8278 43.7401 87.6167C42.9586 88.4151 41.6832 88.4288 40.8943 87.6567C40.1149 86.8749 40.1013 85.5995 40.8734 84.8107Z"
                fill="white" />
            <path
                d="M33.2249 77.3249C33.9971 76.536 35.2725 76.5224 36.0613 77.2945C36.8501 78.0666 36.8638 79.342 36.0823 80.1405C35.3102 80.9293 34.0347 80.943 33.2459 80.1708C32.4569 79.3797 32.4528 78.1137 33.2249 77.3249Z"
                fill="white" />
            <path
                d="M25.5687 69.8296C26.3408 69.0408 27.6162 69.0271 28.4051 69.7992C29.1939 70.5713 29.2076 71.8468 28.426 72.6452C27.6539 73.4341 26.3881 73.4571 25.5897 72.6756C24.8006 71.8845 24.7966 70.6185 25.5687 69.8296Z"
                fill="white" />
            <path
                d="M17.9203 62.3439C18.6924 61.5551 19.9582 61.532 20.7566 62.3135C21.5455 63.0856 21.5591 64.361 20.7776 65.1595C20.0055 65.9483 18.7301 65.962 17.9412 65.1899C17.1522 64.3987 17.1481 63.1327 17.9203 62.3439Z"
                fill="white" />
            <path
                d="M10.2533 54.8394C11.0254 54.0505 12.3008 54.0369 13.0896 54.809C13.8785 55.5811 13.8921 56.8565 13.1106 57.655C12.3385 58.4438 11.0631 58.4575 10.2742 57.6854C9.49481 56.9036 9.48114 55.6282 10.2533 54.8394Z"
                fill="white" />
            <path
                d="M2.59505 47.3441C3.36717 46.5553 4.65221 46.5511 5.44104 47.3232C6.22988 48.0953 6.24355 49.3707 5.46201 50.1692C4.6899 50.958 3.41448 50.9717 2.62564 50.1996C1.8366 49.4084 1.82294 48.133 2.59505 47.3441Z"
                fill="white" />
            <path
                d="M48.5192 76.9993C49.3008 76.2008 50.5762 76.1871 51.365 76.9593C52.1539 77.7314 52.1675 79.0068 51.386 79.8053C50.6139 80.5941 49.3385 80.6078 48.5496 79.8356C47.7608 79.0635 47.7471 77.7881 48.5192 76.9993Z"
                fill="white" />
            <path
                d="M40.8708 69.5133C41.6523 68.7149 42.9277 68.7012 43.7166 69.4733C44.5054 70.2454 44.5191 71.5208 43.7376 72.3193C42.9654 73.1081 41.69 73.1218 40.9012 72.3497C40.1027 71.5681 40.0987 70.3021 40.8708 69.5133Z"
                fill="white" />
            <path
                d="M33.2136 62.0182C33.9951 61.2197 35.2705 61.2061 36.0594 61.9782C36.8482 62.7503 36.8619 64.0257 36.0803 64.8242C35.3082 65.613 34.0424 65.6361 33.244 64.8546C32.4455 64.073 32.4415 62.807 33.2136 62.0182Z"
                fill="white" />
            <path
                d="M25.5661 54.5324C26.3476 53.7339 27.6134 53.7108 28.4119 54.4923C29.2007 55.2645 29.2144 56.5399 28.4329 57.3383C27.6607 58.1272 26.3853 58.1408 25.5965 57.3687C24.798 56.5872 24.794 55.3212 25.5661 54.5324Z"
                fill="white" />
            <path
                d="M17.8991 47.0278C18.6806 46.2294 19.9561 46.2157 20.7449 46.9878C21.5337 47.7599 21.5474 49.0354 20.7659 49.8338C19.9938 50.6227 18.7183 50.6363 17.9295 49.8642C17.1407 49.0921 17.127 47.8167 17.8991 47.0278Z"
                fill="white" />
            <path
                d="M10.2419 39.5327C11.0234 38.7343 12.3085 38.73 13.0973 39.5021C13.8861 40.2742 13.8998 41.5497 13.1183 42.3481C12.3461 43.137 11.0707 43.1506 10.2819 42.3785C9.48344 41.597 9.46977 40.3216 10.2419 39.5327Z"
                fill="white" />
            <path
                d="M2.59345 32.0469C3.37498 31.2484 4.6504 31.2348 5.43924 32.0069C6.22808 32.779 6.24174 34.0544 5.46021 34.8529C4.68809 35.6417 3.41268 35.6554 2.62384 34.8832C1.835 34.1111 1.82133 32.8357 2.59345 32.0469Z"
                fill="white" />
            <path
                d="M56.1742 69.1783C56.9463 68.3894 58.2217 68.3757 59.0105 69.1479C59.7994 69.92 59.813 71.1954 59.0409 71.9842C58.2688 72.7731 56.9934 72.7867 56.2045 72.0146C55.4157 71.2425 55.3926 69.9767 56.1742 69.1783Z"
                fill="white" />
            <path
                d="M48.5267 61.6924C49.2988 60.9036 50.5742 60.8899 51.3631 61.662C52.1519 62.4341 52.1656 63.7096 51.3935 64.4984C50.6213 65.2872 49.3459 65.3009 48.5571 64.5288C47.7586 63.7472 47.7452 62.4909 48.5267 61.6924Z"
                fill="white" />
            <path
                d="M40.8695 54.1972C41.6416 53.4083 42.917 53.3947 43.7058 54.1668C44.4947 54.9389 44.5083 56.2143 43.7362 57.0032C42.9641 57.792 41.6983 57.8151 40.8999 57.0335C40.1014 56.252 40.0879 54.9956 40.8695 54.1972Z"
                fill="white" />
            <path
                d="M33.221 46.7113C33.9931 45.9225 35.2589 45.8994 36.0574 46.6809C36.8462 47.4531 36.8599 48.7285 36.0878 49.5173C35.3157 50.3062 34.0403 50.3198 33.2514 49.5477C32.453 48.7662 32.4395 47.5098 33.221 46.7113Z"
                fill="white" />
            <path
                d="M25.554 39.2069C26.3262 38.4181 27.6016 38.4044 28.3904 39.1766C29.1792 39.9487 29.1929 41.2241 28.4208 42.0129C27.6487 42.8018 26.3733 42.8154 25.5844 42.0433C24.7956 41.2712 24.7725 40.0054 25.554 39.2069Z"
                fill="white" />
            <path
                d="M17.8968 31.7117C18.6689 30.9229 19.954 30.9186 20.7428 31.6907C21.5316 32.4628 21.5453 33.7383 20.7732 34.5271C20.0011 35.3159 18.7257 35.3296 17.9368 34.5575C17.1384 33.776 17.1153 32.5102 17.8968 31.7117Z"
                fill="white" />
            <path
                d="M10.2484 24.2259C11.0205 23.437 12.2959 23.4234 13.0847 24.1955C13.8736 24.9676 13.8872 26.243 13.1151 27.0318C12.343 27.8207 11.0676 27.8343 10.2788 27.0622C9.48992 26.2901 9.46684 25.0243 10.2484 24.2259Z"
                fill="white" />
            <path
                d="M2.59115 16.7307C3.36327 15.9419 4.63868 15.9282 5.43714 16.7098C6.22598 17.4819 6.23964 18.7573 5.46752 19.5461C4.69541 20.335 3.41037 20.3392 2.63115 19.5765C1.83269 18.795 1.80962 17.5292 2.59115 16.7307Z"
                fill="white" />
            <path
                d="M63.8197 61.3666C64.5918 60.5778 65.8672 60.5641 66.656 61.3362C67.4449 62.1083 67.4585 63.3837 66.6864 64.1726C65.9049 64.971 64.6389 64.9751 63.85 64.203C63.0612 63.4309 63.0381 62.1651 63.8197 61.3666Z"
                fill="white" />
            <path
                d="M56.1722 53.881C56.9443 53.0922 58.2101 53.0691 59.0086 53.8506C59.7974 54.6227 59.8111 55.8982 59.039 56.687C58.2574 57.4855 56.9914 57.4895 56.2026 56.7174C55.4041 55.9358 55.3907 54.6795 56.1722 53.881Z"
                fill="white" />
            <path
                d="M48.515 46.3859C49.2871 45.5971 50.5529 45.574 51.3513 46.3555C52.1402 47.1276 52.1538 48.403 51.3817 49.1919C50.6002 49.9903 49.3438 50.0038 48.5454 49.2223C47.7469 48.4407 47.7334 47.1844 48.515 46.3859Z"
                fill="white" />
            <path
                d="M40.8665 38.9001C41.6387 38.1112 42.9044 38.0881 43.7029 38.8697C44.4917 39.6418 44.5054 40.9172 43.7333 41.706C42.9518 42.5045 41.6858 42.5085 40.8969 41.7364C40.0985 40.9549 40.085 39.6985 40.8665 38.9001Z"
                fill="white" />
            <path
                d="M33.2005 31.3955C33.9726 30.6067 35.2481 30.593 36.0369 31.3652C36.8257 32.1373 36.8394 33.4127 36.0673 34.2015C35.2857 35 34.0197 35.004 33.2309 34.2319C32.4421 33.4598 32.419 32.194 33.2005 31.3955Z"
                fill="white" />
            <path
                d="M25.5423 23.9004C26.3144 23.1116 27.5995 23.1073 28.3883 23.8794C29.1771 24.6516 29.1908 25.927 28.4187 26.7158C27.6372 27.5143 26.3712 27.5183 25.5823 26.7462C24.7935 25.9741 24.7608 24.6989 25.5423 23.9004Z"
                fill="white" />
            <path
                d="M17.8949 16.4146C18.667 15.6257 19.9424 15.6121 20.7312 16.3842C21.5201 17.1563 21.5337 18.4317 20.7616 19.2206C19.9801 20.019 18.7141 20.0231 17.9252 19.2509C17.1364 18.4788 17.1133 17.213 17.8949 16.4146Z"
                fill="white" />
            <path
                d="M10.2367 8.91934C11.0088 8.1305 12.2842 8.11684 13.0826 8.89837C13.8715 9.67049 13.8851 10.9459 13.113 11.7347C12.3315 12.5332 11.0655 12.5372 10.2767 11.7651C9.4782 10.9836 9.45512 9.7178 10.2367 8.91934Z"
                fill="white" />
            <path
                d="M2.5892 1.4335C3.36131 0.644661 4.62711 0.621582 5.42557 1.40311C6.2144 2.17523 6.22807 3.45065 5.45595 4.23948C4.67442 5.03794 3.40842 5.04199 2.61958 4.26987C1.82112 3.48834 1.80766 2.23196 2.5892 1.4335Z"
                fill="white" />
        </svg>

    </div>

    <div class="auth-content ticket-form-wrapper">
        
        <?php echo $__env->make('layouts.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="row login-row">
            <div class="top-bg">
                <svg width="66" height="129" viewBox="0 0 66 129" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M65.4557 123.878C64.6742 123.079 63.4082 123.075 62.6194 123.847C61.8305 124.619 61.8169 125.895 62.589 126.684C63.3705 127.482 64.6365 127.486 65.4253 126.714C66.2142 125.942 66.2373 124.676 65.4557 123.878Z"
                        fill="white"></path>
                    <path
                        d="M57.8095 116.066C57.0374 115.277 55.762 115.264 54.9731 116.036C54.1843 116.808 54.1706 118.083 54.9427 118.872C55.7243 119.671 56.9997 119.684 57.7885 118.912C58.5679 118.13 58.5816 116.855 57.8095 116.066Z"
                        fill="white"></path>
                    <path
                        d="M65.4574 108.58C64.6853 107.791 63.4099 107.777 62.6211 108.549C61.8322 109.322 61.8186 110.597 62.5907 111.386C63.3722 112.184 64.6476 112.198 65.4365 111.426C66.2255 110.635 66.2296 109.369 65.4574 108.58Z"
                        fill="white"></path>
                    <path
                        d="M50.1636 108.255C49.3915 107.466 48.0971 107.452 47.3178 108.215C46.529 108.987 46.5153 110.262 47.2969 111.061C48.069 111.849 49.3444 111.863 50.1332 111.091C50.9221 110.319 50.9357 109.043 50.1636 108.255Z"
                        fill="white"></path>
                    <path
                        d="M57.8113 100.769C57.0392 99.9803 55.7544 99.957 54.9655 100.729C54.1767 101.501 54.163 102.777 54.9446 103.575C55.7167 104.364 56.9921 104.378 57.781 103.606C58.5794 102.824 58.5835 101.558 57.8113 100.769Z"
                        fill="white"></path>
                    <path
                        d="M65.469 93.2741C64.6969 92.4852 63.4121 92.4619 62.6233 93.234C61.8344 94.0062 61.8208 95.2816 62.6023 96.08C63.3744 96.8689 64.6402 96.892 65.4387 96.1104C66.2371 95.3289 66.2412 94.0629 65.469 93.2741Z"
                        fill="white"></path>
                    <path
                        d="M42.5087 100.433C41.7272 99.6349 40.4516 99.6403 39.6723 100.403C38.8835 101.175 38.8698 102.451 39.642 103.239C40.4141 104.028 41.6989 104.051 42.4877 103.279C43.2766 102.507 43.2902 101.232 42.5087 100.433Z"
                        fill="white"></path>
                    <path
                        d="M50.1567 92.948C49.3751 92.1496 48.1091 92.1455 47.3203 92.9176C46.5314 93.6898 46.5178 94.9652 47.2899 95.754C48.062 96.5428 49.3468 96.5661 50.1357 95.794C50.9341 95.0125 50.9382 93.7465 50.1567 92.948Z"
                        fill="white"></path>
                    <path
                        d="M57.8141 85.4529C57.0326 84.6544 55.7666 84.6504 54.9778 85.4225C54.1889 86.1946 54.1753 87.4701 54.9474 88.2589C55.7195 89.0477 56.9947 89.0804 57.7932 88.2989C58.5916 87.5174 58.5957 86.2514 57.8141 85.4529Z"
                        fill="white"></path>
                    <path
                        d="M65.4621 77.9666C64.6805 77.1681 63.4242 77.1547 62.6257 77.9362C61.8369 78.7083 61.8232 79.9837 62.5953 80.7726C63.3674 81.5614 64.6523 81.5847 65.4411 80.8126C66.2396 80.031 66.2436 78.765 65.4621 77.9666Z"
                        fill="white"></path>
                    <path
                        d="M34.8627 92.6219C34.0812 91.8234 32.8056 91.8288 32.0263 92.5915C31.2375 93.3636 31.2238 94.639 31.996 95.4278C32.7681 96.2167 34.0435 96.2303 34.8323 95.4582C35.6212 94.6861 35.6442 93.4203 34.8627 92.6219Z"
                        fill="white"></path>
                    <path
                        d="M42.5104 85.1365C41.7289 84.338 40.4629 84.334 39.674 85.1061C38.8852 85.8782 38.8715 87.1536 39.6437 87.9425C40.4158 88.7313 41.6912 88.745 42.48 87.9729C43.2785 87.1913 43.2919 85.935 42.5104 85.1365Z"
                        fill="white"></path>
                    <path
                        d="M50.1681 77.6414C49.3866 76.8429 48.1206 76.8389 47.3318 77.611C46.5429 78.3831 46.5293 79.6585 47.3014 80.4474C48.0735 81.2362 49.3393 81.2593 50.1377 80.4778C50.9362 79.6962 50.9497 78.4398 50.1681 77.6414Z"
                        fill="white"></path>
                    <path
                        d="M57.8158 70.1551C57.0343 69.3566 55.7779 69.3431 54.9795 70.1247C54.1906 70.8968 54.177 72.1722 54.9491 72.961C55.7212 73.7499 56.9966 73.7635 57.7855 72.9914C58.5839 72.2099 58.5974 70.9535 57.8158 70.1551Z"
                        fill="white"></path>
                    <path
                        d="M65.4833 62.6511C64.7018 61.8527 63.4358 61.8487 62.6469 62.6208C61.8581 63.3929 61.8444 64.6683 62.6166 65.4571C63.3887 66.246 64.6641 66.2596 65.4529 65.4875C66.2418 64.7154 66.2648 63.4496 65.4833 62.6511Z"
                        fill="white"></path>
                    <path
                        d="M27.2172 84.8103C26.4451 84.0215 25.1697 84.0078 24.3808 84.7799C23.592 85.5521 23.5783 86.8275 24.3504 87.6163C25.132 88.4148 26.4074 88.4284 27.1962 87.6563C27.9757 86.8746 27.9893 85.5992 27.2172 84.8103Z"
                        fill="white"></path>
                    <path
                        d="M34.8652 77.325C34.093 76.5361 32.8176 76.5225 32.0288 77.2946C31.2399 78.0667 31.2263 79.3421 32.0078 80.1406C32.7799 80.9294 34.0553 80.9431 34.8442 80.171C35.6332 79.3798 35.6373 78.1138 34.8652 77.325Z"
                        fill="white"></path>
                    <path
                        d="M42.5219 69.8299C41.7498 69.041 40.4744 69.0274 39.6855 69.7995C38.8967 70.5716 38.883 71.847 39.6645 72.6455C40.4367 73.4343 41.7025 73.4574 42.5009 72.6759C43.29 71.8847 43.294 70.6187 42.5219 69.8299Z"
                        fill="white"></path>
                    <path
                        d="M50.1706 62.3435C49.3985 61.5547 48.1327 61.5316 47.3342 62.3131C46.5454 63.0853 46.5317 64.3607 47.3132 65.1591C48.0853 65.948 49.3608 65.9616 50.1496 65.1895C50.9386 64.3984 50.9427 63.1324 50.1706 62.3435Z"
                        fill="white"></path>
                    <path
                        d="M57.8371 54.8396C57.065 54.0508 55.7895 54.0371 55.0007 54.8092C54.2119 55.5814 54.1982 56.8568 54.9797 57.6552C55.7519 58.4441 57.0273 58.4577 57.8161 57.6856C58.5955 56.9039 58.6092 55.6285 57.8371 54.8396Z"
                        fill="white"></path>
                    <path
                        d="M65.4948 47.3445C64.7227 46.5557 63.4376 46.5514 62.6488 47.3235C61.86 48.0957 61.8463 49.3711 62.6278 50.1695C63.3999 50.9584 64.6754 50.972 65.4642 50.1999C66.2532 49.4088 66.2669 48.1333 65.4948 47.3445Z"
                        fill="white"></path>
                    <path
                        d="M19.5711 76.9996C18.7896 76.2012 17.5142 76.1875 16.7253 76.9596C15.9365 77.7317 15.9228 79.0072 16.7043 79.8056C17.4765 80.5945 18.7519 80.6081 19.5407 79.836C20.3296 79.0639 20.3432 77.7885 19.5711 76.9996Z"
                        fill="white"></path>
                    <path
                        d="M27.219 69.5133C26.4375 68.7149 25.1621 68.7012 24.3733 69.4733C23.5844 70.2454 23.5708 71.5208 24.3523 72.3193C25.1244 73.1081 26.3998 73.1218 27.1887 72.3497C27.9871 71.5681 27.9912 70.3021 27.219 69.5133Z"
                        fill="white"></path>
                    <path
                        d="M34.8768 62.0182C34.0952 61.2197 32.8198 61.2061 32.031 61.9782C31.2421 62.7503 31.2285 64.0257 32.01 64.8242C32.7821 65.613 34.0479 65.6361 34.8464 64.8546C35.6448 64.073 35.6489 62.807 34.8768 62.0182Z"
                        fill="white"></path>
                    <path
                        d="M42.5245 54.5319C41.7429 53.7334 40.4771 53.7103 39.6787 54.4919C38.8898 55.264 38.8762 56.5394 39.6577 57.3378C40.4298 58.1267 41.7052 58.1403 42.4941 57.3682C43.2925 56.5867 43.2966 55.3207 42.5245 54.5319Z"
                        fill="white"></path>
                    <path
                        d="M50.1912 47.028C49.4097 46.2295 48.1343 46.2158 47.3454 46.988C46.5566 47.7601 46.5429 49.0355 47.3245 49.8339C48.0966 50.6228 49.372 50.6364 50.1608 49.8643C50.9497 49.0922 50.9633 47.8168 50.1912 47.028Z"
                        fill="white"></path>
                    <path
                        d="M57.8489 39.5328C57.0674 38.7344 55.7824 38.7301 54.9935 39.5023C54.2047 40.2744 54.191 41.5498 54.9726 42.3482C55.7447 43.1371 57.0201 43.1507 57.8089 42.3786C58.6074 41.5971 58.621 40.3217 57.8489 39.5328Z"
                        fill="white"></path>
                    <path
                        d="M65.4966 32.0465C64.7151 31.2481 63.4397 31.2344 62.6509 32.0065C61.862 32.7786 61.8483 34.054 62.6299 34.8525C63.402 35.6413 64.6774 35.655 65.4663 34.8829C66.2551 34.1108 66.2688 32.8354 65.4966 32.0465Z"
                        fill="white"></path>
                    <path
                        d="M11.9157 69.1785C11.1436 68.3897 9.86816 68.376 9.07932 69.1481C8.29048 69.9202 8.27682 71.1956 9.04894 71.9845C9.82105 72.7733 11.0965 72.787 11.8853 72.0149C12.6741 71.2427 12.6972 69.977 11.9157 69.1785Z"
                        fill="white"></path>
                    <path
                        d="M19.5636 61.6922C18.7915 60.9033 17.5161 60.8897 16.7273 61.6618C15.9384 62.4339 15.9248 63.7093 16.6969 64.4982C17.469 65.287 18.7444 65.3007 19.5333 64.5285C20.3317 63.747 20.3452 62.4906 19.5636 61.6922Z"
                        fill="white"></path>
                    <path
                        d="M27.2211 54.197C26.449 53.4082 25.1736 53.3945 24.3847 54.1667C23.5959 54.9388 23.5822 56.2142 24.3544 57.003C25.1265 57.7919 26.3923 57.815 27.1907 57.0334C27.9892 56.2519 28.0026 54.9955 27.2211 54.197Z"
                        fill="white"></path>
                    <path
                        d="M34.8691 46.7117C34.0969 45.9229 32.8311 45.8998 32.0327 46.6813C31.2438 47.4534 31.2302 48.7288 32.0023 49.5177C32.7744 50.3065 34.0498 50.3202 34.8387 49.5481C35.6371 48.7665 35.6506 47.5102 34.8691 46.7117Z"
                        fill="white"></path>
                    <path
                        d="M42.5363 39.2068C41.7642 38.418 40.4888 38.4043 39.6999 39.1764C38.9111 39.9485 38.8974 41.224 39.6695 42.0128C40.4417 42.8016 41.7171 42.8153 42.5059 42.0432C43.2947 41.2711 43.3178 40.0053 42.5363 39.2068Z"
                        fill="white"></path>
                    <path
                        d="M50.194 31.7117C49.4219 30.9229 48.1369 30.9186 47.348 31.6907C46.5592 32.4628 46.5455 33.7383 47.3176 34.5271C48.0897 35.3159 49.3652 35.3296 50.154 34.5575C50.9525 33.776 50.9755 32.5102 50.194 31.7117Z"
                        fill="white"></path>
                    <path
                        d="M57.8417 24.2263C57.0696 23.4375 55.7942 23.4238 55.0053 24.196C54.2165 24.9681 54.2028 26.2435 54.975 27.0323C55.7471 27.8212 57.0225 27.8348 57.8113 27.0627C58.6002 26.2906 58.6232 25.0248 57.8417 24.2263Z"
                        fill="white"></path>
                    <path
                        d="M65.4994 16.7312C64.7273 15.9424 63.4519 15.9287 62.6534 16.7103C61.8646 17.4824 61.8509 18.7578 62.6231 19.5466C63.3952 20.3355 64.6802 20.3397 65.4594 19.577C66.2579 18.7955 66.281 17.5297 65.4994 16.7312Z"
                        fill="white"></path>
                    <path
                        d="M4.27018 61.367C3.49806 60.5781 2.22265 60.5645 1.43381 61.3366C0.644973 62.1087 0.631312 63.3841 1.40343 64.173C2.18496 64.9714 3.45096 64.9755 4.2398 64.2033C5.02863 63.4312 5.05171 62.1654 4.27018 61.367Z"
                        fill="white"></path>
                    <path
                        d="M11.9181 53.8806C11.146 53.0918 9.88022 53.0687 9.08176 53.8503C8.29292 54.6224 8.27926 55.8978 9.05137 56.6866C9.83291 57.4851 11.0989 57.4891 11.8877 56.717C12.6862 55.9355 12.6997 54.6791 11.9181 53.8806Z"
                        fill="white"></path>
                    <path
                        d="M19.5751 46.3855C18.803 45.5967 17.5372 45.5736 16.7387 46.3551C15.9499 47.1273 15.9362 48.4027 16.7084 49.1915C17.4899 49.99 18.7463 50.0034 19.5447 49.2219C20.3432 48.4404 20.3566 47.184 19.5751 46.3855Z"
                        fill="white"></path>
                    <path
                        d="M27.2235 38.9002C26.4514 38.1113 25.1856 38.0883 24.3872 38.8698C23.5983 39.6419 23.5847 40.9173 24.3568 41.7062C25.1383 42.5046 26.4043 42.5087 27.1932 41.7365C27.9916 40.955 28.0051 39.6986 27.2235 38.9002Z"
                        fill="white"></path>
                    <path
                        d="M34.8903 31.3953C34.1182 30.6065 32.8428 30.5928 32.0539 31.3649C31.2651 32.137 31.2514 33.4124 32.0235 34.2013C32.8051 34.9997 34.0711 35.0038 34.8599 34.2317C35.6487 33.4595 35.6718 32.1938 34.8903 31.3953Z"
                        fill="white"></path>
                    <path
                        d="M42.5478 23.9002C41.7757 23.1113 40.4906 23.1071 39.7018 23.8792C38.9129 24.6513 38.8993 25.9267 39.6714 26.7156C40.4529 27.514 41.7189 27.5181 42.5078 26.746C43.2966 25.9738 43.3293 24.6986 42.5478 23.9002Z"
                        fill="white"></path>
                    <path
                        d="M50.1957 16.4148C49.4236 15.626 48.1482 15.6123 47.3593 16.3844C46.5705 17.1566 46.5568 18.432 47.329 19.2208C48.1105 20.0193 49.3765 20.0233 50.1653 19.2512C50.9542 18.4791 50.9772 17.2133 50.1957 16.4148Z"
                        fill="white"></path>
                    <path
                        d="M57.8534 8.91971C57.0813 8.13087 55.8059 8.1172 55.0074 8.89874C54.2186 9.67085 54.2049 10.9463 54.9771 11.7351C55.7586 12.5336 57.0246 12.5376 57.8134 11.7655C58.6119 10.984 58.635 9.71816 57.8534 8.91971Z"
                        fill="white"></path>
                    <path
                        d="M65.5011 1.43338C64.729 0.644539 63.4632 0.62146 62.6648 1.40299C61.8759 2.17511 61.8623 3.45052 62.6344 4.23936C63.4159 5.03782 64.6819 5.04186 65.4708 4.26975C66.2692 3.48822 66.2827 2.23184 65.5011 1.43338Z"
                        fill="white"></path>
                </svg>
            </div>

            <div class="col-lg-6 col-12">
                <div class="login-img">
                    <svg width="752" height="752" viewBox="0 0 752 752" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="376" cy="376" r="376" fill="white" fill-opacity="0.1" />
                        <circle cx="376" cy="376" r="331.93" fill="white" fill-opacity="0.1" />
                        <path
                            d="M72.6475 630.068L151.767 629.725L230.887 629.599L389.126 629.363L547.365 629.597L626.484 629.722L705.604 630.068L626.484 630.413L547.365 630.538L389.126 630.774L230.887 630.536L151.767 630.412L72.6475 630.068Z"
                            fill="white" fill-opacity="0.7" />
                        <path class="theme-color"
                            d="M654.062 508.083L598.862 487.06C595.048 485.608 593.133 481.338 594.586 477.523L623.683 401.12C625.136 397.305 629.406 395.39 633.22 396.843L668.227 410.176L684.689 448.426L663.597 503.805C662.146 507.622 657.876 509.536 654.062 508.083Z"
                            fill="#89D8B2" />
                        <path
                            d="M668.227 410.177L660.038 431.68C658.687 435.228 660.467 439.198 664.013 440.55L684.688 448.427L668.227 410.177Z"
                            fill="#E0E0E0" />
                        <path
                            d="M655.744 429.04C655.639 429.315 649.836 427.363 642.785 424.677C635.732 421.991 630.1 419.59 630.207 419.313C630.311 419.037 636.113 420.989 643.167 423.676C650.216 426.363 655.849 428.763 655.744 429.04Z"
                            fill="white" />
                        <path
                            d="M667.607 447.478C667.502 447.755 658.006 444.395 646.402 439.975C634.794 435.554 625.471 431.747 625.577 431.471C625.682 431.194 635.175 434.553 646.784 438.975C658.388 443.394 667.711 447.203 667.607 447.478Z"
                            fill="white" />
                        <path
                            d="M667.526 459.072C667.421 459.348 657.078 455.666 644.428 450.848C631.774 446.028 621.604 441.899 621.709 441.622C621.814 441.347 632.154 445.028 644.808 449.848C657.459 454.666 667.631 458.796 667.526 459.072Z"
                            fill="white" />
                        <path
                            d="M663.877 468.65C663.772 468.927 653.429 465.245 640.78 460.428C628.125 455.608 617.957 451.479 618.061 451.202C618.166 450.927 628.507 454.608 641.161 459.428C653.812 464.243 663.983 468.375 663.877 468.65Z"
                            fill="white" />
                        <path
                            d="M660.229 478.229C660.125 478.506 649.781 474.823 637.133 470.006C624.479 465.187 614.309 461.058 614.414 460.781C614.519 460.504 624.859 464.187 637.513 469.007C650.163 473.822 660.336 477.952 660.229 478.229Z"
                            fill="white" />
                        <path
                            d="M656.581 487.808C656.477 488.085 646.133 484.402 633.483 479.584C620.83 474.764 610.66 470.635 610.764 470.359C610.869 470.082 621.21 473.764 633.864 478.582C646.515 483.401 656.688 487.531 656.581 487.808Z"
                            fill="white" />
                        <path
                            d="M379.237 283.715C377.784 280.434 377.456 276.802 376.495 273.359C375.981 271.508 375.114 269.539 373.38 268.72C372.232 268.181 370.873 268.25 369.654 267.875C365.273 266.564 364.078 260.449 359.931 258.551C358.619 257.965 357.166 257.848 355.76 257.684C350.208 257.028 344.468 255.107 340.976 250.749C339.828 249.343 338.961 247.679 337.556 246.531C336.126 245.384 333.924 244.892 332.541 246.064C333.713 248.406 334.861 250.749 336.009 253.069C337.062 255.177 338.14 257.356 339.897 258.903C341.678 260.473 344.303 261.293 346.434 260.309C347.137 259.981 347.84 259.442 348.637 259.536C349.199 259.606 349.692 260.005 350.066 260.45C353.088 263.8 352.104 269.353 349.152 272.773C346.223 276.169 341.864 277.951 337.671 279.614C336.171 280.2 334.579 280.809 332.986 280.528C330.08 279.989 328.535 276.827 327.691 273.991C325.793 267.712 324.879 260.893 320.989 255.598C319.748 253.934 318.202 252.411 317.452 250.467C316.655 248.358 316.842 245.898 315.577 244.046C314.265 242.102 311.477 240.977 311.29 238.634C311.173 236.994 312.532 235.542 314.03 234.839C315.53 234.113 317.217 233.902 318.764 233.269C319.373 233.011 320.053 232.566 320.076 231.91C320.076 230.926 318.717 230.527 318.365 229.615C317.99 228.584 319.045 227.623 319.49 226.615C320.451 224.319 318.061 221.999 315.741 221.061C313.446 220.125 310.657 219.444 309.579 217.196C309.087 216.165 309.04 214.97 308.829 213.845C308.29 211.011 306.204 208.269 303.347 207.8C300.464 207.331 297.279 209.885 297.746 212.743C298.027 214.313 299.199 215.531 299.831 216.984C300.487 218.436 300.3 220.591 298.8 221.06C296.341 221.81 293.974 217.312 291.912 218.857C292.755 221.739 293.575 224.622 294.419 227.526C291.185 229.166 287.32 226.19 285.937 222.817C284.554 219.466 284.507 215.623 282.867 212.39C281.227 209.133 276.799 206.721 273.987 209.016C273.846 213.187 279.352 214.874 281.789 218.248C283.546 220.685 283.289 224.644 280.687 226.19C278.111 227.737 274.01 225.042 274.994 222.208C275.346 221.224 276.164 220.404 276.258 219.349C276.353 218.037 275.25 216.982 274.244 216.14C272.674 214.804 271.104 213.492 269.534 212.18C268.526 211.336 267.449 210.446 266.184 210.071C262.95 209.135 259.718 211.758 258.007 214.64C256.296 217.545 255.336 220.942 252.97 223.355C249.573 226.87 243.13 227.081 239.944 223.403C236.734 219.724 238.374 212.836 243.083 211.5C244.864 211.008 247.114 211.055 248.051 209.485C249.69 206.697 245.005 203.136 246.622 200.325C247.864 198.17 251.144 199.154 253.534 198.427C255.9 197.701 257.235 195.312 258.641 193.249C260.024 191.21 262.203 189.148 264.64 189.687C264.451 188.257 264.265 186.711 264.898 185.422C265.531 184.111 267.311 183.267 268.482 184.111C267.287 186.078 268.717 188.82 270.802 189.804C272.888 190.788 275.324 190.554 277.62 190.296C279.917 190.015 282.798 189.171 282.985 186.875C283.056 186.125 282.774 185.33 283.056 184.625C284.063 181.885 289.125 185.656 291.069 183.453C292.194 182.306 290.952 180.267 289.383 179.892C287.837 179.494 286.22 180.08 284.628 180.126C283.034 180.196 281.089 179.353 281.019 177.759C280.949 176.189 282.706 175.064 282.894 173.519C283.199 170.895 278.746 170.215 277.176 172.347C275.629 174.478 276.168 177.407 276.637 180.007C277.129 182.608 277.363 185.678 275.443 187.506C274.623 188.747 272.491 188.092 271.788 186.78C271.061 185.468 271.227 183.874 271.108 182.398C270.991 180.899 270.335 179.212 268.883 178.814C267.876 178.533 266.798 179.025 265.767 179.166C261.691 179.658 258.855 174.387 260.144 170.497C261.409 166.584 265.111 164.077 268.696 162.087C271.319 160.634 274.576 159.275 277.178 160.751C278.395 161.429 279.239 162.601 280.434 163.304C282.496 164.523 285.05 164.077 287.416 164.124C291.141 164.218 294.819 165.647 297.608 168.083C298.663 169.044 299.647 170.637 298.827 171.786C297.937 173.004 295.384 173.262 295.828 174.691C298.593 175.605 301.897 173.473 302.202 170.59C303.56 171.199 304.544 172.582 304.661 174.058C307.637 171.035 313.354 171.481 315.791 174.971C316.447 175.885 316.916 176.986 317.853 177.619C318.789 178.228 320.43 177.924 320.547 176.822C320.594 176.471 320.477 176.119 320.359 175.791C319.797 174.199 319.211 172.629 318.65 171.059C320.828 169.887 323.406 171.715 324.882 173.683C330.364 181.015 334.278 176.611 342.008 177.806C347.232 178.603 349.529 181.952 352.482 186.007C361.526 198.471 373.475 208.687 381.698 221.713C382.565 223.072 383.36 224.454 384.11 225.859C383.971 225.509 383.854 225.156 383.713 224.806C380.479 216.301 376.474 208.171 371.764 200.51C370.756 198.87 369.726 197.254 368.672 195.66C368.016 194.676 367.336 193.668 366.657 192.707C365.79 191.442 364.876 190.223 363.963 189.006C363.237 188.022 362.51 187.061 361.76 186.124C361.245 185.468 360.706 184.812 360.167 184.156C359.605 183.406 358.995 182.681 358.339 181.954L356.372 179.681C356.185 179.447 355.974 179.212 355.739 178.978C355.06 178.181 354.333 177.408 353.607 176.635C353.56 176.541 353.49 176.471 353.396 176.402C353.209 176.19 352.998 175.979 352.787 175.768C352.201 175.113 351.57 174.48 350.959 173.848C349.953 172.817 348.92 171.786 347.867 170.802C347 169.936 346.11 169.116 345.196 168.296C344.399 167.57 343.604 166.843 342.782 166.14C341.985 165.437 341.19 164.757 340.369 164.078C339.385 163.234 338.378 162.415 337.346 161.595H337.322C334.487 159.322 331.559 157.166 328.56 155.152C327.81 154.637 327.085 154.144 326.335 153.653C325.585 153.137 324.812 152.669 324.062 152.2C323.289 151.731 322.539 151.239 321.765 150.794C320.992 150.302 320.219 149.858 319.445 149.411C318.812 149.036 318.203 148.686 317.57 148.358C317.242 148.147 316.939 147.983 316.609 147.819C315.275 147.069 313.915 146.343 312.556 145.663C311.877 145.311 311.197 144.96 310.494 144.632C309.627 144.187 308.738 143.765 307.847 143.367C307.73 143.297 307.588 143.228 307.449 143.181C306.652 142.806 305.856 142.431 305.035 142.08C303.887 141.588 302.739 141.096 301.592 140.627C300.28 140.088 298.967 139.549 297.632 139.057C296.156 138.495 294.679 137.956 293.181 137.464C291.681 136.95 290.158 136.456 288.635 135.987C287.113 135.518 285.589 135.098 284.043 134.676C280.997 133.856 277.905 133.13 274.788 132.497C274.741 132.474 274.671 132.474 274.624 132.45C273.429 132.216 272.235 131.981 271.04 131.794C270.946 131.77 270.876 131.747 270.805 131.747C270.29 131.653 269.751 131.56 269.212 131.489C266.986 131.114 264.736 130.809 262.464 130.552C262.207 130.505 261.925 130.482 261.644 130.458C260.988 130.364 260.332 130.318 259.652 130.247C258.153 130.106 256.654 129.989 255.129 129.896C253.56 129.779 251.967 129.71 250.373 129.663C248.709 129.591 247.047 129.568 245.383 129.568C240.978 129.568 236.62 129.757 232.308 130.154C231.277 130.224 230.271 130.318 229.263 130.435C228.208 130.552 227.154 130.669 226.1 130.81C225.045 130.95 223.992 131.091 222.961 131.255C221.906 131.419 220.875 131.583 219.821 131.77C218.931 131.911 218.018 132.075 217.128 132.262C214.925 132.684 212.746 133.152 210.591 133.668C209.583 133.902 208.576 134.16 207.568 134.44C206.561 134.699 205.553 134.979 204.57 135.26C202.906 135.729 201.289 136.244 199.672 136.76H199.649C198.337 137.205 197.001 137.65 195.714 138.096C195.691 138.096 195.644 138.119 195.62 138.143C194.284 138.612 192.996 139.104 191.683 139.619C191.613 139.643 191.542 139.666 191.472 139.689C190.277 140.158 189.083 140.65 187.911 141.142C186.435 141.75 184.982 142.406 183.552 143.062C182.334 143.624 181.14 144.187 179.968 144.773C178.702 145.406 177.437 146.038 176.196 146.694C176.149 146.718 176.102 146.741 176.055 146.764C174.86 147.395 173.666 148.053 172.494 148.731C171.275 149.411 170.08 150.114 168.885 150.864H168.861C167.736 151.543 166.635 152.223 165.534 152.926C165.112 153.184 164.715 153.465 164.293 153.746C163.121 154.496 161.996 155.268 160.848 156.065C159.442 157.026 158.083 158.033 156.724 159.041C155.53 159.932 154.358 160.845 153.21 161.759C146.579 167.054 140.394 172.887 134.794 179.213C132.803 181.416 130.929 183.664 129.101 185.961C127.554 187.929 126.056 189.921 124.626 191.983C125.001 191.935 125.376 191.888 125.751 191.866C127.859 191.702 130.085 191.771 131.983 190.859C133.739 189.992 134.981 188.422 136.575 187.297C140.652 184.392 147.33 183.853 148.431 178.979C148.806 177.34 148.361 175.559 148.97 173.989C150.117 171.06 154.031 170.638 157.171 170.685C158.507 170.685 160.075 170.872 160.685 172.044C161.13 172.864 160.872 173.895 160.544 174.763C158.624 180.245 154.734 184.978 149.789 187.977C145.713 190.461 140.394 192.383 139.27 197.021C139.832 198.591 142.69 198.474 142.924 200.114C143.088 201.425 141.402 202.106 140.793 203.277C139.903 204.988 141.94 207.073 143.885 206.979C145.83 206.885 147.447 205.479 148.875 204.167C153.14 200.208 157.614 195.943 159.161 190.32C159.817 188 160.051 185.283 161.926 183.736C164.151 181.908 168.135 183.173 168.885 185.961C170.736 184.931 173.617 184.158 174.578 186.078C174.906 186.758 174.812 187.554 174.976 188.281C175.585 191.28 179.685 192.64 180.107 195.661C180.599 199.153 176.125 200.956 172.633 201.495C169.47 201.987 166.307 202.479 163.145 202.995C161.763 203.206 160.333 203.44 159.21 204.26C158.085 205.104 157.382 206.697 158.038 207.938C158.413 208.619 159.138 209.063 159.677 209.625C162.302 212.249 160.146 217.661 156.444 217.779C155.178 217.826 153.936 217.357 152.671 217.31C148.923 217.146 145.947 220.45 144.166 223.753C142.385 227.057 141.051 230.829 138.051 233.078C133.225 236.709 124.907 235.867 122.564 241.443C121.627 243.692 122.119 246.222 122.494 248.636C122.869 251.026 123.033 253.696 121.627 255.688C120.246 257.656 116.637 258.078 115.606 255.875C115.161 254.914 115.301 253.79 115.466 252.758C116.028 249.291 116.567 245.823 117.106 242.356C117.504 239.778 117.856 236.896 116.333 234.788C114.202 231.835 109.421 232.117 106.656 234.482C103.916 236.849 102.767 240.551 101.994 244.088C101.432 246.712 100.775 250.413 99.3236 253.413C98.8317 256.318 98.4325 259.271 98.1287 262.247C97.825 265.292 97.614 268.315 97.4971 271.408C97.872 271.102 98.2699 270.729 98.6919 270.283C100.168 268.76 103.143 262.317 105.814 265.479C106.492 266.276 106.517 267.565 105.861 268.408C105.041 269.461 103.4 269.697 102.768 270.844C101.995 272.203 103.073 273.89 104.338 274.781C105.603 275.695 107.15 276.257 108.039 277.546C109.75 280.005 108.111 283.731 109.773 286.237C111.202 288.393 114.249 288.533 116.848 288.815C117.153 288.862 117.434 288.909 117.739 288.956C118.466 283.802 120.879 279.607 127.908 278.015C137.607 275.812 150.354 283.849 155.812 291.159C161.903 299.336 164.786 310.91 174.11 315.01C180.787 317.938 190.276 316.884 193.533 323.42C196.438 329.277 191.378 335.862 190.604 342.352C190.112 346.639 191.518 350.904 191.846 355.191C192.151 359.503 190.885 364.516 186.973 366.321C184.794 367.305 182.052 367.188 180.296 368.827C177.179 371.78 179.734 377.871 176.617 380.824C175.516 381.855 173.992 382.23 172.658 382.908C165.653 386.447 165.839 396.756 169.096 403.902C169.213 404.16 169.33 404.394 169.448 404.652C179.804 410.861 190.956 415.827 202.742 419.342C216.237 423.442 230.552 425.621 245.383 425.621C270.475 425.621 294.139 419.364 314.85 408.33H314.874C319.373 405.918 323.754 403.293 327.972 400.434C334.509 396.053 340.647 391.157 346.363 385.814C350.322 382.111 354.095 378.199 357.609 374.076C360.093 371.217 362.436 368.241 364.686 365.196C365.833 363.626 366.958 362.056 368.012 360.439C371.246 355.707 374.198 350.763 376.845 345.655C380.687 338.298 383.897 330.566 386.427 322.555C389.028 314.472 390.926 306.084 392.074 297.461C392.518 294.135 392.871 290.76 393.104 287.363C391.488 288.933 389.379 290.058 387.153 290.011C383.596 289.97 380.667 286.994 379.237 283.715Z"
                            fill="white" fill-opacity="0.4" />
                        <path
                            d="M116.688 316.515C116.219 312.275 117.626 308.033 117.696 303.745C117.743 300.793 117.532 297.677 117.485 294.702C114.954 294.585 112.425 294.233 109.964 293.648C109.448 293.531 108.886 293.367 108.582 292.945C108.254 292.5 108.301 291.914 108.277 291.375C108.09 288.049 104.879 285.846 101.998 284.182C100.522 283.315 99.0223 282.471 97.4297 281.932C97.4297 282.283 97.4297 282.612 97.4525 282.963C98.0385 299.434 101.318 315.249 106.871 329.939C109.402 336.64 112.425 343.129 115.915 349.338C117.368 352.033 118.961 354.68 120.624 357.281C122.686 360.491 124.842 363.63 127.162 366.653C129.316 369.558 131.613 372.393 134.027 375.111C137.33 378.883 140.821 382.468 144.499 385.888C147.756 388.934 151.153 391.815 154.691 394.557C146.608 372.862 138.993 350.721 125.17 332.258C121.538 327.433 117.368 322.513 116.688 316.515Z"
                            fill="white" fill-opacity="0.7" />
                        <path
                            d="M288.369 391.272C287.436 391.272 286.507 391.177 285.607 390.979C282.552 390.31 280.231 388.552 279.071 386.032C278.136 383.998 278.035 381.755 277.935 379.585C277.868 378.114 277.8 376.594 277.468 375.178C276.87 372.623 275.472 370.427 273.991 368.102C272.889 366.371 271.749 364.58 270.98 362.637C269.573 359.077 269.464 355.18 269.359 351.413L269.332 350.503C268.552 324.463 261.29 303.325 248.335 289.375C246.537 287.439 244.522 285.553 241.978 284.878C239.023 284.094 235.671 285.249 233.828 287.69C233.363 288.306 232.975 289.014 232.598 289.701C232.01 290.776 231.399 291.887 230.456 292.75C229.109 293.98 227.257 294.481 225.243 294.16C222.602 293.741 220.051 291.98 218.744 289.676C216.447 285.624 216.86 280.634 217.192 276.625L218.529 260.466C218.736 257.972 219.018 254.558 221.04 252.218C222.606 250.407 224.862 249.577 227.044 248.773C228.66 248.178 230.332 247.562 231.676 246.556C234.27 244.612 235.421 241.547 236.638 238.301C237.316 236.494 238.017 234.626 238.992 232.957C240.752 229.945 244.916 227.9 248.271 228.393C249.858 228.627 251.034 229.421 251.675 230.667C253.276 227.656 255.257 225.846 257.707 225.143C263.06 223.607 269.584 227.843 275.893 231.938C281.652 235.676 287.089 239.207 291.362 238.431C292.436 238.236 293.53 237.927 294.589 237.63C296.836 236.997 299.161 236.341 301.536 236.676C307.757 237.545 310.931 244.295 313.002 250.077L323.122 278.355C324.381 281.875 326.005 285.739 329.35 287.036C330.661 287.544 332.078 287.597 333.578 287.652C335.042 287.708 336.557 287.764 337.979 288.281C340.504 289.199 342.111 291.172 342.63 293.988C343.49 298.657 341.149 304.767 337.182 308.198C335.348 309.784 333.265 311.202 331.251 312.574C326.676 315.69 322.355 318.632 320.492 323.467C319.495 326.056 319.371 328.947 319.251 331.742C319.125 334.734 318.993 337.828 317.811 340.644C316.79 343.075 315.07 345.1 313.406 347.059C312.388 348.257 311.335 349.497 310.466 350.808C307.227 355.69 306.327 361.744 305.459 367.599C305.348 368.349 305.236 369.097 305.121 369.842C304.107 376.364 302.359 383.642 297.065 388.18C294.752 390.165 291.539 391.272 288.369 391.272Z"
                            fill="#EBEBEB" />
                        <g opacity="0.6">
                            <path
                                d="M97.4523 272.257C97.4174 273.136 97.4201 274.035 97.4053 274.927C97.4201 274.034 97.4174 273.135 97.4523 272.257Z"
                                fill="#F5F5F5" />
                        </g>
                        <path
                            d="M117.742 288.963C117.437 288.916 117.156 288.869 116.851 288.822C114.251 288.541 111.205 288.4 109.777 286.244C108.114 283.737 109.754 280.012 108.043 277.552C107.152 276.263 105.606 275.702 104.341 274.788C103.077 273.897 101.999 272.21 102.772 270.851C103.403 269.703 105.044 269.469 105.864 268.414C106.52 267.57 106.496 266.282 105.817 265.486C103.147 262.323 100.171 268.765 98.6953 270.289C98.2733 270.734 97.8755 271.109 97.5005 271.414V271.438C97.4763 271.719 97.4535 271.977 97.4535 272.258C97.4185 273.137 97.4212 274.036 97.4064 274.929C97.3916 275.823 97.3594 276.71 97.3594 277.601C97.3594 278.326 97.3822 279.044 97.3943 279.769C97.4064 280.492 97.4064 281.221 97.4293 281.936C99.0219 282.475 100.522 283.319 101.998 284.186C104.879 285.849 108.089 288.052 108.277 291.379C108.301 291.918 108.254 292.504 108.582 292.949C108.886 293.371 109.449 293.535 109.963 293.652C112.423 294.238 114.954 294.589 117.484 294.706"
                            fill="white" fill-opacity="0.6" />
                        <path
                            d="M117.485 294.702C117.532 297.677 117.743 300.794 117.696 303.746C117.626 308.033 116.22 312.275 116.688 316.515C117.368 322.513 121.538 327.432 125.17 332.26C138.993 350.722 146.608 372.863 154.691 394.558H154.714C156.214 395.753 157.736 396.878 159.282 397.979C160.5 398.858 161.731 399.718 162.975 400.559C164.22 401.399 165.479 402.22 166.756 403.016C167.646 403.579 168.537 404.117 169.451 404.656C169.334 404.398 169.217 404.164 169.1 403.906C165.843 396.76 165.655 386.451 172.661 382.913C173.997 382.232 175.52 381.857 176.621 380.828C179.736 377.877 177.183 371.784 180.299 368.831C182.056 367.192 184.798 367.309 186.976 366.325C190.889 364.521 192.155 359.507 191.85 355.195C191.522 350.908 190.116 346.643 190.608 342.356C191.381 335.866 196.442 329.283 193.536 323.426C190.28 316.889 180.791 317.944 174.114 315.015C164.79 310.914 161.907 299.341 155.816 291.164C150.358 283.854 137.611 275.817 127.912 278.02C120.882 279.613 118.47 283.807 117.743 288.962"
                            fill="white" fill-opacity="0.5" />
                        <path
                            d="M106.66 234.489C109.425 232.122 114.204 231.841 116.337 234.794C117.86 236.903 117.508 239.785 117.11 242.362C116.571 245.83 116.032 249.297 115.47 252.765C115.306 253.796 115.165 254.921 115.61 255.882C116.641 258.084 120.25 257.662 121.631 255.695C123.037 253.703 122.873 251.032 122.498 248.643C122.123 246.229 121.631 243.7 122.568 241.45C124.911 235.873 133.229 236.716 138.055 233.085C141.053 230.836 142.389 227.064 144.17 223.76C145.951 220.456 148.926 217.153 152.675 217.317C153.94 217.364 155.181 217.832 156.448 217.786C160.149 217.669 162.305 212.257 159.681 209.632C159.142 209.07 158.416 208.624 158.042 207.945C157.386 206.703 158.089 205.111 159.213 204.267C160.338 203.447 161.767 203.213 163.149 203.002C166.312 202.486 169.475 201.994 172.637 201.502C176.129 200.963 180.603 199.159 180.111 195.668C179.689 192.645 175.59 191.286 174.98 188.288C174.816 187.561 174.91 186.765 174.582 186.085C173.621 184.163 170.74 184.937 168.889 185.968C168.139 183.181 164.157 181.915 161.93 183.742C160.056 185.288 159.822 188.007 159.165 190.327C157.618 195.95 153.144 200.213 148.879 204.174C147.451 205.486 145.834 206.891 143.889 206.986C141.944 207.08 139.906 204.994 140.797 203.284C141.405 202.112 143.092 201.433 142.928 200.12C142.694 198.481 139.836 198.598 139.274 197.028C140.397 192.39 145.717 190.468 149.793 187.984C154.737 184.986 158.626 180.252 160.548 174.77C160.876 173.903 161.134 172.872 160.689 172.051C160.08 170.88 158.511 170.692 157.175 170.692C154.035 170.645 150.123 171.067 148.974 173.996C148.365 175.566 148.81 177.346 148.435 178.986C147.334 183.859 140.656 184.398 136.579 187.304C134.985 188.429 133.745 189.999 131.987 190.866C130.089 191.78 127.863 191.71 125.755 191.872C125.38 191.895 125.005 191.942 124.63 191.989C123.342 193.782 122.099 195.609 120.901 197.466C119.704 199.323 118.549 201.209 117.437 203.119C112.188 212.093 107.877 221.675 104.597 231.75C103.45 235.253 102.436 238.814 101.557 242.428C100.678 246.042 99.935 249.709 99.3262 253.422C100.779 250.424 101.435 246.721 101.997 244.097C102.771 240.557 103.919 236.856 106.66 234.489Z"
                            fill="white" fill-opacity="0.5" />
                        <path
                            d="M230.851 165.819C232.25 163.983 231.842 161.343 232.749 159.221C234.257 155.696 238.941 154.434 240.566 150.961C241.191 149.625 241.345 147.992 242.435 146.999C243.344 146.171 244.692 146.003 245.669 145.256C247.852 143.584 246.947 139.78 244.629 138.3C238.821 134.592 228.134 138.878 223.117 142.51C216.665 147.178 210.354 152.797 201.773 152.248C199.407 152.098 196.946 151.447 194.729 152.286C192.512 153.125 191.146 156.448 193.054 157.854C194.116 158.636 195.621 158.419 196.819 158.974C199.031 159.999 199.251 163.201 198.172 165.386C197.093 167.573 195.147 169.207 193.871 171.286C192.635 173.3 192.068 175.716 192.277 178.069C192.424 179.708 193 181.401 194.286 182.427C196.957 184.557 201.017 182.732 203.279 180.171C205.541 177.61 207.102 174.301 210.035 172.547C211.499 171.673 213.187 171.266 214.846 170.872C218.577 169.985 222.306 169.098 226.037 168.211C227.817 167.788 229.741 167.274 230.851 165.819Z"
                            fill="white" fill-opacity="0.3" />
                        <g opacity="0.6">
                            <path
                                d="M393.366 275.561C393.354 273.428 393.29 271.313 393.176 269.211C393.29 271.315 393.354 273.429 393.366 275.561C393.413 276.239 393.413 276.919 393.413 277.598C393.412 276.919 393.412 276.239 393.366 275.561Z"
                                fill="#F5F5F5" />
                        </g>
                        <g opacity="0.6">
                            <path
                                d="M384.11 225.89C384.11 225.89 384.133 225.866 384.11 225.866C384.11 225.89 384.11 225.89 384.11 225.89Z"
                                fill="#F5F5F5" />
                        </g>
                        <path
                            d="M393.367 275.56C393.355 273.428 393.29 271.313 393.176 269.211C393.062 267.109 392.898 265.018 392.687 262.932C392.523 261.246 392.334 259.582 392.101 257.919C391.872 256.163 391.611 254.414 391.32 252.675C390.443 247.457 389.284 242.327 387.86 237.301C387.309 235.368 386.723 233.453 386.1 231.553C385.476 229.652 384.813 227.765 384.111 225.892C384.111 225.892 384.111 225.892 384.111 225.867C383.361 224.462 382.565 223.08 381.698 221.721C373.474 208.695 361.525 198.479 352.482 186.015C349.529 181.962 347.234 178.611 342.008 177.814C334.278 176.619 330.364 181.024 324.882 173.691C323.406 171.723 320.828 169.895 318.65 171.067C319.211 172.637 319.797 174.207 320.359 175.799C320.476 176.127 320.593 176.479 320.547 176.83C320.43 177.931 318.791 178.236 317.853 177.627C316.916 176.994 316.447 175.893 315.791 174.98C313.354 171.489 307.637 171.043 304.661 174.066C304.544 172.59 303.561 171.207 302.202 170.598C301.897 173.48 298.593 175.613 295.829 174.699C295.384 173.27 297.937 173.012 298.827 171.794C299.647 170.647 298.663 169.053 297.608 168.092C294.821 165.655 291.142 164.226 287.416 164.132C285.05 164.085 282.496 164.53 280.434 163.312C279.24 162.609 278.397 161.437 277.178 160.759C274.577 159.283 271.321 160.642 268.696 162.095C265.111 164.086 261.409 166.593 260.144 170.505C258.855 174.395 261.69 179.666 265.767 179.174C266.798 179.033 267.876 178.541 268.883 178.822C270.336 179.22 270.991 180.908 271.108 182.407C271.225 183.882 271.061 185.476 271.788 186.788C272.491 188.1 274.623 188.756 275.443 187.514C277.363 185.686 277.129 182.616 276.638 180.016C276.168 177.415 275.63 174.486 277.177 172.355C278.746 170.223 283.198 170.902 282.894 173.527C282.706 175.072 280.949 176.197 281.019 177.767C281.089 179.36 283.035 180.204 284.628 180.134C286.22 180.087 287.837 179.501 289.383 179.9C290.952 180.275 292.194 182.314 291.069 183.462C289.125 185.664 284.064 181.892 283.056 184.634C282.776 185.336 283.057 186.133 282.985 186.883C282.798 189.179 279.917 190.023 277.62 190.304C275.324 190.562 272.888 190.796 270.802 189.812C268.717 188.828 267.287 186.086 268.482 184.119C267.312 183.275 265.531 184.119 264.898 185.431C264.265 186.719 264.453 188.265 264.64 189.695C262.203 189.156 260.024 191.218 258.641 193.257C257.236 195.318 255.901 197.708 253.534 198.435C251.145 199.162 247.864 198.178 246.622 200.333C245.005 203.144 249.69 206.706 248.051 209.493C247.114 211.063 244.864 211.016 243.083 211.508C238.374 212.844 236.734 219.732 239.944 223.411C243.13 227.089 249.573 226.878 252.97 223.364C255.336 220.95 256.297 217.553 258.007 214.648C259.718 211.766 262.95 209.141 266.184 210.079C267.449 210.454 268.527 211.344 269.535 212.188C271.103 213.5 272.674 214.812 274.244 216.148C275.251 216.992 276.353 218.045 276.259 219.357C276.164 220.411 275.345 221.232 274.994 222.216C274.01 225.05 278.109 227.745 280.687 226.198C283.288 224.652 283.546 220.693 281.789 218.256C279.352 214.883 273.846 213.196 273.987 209.024C276.799 206.729 281.227 209.141 282.867 212.398C284.507 215.632 284.554 219.474 285.937 222.825C287.318 226.198 291.185 229.174 294.419 227.534C293.575 224.628 292.755 221.747 291.912 218.865C293.974 217.32 296.341 221.818 298.8 221.068C300.3 220.599 300.487 218.443 299.831 216.992C299.199 215.539 298.027 214.321 297.746 212.751C297.279 209.893 300.464 207.339 303.347 207.808C306.206 208.277 308.29 211.019 308.829 213.853C309.04 214.978 309.087 216.173 309.579 217.204C310.657 219.454 313.444 220.133 315.741 221.069C318.061 222.006 320.451 224.326 319.49 226.623C319.045 227.629 317.99 228.59 318.365 229.623C318.717 230.536 320.076 230.934 320.076 231.918C320.053 232.574 319.373 233.019 318.764 233.277C317.217 233.91 315.53 234.121 314.03 234.847C312.53 235.55 311.172 237.002 311.29 238.642C311.477 240.985 314.266 242.11 315.577 244.054C316.842 245.905 316.655 248.366 317.452 250.475C318.202 252.419 319.748 253.942 320.99 255.606C324.879 260.901 325.793 267.72 327.691 273.999C328.533 276.833 330.08 279.996 332.986 280.536C334.579 280.817 336.173 280.208 337.671 279.622C341.865 277.958 346.223 276.177 349.152 272.781C352.105 269.361 353.087 263.807 350.066 260.458C349.691 260.013 349.199 259.614 348.637 259.544C347.84 259.45 347.137 259.989 346.434 260.317C344.303 261.301 341.678 260.481 339.897 258.911C338.14 257.364 337.062 255.185 336.009 253.077C334.861 250.757 333.712 248.414 332.541 246.072C333.924 244.9 336.126 245.392 337.556 246.54C338.962 247.687 339.828 249.351 340.976 250.757C344.467 255.114 350.208 257.036 355.76 257.692C357.166 257.856 358.619 257.973 359.931 258.559C364.078 260.457 365.273 266.572 369.654 267.884C370.872 268.259 372.231 268.189 373.38 268.728C375.114 269.547 375.981 271.516 376.495 273.367C377.456 276.812 377.784 280.443 379.237 283.723C380.667 287.003 383.596 289.979 387.157 290.025C389.383 290.072 391.492 288.947 393.109 287.377V287.353C393.297 284.119 393.414 280.887 393.414 277.606C393.412 276.919 393.412 276.239 393.367 275.56Z"
                            fill="white" fill-opacity="0.5" />
                        <path
                            d="M333.443 337.014C331.237 337.448 330.797 338.745 329.598 340.379C328.037 342.505 325.802 344.634 324.383 346.732C321.975 350.291 324.144 355.84 320.976 358.833C320.331 359.444 319.496 359.843 318.917 360.516C317.644 361.996 318.119 364.508 319.675 365.685C321.231 366.864 323.513 366.779 325.193 365.786C326.872 364.791 327.992 363.029 328.575 361.168C328.996 359.827 329.229 358.306 330.287 357.382C332.1 355.796 334.917 356.973 337.303 356.639C347.454 355.218 343.093 335.114 333.443 337.014Z"
                            fill="#EBEBEB" />
                        <path class="theme-color" opacity="0.8"
                            d="M321.918 635.781C335.5 622.198 335.5 600.176 321.918 586.594C308.335 573.011 286.313 573.011 272.73 586.594C259.148 600.176 259.148 622.198 272.73 635.781C286.313 649.364 308.335 649.364 321.918 635.781Z"
                            fill="#89E6BA" />
                        <path class="theme-color"
                            d="M297.329 640.135C281.366 640.135 268.38 627.149 268.38 611.186C268.38 595.223 281.366 582.237 297.329 582.237C313.292 582.237 326.278 595.223 326.278 611.186C326.278 627.149 313.292 640.135 297.329 640.135ZM297.329 587.192C284.099 587.192 273.334 597.956 273.334 611.187C273.334 624.418 284.098 635.182 297.329 635.182C310.559 635.182 321.324 624.418 321.324 611.187C321.324 597.956 310.559 587.192 297.329 587.192Z"
                            fill="#0CAF60" />
                        <path
                            d="M297.135 621.083C291.255 621.083 286.473 616.301 286.473 610.422C286.473 604.543 291.255 599.76 297.135 599.76C303.014 599.76 307.796 604.543 307.796 610.422C307.796 616.301 303.014 621.083 297.135 621.083ZM297.135 604.715C293.988 604.715 291.427 607.275 291.427 610.422C291.427 613.569 293.988 616.129 297.135 616.129C300.282 616.129 302.842 613.568 302.842 610.422C302.842 607.275 300.282 604.715 297.135 604.715Z"
                            fill="white" />
                        <path class="theme-color"
                            d="M297.133 610.422H283.656L286.006 614.58L254.286 629.117L255.357 630.901L287.182 616.533L289.364 620.662L297.133 610.422Z"
                            fill="#89D8B2" />
                        <path class="theme-color"
                            d="M254.287 629.117L253.95 628.79C252.287 627.17 249.882 626.57 247.653 627.218L235 630.901L242.046 633.997L239.215 641.525L251.086 637.292C253.763 636.336 255.499 633.74 255.357 630.901L254.287 629.117Z"
                            fill="#89D8B2" />
                        <path
                            d="M658.784 684.995C658.784 685.189 534.854 685.345 382.013 685.345C229.12 685.345 105.215 685.187 105.215 684.995C105.215 684.803 229.118 684.646 382.013 684.646C534.853 684.644 658.784 684.802 658.784 684.995Z"
                            fill="white" />
                        <path class="theme-color" d="M576.284 218.24H174.849V519.883H576.284V218.24Z" fill="#DCF9EB" />
                        <path
                            d="M576.284 519.883C576.284 519.883 576.263 519.397 576.253 518.471C576.247 517.541 576.236 516.165 576.223 514.35C576.208 510.72 576.186 505.34 576.158 498.312C576.124 484.277 576.075 463.668 576.01 437.351C575.939 384.801 575.835 309.453 575.71 218.24L576.284 218.814C462.954 218.849 324.362 218.893 174.883 218.94H174.849L175.549 218.24C175.525 326.69 175.502 429.397 175.481 519.883L174.849 519.252C293.734 519.381 394.019 519.49 464.591 519.566C499.925 519.639 527.82 519.695 546.887 519.734C556.432 519.768 563.768 519.792 568.723 519.81C571.201 519.826 573.084 519.838 574.353 519.846C574.985 519.854 575.462 519.859 575.788 519.865C576.112 519.871 576.284 519.883 576.284 519.883C576.284 519.883 576.137 519.896 575.826 519.902C575.508 519.906 575.041 519.913 574.426 519.921C573.172 519.929 571.313 519.941 568.865 519.957C563.938 519.975 556.646 520 547.155 520.033C528.119 520.072 500.274 520.129 465.001 520.201C394.33 520.277 293.902 520.386 174.848 520.515L174.216 520.516V519.883C174.196 429.397 174.172 326.69 174.147 218.24V217.54H174.848H174.881C324.361 217.587 462.953 217.63 576.283 217.666H576.858L576.857 218.24C576.732 309.604 576.63 385.074 576.559 437.71C576.495 463.972 576.444 484.536 576.411 498.542C576.382 505.521 576.36 510.865 576.346 514.471C576.333 516.26 576.322 517.616 576.315 518.531C576.305 519.44 576.284 519.883 576.284 519.883Z"
                            fill="#060606" />
                        <path
                            d="M574.277 255.177C574.277 255.202 573.933 255.226 573.262 255.249C572.57 255.265 571.578 255.286 570.285 255.316C567.645 255.344 563.792 255.384 558.837 255.437C548.895 255.517 534.508 255.555 516.732 255.551C481.179 255.55 432.065 255.285 377.824 254.845C323.574 254.41 274.467 254.015 238.899 253.73C221.137 253.59 206.761 253.477 196.799 253.399C191.844 253.337 187.992 253.29 185.354 253.257C184.061 253.226 183.069 253.202 182.377 253.184C181.706 253.16 181.362 253.136 181.362 253.112C181.362 253.087 181.706 253.063 182.377 253.04C183.069 253.026 184.061 253.003 185.354 252.973C187.994 252.945 191.846 252.905 196.801 252.852C206.742 252.772 221.127 252.734 238.903 252.738C274.456 252.739 323.575 253.004 377.835 253.444C432.067 253.879 481.168 254.274 516.736 254.559C534.498 254.699 548.875 254.812 558.838 254.89C563.793 254.952 567.647 254.999 570.286 255.032C571.579 255.063 572.571 255.087 573.263 255.105C573.933 255.129 574.277 255.154 574.277 255.177Z"
                            fill="#060606" />
                        <path
                            d="M201.073 233.56C201.073 236.17 198.956 238.287 196.346 238.287C193.736 238.287 191.619 236.17 191.619 233.56C191.619 230.95 193.736 228.833 196.346 228.833C198.957 228.833 201.073 230.95 201.073 233.56Z"
                            fill="#060606" />
                        <path
                            d="M219.982 233.56C219.982 236.17 217.865 238.287 215.255 238.287C212.645 238.287 210.528 236.17 210.528 233.56C210.528 230.95 212.645 228.833 215.255 228.833C217.865 228.833 219.982 230.95 219.982 233.56Z"
                            fill="#060606" />
                        <path
                            d="M234.162 238.287C236.773 238.287 238.889 236.171 238.889 233.56C238.889 230.95 236.773 228.833 234.162 228.833C231.552 228.833 229.436 230.95 229.436 233.56C229.436 236.171 231.552 238.287 234.162 238.287Z"
                            fill="#060606" />
                        <path class="theme-color" opacity="0.5"
                            d="M643.897 223.002C642.154 190.697 608.397 174.449 591.125 172.353L577.307 188.624C588.437 186.95 616.103 202.393 617.452 213.566C618.803 224.74 610.289 239.019 599.081 240.044C590.277 240.85 575.604 233.037 570.011 239.884C555.897 227.313 531.784 228.35 518.802 242.087C508.815 238.513 497.223 239.761 488.225 245.378C479.228 250.994 473.017 260.861 471.842 271.402L523.823 301.581C523.823 301.581 545.493 320.997 560.261 309.028C565.304 304.94 567.226 299.075 567.696 293.422C568.683 293.538 569.689 293.482 570.643 293.228C574.395 292.229 577.174 288.865 578.397 285.18C578.554 284.708 578.682 284.224 578.792 283.736C591.415 286.505 608.63 283.367 618.787 277.026C633.545 267.813 644.834 240.375 643.897 223.002Z"
                            fill="#CBEFDE" />
                        <path
                            d="M573.687 246.134C573.679 246.138 573.615 246.053 573.496 245.88C573.365 245.686 573.193 245.433 572.978 245.113C572.757 244.771 572.479 244.352 572.112 243.885C571.751 243.413 571.359 242.849 570.844 242.275C568.87 239.932 565.636 236.716 560.742 234.151C558.312 232.865 555.476 231.764 552.313 231.095C549.158 230.416 545.668 230.169 542.063 230.634C534.88 231.487 527.16 235.028 521.548 241.294C520.771 242.134 520.09 243.043 519.448 243.884L519.322 244.049L519.142 243.959C511.945 240.382 503.919 239.934 497.257 241.531C495.576 241.906 493.995 242.475 492.48 243.063C490.994 243.719 489.563 244.401 488.249 245.183C485.593 246.695 483.317 248.428 481.452 250.222C477.698 253.815 475.675 257.602 474.663 260.287C474.385 260.954 474.195 261.566 474.031 262.097C473.852 262.624 473.73 263.077 473.644 263.447C473.553 263.795 473.481 264.071 473.426 264.283C473.374 264.472 473.344 264.567 473.335 264.565C473.327 264.563 473.342 264.464 473.378 264.273C473.422 264.058 473.48 263.777 473.552 263.424C473.622 263.049 473.731 262.589 473.897 262.056C474.047 261.518 474.225 260.897 474.491 260.22C475.456 257.498 477.452 253.643 481.219 249.98C483.089 248.15 485.378 246.383 488.05 244.839C489.373 244.043 490.811 243.346 492.318 242.674C493.851 242.07 495.452 241.486 497.154 241.1C503.902 239.457 512.042 239.891 519.357 243.523L519.052 243.598C519.704 242.744 520.396 241.82 521.185 240.967C526.885 234.604 534.719 231.028 542.008 230.187C545.665 229.727 549.205 229.994 552.397 230.698C555.597 231.392 558.457 232.525 560.902 233.843C565.825 236.474 569.048 239.755 570.988 242.15C571.495 242.738 571.878 243.312 572.228 243.795C572.585 244.273 572.851 244.702 573.06 245.054C573.26 245.385 573.417 245.648 573.539 245.848C573.644 246.035 573.694 246.129 573.687 246.134Z"
                            fill="#060606" />
                        <path
                            d="M583.732 239.383C583.679 239.459 583.006 238.965 581.777 238.505C581.166 238.267 580.404 238.081 579.55 237.96C578.692 237.863 577.739 237.847 576.75 237.974C575.762 238.118 574.848 238.389 574.048 238.713C573.258 239.059 572.575 239.442 572.05 239.835C570.989 240.609 570.473 241.265 570.403 241.206C570.377 241.186 570.488 241.01 570.716 240.707C570.934 240.398 571.319 239.999 571.84 239.564C572.359 239.121 573.052 238.688 573.869 238.303C574.696 237.942 575.65 237.643 576.685 237.494C577.72 237.361 578.72 237.392 579.613 237.518C580.502 237.669 581.288 237.9 581.906 238.188C582.525 238.467 583.002 238.747 583.296 238.988C583.597 239.217 583.752 239.356 583.732 239.383Z"
                            fill="#060606" />
                        <path
                            d="M598.421 259.03C598.401 259.068 597.893 258.768 596.895 258.41C595.901 258.062 594.376 257.676 592.463 257.782C590.57 257.883 588.261 258.519 586.289 260.164C584.326 261.768 582.706 264.332 582.363 267.321L582.319 267.705L581.995 267.495C580.966 266.831 579.808 266.257 578.576 265.817C575.304 264.632 571.868 264.554 568.941 265.213C566.002 265.895 563.592 267.298 561.847 268.759C560.091 270.227 558.964 271.728 558.267 272.798C557.577 273.879 557.279 274.531 557.236 274.509C557.222 274.503 557.286 274.336 557.422 274.024C557.553 273.708 557.784 273.262 558.106 272.698C558.761 271.586 559.862 270.028 561.624 268.497C563.373 266.975 565.823 265.502 568.838 264.777C571.84 264.075 575.373 264.141 578.739 265.36C580.006 265.811 581.197 266.404 582.254 267.091L581.885 267.266C582.255 264.133 583.962 261.48 586.02 259.832C588.092 258.144 590.502 257.522 592.448 257.462C594.416 257.397 595.964 257.842 596.954 258.246C597.453 258.45 597.824 258.641 598.064 258.788C598.307 258.935 598.429 259.017 598.421 259.03Z"
                            fill="#060606" />
                        <path
                            d="M638.688 204.135C638.703 204.127 638.831 204.351 639.065 204.787C639.289 205.226 639.65 205.861 640.045 206.712C640.817 208.421 641.847 210.95 642.656 214.216C643.468 217.477 644.025 221.469 644.067 225.914C644.077 228.135 643.985 230.47 643.713 232.873C643.472 235.279 643.063 237.752 642.519 240.257C640.338 250.296 636.357 258.83 632.763 264.487C630.981 267.335 629.276 269.466 628.009 270.851C627.361 271.532 626.855 272.057 626.478 272.378C626.112 272.71 625.915 272.878 625.904 272.866C625.893 272.853 626.068 272.661 626.41 272.308C626.764 271.966 627.246 271.422 627.867 270.726C629.084 269.311 630.736 267.161 632.472 264.306C635.97 258.634 639.878 250.128 642.044 240.155C642.584 237.667 642.993 235.21 643.239 232.823C643.515 230.438 643.616 228.121 643.618 225.917C643.6 221.505 643.084 217.544 642.32 214.297C641.56 211.045 640.585 208.514 639.87 206.79C639.504 205.931 639.172 205.284 638.975 204.832C638.774 204.383 638.673 204.142 638.688 204.135Z"
                            fill="#060606" />
                        <path
                            d="M612.897 205.396C612.918 205.377 613.24 205.681 613.762 206.291C614.284 206.899 614.978 207.836 615.692 209.084C617.126 211.552 618.516 215.445 618.375 219.874C618.231 224.304 616.595 228.1 615.005 230.471C614.212 231.67 613.459 232.561 612.899 233.133C612.341 233.708 611.999 233.991 611.98 233.971C611.904 233.903 613.225 232.698 614.716 230.286C616.207 227.905 617.75 224.178 617.891 219.857C618.028 215.538 616.727 211.72 615.392 209.248C614.057 206.746 612.817 205.458 612.897 205.396Z"
                            fill="#060606" />
                        <path
                            d="M578.71 180.351C581.082 183.997 584.202 187.15 587.799 189.594C590.151 191.192 593.178 188.828 592.232 186.147L592.207 186.076C596.445 189.319 600.895 192.284 605.519 194.947C608.473 196.648 611.94 193.749 610.773 190.547C606.196 178 596.986 167.135 585.212 160.789L578.71 180.351Z"
                            fill="#FFC727" />
                        <g opacity="0.3">
                            <path
                                d="M584.081 180.797C584.493 181.415 584.921 182.049 585.54 182.461C586.158 182.872 587.022 183.009 587.635 182.588C588.551 181.96 588.515 180.447 589.462 179.866C590.467 179.249 591.706 180.116 592.56 180.931C593.463 181.792 594.367 182.652 595.269 183.514C595.933 184.147 596.828 184.83 597.675 184.48C598.613 184.093 598.672 182.79 598.468 181.795C597.521 177.188 594.149 173.151 589.783 171.4L584.081 180.797Z"
                                fill="#060606" />
                        </g>
                        <path
                            d="M619.983 203.014C619.897 204.65 621.286 206.222 622.92 206.338C624.554 206.455 626.151 205.095 626.297 203.463C626.444 201.831 625.114 200.21 623.485 200.033C621.856 199.856 620.21 201.156 620.003 202.781"
                            fill="#FFC727" />
                        <path class="theme-color"
                            d="M448.522 90.4922C445.898 94.5831 451.648 108.888 464.832 127.208C477.813 145.246 492.775 155.354 492.775 155.354L568.81 204.13L581.663 184.095L589.112 172.483L601.964 152.448L532.965 108.186C526.223 103.861 519.099 100.158 511.657 97.1933C505.259 94.6438 497.233 91.8844 488.696 90.0091C466.738 85.1871 451.146 86.4012 448.522 90.4922Z"
                            fill="#DCF5E9" />
                        <path
                            d="M554.319 121.886C554.36 121.871 554.456 121.838 554.599 121.789C570.959 116.291 588.934 118.547 603.461 127.867L612.573 133.712L588.392 143.744L554.319 121.886Z"
                            fill="#FFC727" />
                        <path
                            d="M554.319 121.885C554.323 121.886 554.382 121.922 554.494 121.992C554.615 122.068 554.777 122.17 554.987 122.301C555.428 122.581 556.062 122.982 556.88 123.5C558.535 124.551 560.931 126.072 563.951 127.991C569.979 131.833 578.491 137.256 588.472 143.617L588.334 143.605C595.118 140.787 602.569 137.691 610.372 134.45C611.105 134.146 611.834 133.843 612.511 133.563L612.486 133.846C610.671 132.681 608.879 131.531 607.114 130.398C605.343 129.279 603.629 128.118 601.885 127.098C598.418 125.018 594.86 123.387 591.365 122.156C587.873 120.908 584.425 120.121 581.175 119.625C579.555 119.336 577.966 119.236 576.449 119.082C574.925 119.028 573.462 118.914 572.065 118.968C566.472 119.013 562 119.847 558.981 120.593C557.456 120.92 556.313 121.325 555.522 121.539C554.823 121.741 554.498 121.834 554.319 121.885C554.319 121.885 554.407 121.844 554.614 121.768C554.826 121.7 555.122 121.604 555.502 121.481C556.288 121.248 557.427 120.823 558.951 120.476C561.967 119.692 566.448 118.821 572.063 118.747C573.465 118.686 574.933 118.793 576.465 118.841C577.99 118.989 579.585 119.082 581.214 119.367C584.481 119.854 587.948 120.634 591.461 121.881C594.978 123.11 598.557 124.743 602.046 126.832C603.805 127.857 605.513 129.011 607.287 130.132C609.052 131.264 610.844 132.413 612.66 133.576L612.919 133.742L612.635 133.86C611.958 134.141 611.229 134.444 610.496 134.748C602.69 137.982 595.237 141.069 588.45 143.881L588.377 143.911L588.312 143.869C578.324 137.419 569.805 131.918 563.773 128.023C560.788 126.09 558.42 124.555 556.785 123.496C555.988 122.977 555.37 122.576 554.94 122.297C554.74 122.166 554.585 122.065 554.471 121.989C554.365 121.92 554.314 121.885 554.319 121.885Z"
                            fill="#060606" />
                        <path
                            d="M521.169 173.568C521.172 173.611 521.182 173.708 521.198 173.858C522.997 190.787 532.411 205.975 546.741 215.167L555.728 220.932L554.778 195.128L521.169 173.568Z"
                            fill="#FFC727" />
                        <path
                            d="M521.169 173.568C521.167 173.564 521.218 173.596 521.324 173.66C521.439 173.732 521.593 173.829 521.793 173.954C522.221 174.224 522.834 174.613 523.627 175.115C525.25 176.145 527.6 177.637 530.559 179.517C536.533 183.324 544.968 188.699 554.859 195.002L554.924 195.044L554.927 195.122C555.198 202.363 555.494 210.316 555.805 218.643C555.834 219.425 555.862 220.204 555.889 220.926L555.9 221.234L555.641 221.068C553.851 219.919 552.083 218.785 550.343 217.668C548.608 216.538 546.872 215.481 545.229 214.326C541.922 212.058 538.986 209.519 536.438 206.872C533.876 204.234 531.75 201.446 529.97 198.719C529.044 197.375 528.305 195.983 527.545 194.677C526.872 193.323 526.172 192.051 525.65 190.769C523.408 185.704 522.347 181.328 521.81 178.302C521.494 176.793 521.406 175.598 521.291 174.797C521.245 174.405 521.209 174.101 521.184 173.883C521.168 173.664 521.169 173.568 521.169 173.568C521.197 173.751 521.247 174.081 521.356 174.787C521.491 175.585 521.597 176.776 521.931 178.278C522.504 181.291 523.595 185.644 525.855 190.677C526.381 191.951 527.085 193.215 527.76 194.56C528.522 195.857 529.264 197.24 530.19 198.574C531.971 201.283 534.095 204.051 536.65 206.668C539.19 209.296 542.115 211.815 545.407 214.068C547.038 215.212 548.783 216.273 550.516 217.399C552.257 218.515 554.025 219.649 555.816 220.797L555.569 220.939C555.542 220.217 555.514 219.438 555.485 218.656C555.183 210.329 554.894 202.375 554.63 195.134L554.699 195.254C544.892 188.922 536.529 183.52 530.605 179.695C527.644 177.777 525.294 176.254 523.672 175.202C522.871 174.682 522.251 174.279 521.818 173.998C521.614 173.863 521.455 173.76 521.337 173.682C521.227 173.61 521.171 173.57 521.169 173.568Z"
                            fill="#060606" />
                        <path
                            d="M448.522 90.4922C446.376 93.5779 449.474 102.93 457.027 115.446L477.482 87.8895C462.772 86.0748 451.28 86.5289 448.522 90.4922Z"
                            fill="#FFC727" />
                        <path
                            d="M589.282 145.049C589.358 145.097 582.138 156.632 573.159 170.811C564.177 184.995 556.837 196.451 556.762 196.403C556.688 196.356 563.905 184.822 572.887 170.639C581.866 156.461 589.208 145.002 589.282 145.049Z"
                            fill="#060606" />
                        <path
                            d="M591.437 146.757C591.513 146.804 584.293 158.34 575.314 172.519C566.332 186.702 558.992 198.158 558.918 198.111C558.843 198.063 566.061 186.531 575.043 172.347C584.02 158.168 591.362 146.709 591.437 146.757Z"
                            fill="#060606" />
                        <path
                            d="M593.897 148.277C593.973 148.324 586.753 159.86 577.774 174.039C568.792 188.222 561.452 199.678 561.378 199.631C561.302 199.583 568.521 188.05 577.503 173.866C586.481 159.687 593.823 148.229 593.897 148.277Z"
                            fill="#060606" />
                        <path
                            d="M596.354 149.796C596.43 149.843 589.21 161.379 580.231 175.558C571.249 189.741 563.909 201.197 563.835 201.15C563.759 201.102 570.978 189.569 579.96 175.385C588.938 161.207 596.28 149.748 596.354 149.796Z"
                            fill="#060606" />
                        <path
                            d="M598.815 151.316C598.89 151.363 591.671 162.899 582.692 177.078C573.71 191.261 566.37 202.717 566.296 202.67C566.22 202.622 573.439 191.09 582.421 176.906C591.399 162.726 598.74 151.268 598.815 151.316Z"
                            fill="#060606" />
                        <path
                            d="M537.864 147.661C537.867 147.651 538 147.709 538.255 147.832C538.518 147.948 538.862 148.169 539.326 148.433C540.243 148.972 541.552 149.781 543.159 150.795C546.375 152.823 550.783 155.674 555.634 158.853C560.486 162.032 564.861 164.937 568.017 167.054C569.568 168.103 570.834 168.96 571.745 169.577C572.159 169.866 572.493 170.098 572.749 170.277C572.977 170.44 573.093 170.53 573.087 170.54C573.08 170.549 572.952 170.477 572.713 170.332C572.448 170.166 572.104 169.95 571.676 169.682C570.751 169.086 569.466 168.259 567.892 167.244C564.682 165.148 560.3 162.285 555.457 159.122C550.62 155.954 546.243 153.088 543.036 150.987C541.466 149.969 540.183 149.138 539.26 148.54C538.81 148.261 538.469 148.019 538.227 147.891C537.988 147.752 537.862 147.673 537.864 147.661Z"
                            fill="#060606" />
                        <path
                            d="M554.321 121.886C554.396 121.933 547.106 133.45 538.041 147.604C528.972 161.765 521.563 173.2 521.488 173.153C521.413 173.105 528.701 161.591 537.77 147.431C546.835 133.276 554.246 121.838 554.321 121.886Z"
                            fill="#060606" />
                        <path
                            d="M565.599 159.605C565.583 159.607 565.534 159.444 565.576 159.145C565.616 158.852 565.778 158.416 566.177 158.037C566.555 157.661 567.259 157.356 567.986 157.583C568.687 157.787 569.37 158.434 569.465 159.316C569.535 160.201 568.983 160.964 568.331 161.292C567.658 161.65 566.911 161.48 566.469 161.18C566.006 160.881 565.768 160.483 565.674 160.201C565.578 159.915 565.596 159.745 565.612 159.745C565.639 159.74 565.666 159.902 565.79 160.153C565.911 160.401 566.159 160.742 566.587 160.985C567.004 161.231 567.634 161.344 568.194 161.029C568.744 160.738 569.207 160.066 569.145 159.345C569.073 158.625 568.495 158.051 567.9 157.866C567.292 157.66 566.693 157.887 566.329 158.205C565.953 158.523 565.772 158.905 565.698 159.171C565.623 159.442 565.626 159.604 565.599 159.605Z"
                            fill="#060606" />
                        <path
                            d="M551.077 149.906C551.061 149.909 551.013 149.745 551.055 149.446C551.095 149.152 551.256 148.717 551.655 148.337C552.034 147.961 552.737 147.657 553.464 147.884C554.166 148.088 554.848 148.735 554.943 149.617C555.013 150.502 554.461 151.265 553.809 151.593C553.136 151.951 552.389 151.78 551.947 151.481C551.485 151.182 551.247 150.783 551.153 150.502C551.057 150.216 551.074 150.047 551.09 150.046C551.117 150.041 551.144 150.202 551.268 150.453C551.39 150.701 551.638 151.043 552.066 151.286C552.482 151.531 553.113 151.645 553.672 151.33C554.223 151.039 554.685 150.367 554.624 149.646C554.551 148.926 553.974 148.351 553.379 148.167C552.771 147.96 552.172 148.188 551.807 148.506C551.431 148.824 551.251 149.206 551.177 149.471C551.101 149.742 551.105 149.905 551.077 149.906Z"
                            fill="#060606" />
                        <path
                            d="M523.114 143.153C523.098 143.156 523.05 142.992 523.092 142.694C523.132 142.399 523.293 141.965 523.692 141.585C524.071 141.208 524.774 140.904 525.502 141.132C526.203 141.335 526.885 141.982 526.981 142.864C527.05 143.749 526.498 144.512 525.847 144.84C525.173 145.199 524.426 145.029 523.984 144.729C523.522 144.429 523.284 144.031 523.19 143.749C523.094 143.463 523.111 143.293 523.127 143.293C523.155 143.289 523.181 143.45 523.305 143.701C523.427 143.949 523.675 144.29 524.103 144.534C524.52 144.779 525.15 144.893 525.709 144.577C526.26 144.287 526.722 143.614 526.661 142.893C526.588 142.173 526.011 141.599 525.416 141.414C524.808 141.207 524.209 141.436 523.844 141.754C523.469 142.072 523.288 142.453 523.214 142.72C523.139 142.99 523.142 143.153 523.114 143.153Z"
                            fill="#060606" />
                        <path
                            d="M510.663 140.126C510.718 140.053 516.051 142.992 522.574 146.691C529.099 150.39 534.342 153.448 534.287 153.52C534.232 153.593 528.9 150.654 522.375 146.954C515.852 143.257 510.608 140.199 510.663 140.126Z"
                            fill="#060606" />
                        <g opacity="0.3">
                            <path
                                d="M553.896 194.563C553.896 194.563 532.154 179.901 521.165 173.568C524.959 179.01 529.338 185.185 534.605 189.215C539.928 193.285 547.236 195.297 553.896 194.563Z"
                                fill="#060606" />
                        </g>
                        <path
                            d="M518.587 129.855C521.45 120.111 515.872 109.89 506.127 107.026C496.382 104.163 486.161 109.742 483.298 119.486C480.434 129.231 486.013 139.452 495.758 142.315C505.503 145.179 515.723 139.6 518.587 129.855Z"
                            fill="white" />
                        <path
                            d="M519.302 125.702C519.294 125.701 519.286 125.601 519.279 125.403C519.274 125.18 519.268 124.891 519.26 124.529C519.264 124.145 519.253 123.671 519.175 123.115C519.115 122.557 519.065 121.912 518.89 121.204C518.641 119.772 518.068 118.066 517.12 116.24C516.163 114.421 514.748 112.498 512.77 110.824C510.798 109.164 508.275 107.706 505.309 107.008C502.362 106.33 498.999 106.233 495.733 107.268C494.093 107.735 492.492 108.493 491.006 109.478C490.24 109.943 489.56 110.539 488.851 111.11C488.203 111.751 487.525 112.375 486.956 113.111C484.557 115.951 483.082 119.693 482.822 123.621C482.633 127.554 483.673 131.441 485.734 134.536C486.216 135.332 486.819 136.03 487.39 136.74C488.029 137.388 488.637 138.058 489.346 138.607C490.711 139.755 492.214 140.689 493.792 141.34C496.92 142.739 500.273 143.025 503.278 142.686C506.304 142.329 508.977 141.167 511.124 139.742C513.279 138.303 514.905 136.554 516.062 134.855C517.211 133.148 517.974 131.518 518.384 130.125C518.638 129.442 518.761 128.807 518.884 128.259C519.025 127.716 519.09 127.246 519.13 126.864C519.178 126.505 519.217 126.219 519.247 125.998C519.274 125.802 519.294 125.701 519.302 125.702C519.311 125.702 519.308 125.804 519.295 126.001C519.277 126.224 519.254 126.513 519.225 126.875C519.201 127.261 519.151 127.736 519.024 128.287C518.915 128.841 518.805 129.486 518.563 130.181C518.177 131.598 517.43 133.26 516.286 135.007C515.133 136.745 513.499 138.542 511.315 140.027C509.14 141.497 506.42 142.703 503.327 143.085C500.258 143.45 496.826 143.172 493.614 141.751C491.995 141.089 490.45 140.137 489.048 138.963C488.32 138.401 487.695 137.717 487.037 137.053C486.449 136.327 485.83 135.611 485.333 134.795C484.311 133.196 483.441 131.433 482.961 129.519C482.459 127.617 482.246 125.613 482.335 123.593C482.601 119.562 484.121 115.717 486.588 112.808C487.173 112.055 487.87 111.414 488.536 110.76C489.264 110.175 489.963 109.565 490.749 109.09C492.276 108.083 493.919 107.313 495.602 106.839C498.954 105.792 502.396 105.906 505.403 106.617C508.431 107.348 510.996 108.856 512.991 110.564C514.992 112.287 516.412 114.257 517.359 116.115C518.298 117.98 518.85 119.716 519.074 121.168C519.236 121.886 519.272 122.539 519.316 123.102C519.381 123.665 519.376 124.142 519.356 124.528C519.344 124.892 519.334 125.181 519.327 125.405C519.319 125.603 519.311 125.702 519.302 125.702Z"
                            fill="#060606" />
                        <path
                            d="M448.523 90.4921C448.523 90.4921 448.561 90.4306 448.645 90.3131C448.721 90.19 448.859 90.0259 449.066 89.8272C449.476 89.4318 450.186 88.9423 451.216 88.5142C453.274 87.6517 456.545 87.0194 460.783 86.846C465.023 86.6604 470.24 86.9 476.25 87.6806C482.256 88.4751 489.083 89.7256 496.478 91.8172C500.173 92.8682 504.008 94.1206 507.954 95.58C511.899 97.0394 515.964 98.7067 520.056 100.704C524.147 102.7 528.284 104.983 532.398 107.588C536.494 110.209 540.717 112.913 545.059 115.691C562.417 126.816 581.653 139.145 602.095 152.246L602.297 152.375L602.168 152.578C596.848 160.872 591.272 169.565 585.596 178.417C579.916 187.269 574.337 195.964 569.015 204.26L568.885 204.462L568.683 204.333C548.245 191.21 529.015 178.864 511.664 167.723C507.328 164.936 503.109 162.225 499.018 159.597C496.973 158.282 494.959 156.988 492.979 155.716C491.014 154.39 489.199 152.952 487.436 151.51C480.407 145.714 474.531 139.6 469.631 133.687C464.79 127.717 460.91 121.97 457.724 116.817C454.548 111.657 452.134 107.032 450.492 103.119C448.842 99.2131 447.989 95.9959 447.879 93.7662C447.822 92.6528 447.962 91.8005 448.149 91.2624C448.242 90.992 448.332 90.798 448.412 90.6768C448.483 90.5518 448.523 90.4921 448.523 90.4921C448.55 90.5052 448.354 90.7346 448.19 91.2773C448.02 91.8144 447.896 92.6574 447.967 93.7615C448.105 95.9726 448.98 99.1674 450.65 103.052C452.312 106.944 454.744 111.548 457.935 116.687C461.137 121.817 465.033 127.546 469.875 133.485C474.78 139.369 480.656 145.455 487.673 151.219C489.431 152.65 491.252 154.087 493.192 155.39C495.175 156.659 497.19 157.95 499.237 159.261C503.331 161.883 507.555 164.588 511.895 167.367C529.254 178.493 548.493 190.824 568.94 203.928L568.609 204.001C573.93 195.704 579.507 187.008 585.185 178.155C590.864 169.305 596.441 160.613 601.762 152.319L601.835 152.651C581.404 139.533 562.177 127.189 544.829 116.05C540.492 113.265 536.274 110.556 532.182 107.929C528.084 105.326 523.964 103.042 519.889 101.045C515.813 99.0452 511.766 97.3741 507.831 95.9082C503.896 94.4423 500.072 93.1834 496.389 92.124C489.018 90.0175 482.206 88.7464 476.215 87.9296C470.219 87.1267 465.015 86.8609 460.787 87.0194C456.56 87.1658 453.3 87.7682 451.246 88.5972C450.22 89.0094 449.51 89.4813 449.094 89.8608C448.674 90.2375 448.546 90.5098 448.523 90.4921Z"
                            fill="#060606" />
                        <path
                            d="M439.923 301.494H289.754C279.948 301.494 271.998 293.545 271.998 283.738C271.998 273.932 279.947 265.982 289.754 265.982H439.924C449.73 265.982 457.68 273.931 457.68 283.738C457.679 293.545 449.73 301.494 439.923 301.494Z"
                            fill="white" />
                        <path
                            d="M439.922 301.494C439.922 301.494 440.282 301.461 440.983 301.417C441.333 301.395 441.771 301.385 442.283 301.284C442.793 301.187 443.4 301.147 444.055 300.943C444.386 300.857 444.737 300.764 445.106 300.668C445.469 300.551 445.843 300.399 446.239 300.256C446.437 300.182 446.639 300.106 446.845 300.028C447.044 299.931 447.246 299.832 447.453 299.731C447.863 299.52 448.313 299.344 448.729 299.064C450.457 298.071 452.296 296.607 453.877 294.547C454.268 294.031 454.67 293.498 455.002 292.899C455.379 292.327 455.682 291.693 455.986 291.041C456.318 290.401 456.507 289.683 456.783 288.983C456.876 288.618 456.97 288.249 457.065 287.875L457.208 287.312L457.297 286.731C457.356 286.342 457.416 285.948 457.476 285.55C457.495 285.148 457.515 284.742 457.535 284.331L457.563 283.713L457.53 283.089C457.503 282.671 457.497 282.247 457.452 281.822C457.251 280.124 456.799 278.394 456.082 276.703C454.609 273.345 451.919 270.205 448.246 268.218C446.414 267.228 444.341 266.563 442.161 266.292C439.986 266.044 437.694 266.17 435.369 266.141C398.095 266.159 346.618 266.182 289.762 266.207C288.006 266.243 286.263 266.486 284.588 266.983C282.928 267.521 281.351 268.279 279.904 269.235C278.478 270.224 277.208 271.413 276.111 272.738C275.023 274.076 274.176 275.585 273.509 277.156C272.851 278.738 272.498 280.419 272.302 282.1C272.163 283.793 272.25 285.491 272.557 287.148C272.919 288.789 273.439 290.397 274.227 291.873C275.03 293.331 275.97 294.722 277.138 295.9C279.44 298.275 282.385 299.993 285.548 300.747C286.327 300.988 287.143 301.04 287.938 301.183C288.749 301.214 289.543 301.296 290.363 301.277C291.992 301.278 293.612 301.278 295.225 301.279C301.674 301.282 307.987 301.284 314.148 301.287C338.786 301.305 360.973 301.321 379.609 301.335C398.237 301.365 413.312 301.39 423.74 301.407C428.944 301.425 432.987 301.44 435.739 301.449C437.105 301.459 438.147 301.467 438.859 301.472C439.562 301.479 439.922 301.494 439.922 301.494C439.922 301.494 439.562 301.51 438.859 301.518C438.147 301.523 437.104 301.531 435.739 301.54C432.988 301.55 428.945 301.564 423.74 301.582C413.312 301.6 398.237 301.624 379.609 301.654C360.973 301.668 338.786 301.685 314.148 301.703C307.987 301.705 301.674 301.708 295.225 301.71C293.612 301.711 291.992 301.711 290.363 301.712C289.552 301.732 288.717 301.65 287.893 301.617C287.078 301.473 286.242 301.418 285.443 301.173C282.201 300.4 279.18 298.642 276.82 296.208C275.624 295.001 274.659 293.577 273.835 292.081C273.027 290.568 272.491 288.92 272.12 287.237C271.805 285.539 271.715 283.797 271.858 282.062C272.057 280.337 272.42 278.613 273.094 276.991C273.778 275.379 274.646 273.831 275.761 272.46C276.886 271.1 278.189 269.881 279.652 268.867C281.135 267.885 282.752 267.107 284.456 266.556C286.174 266.045 287.962 265.795 289.762 265.76C346.618 265.786 398.095 265.809 435.369 265.826C437.698 265.859 439.969 265.737 442.199 265.994C444.415 266.275 446.522 266.958 448.381 267.968C452.109 269.998 454.829 273.194 456.312 276.604C457.035 278.323 457.486 280.078 457.683 281.8C457.727 282.229 457.731 282.659 457.757 283.083L457.788 283.716L457.757 284.342C457.736 284.757 457.713 285.168 457.692 285.575C457.629 285.977 457.568 286.376 457.507 286.77L457.414 287.357L457.266 287.927C457.169 288.305 457.072 288.678 456.976 289.047C456.694 289.754 456.498 290.48 456.16 291.126C455.851 291.784 455.541 292.422 455.158 292.999C454.819 293.604 454.411 294.139 454.012 294.659C452.406 296.731 450.541 298.196 448.793 299.184C448.373 299.463 447.917 299.638 447.504 299.847C447.294 299.946 447.089 300.045 446.889 300.14C446.68 300.217 446.476 300.291 446.277 300.365C445.877 300.506 445.5 300.655 445.133 300.769C444.761 300.863 444.408 300.951 444.074 301.036C443.414 301.232 442.803 301.267 442.289 301.356C441.775 301.45 441.336 301.452 440.984 301.467C440.282 301.492 439.922 301.494 439.922 301.494Z"
                            fill="#060606" />
                        <path
                            d="M438.693 288.354C441.778 285.268 441.778 280.266 438.693 277.18C435.607 274.095 430.605 274.095 427.519 277.18C424.434 280.266 424.434 285.268 427.519 288.354C430.605 291.439 435.607 291.439 438.693 288.354Z"
                            fill="white" />
                        <path
                            d="M433.11 291.1C428.515 291.1 424.776 287.361 424.776 282.766C424.776 278.172 428.515 274.433 433.11 274.433C437.704 274.433 441.443 278.171 441.443 282.766C441.442 287.361 437.704 291.1 433.11 291.1ZM433.11 275.299C428.991 275.299 425.641 278.649 425.641 282.767C425.641 286.885 428.991 290.236 433.11 290.236C437.228 290.236 440.578 286.885 440.578 282.767C440.577 278.649 437.227 275.299 433.11 275.299Z"
                            fill="#060606" />
                        <path d="M439.721 287.06L439.26 287.791L445.947 292.013L446.409 291.282L439.721 287.06Z"
                            fill="#060606" />
                        <path
                            d="M296.938 286.615L297.589 285.169C298.288 285.679 299.33 286.034 300.326 286.034C301.463 286.034 301.926 285.655 301.926 285.145C301.926 283.593 297.104 284.659 297.104 281.578C297.104 280.169 298.241 278.995 300.599 278.995C301.642 278.995 302.708 279.244 303.478 279.73L302.886 281.188C302.115 280.75 301.322 280.536 300.587 280.536C299.45 280.536 299.012 280.962 299.012 281.484C299.012 283.013 303.834 281.958 303.834 285.002C303.834 286.389 302.685 287.574 300.316 287.574C298.999 287.575 297.673 287.184 296.938 286.615Z"
                            fill="#060606" />
                        <path
                            d="M311.224 284.766H306.402C306.58 285.56 307.255 286.046 308.227 286.046C308.902 286.046 309.388 285.845 309.826 285.43L310.809 286.496C310.217 287.171 309.328 287.527 308.179 287.527C305.976 287.527 304.542 286.14 304.542 284.244C304.542 282.337 306 280.963 307.943 280.963C309.815 280.963 311.26 282.219 311.26 284.268C311.26 284.411 311.236 284.612 311.224 284.766ZM306.379 283.688H309.518C309.389 282.882 308.783 282.361 307.954 282.361C307.113 282.362 306.508 282.871 306.379 283.688Z"
                            fill="#060606" />
                        <path
                            d="M317.951 283.795V287.433H316.221V286.639C315.877 287.22 315.214 287.528 314.278 287.528C312.785 287.528 311.896 286.698 311.896 285.597C311.896 284.471 312.69 283.689 314.634 283.689H316.103C316.103 282.895 315.629 282.433 314.634 282.433C313.959 282.433 313.26 282.658 312.798 283.026L312.134 281.734C312.833 281.236 313.864 280.963 314.883 280.963C316.825 280.963 317.951 281.864 317.951 283.795ZM316.102 285.418V284.767H314.835C313.969 284.767 313.697 285.087 313.697 285.514C313.697 285.975 314.088 286.284 314.74 286.284C315.356 286.283 315.89 285.999 316.102 285.418Z"
                            fill="#060606" />
                        <path
                            d="M323.576 280.963V282.669C323.422 282.657 323.303 282.646 323.161 282.646C322.142 282.646 321.466 283.203 321.466 284.423V287.432H319.617V281.058H321.383V281.899C321.834 281.283 322.593 280.963 323.576 280.963Z"
                            fill="#060606" />
                        <path
                            d="M324.144 284.245C324.144 282.325 325.625 280.963 327.698 280.963C329.037 280.963 330.092 281.544 330.554 282.586L329.12 283.357C328.776 282.752 328.267 282.48 327.686 282.48C326.75 282.48 326.016 283.131 326.016 284.246C326.016 285.36 326.751 286.012 327.686 286.012C328.267 286.012 328.776 285.75 329.12 285.135L330.554 285.916C330.091 286.935 329.037 287.528 327.698 287.528C325.625 287.527 324.144 286.165 324.144 284.245Z"
                            fill="#060606" />
                        <path
                            d="M338.086 283.783V287.432H336.237V284.067C336.237 283.036 335.763 282.562 334.945 282.562C334.057 282.562 333.416 283.107 333.416 284.28V287.432H331.567V278.641H333.416V281.722C333.914 281.224 334.625 280.963 335.442 280.963C336.948 280.963 338.086 281.84 338.086 283.783Z"
                            fill="#060606" />
                        <path
                            d="M339.304 286.366C339.304 285.68 339.813 285.229 340.453 285.229C341.093 285.229 341.602 285.68 341.602 286.366C341.602 287.041 341.093 287.527 340.453 287.527C339.814 287.527 339.304 287.041 339.304 286.366Z"
                            fill="#060606" />
                        <path
                            d="M342.407 286.366C342.407 285.68 342.917 285.229 343.556 285.229C344.196 285.229 344.706 285.68 344.706 286.366C344.706 287.041 344.196 287.527 343.556 287.527C342.917 287.527 342.407 287.041 342.407 286.366Z"
                            fill="#060606" />
                        <path
                            d="M345.51 286.366C345.51 285.68 346.019 285.229 346.659 285.229C347.299 285.229 347.808 285.68 347.808 286.366C347.808 287.041 347.299 287.527 346.659 287.527C346.02 287.527 345.51 287.041 345.51 286.366Z"
                            fill="#060606" />
                        <path class="theme-color"
                            d="M181.639 178.502L138.305 155.619C135.31 154.037 134.165 150.328 135.746 147.334L167.42 87.3535C169.001 84.359 172.711 83.2126 175.705 84.7945L203.187 99.307L212.883 132.468L189.925 175.943C188.344 178.939 184.635 180.084 181.639 178.502Z"
                            fill="#2E4D3E" />
                        <g opacity="0.3">
                            <path
                                d="M203.188 99.307L194.274 116.188C192.804 118.972 193.868 122.422 196.653 123.894L212.883 132.468L203.188 99.307Z"
                                fill="white" />
                        </g>
                        <g opacity="0.2">
                            <path
                                d="M193.714 117.787C193.714 117.787 191.339 121.768 195.289 125.575C195.437 125.718 195.597 125.851 195.759 125.977C197.679 127.476 210.32 137.325 210.49 137.005C210.672 136.658 212.885 132.469 212.885 132.469L196.653 123.897C196.653 123.897 192.672 121.617 193.714 117.787Z"
                                fill="#060606" />
                        </g>
                        <path
                            d="M191.004 113.58C190.89 113.797 186.308 111.603 180.772 108.68C175.235 105.756 170.84 103.211 170.954 102.994C171.069 102.777 175.649 104.971 181.186 107.894C186.723 110.817 191.118 113.364 191.004 113.58Z"
                            fill="#FAFAFA" />
                        <path
                            d="M198.912 129.962C198.798 130.179 191.317 126.454 182.207 121.643C173.094 116.83 165.801 112.755 165.915 112.537C166.03 112.321 173.509 116.045 182.621 120.857C191.732 125.668 199.026 129.746 198.912 129.962Z"
                            fill="#FAFAFA" />
                        <path
                            d="M197.674 139.502C197.56 139.718 189.414 135.642 179.483 130.399C169.549 125.153 161.591 120.726 161.706 120.509C161.821 120.292 169.964 124.367 179.899 129.613C189.83 134.857 197.789 139.284 197.674 139.502Z"
                            fill="#FAFAFA" />
                        <path
                            d="M193.704 147.02C193.59 147.238 185.444 143.162 175.513 137.917C165.578 132.672 157.62 128.245 157.736 128.027C157.85 127.811 165.993 131.886 175.928 137.131C185.859 142.375 193.818 146.804 193.704 147.02Z"
                            fill="#FAFAFA" />
                        <path
                            d="M189.733 154.54C189.619 154.756 181.473 150.681 171.542 145.437C161.607 140.191 153.649 135.764 153.765 135.547C153.879 135.33 162.022 139.405 171.957 144.651C181.888 149.895 189.849 154.324 189.733 154.54Z"
                            fill="#FAFAFA" />
                        <path
                            d="M185.762 162.06C185.648 162.276 177.502 158.2 167.571 152.957C157.636 147.711 149.679 143.284 149.794 143.066C149.908 142.85 158.052 146.925 167.987 152.171C177.917 157.415 185.877 161.843 185.762 162.06Z"
                            fill="#FAFAFA" />
                        <path
                            d="M395.221 629.476C391.401 628.926 388.751 625.385 389.299 621.567L397.944 561.452C398.383 558.393 401.389 556.294 404.655 556.764L410.307 557.577C412.614 557.909 414.89 556.954 416.14 555.131L417.709 552.841C418.957 551.019 421.234 550.064 423.542 550.396L450.375 554.255C452.466 554.556 454.254 555.869 455.075 557.708L456.092 559.986C456.913 561.826 458.701 563.137 460.792 563.439L494.997 568.358C498.263 568.827 500.554 571.688 500.115 574.747L491.274 636.231C490.724 640.051 487.184 642.701 483.365 642.151L395.221 629.476Z"
                            fill="#455A64" />
                        <g opacity="0.3">
                            <path
                                d="M395.221 629.476C391.401 628.926 388.751 625.385 389.299 621.567L397.944 561.452C398.383 558.393 401.389 556.294 404.655 556.764L410.307 557.577C412.614 557.909 414.89 556.954 416.14 555.131L417.709 552.841C418.957 551.019 421.234 550.064 423.542 550.396L450.375 554.255C452.466 554.556 454.254 555.869 455.075 557.708L456.092 559.986C456.913 561.826 458.701 563.137 460.792 563.439L494.997 568.358C498.263 568.827 500.554 571.688 500.115 574.747L491.274 636.231C490.724 640.051 487.184 642.701 483.365 642.151L395.221 629.476Z"
                                fill="#060606" />
                        </g>
                        <path class="theme-color"
                            d="M457.416 562.953L435.663 559.777L434.243 555.862C433.321 553.322 430.961 551.463 428.144 551.059L406.875 548C403.089 547.456 399.606 549.888 399.097 553.434L398.741 555.913L389.354 621.187C388.775 625.215 391.792 628.983 396.093 629.601L482.491 642.025C486.792 642.643 490.748 639.88 491.328 635.851L500.194 574.188C500.589 571.437 498.681 568.886 495.93 568.491L457.416 562.953Z"
                            fill="#455A64" />
                        <path d="M474.858 589.777L423.439 582.384L420.329 604.017L471.748 611.41L474.858 589.777Z"
                            fill="white" />
                        <path
                            d="M465.56 598.197C465.532 598.388 457.601 597.407 447.846 596.004C438.089 594.6 430.202 593.309 430.231 593.117C430.257 592.926 438.188 593.907 447.946 595.31C457.701 596.713 465.587 598.006 465.56 598.197Z"
                            fill="#060606" />
                        <path
                            d="M464.898 602.806C464.871 602.996 456.939 602.014 447.184 600.612C437.427 599.209 429.54 597.917 429.568 597.725C429.597 597.534 437.526 598.516 447.284 599.919C457.038 601.322 464.925 602.613 464.898 602.806Z"
                            fill="#060606" />
                        <path
                            d="M551.248 602.755C548.883 603.66 546.231 602.476 545.325 600.111L531.073 562.879C530.348 560.984 531.4 558.822 533.423 558.048L536.924 556.708C538.352 556.161 539.352 554.887 539.487 553.442L539.655 551.627C539.788 550.184 540.789 548.909 542.218 548.362L558.836 542C560.132 541.504 561.575 541.686 562.634 542.479L563.946 543.46C565.005 544.252 566.449 544.434 567.744 543.938L588.93 535.829C590.953 535.055 593.181 535.962 593.905 537.857L608.482 575.936C609.388 578.302 608.204 580.953 605.839 581.859L551.248 602.755Z"
                            fill="#EB996E" />
                        <g opacity="0.3">
                            <path
                                d="M551.248 602.755C548.883 603.66 546.231 602.476 545.325 600.111L531.073 562.879C530.348 560.984 531.4 558.822 533.423 558.048L536.924 556.708C538.352 556.161 539.352 554.887 539.487 553.442L539.655 551.627C539.788 550.184 540.789 548.909 542.218 548.362L558.836 542C560.132 541.504 561.575 541.686 562.634 542.479L563.946 543.46C565.005 544.252 566.449 544.434 567.744 543.938L588.93 535.829C590.953 535.055 593.181 535.962 593.905 537.857L608.482 575.936C609.388 578.302 608.204 580.953 605.839 581.859L551.248 602.755Z"
                                fill="#060606" />
                        </g>
                        <path
                            d="M565.654 544.737L552.166 549.865L550.1 548.075C548.76 546.914 546.812 546.602 545.068 547.269L531.895 552.312C529.55 553.209 528.331 555.717 529.172 557.913L529.761 559.45L545.236 599.877C546.192 602.372 549.124 603.568 551.788 602.548L605.298 582.065C607.962 581.045 609.347 578.196 608.392 575.701L593.773 537.51C593.121 535.806 591.212 534.954 589.507 535.606L565.654 544.737Z"
                            fill="#EB996E" />
                        <path d="M584.224 554.548L552.378 566.738L557.507 580.137L589.353 567.947L584.224 554.548Z"
                            fill="white" />
                        <path
                            d="M581.586 562.343C581.654 562.523 576.812 564.545 570.77 566.858C564.726 569.171 559.772 570.9 559.704 570.719C559.635 570.539 564.476 568.518 570.52 566.205C576.562 563.892 581.516 562.163 581.586 562.343Z"
                            fill="#060606" />
                        <path
                            d="M582.678 565.198C582.747 565.378 577.904 567.401 571.863 569.712C565.819 572.025 560.865 573.754 560.797 573.574C560.728 573.394 565.569 571.372 571.613 569.059C577.654 566.746 582.608 565.016 582.678 565.198Z"
                            fill="#060606" />
                        <path
                            d="M604.883 625.967C607.591 627.143 609.583 629.645 610.583 632.423C611.583 635.201 611.673 638.235 611.34 641.169C610.696 646.844 607.472 652.573 603.999 657.107C599.219 652.937 598.12 645.66 597.795 641.935C597.28 636.045 599.925 625.089 604.883 625.967Z"
                            fill="#7C3B29" />
                        <path
                            d="M609.555 666.474C608.79 663.265 610.125 659.747 612.587 657.553C615.049 655.36 618.49 654.431 621.777 654.683C623.297 654.798 624.941 655.242 625.811 656.494C626.624 657.665 626.534 659.298 625.873 660.561C625.213 661.825 624.069 662.769 622.862 663.526C618.721 666.124 614.238 667.879 609.555 666.474Z"
                            fill="#7C3B29" />
                        <path
                            d="M603.426 683.876C603.398 683.869 603.463 683.455 603.597 682.71C603.748 681.891 603.941 680.831 604.175 679.559C604.703 676.926 605.381 673.152 607.428 669.491C609.446 665.838 612.273 663.147 614.653 661.813C615.834 661.128 616.869 660.721 617.599 660.509C617.959 660.388 618.253 660.341 618.447 660.294C618.643 660.252 618.747 660.237 618.749 660.252C618.783 660.345 617.094 660.649 614.802 662.064C612.504 663.439 609.773 666.101 607.788 669.692C605.781 673.278 605.061 676.998 604.46 679.618C604.171 680.939 603.936 682.009 603.753 682.744C603.572 683.479 603.453 683.881 603.426 683.876Z"
                            fill="#060606" />
                        <path
                            d="M603.607 634.488C603.622 634.488 603.64 634.662 603.665 634.997C603.687 635.375 603.716 635.86 603.752 636.459C603.821 637.729 603.894 639.569 603.968 641.843C604.115 646.39 604.23 652.676 604.202 659.619C604.171 666.564 604.001 672.849 603.815 677.395C603.722 679.668 603.631 681.506 603.553 682.776C603.513 683.376 603.479 683.861 603.454 684.239C603.427 684.573 603.405 684.748 603.39 684.747C603.376 684.747 603.369 684.569 603.37 684.234C603.376 683.855 603.384 683.37 603.392 682.77C603.424 681.447 603.468 679.619 603.522 677.385C603.634 672.839 603.757 666.558 603.788 659.618C603.816 652.68 603.748 646.398 603.675 641.851C603.64 639.616 603.612 637.79 603.591 636.466C603.587 635.865 603.584 635.379 603.581 635.001C603.584 634.665 603.592 634.489 603.607 634.488Z"
                            fill="#060606" />
                        <path
                            d="M601.287 669.929C600.2 663.062 595.572 656.854 589.301 653.851C587.704 653.086 585.619 652.586 584.307 653.774C582.992 654.963 583.287 657.099 583.929 658.752C586.606 665.628 593.795 670.483 601.174 670.395"
                            fill="#7C3B29" />
                        <path
                            d="M590.075 659.233C590.087 659.208 590.447 659.366 591.088 659.676C591.411 659.829 591.805 660.017 592.235 660.286C592.664 660.553 593.184 660.815 593.693 661.201C594.215 661.569 594.797 661.962 595.362 662.458C595.956 662.92 596.534 663.479 597.139 664.072C598.317 665.285 599.502 666.734 600.514 668.409C601.511 670.093 602.233 671.821 602.737 673.435C602.964 674.251 603.183 675.025 603.299 675.77C603.46 676.506 603.52 677.205 603.585 677.84C603.672 678.474 603.643 679.055 603.664 679.56C603.687 680.067 603.655 680.502 603.625 680.858C603.573 681.569 603.531 681.96 603.503 681.958C603.41 681.954 603.572 680.38 603.293 677.869C603.21 677.244 603.135 676.558 602.961 675.836C602.834 675.105 602.605 674.347 602.373 673.547C601.857 671.965 601.138 670.274 600.158 668.62C599.163 666.975 598.009 665.546 596.865 664.337C596.278 663.747 595.717 663.186 595.141 662.72C594.592 662.218 594.028 661.819 593.524 661.44C591.473 659.969 590.033 659.314 590.075 659.233Z"
                            fill="#060606" />
                        <path
                            d="M480.009 373.056C479.978 372.963 481.864 373.259 484.971 372.018C486.474 371.366 488.281 370.283 489.715 368.435C490.432 367.523 491.073 366.442 491.494 365.197C491.907 363.954 492.108 362.559 491.997 361.096C491.888 359.635 491.455 358.107 490.633 356.668C489.819 355.226 488.577 353.904 487.02 352.858C485.471 351.797 483.537 351.104 481.468 350.857C480.433 350.75 479.358 350.768 478.26 350.773C477.163 350.774 476.048 350.775 474.912 350.777C465.826 350.786 455.482 350.797 444.048 350.809C398.301 350.826 335.119 350.849 265.335 350.874C263.202 350.905 261.058 351.393 259.246 352.431C257.406 353.423 255.916 354.907 254.884 356.607C252.857 360.038 252.986 364.451 255.271 367.693C256.361 369.336 257.966 370.658 259.778 371.565C261.617 372.446 263.669 372.893 265.74 372.838C269.924 372.839 274.075 372.839 278.189 372.84C294.645 372.844 310.518 372.848 325.639 372.852C355.879 372.87 383.112 372.886 405.984 372.9C428.849 372.93 447.353 372.953 460.15 372.97C466.54 372.988 471.502 373.003 474.877 373.012C476.555 373.021 477.836 373.029 478.707 373.034C479.567 373.041 480.009 373.056 480.009 373.056C480.009 373.056 479.567 373.071 478.704 373.079C477.833 373.084 476.552 373.092 474.874 373.101C471.5 373.11 466.537 373.125 460.147 373.143C447.35 373.16 428.847 373.183 405.982 373.213C383.109 373.227 355.877 373.243 325.636 373.261C310.515 373.265 294.641 373.269 278.186 373.274C274.072 373.274 269.922 373.275 265.737 373.275C263.618 373.333 261.458 372.869 259.554 371.953C257.668 371.011 256.001 369.635 254.866 367.928C252.49 364.555 252.352 359.968 254.462 356.396C255.535 354.627 257.085 353.086 258.999 352.052C260.883 350.974 263.116 350.463 265.333 350.432C335.117 350.457 398.299 350.48 444.046 350.497C455.48 350.508 465.824 350.519 474.91 350.529C476.046 350.531 477.162 350.532 478.258 350.533C479.35 350.532 480.432 350.515 481.495 350.629C483.607 350.885 485.576 351.6 487.151 352.687C488.735 353.758 489.992 355.108 490.814 356.578C491.644 358.045 492.078 359.6 492.181 361.084C492.286 362.569 492.075 363.984 491.65 365.242C491.216 366.502 490.56 367.593 489.828 368.513C488.364 370.374 486.531 371.454 485.009 372.099C483.461 372.738 482.166 372.908 481.314 373.011C480.451 373.056 480.009 373.056 480.009 373.056Z"
                            fill="#060606" />
                        <path
                            d="M480.034 426.816C480.003 426.723 481.888 427.019 484.995 425.778C486.498 425.126 488.305 424.043 489.74 422.195C490.456 421.283 491.098 420.202 491.519 418.957C491.931 417.714 492.132 416.319 492.021 414.856C491.913 413.395 491.479 411.867 490.658 410.428C489.843 408.986 488.602 407.664 487.044 406.618C485.495 405.557 483.562 404.864 481.492 404.617C480.457 404.51 479.382 404.528 478.284 404.533C477.188 404.534 476.072 404.535 474.936 404.537C465.851 404.546 455.506 404.557 444.072 404.569C398.326 404.586 335.143 404.609 265.359 404.634C263.226 404.665 261.082 405.153 259.27 406.191C257.431 407.183 255.94 408.667 254.908 410.367C252.882 413.798 253.011 418.211 255.296 421.453C256.386 423.096 257.99 424.418 259.802 425.325C261.641 426.206 263.693 426.653 265.764 426.598C269.948 426.599 274.099 426.599 278.213 426.6C294.67 426.604 310.542 426.608 325.663 426.612C355.904 426.63 383.137 426.646 406.009 426.66C428.874 426.69 447.378 426.713 460.175 426.73C466.564 426.748 471.526 426.763 474.902 426.772C476.579 426.781 477.86 426.789 478.732 426.794C479.592 426.801 480.034 426.816 480.034 426.816C480.034 426.816 479.592 426.831 478.729 426.839C477.858 426.844 476.577 426.852 474.899 426.861C471.524 426.87 466.561 426.885 460.172 426.903C447.375 426.92 428.871 426.943 406.006 426.973C383.134 426.987 355.901 427.003 325.661 427.021C310.54 427.025 294.666 427.029 278.211 427.034C274.096 427.034 269.946 427.035 265.762 427.035C263.643 427.093 261.482 426.629 259.578 425.713C257.692 424.771 256.026 423.395 254.891 421.689C252.514 418.315 252.376 413.728 254.486 410.156C255.56 408.387 257.11 406.846 259.023 405.812C260.908 404.734 263.14 404.223 265.357 404.192C335.141 404.217 398.324 404.24 444.07 404.257C455.505 404.268 465.848 404.279 474.935 404.289C476.07 404.291 477.186 404.292 478.282 404.293C479.375 404.292 480.456 404.275 481.52 404.389C483.631 404.646 485.601 405.36 487.176 406.447C488.759 407.518 490.016 408.868 490.839 410.338C491.668 411.805 492.102 413.36 492.205 414.844C492.311 416.329 492.099 417.744 491.674 419.002C491.24 420.262 490.584 421.353 489.853 422.273C488.389 424.134 486.555 425.214 485.034 425.859C483.485 426.499 482.191 426.668 481.339 426.771C480.476 426.816 480.034 426.816 480.034 426.816Z"
                            fill="#060606" />
                        <path
                            d="M355.12 340.352C355.12 340.724 332.252 341.024 304.05 341.024C275.838 341.024 252.976 340.722 252.976 340.352C252.976 339.982 275.838 339.68 304.05 339.68C332.252 339.68 355.12 339.98 355.12 340.352Z"
                            fill="#455A64" />
                        <path
                            d="M355.12 394.112C355.12 394.484 332.252 394.784 304.05 394.784C275.838 394.784 252.976 394.482 252.976 394.112C252.976 393.742 275.838 393.44 304.05 393.44C332.252 393.44 355.12 393.74 355.12 394.112Z"
                            fill="#455A64" />
                        <path d="M271.792 363.872H266.416V358.496H271.792V363.872Z" fill="#66B58F"
                            class="theme-color" />
                        <path d="M281.2 363.872H275.824V358.496H281.2V363.872Z" fill="#66B58F" class="theme-color" />
                        <path d="M290.608 363.872H285.232V358.496H290.608V363.872Z" fill="#66B58F"
                            class="theme-color" />
                        <path d="M300.016 363.872H294.64V358.496H300.016V363.872Z" fill="#66B58F" class="theme-color" />
                        <path d="M309.424 363.872H304.048V358.496H309.424V363.872Z" fill="#66B58F"
                            class="theme-color" />
                        <path d="M318.832 363.872H313.456V358.496H318.832V363.872Z" fill="#66B58F"
                            class="theme-color" />
                        <path d="M328.24 363.872H322.864V358.496H328.24V363.872Z" fill="#66B58F" class="theme-color" />
                        <path d="M337.648 363.872H332.272V358.496H337.648V363.872Z" fill="#66B58F"
                            class="theme-color" />
                        <path d="M347.056 363.872H341.68V358.496H347.056V363.872Z" fill="#66B58F" class="theme-color" />
                        <path d="M356.464 363.872H351.088V358.496H356.464V363.872Z" fill="#66B58F"
                            class="theme-color" />
                        <path d="M365.872 363.872H360.496V358.496H365.872V363.872Z" fill="#66B58F"
                            class="theme-color" />
                        <path d="M375.28 363.872H369.904V358.496H375.28V363.872Z" fill="#66B58F" class="theme-color" />
                        <path d="M384.688 363.872H379.312V358.496H384.688V363.872Z" fill="#66B58F"
                            class="theme-color" />
                        <path d="M394.096 363.872H388.72V358.496H394.096V363.872Z" fill="#66B58F" class="theme-color" />
                        <path d="M403.504 363.872H398.128V358.496H403.504V363.872Z" fill="#66B58F"
                            class="theme-color" />
                        <path d="M412.912 363.872H407.536V358.496H412.912V363.872Z" fill="#66B58F"
                            class="theme-color" />
                        <path d="M271.792 418.976H266.416V413.6H271.792V418.976Z" fill="#66B58F" class="theme-color" />
                        <path d="M281.2 418.976H275.824V413.6H281.2V418.976Z" fill="#66B58F" class="theme-color" />
                        <path d="M290.608 418.976H285.232V413.6H290.608V418.976Z" fill="#66B58F" class="theme-color" />
                        <path d="M300.016 418.976H294.64V413.6H300.016V418.976Z" fill="#66B58F" class="theme-color" />
                        <path d="M309.424 418.976H304.048V413.6H309.424V418.976Z" fill="#66B58F" class="theme-color" />
                        <path d="M318.832 418.976H313.456V413.6H318.832V418.976Z" fill="#66B58F" class="theme-color" />
                        <path d="M328.24 418.976H322.864V413.6H328.24V418.976Z" fill="#66B58F" class="theme-color" />
                        <path d="M337.648 418.976H332.272V413.6H337.648V418.976Z" fill="#66B58F" class="theme-color" />
                        <path
                            d="M185.576 587.518V608.287L227.456 608.084C227.152 603.873 204.167 595.47 204.167 595.47L204.624 587.518H185.576Z"
                            fill="#455A64" />
                        <g opacity="0.6">
                            <path
                                d="M192.35 593.59C191.547 593.836 191.004 594.804 191.203 595.665C191.403 596.525 192.328 597.12 193.135 596.889C193.942 596.658 194.628 595.517 194.339 594.686C194.05 593.855 192.927 593.22 192.196 593.649"
                                fill="white" />
                        </g>
                        <path
                            d="M185.576 608.287V604.97L225.561 605.443C225.561 605.443 227.646 606.698 227.456 608.085L185.576 608.287Z"
                            fill="#060606" />
                        <path
                            d="M204.166 595.871C204.163 596.087 203.147 596.2 202.156 596.908C201.147 597.589 200.645 598.529 200.457 598.447C200.269 598.408 200.554 597.115 201.768 596.28C202.974 595.435 204.208 595.673 204.166 595.871Z"
                            fill="#060606" />
                        <path
                            d="M209.653 597.793C209.702 598.001 208.826 598.381 208.149 599.303C207.445 600.203 207.285 601.192 207.082 601.185C206.891 601.222 206.733 599.962 207.596 598.833C208.451 597.696 209.646 597.588 209.653 597.793Z"
                            fill="#060606" />
                        <path
                            d="M212.122 603.086C211.938 603.135 211.639 602.062 212.145 600.875C212.643 599.683 213.595 599.203 213.684 599.381C213.801 599.557 213.193 600.199 212.792 601.181C212.369 602.152 212.323 603.062 212.122 603.086Z"
                            fill="#060606" />
                        <path
                            d="M203.76 589.966C203.678 590.164 202.74 589.88 201.591 589.98C200.44 590.056 199.551 590.478 199.443 590.295C199.323 590.141 200.185 589.33 201.54 589.232C202.893 589.123 203.857 589.795 203.76 589.966Z"
                            fill="#060606" />
                        <path
                            d="M203.992 596.801C204.023 596.806 204.129 596.358 204.082 595.532C204.022 594.718 203.773 593.5 202.973 592.258C202.569 591.646 202.039 591.033 201.335 590.534C200.995 590.296 200.464 590.034 199.921 590.286C199.412 590.53 199.125 591.099 199.096 591.654C199.149 593.791 200.684 595.763 202.776 596.513C204.922 597.264 207.191 596.337 208.433 594.833C208.737 594.45 209.031 594.061 209.184 593.551C209.255 593.302 209.289 593.007 209.19 592.72C209.095 592.438 208.871 592.213 208.621 592.119C208.115 591.946 207.686 592.098 207.316 592.248C206.952 592.423 206.64 592.603 206.341 592.803C205.153 593.594 204.395 594.509 203.947 595.173C203.497 595.842 203.341 596.269 203.37 596.285C203.464 596.381 204.237 594.645 206.559 593.186C207.119 592.865 207.854 592.403 208.446 592.609C208.706 592.716 208.809 593.021 208.685 593.385C208.575 593.743 208.307 594.106 208.027 594.443C206.894 595.772 204.844 596.579 202.963 595.912C201.105 595.287 199.703 593.398 199.647 591.691C199.657 591.296 199.861 590.933 200.14 590.792C200.408 590.649 200.76 590.769 201.073 590.977C201.716 591.408 202.235 591.964 202.632 592.519C203.424 593.649 203.727 594.785 203.853 595.562C203.967 596.347 203.942 596.798 203.992 596.801Z"
                            fill="#060606" />
                        <path
                            d="M170.27 590.526L170.98 595.868L170.506 607.923L154.804 608.306L154.245 595.868L156.031 588.481L170.27 590.526Z"
                            fill="#455A64" />
                        <path
                            d="M162.743 607.015C162.647 607.02 162.874 603.333 163.248 598.78C163.622 594.226 164.003 590.532 164.098 590.527C164.193 590.522 163.967 594.209 163.593 598.763C163.219 603.315 162.838 607.01 162.743 607.015Z"
                            fill="#060606" />
                        <path d="M170.568 605.916L154.705 606.1V608.306L170.579 608.287L170.568 605.916Z"
                            fill="#060606" />
                        <path
                            d="M154.744 598.986C154.72 598.968 154.855 598.736 155.146 598.35C155.437 597.964 155.899 597.433 156.546 596.853C157.193 596.275 158.033 595.647 159.082 595.151C160.121 594.646 161.388 594.29 162.742 594.303C165.458 594.307 167.742 595.636 168.867 596.962C169.451 597.616 169.811 598.231 170.017 598.67C170.219 599.112 170.294 599.37 170.267 599.381C170.181 599.429 169.802 598.4 168.623 597.194C167.481 595.983 165.314 594.786 162.737 594.779C160.168 594.765 158.051 596.063 156.765 597.111C155.449 598.18 154.81 599.04 154.744 598.986Z"
                            fill="#060606" />
                        <path
                            d="M162.675 254.168L162.509 308.454L185.799 309.565L186.472 296.361C186.472 296.361 194.744 298.004 196.878 290.321C198.242 285.413 197.901 247.487 197.901 247.487L162.675 254.168Z"
                            fill="#FFBE9D" />
                        <path
                            d="M200.966 251.309C197.298 252.359 196.501 258.355 196.501 258.355L190.747 271.064C187.816 268.769 183.88 268.901 183.135 274.052C182.597 277.774 187.225 278.527 187.225 278.527C184.531 283.112 182.703 286.82 178.781 291.181C174.536 295.901 172.157 296.376 167.553 296.453H162.476C162.476 296.453 159.991 288.386 155.389 268.211C150.283 245.829 176.75 248.712 181.657 242.999C189.646 233.693 212.53 247.999 200.966 251.309Z"
                            fill="#060606" />
                        <path
                            d="M207.43 246.447C207.051 244.064 204.768 242.07 202.359 242.222C203.222 241.012 202.81 239.193 201.7 238.205C200.59 237.216 198.976 236.96 197.507 237.182C196.037 237.404 194.67 238.049 193.327 238.686C193.086 237.55 191.649 235.669 190.628 235.114C188.58 234 187.296 234 186.135 234C178.989 233.999 175.221 238.897 171.387 243.882C170.729 244.738 170.077 245.693 169.069 246.081C168.39 246.343 167.639 246.309 166.911 246.323C161.468 246.429 156.2 249.705 153.697 254.54C151.194 259.375 149.327 270.566 155.801 277.503L159.705 286.216L197.037 256.636C197.302 256.774 199.642 257.915 201.443 256.968C205.913 254.615 204.038 250.691 204.038 250.691C204.394 250.506 207.809 248.83 207.43 246.447Z"
                            fill="#060606" />
                        <path
                            d="M172.876 275.54C173.027 275.524 173.257 277.408 172.743 279.662C172.242 281.92 171.226 283.522 171.097 283.443C170.941 283.365 171.688 281.702 172.168 279.532C172.663 277.367 172.702 275.544 172.876 275.54Z"
                            fill="#455A64" />
                        <path
                            d="M175.691 272.876C175.848 272.883 175.882 274.678 175.475 276.844C175.074 279.012 174.395 280.674 174.246 280.624C174.085 280.573 174.503 278.862 174.895 276.736C175.295 274.612 175.523 272.866 175.691 272.876Z"
                            fill="#455A64" />
                        <path
                            d="M183.759 263.917C183.815 263.995 183.155 264.476 182.318 265.457C181.473 266.428 180.512 267.947 179.808 269.789C179.103 271.632 178.716 273.398 178.417 274.671C178.124 275.948 177.923 276.739 177.84 276.724C177.762 276.711 177.818 275.898 178.007 274.594C178.204 273.294 178.53 271.483 179.258 269.577C179.985 267.671 181.053 266.11 182.012 265.174C182.966 264.225 183.726 263.859 183.759 263.917Z"
                            fill="#455A64" />
                        <path
                            d="M187.02 257.817C187.088 257.798 187.327 258.342 187.472 259.286C187.62 260.225 187.624 261.571 187.27 262.992C186.911 264.413 186.273 265.597 185.7 266.356C185.127 267.12 184.66 267.487 184.609 267.438C184.463 267.326 186.039 265.574 186.698 262.848C187.402 260.136 186.84 257.847 187.02 257.817Z"
                            fill="#455A64" />
                        <path
                            d="M159.224 271.375C159.145 271.517 158.431 271.27 157.631 270.823C156.831 270.376 156.246 269.898 156.326 269.756C156.405 269.614 157.118 269.861 157.919 270.308C158.719 270.755 159.304 271.233 159.224 271.375Z"
                            fill="#455A64" />
                        <path
                            d="M170.476 265.579C170.63 265.601 170.535 266.752 169.811 267.94C169.095 269.134 168.121 269.754 168.03 269.628C167.919 269.498 168.651 268.732 169.306 267.635C169.973 266.546 170.31 265.542 170.476 265.579Z"
                            fill="#455A64" />
                        <path
                            d="M173.936 263.721C174.086 263.754 173.842 265.133 172.9 266.543C171.967 267.96 170.792 268.72 170.702 268.595C170.592 268.463 171.534 267.548 172.408 266.217C173.295 264.895 173.772 263.671 173.936 263.721Z"
                            fill="#455A64" />
                        <path
                            d="M191.134 240.986C191.093 241.033 190.697 240.654 189.857 240.176C189.017 239.714 187.675 239.21 185.955 239.167C184.251 239.114 182.159 239.52 180.23 240.705C178.3 241.889 176.593 243.818 175.354 246.137C174.451 247.822 173.826 249.577 173.375 251.227L173.282 251.568L172.969 251.404C171.24 250.496 169.408 250.097 167.773 250.075C166.131 250.03 164.686 250.331 163.543 250.714C161.241 251.5 160.149 252.535 160.09 252.441C160.072 252.42 160.331 252.161 160.869 251.751C161.411 251.348 162.26 250.825 163.424 250.379C164.585 249.938 166.071 249.581 167.779 249.591C169.48 249.578 171.403 249.963 173.235 250.905L172.829 251.082C173.273 249.395 173.904 247.595 174.835 245.857C176.114 243.465 177.903 241.46 179.95 240.24C182.001 239.017 184.197 238.641 185.974 238.75C187.768 238.849 189.146 239.441 189.976 239.979C190.385 240.265 190.692 240.496 190.871 240.689C191.057 240.87 191.148 240.971 191.134 240.986Z"
                            fill="#455A64" />
                        <path
                            d="M203.381 243.94C203.339 243.929 204.029 243.766 204.717 244.546C205.032 244.922 205.321 245.514 205.253 246.246C205.182 246.976 204.678 247.729 203.899 248.18C203.133 248.649 202.084 248.806 201.07 248.569C200.05 248.347 199.069 247.806 198.151 247.154C197.225 246.507 196.336 245.754 195.296 245.198C194.258 244.634 193.089 244.223 191.855 243.988C189.376 243.526 186.913 243.805 184.833 244.469C182.741 245.14 181.004 246.147 179.642 247.107C176.923 249.062 175.582 250.698 175.499 250.614C175.472 250.59 175.783 250.168 176.42 249.467C177.064 248.774 178.036 247.795 179.397 246.771C180.753 245.75 182.512 244.676 184.665 243.953C186.811 243.236 189.37 242.926 191.964 243.409C193.256 243.655 194.484 244.091 195.574 244.692C196.675 245.292 197.575 246.073 198.466 246.712C199.351 247.359 200.258 247.872 201.179 248.093C202.096 248.325 202.999 248.209 203.692 247.819C204.388 247.447 204.839 246.81 204.926 246.206C205.014 245.593 204.794 245.044 204.537 244.689C203.984 243.947 203.351 244.006 203.381 243.94Z"
                            fill="#455A64" />
                        <path
                            d="M311.887 285.591C311.008 284.81 299.148 289.786 299.148 289.786C299.148 289.786 290.299 296.727 286.656 300.828L284.406 302.699L250.749 328.873L209.348 311.65L200.366 334.747C200.366 334.747 246.844 353.249 253.925 350.081C261.621 346.638 290.27 316.654 290.337 316.551L290.338 316.55L294.475 312.564C294.475 312.564 296.664 312.521 298.323 312.423C299.982 312.325 304.842 309.096 304.842 309.096C304.842 309.096 305.544 307.833 305.784 306.265C306.024 304.697 304.885 304.209 304.885 304.209C304.885 304.209 305.158 303.194 304.969 301.873C304.78 300.552 303.015 299.019 303.015 299.019C303.015 299.019 303.712 298.45 304.121 296.928C304.53 295.405 302.558 293.968 302.558 293.968C302.558 293.968 309.441 289.287 311.113 288.466C312.785 287.647 312.766 286.371 311.887 285.591Z"
                            fill="#FFBE9D" />
                        <path
                            d="M215.436 522.124C215.574 520.604 215.65 519.436 215.65 518.704L220.325 444.07C220.325 444.07 216.395 422.275 214.537 416.491L197.824 410.022L175.561 418.694C175.413 416.897 175.323 415.795 175.323 415.795L142.529 427.13C142.529 427.13 141.68 449.502 142.529 456.312C142.801 458.499 143.66 464.151 144.699 470.81C144.699 470.81 145.755 485.282 145.972 486.09C146.767 489.04 146.951 496.266 146.951 503.507C146.951 512.709 147.451 523.658 148.025 528.864C148.599 534.069 148.878 591.303 148.878 591.303H173.075L176.182 500.137C176.703 490.367 177.486 475.427 177.988 464.619L183.671 498.28C183.671 499.514 187.129 518.759 187.129 518.759C187.129 518.759 185.863 527.788 185.646 537.02C185.247 553.987 183.252 591.303 183.252 591.303H206.939C206.939 591.303 214.052 537.417 215.436 522.124Z"
                            fill="#060606" />
                        <path
                            d="M219.512 439.598C219.481 439.652 218.622 439.254 217.329 438.434C216.037 437.617 214.332 436.349 212.649 434.724C210.969 433.095 209.645 431.432 208.786 430.168C207.925 428.903 207.498 428.057 207.551 428.025C207.618 427.983 208.152 428.758 209.078 429.955C210.003 431.152 211.349 432.752 213.004 434.357C214.662 435.957 216.305 437.25 217.531 438.135C218.759 439.022 219.551 439.53 219.512 439.598Z"
                            fill="#455A64" />
                        <path
                            d="M177.276 453.161C177.244 453.177 177.081 452.912 176.812 452.417C176.538 451.925 176.187 451.189 175.793 450.262C175.004 448.41 174.122 445.749 173.589 442.714C173.063 439.676 172.993 436.874 173.11 434.864C173.166 433.859 173.248 433.047 173.34 432.492C173.426 431.936 173.49 431.631 173.525 431.635C173.608 431.644 173.493 432.88 173.472 434.875C173.449 436.869 173.575 439.629 174.094 442.626C174.62 445.621 175.434 448.26 176.13 450.129C176.824 452 177.351 453.124 177.276 453.161Z"
                            fill="#455A64" />
                        <path
                            d="M180.797 481.262C180.76 481.268 180.652 480.805 180.486 479.963C180.312 479.014 180.092 477.817 179.831 476.392C179.304 473.259 178.611 469.138 177.845 464.582C176.507 456.21 175.596 450.51 175.173 447.859C175.284 447.817 175.753 449.686 176.317 452.692C176.894 455.704 177.62 459.878 178.375 464.495C179.129 469.111 179.77 473.297 180.206 476.332C180.4 477.768 180.563 478.974 180.693 479.931C180.794 480.783 180.834 481.256 180.797 481.262Z"
                            fill="#455A64" />
                        <path
                            d="M123.69 356.779C123.69 356.779 120.493 379.273 119.896 387.155C119.537 391.9 124.356 398.2 128.034 398.661C131.771 399.129 144.117 399.859 144.117 399.859L145.146 385.752L144.825 382.947L140.975 382.222L142.135 359.847L123.69 356.779Z"
                            fill="#FFBE9D" />
                        <path
                            d="M141.628 360.603C141.665 360.602 141.714 361.036 141.771 361.825C141.83 362.613 141.88 363.756 141.908 365.169C141.972 367.995 141.907 371.902 141.665 376.206C141.423 380.511 141.08 384.398 140.8 387.208C140.66 388.613 140.534 389.748 140.434 390.532C140.335 391.316 140.262 391.747 140.225 391.744C140.188 391.741 140.19 391.303 140.226 390.514C140.279 389.614 140.344 388.498 140.422 387.177C140.611 384.242 140.857 380.413 141.129 376.177C141.371 371.882 141.496 367.99 141.529 365.171C141.542 363.849 141.553 362.732 141.562 361.832C141.57 361.042 141.592 360.604 141.628 360.603Z"
                            fill="#AA6550" />
                        <g opacity="0.3">
                            <path
                                d="M142.842 427.538C149.142 429.878 156.046 430.075 162.741 429.489C169.436 428.903 176.046 427.565 182.737 426.93C192.852 425.97 203.12 426.635 213.028 428.891C213.73 429.051 214.454 429.219 215.163 429.094C215.872 428.969 216.568 428.466 216.679 427.754C216.852 426.636 215.628 425.856 214.585 425.417C191.814 415.838 164.977 416.438 142.656 427.025"
                                fill="#060606" />
                        </g>
                        <path
                            d="M239.302 321.873L203.788 304.19C194.454 303.1 186.906 303.452 186.906 303.452H163.399C163.399 303.452 134.911 311.854 130.21 319.598L118 356.2L142.135 359.846L145.146 386.141C145.146 386.141 142.151 416.59 142.151 421.015C142.151 425.44 142.528 427.13 142.528 427.13C142.528 427.13 190.821 419.787 202.713 423.659C214.605 427.531 217.819 427.13 217.819 427.13C217.819 427.13 216.825 414.491 215.943 407.159L213.186 370.466L211.15 342.449L233.5 349.289L239.302 321.873Z"
                            fill="#FFA21D" />
                        <path
                            d="M141.914 360.133C141.826 360.143 141.589 358.619 141.053 356.186C140.515 353.754 139.626 350.42 138.259 346.849C136.891 343.277 135.326 340.156 134.116 337.933C133.542 336.901 133.055 336.024 132.658 335.309C132.31 334.691 132.132 334.34 132.165 334.322C132.198 334.305 132.437 334.622 132.844 335.213C133.254 335.801 133.81 336.674 134.461 337.77C135.765 339.961 137.398 343.083 138.777 346.684C140.156 350.284 140.992 353.661 141.435 356.121C141.655 357.352 141.8 358.353 141.863 359.048C141.931 359.743 141.951 360.129 141.914 360.133Z"
                            fill="#060606" />
                        <path
                            d="M187.465 370.526C187.482 370.532 187.438 370.698 187.34 371.009C187.218 371.374 187.068 371.821 186.887 372.362C186.69 372.95 186.436 373.664 186.104 374.479C185.777 375.296 185.427 376.237 184.966 377.245C184.097 379.285 182.94 381.661 181.543 384.24C180.121 386.804 178.444 389.563 176.512 392.343C174.562 395.112 172.545 397.633 170.622 399.848C168.678 402.044 166.841 403.945 165.223 405.46C164.434 406.239 163.67 406.889 163.014 407.477C162.362 408.068 161.778 408.552 161.293 408.938C160.847 409.293 160.478 409.587 160.177 409.826C159.918 410.025 159.777 410.122 159.766 410.109C159.755 410.096 159.874 409.971 160.111 409.747C160.395 409.488 160.742 409.171 161.163 408.787C161.627 408.378 162.19 407.874 162.822 407.265C163.457 406.659 164.201 405.993 164.971 405.2C166.551 403.657 168.351 401.74 170.266 399.538C172.159 397.318 174.153 394.802 176.093 392.049C178.015 389.284 179.694 386.55 181.131 384.011C182.543 381.458 183.728 379.11 184.636 377.098C185.116 376.103 185.488 375.176 185.839 374.372C186.195 373.569 186.476 372.868 186.701 372.292C186.918 371.765 187.096 371.33 187.243 370.975C187.372 370.675 187.448 370.52 187.465 370.526Z"
                            fill="#060606" />
                        <path
                            d="M203.874 306.615C203.977 306.663 202.546 308.081 202.003 311.071C201.726 312.546 201.72 314.352 202.036 316.32C202.34 318.289 202.934 320.421 203.537 322.661C204.762 327.137 206.06 331.135 207.045 334.013C207.515 335.372 207.909 336.513 208.223 337.419C208.501 338.224 208.641 338.675 208.607 338.689C208.573 338.703 208.367 338.278 208.029 337.495C207.693 336.711 207.228 335.568 206.689 334.142C205.611 331.29 204.251 327.296 203.021 322.804C202.417 320.559 201.833 318.412 201.549 316.394C201.252 314.382 201.298 312.51 201.633 310.998C201.956 309.481 202.529 308.341 203.008 307.628C203.493 306.914 203.854 306.596 203.874 306.615Z"
                            fill="#060606" />
                        <path
                            d="M136.853 345.145C136.889 345.185 136.256 345.821 134.96 346.43C133.683 347.04 131.68 347.543 129.496 347.212C127.311 346.879 125.548 345.803 124.51 344.84C123.454 343.873 123.039 343.077 123.086 343.05C123.156 342.995 123.673 343.701 124.749 344.559C125.811 345.416 127.51 346.381 129.574 346.696C131.638 347.009 133.547 346.594 134.816 346.091C136.099 345.592 136.802 345.071 136.853 345.145Z"
                            fill="white" />
                        <path
                            d="M204.93 328.632C204.946 328.639 204.843 328.904 204.631 329.401C204.416 329.897 204.073 330.618 203.583 331.523C202.587 333.313 200.969 335.864 198.302 338.43C195.656 340.971 191.841 343.499 187.031 344.564C184.644 345.097 182.034 345.284 179.387 344.892C176.73 344.533 174.113 343.499 171.652 342.143C166.741 339.4 162.596 335.929 158.055 334.271C153.552 332.542 149.024 332.742 145.517 333.58C141.968 334.432 139.378 335.975 137.727 337.151C136.087 338.367 135.319 339.213 135.273 339.165C135.273 339.165 135.986 338.267 137.605 336.989C139.234 335.752 141.831 334.136 145.427 333.223C148.978 332.326 153.598 332.077 158.222 333.823C162.872 335.498 167.056 338.986 171.901 341.687C174.331 343.025 176.875 344.031 179.459 344.388C182.036 344.776 184.587 344.605 186.926 344.096C191.641 343.079 195.405 340.636 198.048 338.162C200.711 335.666 202.362 333.171 203.405 331.423C203.919 330.54 204.29 329.836 204.534 329.356C204.779 328.875 204.914 328.625 204.93 328.632Z"
                            fill="white" />
                        <path
                            d="M227.163 315.807C227.19 315.796 227.378 316.197 227.625 316.958C227.864 317.72 228.122 318.86 228.201 320.295C228.27 321.725 228.17 323.46 227.644 325.294C227.137 327.127 226.225 329.063 224.834 330.778C223.437 332.502 221.741 333.734 220.377 334.993C218.982 336.228 217.929 337.531 217.352 338.804C216.76 340.066 216.626 341.215 216.689 341.987C216.749 342.764 216.914 343.179 216.866 343.195C216.849 343.201 216.799 343.103 216.718 342.907C216.639 342.711 216.544 342.409 216.487 342.008C216.358 341.212 216.44 339.991 217.015 338.654C217.569 337.309 218.653 335.911 220.051 334.64C221.423 333.341 223.091 332.105 224.429 330.449C227.147 327.115 227.912 323.074 227.832 320.308C227.766 317.49 227.05 315.835 227.163 315.807Z"
                            fill="white" />
                        <path
                            d="M169.4 400.115C169.408 400.148 169.04 400.284 168.358 400.478C167.676 400.669 166.68 400.928 165.415 401.107C164.158 401.258 162.586 401.372 160.927 400.845C160.104 400.585 159.285 400.139 158.573 399.52C157.865 398.898 157.273 398.144 156.653 397.419C156.038 396.687 155.376 396.063 154.644 395.565C153.909 395.075 153.124 394.72 152.352 394.466C150.799 393.954 149.291 393.914 148.065 394.055C146.831 394.198 145.873 394.558 145.243 394.85C144.607 395.139 144.275 395.349 144.248 395.308C144.234 395.289 144.528 395.021 145.151 394.669C145.768 394.314 146.738 393.887 148.013 393.69C149.28 393.496 150.857 393.497 152.496 394.008C153.312 394.263 154.143 394.626 154.927 395.14C155.705 395.658 156.425 396.336 157.049 397.08C157.679 397.819 158.254 398.553 158.911 399.138C159.567 399.716 160.313 400.134 161.078 400.389C162.617 400.908 164.138 400.845 165.374 400.741C167.861 400.453 169.379 400.017 169.4 400.115Z"
                            fill="white" />
                        <path
                            d="M215.386 397.978C215.396 397.993 215.288 398.085 215.07 398.248C214.847 398.403 214.538 398.666 214.084 398.915C213.208 399.464 211.843 400.131 210.042 400.606C208.245 401.049 206 401.333 203.552 400.981C201.107 400.686 198.478 399.703 196.176 398.022C193.881 396.333 192.069 394.337 190.277 392.717C188.509 391.07 186.712 389.827 185.04 389.109C183.378 388.368 181.892 388.174 180.881 388.189C179.865 388.206 179.309 388.358 179.298 388.306C179.294 388.289 179.428 388.243 179.692 388.171C179.954 388.094 180.353 388.023 180.873 387.986C181.906 387.907 183.455 388.051 185.183 388.77C186.917 389.461 188.792 390.715 190.598 392.361C192.427 393.981 194.246 395.957 196.482 397.601C198.718 399.231 201.241 400.191 203.618 400.505C205.993 400.873 208.184 400.635 209.953 400.248C211.725 399.829 213.088 399.226 213.983 398.738C214.887 398.26 215.358 397.936 215.386 397.978Z"
                            fill="white" />
                        <rect class="theme-color" x="281" y="450" width="183" height="29" rx="14.5" fill="#0CAF60" />
                        <rect x="329" y="460" width="88" height="9" rx="4.5" fill="white" />
                        <path
                            d="M463.752 252.585C456.788 249.267 450.762 243.823 446.762 236.567C441.837 227.63 440.687 217.309 443.523 207.507C446.36 197.704 452.845 189.593 461.782 184.668C480.232 174.5 503.514 181.238 513.683 199.689C518.608 208.626 519.758 218.947 516.921 228.749C514.084 238.551 507.6 246.663 498.662 251.588C487.469 257.756 474.494 257.702 463.752 252.585ZM495.591 185.978C485.566 181.203 473.463 181.152 463.018 186.908C454.68 191.503 448.629 199.072 445.982 208.217C443.334 217.363 444.408 226.993 449.004 235.332C453.599 243.672 461.167 249.721 470.314 252.368C479.459 255.015 489.089 253.942 497.428 249.346C505.767 244.751 511.817 237.183 514.465 228.037C517.112 218.891 516.039 209.262 511.443 200.922C507.712 194.154 502.088 189.073 495.591 185.978Z"
                            fill="#060606" />
                        <path
                            d="M528.211 294.342C525.979 295.719 523.054 295.026 521.677 292.794L496.694 252.31C496.458 251.927 496.576 251.424 496.96 251.188L502.289 247.9C502.664 247.669 503.153 247.777 503.396 248.143L529.673 287.672C531.159 289.909 530.497 292.932 528.211 294.342Z"
                            fill="#060606" />
                        <path
                            d="M464.67 250.656C457.706 247.339 451.679 241.895 447.68 234.638C442.755 225.702 441.605 215.381 444.441 205.578C447.278 195.775 453.763 187.664 462.7 182.739C481.149 172.57 504.432 179.309 514.601 197.76C519.526 206.697 520.676 217.018 517.839 226.82C515.002 236.622 508.518 244.733 499.58 249.659C488.387 255.828 475.412 255.774 464.67 250.656ZM496.509 184.051C486.484 179.275 474.381 179.225 463.936 184.98C455.597 189.575 449.547 197.144 446.9 206.289C444.252 215.435 445.326 225.065 449.922 233.404C454.517 241.744 462.085 247.794 471.232 250.44C480.377 253.087 490.007 252.015 498.346 247.419C506.685 242.824 512.735 235.256 515.382 226.109C518.03 216.963 516.957 207.334 512.361 198.995C508.63 192.225 503.006 187.145 496.509 184.051Z"
                            fill="#455A64" />
                        <path
                            d="M529.239 293.709L528.853 293.948C527.11 295.022 524.827 294.482 523.752 292.739L497.185 249.688L503.878 245.557L530.446 288.609C531.521 290.351 530.98 292.635 529.239 293.709Z"
                            fill="#455A64" />
                        <path
                            d="M452.622 207.125C452.597 207.12 452.673 206.702 452.834 205.946C452.908 205.566 453.013 205.105 453.187 204.584C453.353 204.061 453.509 203.452 453.784 202.816C453.912 202.492 454.045 202.155 454.184 201.806C454.327 201.456 454.514 201.109 454.687 200.741C455.02 199.996 455.475 199.254 455.934 198.461C456.912 196.913 458.126 195.296 459.592 193.77C461.078 192.262 462.662 191.004 464.183 189.985C464.963 189.504 465.693 189.029 466.429 188.676C466.792 188.493 467.133 188.296 467.479 188.144C467.825 187.996 468.158 187.853 468.478 187.716C469.106 187.425 469.711 187.252 470.229 187.072C470.745 186.885 471.203 186.767 471.581 186.683C472.332 186.502 472.749 186.414 472.754 186.439C472.76 186.463 472.354 186.598 471.619 186.82C471.249 186.924 470.801 187.061 470.294 187.266C469.786 187.464 469.195 187.651 468.579 187.955C468.266 188.097 467.939 188.245 467.6 188.399C467.261 188.556 466.927 188.757 466.571 188.944C465.85 189.305 465.135 189.784 464.369 190.266C462.877 191.288 461.32 192.537 459.853 194.025C458.406 195.532 457.2 197.122 456.218 198.641C455.758 199.419 455.297 200.147 454.957 200.877C454.78 201.238 454.588 201.578 454.44 201.921C454.295 202.264 454.156 202.594 454.023 202.911C453.736 203.535 453.565 204.132 453.381 204.645C453.19 205.157 453.066 205.609 452.971 205.981C452.77 206.722 452.646 207.131 452.622 207.125Z"
                            fill="#E0E0E0" />
                    </svg>

                </div>

            </div>
            <div class="col-lg-6 col-12">
                <div class="login-form-wrp">
                    <h2 class="mb-4 text-center"><?php echo e(__('Search Ticket')); ?></h2>
                    <div class="login-form">
                        <form action="<?php echo e(route('ticket.search')); ?>" method="POST"
                            class="needs-validation create-form mb-3" novalidate>
                            <?php echo csrf_field(); ?>
                            <?php if(session()->has('info')): ?>
                            <div class="alert alert-success">
                                <?php echo e(session()->get('info')); ?>

                            </div>
                            <?php endif; ?>
                            <?php if(session()->has('status')): ?>
                            <div class="alert alert-info">
                                <?php echo e(session()->get('status')); ?>

                            </div>
                            <?php endif; ?>
                            <div class="text-start row">
                                <div class="col-12 form-group mb-3">
                                    <label for="ticket_id" class="form-label"><?php echo e(__('Ticket Number')); ?></label>
                                    <?php if (isset($component)) { $__componentOriginaleab1765d328ab3f8835fc5d78676a070 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaleab1765d328ab3f8835fc5d78676a070 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.required','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('required'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $attributes = $__attributesOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $component = $__componentOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__componentOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
                                    <input type="text"
                                        class="form-control <?php echo e($errors->has('ticket_id') ? 'is-invalid' : ''); ?>" min="0"
                                        id="ticket_id" name="ticket_id" placeholder="<?php echo e(__('Enter Ticket Number')); ?>"
                                        required="" value="<?php echo e(old('ticket_id')); ?>" autofocus>
                                    <div class="invalid-feedback d-block">
                                        <?php echo e($errors->first('ticket_id')); ?>

                                    </div>
                                </div>
                                <div class="col-12 form-group mb-3">
                                    <label for="email" class="form-label"><?php echo e(__('Email')); ?></label>
                                    <?php if (isset($component)) { $__componentOriginaleab1765d328ab3f8835fc5d78676a070 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaleab1765d328ab3f8835fc5d78676a070 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.required','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('required'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $attributes = $__attributesOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__attributesOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaleab1765d328ab3f8835fc5d78676a070)): ?>
<?php $component = $__componentOriginaleab1765d328ab3f8835fc5d78676a070; ?>
<?php unset($__componentOriginaleab1765d328ab3f8835fc5d78676a070); ?>
<?php endif; ?>
                                    <input type="email"
                                        class="form-control <?php echo e($errors->has('email') ? 'is-invalid' : ''); ?>" id="email"
                                        name="email" placeholder="<?php echo e(__('Email address')); ?>" required
                                        value="<?php echo e(old('email')); ?>">
                                    <div class="invalid-feedback d-block">
                                        <?php echo e($errors->first('email')); ?>

                                    </div>
                                </div>
                                <div class="col-12 text-center mt-1">
                                    <button class="btn btn-primary login-do-btn"
                                        id="login_button"><?php echo e(__('Search Ticket')); ?></button>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
        <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
</div>





<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/phoxag/dash.phoxago.com/resources/views/search.blade.php ENDPATH**/ ?>