<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Manage FAQ')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('FAQ')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css-page'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/summernote/summernote-bs4.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('multiple-action-button'); ?>
    <?php if (app('laratrust')->hasPermission('faq create')) : ?>
        <a href="#" class="btn btn-sm btn-primary btn-icon" title="<?php echo e(__('Create FAQ')); ?>" data-bs-toggle="tooltip"
            data-bs-placement="top" data-ajax-popup="true" data-title="<?php echo e(__('Create FAQ')); ?>"
            data-url="<?php echo e(route('admin.faq.create')); ?>" data-size="lg"><i class="ti ti-plus"></i></a>
    <?php endif; // app('laratrust')->permission ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <div class="card faq-page-tabel">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="pc-dt-simple" class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th class="w-25"><?php echo e(__('Title')); ?></th>
                                    <th><?php echo e(__('Description')); ?></th>
                                    <?php if(Laratrust::hasPermission('faq show') || Laratrust::hasPermission('faq edit') || Laratrust::hasPermission('faq delete')): ?>
                                        
                                    <?php endif; ?>
                                    <th class="text-end me-3"><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <th scope="row"><?php echo e(++$index); ?></th>
                                        <td><span class="font-weight-bold white-space"><?php echo e($faq->title); ?></span></td>
                                        <td class="faq_desc"><p><?php echo $faq->description; ?></p></td>
                                        <td class="text-end">
                                            <?php if (app('laratrust')->hasPermission('faq show')) : ?>
                                                    <div class="action-btn me-2">
                                                        <a href="#" class="btn btn-sm btn-icon bg-warning text-white"
                                                            title="<?php echo e(__('Show FAQ')); ?>" data-bs-toggle="tooltip"
                                                            data-bs-placement="top" data-ajax-popup="true"
                                                            data-title="<?php echo e(__('Show FAQ')); ?>"
                                                            data-url="<?php echo e(route('admin.show.faq', $faq->id)); ?>" data-size="lg"><i class="ti ti-eye"></i></a>
                                                    </div>
                                            <?php endif; // app('laratrust')->permission ?>
                                            <?php if (app('laratrust')->hasPermission('faq edit')) : ?>
                                                <div class="action-btn me-2">
                                                    <a href="#" class="btn btn-sm btn-icon bg-info text-white"
                                                        title="<?php echo e(__('Edit FAQ')); ?>" data-bs-toggle="tooltip"
                                                        data-bs-placement="top" data-ajax-popup="true"
                                                        data-title="<?php echo e(__('Edit FAQ')); ?>"
                                                        data-url="<?php echo e(route('admin.faq.edit', $faq->id)); ?>" data-size="lg"><i class="ti ti-pencil"></i></a>
                                                </div>
                                            <?php endif; // app('laratrust')->permission ?>
                                            <?php if (app('laratrust')->hasPermission('faq delete')) : ?>
                                                <div class="action-btn ">
                                                    <form method="POST" action="<?php echo e(route('admin.faq.destroy', $faq->id)); ?>"
                                                        id="user-form-<?php echo e($faq->id); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <input name="_method" type="hidden" value="DELETE">
                                                        <a class="mx-3 bg-danger btn btn-sm  align-items-center bs-pass-para show_confirm"
                                                            data-bs-toggle="tooltip" title=""
                                                            data-bs-original-title="Delete" aria-label="Delete"
                                                            data-confirm="<?php echo e(__('Are You Sure?')); ?>"
                                                            data-text="<?php echo e(__('This action can not be undone. Do you want to continue?')); ?>"
                                                            data-confirm-yes="delete-form-<?php echo e($faq->id); ?>"><i
                                                                class="ti ti-trash text-white text-white"></i></a>
                                                    </form>
                                                </div>
                                            <?php endif; // app('laratrust')->permission ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('css/summernote/summernote-bs4.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/phoxag/dash.phoxago.com/resources/views/admin/faq/index.blade.php ENDPATH**/ ?>