<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Manage Custom Field')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('Custom Field')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('multiple-action-button'); ?>
    <?php if (app('laratrust')->hasPermission('user create')) : ?>
        <a href="#" class="btn btn-sm btn-primary btn-icon" title="<?php echo e(__('Create')); ?>" data-bs-toggle="tooltip"
            data-bs-placement="top" data-ajax-popup="true" data-title="<?php echo e(__('Create Custom Field')); ?>"
            data-url="<?php echo e(route('admin.custom-field.create')); ?>" data-size="md"><i class="ti ti-plus"></i></a>
    <?php endif; // app('laratrust')->permission ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table id="pc-dt-simple" class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th scope="col">#</th>
                                    <th><?php echo e(__('Labels')); ?></th>
                                    <th><?php echo e(__('Placeholder')); ?></th>
                                    <th><?php echo e(__('Type')); ?></th>
                                    <th><?php echo e(__('Require')); ?></th>
                                    <th><?php echo e(__('Width')); ?></th>
                                    <th class="text-end me-3"><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody class="sortable">
                                <?php $__currentLoopData = $customFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $customField): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr data-id="<?php echo e($customField->id); ?>">
                                        <td scope="row">
                                            <i class="ti ti-arrows-maximize sort-handler ui-sortable-handle"></i>
                                        </td>
                                        <td><?php echo e($customField->name); ?></td>
                                        <td><?php echo e($customField->placeholder); ?></td>
                                        <td><?php echo e($customField->type); ?></td>
                                        <?php if($customField->is_required == 1): ?>
                                            <td><span
                                                    class="badge bg-success p-2 px-3 status-badge7"><?php echo e(__('Required')); ?></span>
                                            </td>
                                        <?php else: ?>
                                            <td><span
                                                    class="badge bg-danger p-2 px-3 status-badge7"><?php echo e(__('Not Required')); ?></span>
                                            </td>
                                        <?php endif; ?>
                                        <td><?php echo e($customField->width); ?></td>
                                        <td class="text-end me-3">
                                            <?php if (app('laratrust')->hasPermission('faq edit')) : ?>
                                                <div class="action-btn me-2">
                                                    <a href="#" class="btn btn-sm btn-icon bg-info text-white"
                                                        title="<?php echo e(__('Edit Custom Field')); ?>" data-bs-toggle="tooltip"
                                                        data-bs-placement="top" data-ajax-popup="true"
                                                        data-title="<?php echo e(__('Edit Custom Field')); ?>"
                                                        data-url="<?php echo e(route('admin.custom-field.edit', $customField->id)); ?>"
                                                        data-size="md"><i class="ti ti-pencil"></i></a>
                                                </div>
                                            <?php endif; // app('laratrust')->permission ?>
                                            <?php if (app('laratrust')->hasPermission('user delete')) : ?>
                                                <?php if($customField->id > 6): ?>
                                                    <div class="action-btn me-2">
                                                        <form method="POST"
                                                            action="<?php echo e(route('admin.custom-field.destroy', $customField->id)); ?>"
                                                            id="delete-form-<?php echo e($customField->id); ?>">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('DELETE'); ?>
                                                            <input name="_method" type="hidden" value="DELETE">

                                                            <a class="mx-3 bg-danger btn btn-sm  align-items-center bs-pass-para show_confirm"
                                                                data-bs-toggle="tooltip" title=""
                                                                data-bs-original-title="Delete" aria-label="Delete"
                                                                data-confirm="<?php echo e(__('Are You Sure?')); ?>"
                                                                data-text="<?php echo e(__('This action can not be undone. Do you want to continue?')); ?>"
                                                                data-confirm-yes="delete-form-<?php echo e($customField->id); ?>"><i
                                                                    class="ti ti-trash text-white text-white"></i></a>
                                                        </form>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endif; // app('laratrust')->permission ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <div class="note mt-2 d-flex">
                            <p class="mb-0"><b>Note : </b></p> <span class="text-danger ms-2"> You Can Drag & Drop the Custom
                                Fields.</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('js/jquery-ui.min.js')); ?>"></script>
    <script>
        $(function() {
            $(".sortable").sortable();
            $(".sortable").disableSelection();
            $(".sortable").sortable({
                items: "tr", // Only make table rows draggable
                handle: "td", // Only allow dragging from the handle icon
                helper: function(e, ui) {
                    ui.children().each(function() {
                        $(this).width($(this).width()); // Preserve width of each cell
                    });
                    return ui;
                },
                placeholder: "sortable-placeholder",
                stop: function() {
                    var order = [];
                    $(this).find('tr').each(function(index, data) {
                        order[index] = $(data).attr('data-id');
                    });

                    $.ajax({
                        url: "<?php echo e(route('admin.custom-field.order')); ?>",
                        data: {
                            order: order,
                            _token: $('meta[name="csrf-token"]').attr('content')
                        },
                        type: 'POST',
                        success: function(data) {
                            show_toastr('<?php echo e(__('Success')); ?>', data.message, 'success');
                        },
                        error: function(data) {
                            data = data.responseJSON;
                            show_toastr('<?php echo e(__('Error')); ?>', data.message, 'error');
                        }
                    })
                }
            });
        });
    </script>
    <script src="<?php echo e(asset('js/repeater.js')); ?>"></script>

    <script>
        $(document).on('click', '.field_type', function() {
            var type = $(this).val();
            if (type == 'select' || type == 'checkbox' || type == 'radio') {
                $('.repeater').removeClass('d-none');
                $('.repeater .field_value').attr('required', 'required');
            } else {
                $('.repeater').addClass('d-none');
                $('.repeater .field_value').removeAttr('required');
            }
        });
    </script>

    <script>
        $('#commonModal').on('shown.bs.modal', function() {
            var selector = "body";

            if ($(selector + " .repeater").length) {
                var $dragAndDrop = $("body .repeater .repeater-field").sortable({
                    handle: '.sort-handler'
                });
                var $repeater = $(selector + ' .repeater').repeater({
                    initEmpty: false,
                    defaultValues: {
                        'status': 1
                    },
                    show: function() {
                        $(this).slideDown();
                        $(this).find('.add-row').remove();
                    },
                    hide: function(deleteElement) {
                        $(this).remove();
                    },
                    ready: function(setIndexes) {
                        $dragAndDrop.on('drop', setIndexes);
                    },
                    isFirstItemUndeletable: true
                });

                var value = $(selector + " .repeater").attr('data-value');
                if (typeof value != 'undefined' && value.length != 0) {
                    value = JSON.parse(value);
                    $repeater.setList(value);
                }
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/phoxag/dash.phoxago.com/resources/views/admin/custom-field/index.blade.php ENDPATH**/ ?>