<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Email Templates')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('Email Templates')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('action-button'); ?>
    <div class="row justify-content-end">
        <div class="col-auto">
            <a href="<?php echo e(route('email_template.index')); ?>" class="btn btn-sm btn-primary"
                data-bs-toggle="tooltip" data-bs-placement="top" title="" data-bs-original-title="Return"><i
                    class="ti ti-arrow-back-up"></i>
            </a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css-page'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/summernote/summernote-bs4.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('css/summernote/summernote-bs4.js')); ?>"></script>
    <script src="<?php echo e(asset('js/tinymce/tinymce.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row invoice-row row-gap-1">
        <div class="col-md-4  col-12">
            <div class="card mb-0 h-100">
                <div class="card-body">

                    <form action="<?php echo e(route('email_template.update', $emailTemplate->id)); ?>" class="needs-validation"
                        method="POST" enctype="multipart/form-data" novalidate>
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="row">
                            <div class="form-group col-md-12">
                                <label name="name" class="col-form-label text-dark"><?php echo e(__('Name')); ?></label>
                                <input type="text" name="name" value="<?php echo e($emailTemplate->action); ?>"
                                    class="form-control font-style" disabled>
                            </div>
                            <div class="form-group col-md-12">
                                <label for="from" class="col-form-label text-dark"><?php echo e(__('From')); ?></label>
                                <input type="text" name="from" class="form-control font-style" required
                                    placeholder="<?php echo e(__('Enter From Name ')); ?>" value="<?php echo e($emailTemplate->from); ?>">
                            </div>
                            <input type="hidden" name="lang" value="<?php echo e($currEmailTempLang->lang); ?>">
                            <div class="col-12 text-end">
                                <input type="submit" value="<?php echo e(__('Save')); ?>" class="btn btn-print-invoice  btn-primary">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-8 col-12">
            <div class="card h-100">
                <div class=" card-body">

                    <div class="row text-xs">
                        <h6 class="font-weight-bold mb-4"><?php echo e(__('Place Holders')); ?></h6>
                        <?php
                            $variables = json_decode($currEmailTempLang->variables);
                        ?>
                        <?php if(!empty($variables) > 0): ?>
                            <?php $__currentLoopData = $variables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $var): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-6 pb-1">
                                    <p class="mb-1"><?php echo e(__($key)); ?> : <span class="pull-right text-primary"><?php echo e('{' . $var . '}'); ?></span>
                                    </p>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <h5></h5>
            <div class="row row-gap-1">
                <div class="col-sm-3 col-md-3 col-lg-3 col-xl-3">
                    <div class="card sticky-top language-sidebar email-sidebar mb-0">
                        <div class="list-group list-group-flush" id="useradd-sidenav">
                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a class="list-group-item list-group-item-action border-0 <?php echo e($currEmailTempLang->lang == $key ? 'active' : ''); ?>"
                                    href="<?php echo e(route('manage.email.language', [$emailTemplate->id, $key])); ?>">
                                    <?php echo e(Str::ucfirst($lang)); ?>

                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>

                <div class="col-lg-9 col-md-9 col-sm-9">
                    <div class="card p-3">
                        <form action="<?php echo e(route('store.email.language', $currEmailTempLang->parent_id)); ?>"
                            class="needs-validation mt-3" method="POST" enctype="multipart/form-data" novalidate>
                            <?php echo csrf_field(); ?>
                            <div class="form-group col-12">
                                <label for="subject" class="col-form-label text-dark"><?php echo e(__('Subject')); ?></label>
                                <input type="text" name="subject" class="form-control font-style" required
                                    value="<?php echo e($currEmailTempLang->subject); ?>">
                            </div>
                            <div class="form-group col-12">
                                <label class="col-form-label text-dark" for="content"><?php echo e(__('Email Message')); ?></label>
                                <textarea name="content" class="summernote-simple" id="contenrt"
                                    required><?php echo e($currEmailTempLang->content); ?></textarea>
                                <p class="text-danger summernote_text"></p>
                            </div>

                            <div class="col-md-12 text-end mb-3">
                                <input type="hidden" name="lang" value="<?php echo e($currEmailTempLang->lang); ?>">
                                <input type="submit" value="<?php echo e(__('Save')); ?>" class="btn btn-print-invoice  btn-primary">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/phoxag/dash.phoxago.com/resources/views/email_templates/show.blade.php ENDPATH**/ ?>