<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Manage KnowledgeBase Category')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.knowledge')); ?>"><?php echo e(__('Knowledge')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('Category')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('multiple-action-button'); ?>
    
    <?php echo $__env->yieldPushContent('addButtonHook'); ?>
    <?php if (app('laratrust')->hasPermission('knowledgebase-category create')) : ?>
        <a href="#" class="btn btn-sm btn-primary btn-icon" title="<?php echo e(__('Create Knowledgebase Category')); ?>"
            data-bs-toggle="tooltip" data-bs-placement="top" data-ajax-popup="true"
            data-title="<?php echo e(__('Create Knowledgebase Category')); ?>" data-url="<?php echo e(route('admin.knowledgecategory.create')); ?>"
            data-size="md"><i class="ti ti-plus"></i></a>
    <?php endif; // app('laratrust')->permission ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="pc-dt-simple" class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th class="w-50"><?php echo e(__('Title')); ?></th>
                                    <?php if(Laratrust::hasPermission('knowledgebase-category edit') || Laratrust::hasPermission('knowledgebase-category delete')): ?>
                                        <th class="text-end me-3"><?php echo e(__('Action')); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $knowledges_category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $knowledge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <th scope="row"><?php echo e(++$index); ?></th>
                                        <td><span class="font-weight-bold white-space"><?php echo e($knowledge->title); ?></span></td>
                                        <td class="text-end">
                                            <?php if (app('laratrust')->hasPermission('knowledgebase-category edit')) : ?>
                                                <div class="action-btn me-2">
                                                    <a href="#" class="btn btn-sm btn-info btn-icon"
                                                        title="<?php echo e(__('Edit Knowledgebase Category')); ?>"
                                                        data-bs-toggle="tooltip" data-bs-placement="top" data-ajax-popup="true"
                                                        data-title="<?php echo e(__('Edit Knowledgebase Category')); ?>"
                                                        data-url="<?php echo e(route('admin.knowledgecategory.edit', $knowledge->id)); ?>"
                                                        data-size="md"><i class="ti ti-pencil"></i></a>
                                                </div>
                                            <?php endif; // app('laratrust')->permission ?>
                                            <?php if (app('laratrust')->hasPermission('knowledgebase-category delete')) : ?>
                                                <div class="action-btn">
                                                    <form method="POST"
                                                        action="<?php echo e(route('admin.knowledgecategory.destroy', $knowledge->id)); ?>"
                                                        id="user-form-<?php echo e($knowledge->id); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <input name="_method" type="hidden" value="DELETE">
                                                        <a class="mx-3 bg-danger btn btn-sm  align-items-center bs-pass-para show_confirm"
                                                            data-bs-toggle="tooltip" title=""
                                                            data-bs-original-title="Delete" aria-label="Delete"
                                                            data-confirm="<?php echo e(__('Are You Sure?')); ?>"
                                                            data-text="<?php echo e(__('This action can not be undone. Do you want to continue?')); ?>"
                                                            data-confirm-yes="delete-form-<?php echo e($knowledge->id); ?>"><i
                                                                class="ti ti-trash text-white text-white"></i></a>
                                                    </form>
                                                </div>
                                            <?php endif; // app('laratrust')->permission ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/phoxag/dash.phoxago.com/resources/views/admin/knowledgecategory/index.blade.php ENDPATH**/ ?>