@extends('layouts.auth')

@section('page-title')
{{ __('Set a New Password') }}
@endsection

@section('content')

<div class="auth-wrapper login-page">
    <div class="bottom-bg">
        <svg width="69" height="129" viewBox="0 0 69 129" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path
                d="M2.6351 123.878C3.41663 123.079 4.68262 123.075 5.47146 123.847C6.2603 124.619 6.27396 125.895 5.50185 126.684C4.72031 127.482 3.45432 127.486 2.66548 126.714C1.87664 125.942 1.85356 124.676 2.6351 123.878Z"
                fill="white" />
            <path
                d="M10.2806 116.066C11.0527 115.277 12.3281 115.263 13.117 116.035C13.9058 116.808 13.9195 118.083 13.1474 118.872C12.3658 119.67 11.0904 119.684 10.3016 118.912C9.52215 118.13 9.50849 116.855 10.2806 116.066Z"
                fill="white" />
            <path
                d="M2.63314 108.58C3.40526 107.792 4.68067 107.778 5.46951 108.55C6.25835 109.322 6.27201 110.597 5.4999 111.386C4.71837 112.185 3.44295 112.198 2.65411 111.426C1.86507 110.635 1.86103 109.369 2.63314 108.58Z"
                fill="white" />
            <path
                d="M17.9265 108.255C18.6986 107.466 19.993 107.452 20.7722 108.215C21.5611 108.987 21.5747 110.262 20.7932 111.061C20.0211 111.849 18.7457 111.863 17.9568 111.091C17.168 110.319 17.1543 109.043 17.9265 108.255Z"
                fill="white" />
            <path
                d="M10.279 100.769C11.0511 99.98 12.3359 99.9567 13.1248 100.729C13.9136 101.501 13.9273 102.776 13.1458 103.575C12.3736 104.364 11.0982 104.377 10.3094 103.605C9.51092 102.824 9.50688 101.558 10.279 100.769Z"
                fill="white" />
            <path
                d="M2.62177 93.2737C3.39389 92.4848 4.67872 92.4616 5.46756 93.2337C6.25639 94.0058 6.27006 95.2812 5.48853 96.0797C4.71641 96.8685 3.45061 96.8916 2.65215 96.1101C1.85369 95.3285 1.84965 94.0625 2.62177 93.2737Z"
                fill="white" />
            <path
                d="M25.5814 100.433C26.3629 99.6349 27.6385 99.6403 28.4178 100.403C29.2066 101.175 29.2203 102.451 28.4481 103.239C27.676 104.028 26.3912 104.051 25.6024 103.279C24.8135 102.507 24.7999 101.232 25.5814 100.433Z"
                fill="white" />
            <path
                d="M17.9339 92.9479C18.7155 92.1494 19.9815 92.1454 20.7703 92.9175C21.5591 93.6896 21.5728 94.965 20.8007 95.7539C20.0286 96.5427 18.7437 96.566 17.9549 95.7939C17.1564 95.0124 17.1524 93.7464 17.9339 92.9479Z"
                fill="white" />
            <path
                d="M10.2757 85.4527C11.0573 84.6542 12.3232 84.6502 13.1121 85.4223C13.9009 86.1944 13.9146 87.4698 13.1425 88.2586C12.3704 89.0475 11.0951 89.0802 10.2967 88.2987C9.49823 87.5171 9.49419 86.2511 10.2757 85.4527Z"
                fill="white" />
            <path
                d="M2.62826 77.9668C3.40979 77.1684 4.66617 77.1549 5.46463 77.9364C6.25346 78.7086 6.26713 79.984 5.49502 80.7728C4.7229 81.5616 3.43807 81.5849 2.64923 80.8128C1.85077 80.0313 1.84673 78.7653 2.62826 77.9668Z"
                fill="white" />
            <path
                d="M33.2279 92.6221C34.0094 91.8236 35.285 91.829 36.0642 92.5917C36.8531 93.3638 36.8667 94.6392 36.0946 95.4281C35.3225 96.2169 34.0471 96.2306 33.2583 95.4585C32.4694 94.6863 32.4463 93.4206 33.2279 92.6221Z"
                fill="white" />
            <path
                d="M25.5794 85.1361C26.361 84.3377 27.627 84.3336 28.4158 85.1057C29.2046 85.8779 29.2183 87.1533 28.4462 87.9421C27.6741 88.731 26.3987 88.7446 25.6098 87.9725C24.8114 87.191 24.7979 85.9346 25.5794 85.1361Z"
                fill="white" />
            <path
                d="M17.9222 77.641C18.7037 76.8426 19.9697 76.8385 20.7586 77.6106C21.5474 78.3827 21.5611 79.6582 20.789 80.447C20.0168 81.2358 18.751 81.2589 17.9526 80.4774C17.1541 79.6959 17.1407 78.4395 17.9222 77.641Z"
                fill="white" />
            <path
                d="M10.2747 70.1555C11.0563 69.3571 12.3127 69.3436 13.1111 70.1252C13.8999 70.8973 13.9136 72.1727 13.1415 72.9615C12.3694 73.7504 11.094 73.764 10.3051 72.9919C9.50667 72.2104 9.49321 70.954 10.2747 70.1555Z"
                fill="white" />
            <path
                d="M2.60678 62.6507C3.38831 61.8522 4.65431 61.8482 5.44315 62.6203C6.23198 63.3924 6.24565 64.6678 5.47353 65.4566C4.70141 66.2455 3.426 66.2592 2.63716 65.487C1.84832 64.7149 1.82524 63.4491 2.60678 62.6507Z"
                fill="white" />
            <path
                d="M40.8734 84.8107C41.6455 84.0219 42.9209 84.0082 43.7097 84.7803C44.4986 85.5524 44.5122 86.8278 43.7401 87.6167C42.9586 88.4151 41.6832 88.4288 40.8943 87.6567C40.1149 86.8749 40.1013 85.5995 40.8734 84.8107Z"
                fill="white" />
            <path
                d="M33.2249 77.3249C33.9971 76.536 35.2725 76.5224 36.0613 77.2945C36.8501 78.0666 36.8638 79.342 36.0823 80.1405C35.3102 80.9293 34.0347 80.943 33.2459 80.1708C32.4569 79.3797 32.4528 78.1137 33.2249 77.3249Z"
                fill="white" />
            <path
                d="M25.5687 69.8296C26.3408 69.0408 27.6162 69.0271 28.4051 69.7992C29.1939 70.5713 29.2076 71.8468 28.426 72.6452C27.6539 73.4341 26.3881 73.4571 25.5897 72.6756C24.8006 71.8845 24.7966 70.6185 25.5687 69.8296Z"
                fill="white" />
            <path
                d="M17.9203 62.3439C18.6924 61.5551 19.9582 61.532 20.7566 62.3135C21.5455 63.0856 21.5591 64.361 20.7776 65.1595C20.0055 65.9483 18.7301 65.962 17.9412 65.1899C17.1522 64.3987 17.1481 63.1327 17.9203 62.3439Z"
                fill="white" />
            <path
                d="M10.2533 54.8394C11.0254 54.0505 12.3008 54.0369 13.0896 54.809C13.8785 55.5811 13.8921 56.8565 13.1106 57.655C12.3385 58.4438 11.0631 58.4575 10.2742 57.6854C9.49481 56.9036 9.48114 55.6282 10.2533 54.8394Z"
                fill="white" />
            <path
                d="M2.59505 47.3441C3.36717 46.5553 4.65221 46.5511 5.44104 47.3232C6.22988 48.0953 6.24355 49.3707 5.46201 50.1692C4.6899 50.958 3.41448 50.9717 2.62564 50.1996C1.8366 49.4084 1.82294 48.133 2.59505 47.3441Z"
                fill="white" />
            <path
                d="M48.5192 76.9993C49.3008 76.2008 50.5762 76.1871 51.365 76.9593C52.1539 77.7314 52.1675 79.0068 51.386 79.8053C50.6139 80.5941 49.3385 80.6078 48.5496 79.8356C47.7608 79.0635 47.7471 77.7881 48.5192 76.9993Z"
                fill="white" />
            <path
                d="M40.8708 69.5133C41.6523 68.7149 42.9277 68.7012 43.7166 69.4733C44.5054 70.2454 44.5191 71.5208 43.7376 72.3193C42.9654 73.1081 41.69 73.1218 40.9012 72.3497C40.1027 71.5681 40.0987 70.3021 40.8708 69.5133Z"
                fill="white" />
            <path
                d="M33.2136 62.0182C33.9951 61.2197 35.2705 61.2061 36.0594 61.9782C36.8482 62.7503 36.8619 64.0257 36.0803 64.8242C35.3082 65.613 34.0424 65.6361 33.244 64.8546C32.4455 64.073 32.4415 62.807 33.2136 62.0182Z"
                fill="white" />
            <path
                d="M25.5661 54.5324C26.3476 53.7339 27.6134 53.7108 28.4119 54.4923C29.2007 55.2645 29.2144 56.5399 28.4329 57.3383C27.6607 58.1272 26.3853 58.1408 25.5965 57.3687C24.798 56.5872 24.794 55.3212 25.5661 54.5324Z"
                fill="white" />
            <path
                d="M17.8991 47.0278C18.6806 46.2294 19.9561 46.2157 20.7449 46.9878C21.5337 47.7599 21.5474 49.0354 20.7659 49.8338C19.9938 50.6227 18.7183 50.6363 17.9295 49.8642C17.1407 49.0921 17.127 47.8167 17.8991 47.0278Z"
                fill="white" />
            <path
                d="M10.2419 39.5327C11.0234 38.7343 12.3085 38.73 13.0973 39.5021C13.8861 40.2742 13.8998 41.5497 13.1183 42.3481C12.3461 43.137 11.0707 43.1506 10.2819 42.3785C9.48344 41.597 9.46977 40.3216 10.2419 39.5327Z"
                fill="white" />
            <path
                d="M2.59345 32.0469C3.37498 31.2484 4.6504 31.2348 5.43924 32.0069C6.22808 32.779 6.24174 34.0544 5.46021 34.8529C4.68809 35.6417 3.41268 35.6554 2.62384 34.8832C1.835 34.1111 1.82133 32.8357 2.59345 32.0469Z"
                fill="white" />
            <path
                d="M56.1742 69.1783C56.9463 68.3894 58.2217 68.3757 59.0105 69.1479C59.7994 69.92 59.813 71.1954 59.0409 71.9842C58.2688 72.7731 56.9934 72.7867 56.2045 72.0146C55.4157 71.2425 55.3926 69.9767 56.1742 69.1783Z"
                fill="white" />
            <path
                d="M48.5267 61.6924C49.2988 60.9036 50.5742 60.8899 51.3631 61.662C52.1519 62.4341 52.1656 63.7096 51.3935 64.4984C50.6213 65.2872 49.3459 65.3009 48.5571 64.5288C47.7586 63.7472 47.7452 62.4909 48.5267 61.6924Z"
                fill="white" />
            <path
                d="M40.8695 54.1972C41.6416 53.4083 42.917 53.3947 43.7058 54.1668C44.4947 54.9389 44.5083 56.2143 43.7362 57.0032C42.9641 57.792 41.6983 57.8151 40.8999 57.0335C40.1014 56.252 40.0879 54.9956 40.8695 54.1972Z"
                fill="white" />
            <path
                d="M33.221 46.7113C33.9931 45.9225 35.2589 45.8994 36.0574 46.6809C36.8462 47.4531 36.8599 48.7285 36.0878 49.5173C35.3157 50.3062 34.0403 50.3198 33.2514 49.5477C32.453 48.7662 32.4395 47.5098 33.221 46.7113Z"
                fill="white" />
            <path
                d="M25.554 39.2069C26.3262 38.4181 27.6016 38.4044 28.3904 39.1766C29.1792 39.9487 29.1929 41.2241 28.4208 42.0129C27.6487 42.8018 26.3733 42.8154 25.5844 42.0433C24.7956 41.2712 24.7725 40.0054 25.554 39.2069Z"
                fill="white" />
            <path
                d="M17.8968 31.7117C18.6689 30.9229 19.954 30.9186 20.7428 31.6907C21.5316 32.4628 21.5453 33.7383 20.7732 34.5271C20.0011 35.3159 18.7257 35.3296 17.9368 34.5575C17.1384 33.776 17.1153 32.5102 17.8968 31.7117Z"
                fill="white" />
            <path
                d="M10.2484 24.2259C11.0205 23.437 12.2959 23.4234 13.0847 24.1955C13.8736 24.9676 13.8872 26.243 13.1151 27.0318C12.343 27.8207 11.0676 27.8343 10.2788 27.0622C9.48992 26.2901 9.46684 25.0243 10.2484 24.2259Z"
                fill="white" />
            <path
                d="M2.59115 16.7307C3.36327 15.9419 4.63868 15.9282 5.43714 16.7098C6.22598 17.4819 6.23964 18.7573 5.46752 19.5461C4.69541 20.335 3.41037 20.3392 2.63115 19.5765C1.83269 18.795 1.80962 17.5292 2.59115 16.7307Z"
                fill="white" />
            <path
                d="M63.8197 61.3666C64.5918 60.5778 65.8672 60.5641 66.656 61.3362C67.4449 62.1083 67.4585 63.3837 66.6864 64.1726C65.9049 64.971 64.6389 64.9751 63.85 64.203C63.0612 63.4309 63.0381 62.1651 63.8197 61.3666Z"
                fill="white" />
            <path
                d="M56.1722 53.881C56.9443 53.0922 58.2101 53.0691 59.0086 53.8506C59.7974 54.6227 59.8111 55.8982 59.039 56.687C58.2574 57.4855 56.9914 57.4895 56.2026 56.7174C55.4041 55.9358 55.3907 54.6795 56.1722 53.881Z"
                fill="white" />
            <path
                d="M48.515 46.3859C49.2871 45.5971 50.5529 45.574 51.3513 46.3555C52.1402 47.1276 52.1538 48.403 51.3817 49.1919C50.6002 49.9903 49.3438 50.0038 48.5454 49.2223C47.7469 48.4407 47.7334 47.1844 48.515 46.3859Z"
                fill="white" />
            <path
                d="M40.8665 38.9001C41.6387 38.1112 42.9044 38.0881 43.7029 38.8697C44.4917 39.6418 44.5054 40.9172 43.7333 41.706C42.9518 42.5045 41.6858 42.5085 40.8969 41.7364C40.0985 40.9549 40.085 39.6985 40.8665 38.9001Z"
                fill="white" />
            <path
                d="M33.2005 31.3955C33.9726 30.6067 35.2481 30.593 36.0369 31.3652C36.8257 32.1373 36.8394 33.4127 36.0673 34.2015C35.2857 35 34.0197 35.004 33.2309 34.2319C32.4421 33.4598 32.419 32.194 33.2005 31.3955Z"
                fill="white" />
            <path
                d="M25.5423 23.9004C26.3144 23.1116 27.5995 23.1073 28.3883 23.8794C29.1771 24.6516 29.1908 25.927 28.4187 26.7158C27.6372 27.5143 26.3712 27.5183 25.5823 26.7462C24.7935 25.9741 24.7608 24.6989 25.5423 23.9004Z"
                fill="white" />
            <path
                d="M17.8949 16.4146C18.667 15.6257 19.9424 15.6121 20.7312 16.3842C21.5201 17.1563 21.5337 18.4317 20.7616 19.2206C19.9801 20.019 18.7141 20.0231 17.9252 19.2509C17.1364 18.4788 17.1133 17.213 17.8949 16.4146Z"
                fill="white" />
            <path
                d="M10.2367 8.91934C11.0088 8.1305 12.2842 8.11684 13.0826 8.89837C13.8715 9.67049 13.8851 10.9459 13.113 11.7347C12.3315 12.5332 11.0655 12.5372 10.2767 11.7651C9.4782 10.9836 9.45512 9.7178 10.2367 8.91934Z"
                fill="white" />
            <path
                d="M2.5892 1.4335C3.36131 0.644661 4.62711 0.621582 5.42557 1.40311C6.2144 2.17523 6.22807 3.45065 5.45595 4.23948C4.67442 5.03794 3.40842 5.04199 2.61958 4.26987C1.82112 3.48834 1.80766 2.23196 2.5892 1.4335Z"
                fill="white" />
        </svg>

    </div>
    <div class="auth-content ticket-form-wrapper">
        {{-- Navbar --}}
        @include('layouts.navbar')

        <div class="row login-row">
            <div class="col-lg-6 col-12">
                <div class="top-bg">
                    <svg width="66" height="129" viewBox="0 0 66 129" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M65.4557 123.878C64.6742 123.079 63.4082 123.075 62.6194 123.847C61.8305 124.619 61.8169 125.895 62.589 126.684C63.3705 127.482 64.6365 127.486 65.4253 126.714C66.2142 125.942 66.2373 124.676 65.4557 123.878Z"
                            fill="white"></path>
                        <path
                            d="M57.8095 116.066C57.0374 115.277 55.762 115.264 54.9731 116.036C54.1843 116.808 54.1706 118.083 54.9427 118.872C55.7243 119.671 56.9997 119.684 57.7885 118.912C58.5679 118.13 58.5816 116.855 57.8095 116.066Z"
                            fill="white"></path>
                        <path
                            d="M65.4574 108.58C64.6853 107.791 63.4099 107.777 62.6211 108.549C61.8322 109.322 61.8186 110.597 62.5907 111.386C63.3722 112.184 64.6476 112.198 65.4365 111.426C66.2255 110.635 66.2296 109.369 65.4574 108.58Z"
                            fill="white"></path>
                        <path
                            d="M50.1636 108.255C49.3915 107.466 48.0971 107.452 47.3178 108.215C46.529 108.987 46.5153 110.262 47.2969 111.061C48.069 111.849 49.3444 111.863 50.1332 111.091C50.9221 110.319 50.9357 109.043 50.1636 108.255Z"
                            fill="white"></path>
                        <path
                            d="M57.8113 100.769C57.0392 99.9803 55.7544 99.957 54.9655 100.729C54.1767 101.501 54.163 102.777 54.9446 103.575C55.7167 104.364 56.9921 104.378 57.781 103.606C58.5794 102.824 58.5835 101.558 57.8113 100.769Z"
                            fill="white"></path>
                        <path
                            d="M65.469 93.2741C64.6969 92.4852 63.4121 92.4619 62.6233 93.234C61.8344 94.0062 61.8208 95.2816 62.6023 96.08C63.3744 96.8689 64.6402 96.892 65.4387 96.1104C66.2371 95.3289 66.2412 94.0629 65.469 93.2741Z"
                            fill="white"></path>
                        <path
                            d="M42.5087 100.433C41.7272 99.6349 40.4516 99.6403 39.6723 100.403C38.8835 101.175 38.8698 102.451 39.642 103.239C40.4141 104.028 41.6989 104.051 42.4877 103.279C43.2766 102.507 43.2902 101.232 42.5087 100.433Z"
                            fill="white"></path>
                        <path
                            d="M50.1567 92.948C49.3751 92.1496 48.1091 92.1455 47.3203 92.9176C46.5314 93.6898 46.5178 94.9652 47.2899 95.754C48.062 96.5428 49.3468 96.5661 50.1357 95.794C50.9341 95.0125 50.9382 93.7465 50.1567 92.948Z"
                            fill="white"></path>
                        <path
                            d="M57.8141 85.4529C57.0326 84.6544 55.7666 84.6504 54.9778 85.4225C54.1889 86.1946 54.1753 87.4701 54.9474 88.2589C55.7195 89.0477 56.9947 89.0804 57.7932 88.2989C58.5916 87.5174 58.5957 86.2514 57.8141 85.4529Z"
                            fill="white"></path>
                        <path
                            d="M65.4621 77.9666C64.6805 77.1681 63.4242 77.1547 62.6257 77.9362C61.8369 78.7083 61.8232 79.9837 62.5953 80.7726C63.3674 81.5614 64.6523 81.5847 65.4411 80.8126C66.2396 80.031 66.2436 78.765 65.4621 77.9666Z"
                            fill="white"></path>
                        <path
                            d="M34.8627 92.6219C34.0812 91.8234 32.8056 91.8288 32.0263 92.5915C31.2375 93.3636 31.2238 94.639 31.996 95.4278C32.7681 96.2167 34.0435 96.2303 34.8323 95.4582C35.6212 94.6861 35.6442 93.4203 34.8627 92.6219Z"
                            fill="white"></path>
                        <path
                            d="M42.5104 85.1365C41.7289 84.338 40.4629 84.334 39.674 85.1061C38.8852 85.8782 38.8715 87.1536 39.6437 87.9425C40.4158 88.7313 41.6912 88.745 42.48 87.9729C43.2785 87.1913 43.2919 85.935 42.5104 85.1365Z"
                            fill="white"></path>
                        <path
                            d="M50.1681 77.6414C49.3866 76.8429 48.1206 76.8389 47.3318 77.611C46.5429 78.3831 46.5293 79.6585 47.3014 80.4474C48.0735 81.2362 49.3393 81.2593 50.1377 80.4778C50.9362 79.6962 50.9497 78.4398 50.1681 77.6414Z"
                            fill="white"></path>
                        <path
                            d="M57.8158 70.1551C57.0343 69.3566 55.7779 69.3431 54.9795 70.1247C54.1906 70.8968 54.177 72.1722 54.9491 72.961C55.7212 73.7499 56.9966 73.7635 57.7855 72.9914C58.5839 72.2099 58.5974 70.9535 57.8158 70.1551Z"
                            fill="white"></path>
                        <path
                            d="M65.4833 62.6511C64.7018 61.8527 63.4358 61.8487 62.6469 62.6208C61.8581 63.3929 61.8444 64.6683 62.6166 65.4571C63.3887 66.246 64.6641 66.2596 65.4529 65.4875C66.2418 64.7154 66.2648 63.4496 65.4833 62.6511Z"
                            fill="white"></path>
                        <path
                            d="M27.2172 84.8103C26.4451 84.0215 25.1697 84.0078 24.3808 84.7799C23.592 85.5521 23.5783 86.8275 24.3504 87.6163C25.132 88.4148 26.4074 88.4284 27.1962 87.6563C27.9757 86.8746 27.9893 85.5992 27.2172 84.8103Z"
                            fill="white"></path>
                        <path
                            d="M34.8652 77.325C34.093 76.5361 32.8176 76.5225 32.0288 77.2946C31.2399 78.0667 31.2263 79.3421 32.0078 80.1406C32.7799 80.9294 34.0553 80.9431 34.8442 80.171C35.6332 79.3798 35.6373 78.1138 34.8652 77.325Z"
                            fill="white"></path>
                        <path
                            d="M42.5219 69.8299C41.7498 69.041 40.4744 69.0274 39.6855 69.7995C38.8967 70.5716 38.883 71.847 39.6645 72.6455C40.4367 73.4343 41.7025 73.4574 42.5009 72.6759C43.29 71.8847 43.294 70.6187 42.5219 69.8299Z"
                            fill="white"></path>
                        <path
                            d="M50.1706 62.3435C49.3985 61.5547 48.1327 61.5316 47.3342 62.3131C46.5454 63.0853 46.5317 64.3607 47.3132 65.1591C48.0853 65.948 49.3608 65.9616 50.1496 65.1895C50.9386 64.3984 50.9427 63.1324 50.1706 62.3435Z"
                            fill="white"></path>
                        <path
                            d="M57.8371 54.8396C57.065 54.0508 55.7895 54.0371 55.0007 54.8092C54.2119 55.5814 54.1982 56.8568 54.9797 57.6552C55.7519 58.4441 57.0273 58.4577 57.8161 57.6856C58.5955 56.9039 58.6092 55.6285 57.8371 54.8396Z"
                            fill="white"></path>
                        <path
                            d="M65.4948 47.3445C64.7227 46.5557 63.4376 46.5514 62.6488 47.3235C61.86 48.0957 61.8463 49.3711 62.6278 50.1695C63.3999 50.9584 64.6754 50.972 65.4642 50.1999C66.2532 49.4088 66.2669 48.1333 65.4948 47.3445Z"
                            fill="white"></path>
                        <path
                            d="M19.5711 76.9996C18.7896 76.2012 17.5142 76.1875 16.7253 76.9596C15.9365 77.7317 15.9228 79.0072 16.7043 79.8056C17.4765 80.5945 18.7519 80.6081 19.5407 79.836C20.3296 79.0639 20.3432 77.7885 19.5711 76.9996Z"
                            fill="white"></path>
                        <path
                            d="M27.219 69.5133C26.4375 68.7149 25.1621 68.7012 24.3733 69.4733C23.5844 70.2454 23.5708 71.5208 24.3523 72.3193C25.1244 73.1081 26.3998 73.1218 27.1887 72.3497C27.9871 71.5681 27.9912 70.3021 27.219 69.5133Z"
                            fill="white"></path>
                        <path
                            d="M34.8768 62.0182C34.0952 61.2197 32.8198 61.2061 32.031 61.9782C31.2421 62.7503 31.2285 64.0257 32.01 64.8242C32.7821 65.613 34.0479 65.6361 34.8464 64.8546C35.6448 64.073 35.6489 62.807 34.8768 62.0182Z"
                            fill="white"></path>
                        <path
                            d="M42.5245 54.5319C41.7429 53.7334 40.4771 53.7103 39.6787 54.4919C38.8898 55.264 38.8762 56.5394 39.6577 57.3378C40.4298 58.1267 41.7052 58.1403 42.4941 57.3682C43.2925 56.5867 43.2966 55.3207 42.5245 54.5319Z"
                            fill="white"></path>
                        <path
                            d="M50.1912 47.028C49.4097 46.2295 48.1343 46.2158 47.3454 46.988C46.5566 47.7601 46.5429 49.0355 47.3245 49.8339C48.0966 50.6228 49.372 50.6364 50.1608 49.8643C50.9497 49.0922 50.9633 47.8168 50.1912 47.028Z"
                            fill="white"></path>
                        <path
                            d="M57.8489 39.5328C57.0674 38.7344 55.7824 38.7301 54.9935 39.5023C54.2047 40.2744 54.191 41.5498 54.9726 42.3482C55.7447 43.1371 57.0201 43.1507 57.8089 42.3786C58.6074 41.5971 58.621 40.3217 57.8489 39.5328Z"
                            fill="white"></path>
                        <path
                            d="M65.4966 32.0465C64.7151 31.2481 63.4397 31.2344 62.6509 32.0065C61.862 32.7786 61.8483 34.054 62.6299 34.8525C63.402 35.6413 64.6774 35.655 65.4663 34.8829C66.2551 34.1108 66.2688 32.8354 65.4966 32.0465Z"
                            fill="white"></path>
                        <path
                            d="M11.9157 69.1785C11.1436 68.3897 9.86816 68.376 9.07932 69.1481C8.29048 69.9202 8.27682 71.1956 9.04894 71.9845C9.82105 72.7733 11.0965 72.787 11.8853 72.0149C12.6741 71.2427 12.6972 69.977 11.9157 69.1785Z"
                            fill="white"></path>
                        <path
                            d="M19.5636 61.6922C18.7915 60.9033 17.5161 60.8897 16.7273 61.6618C15.9384 62.4339 15.9248 63.7093 16.6969 64.4982C17.469 65.287 18.7444 65.3007 19.5333 64.5285C20.3317 63.747 20.3452 62.4906 19.5636 61.6922Z"
                            fill="white"></path>
                        <path
                            d="M27.2211 54.197C26.449 53.4082 25.1736 53.3945 24.3847 54.1667C23.5959 54.9388 23.5822 56.2142 24.3544 57.003C25.1265 57.7919 26.3923 57.815 27.1907 57.0334C27.9892 56.2519 28.0026 54.9955 27.2211 54.197Z"
                            fill="white"></path>
                        <path
                            d="M34.8691 46.7117C34.0969 45.9229 32.8311 45.8998 32.0327 46.6813C31.2438 47.4534 31.2302 48.7288 32.0023 49.5177C32.7744 50.3065 34.0498 50.3202 34.8387 49.5481C35.6371 48.7665 35.6506 47.5102 34.8691 46.7117Z"
                            fill="white"></path>
                        <path
                            d="M42.5363 39.2068C41.7642 38.418 40.4888 38.4043 39.6999 39.1764C38.9111 39.9485 38.8974 41.224 39.6695 42.0128C40.4417 42.8016 41.7171 42.8153 42.5059 42.0432C43.2947 41.2711 43.3178 40.0053 42.5363 39.2068Z"
                            fill="white"></path>
                        <path
                            d="M50.194 31.7117C49.4219 30.9229 48.1369 30.9186 47.348 31.6907C46.5592 32.4628 46.5455 33.7383 47.3176 34.5271C48.0897 35.3159 49.3652 35.3296 50.154 34.5575C50.9525 33.776 50.9755 32.5102 50.194 31.7117Z"
                            fill="white"></path>
                        <path
                            d="M57.8417 24.2263C57.0696 23.4375 55.7942 23.4238 55.0053 24.196C54.2165 24.9681 54.2028 26.2435 54.975 27.0323C55.7471 27.8212 57.0225 27.8348 57.8113 27.0627C58.6002 26.2906 58.6232 25.0248 57.8417 24.2263Z"
                            fill="white"></path>
                        <path
                            d="M65.4994 16.7312C64.7273 15.9424 63.4519 15.9287 62.6534 16.7103C61.8646 17.4824 61.8509 18.7578 62.6231 19.5466C63.3952 20.3355 64.6802 20.3397 65.4594 19.577C66.2579 18.7955 66.281 17.5297 65.4994 16.7312Z"
                            fill="white"></path>
                        <path
                            d="M4.27018 61.367C3.49806 60.5781 2.22265 60.5645 1.43381 61.3366C0.644973 62.1087 0.631312 63.3841 1.40343 64.173C2.18496 64.9714 3.45096 64.9755 4.2398 64.2033C5.02863 63.4312 5.05171 62.1654 4.27018 61.367Z"
                            fill="white"></path>
                        <path
                            d="M11.9181 53.8806C11.146 53.0918 9.88022 53.0687 9.08176 53.8503C8.29292 54.6224 8.27926 55.8978 9.05137 56.6866C9.83291 57.4851 11.0989 57.4891 11.8877 56.717C12.6862 55.9355 12.6997 54.6791 11.9181 53.8806Z"
                            fill="white"></path>
                        <path
                            d="M19.5751 46.3855C18.803 45.5967 17.5372 45.5736 16.7387 46.3551C15.9499 47.1273 15.9362 48.4027 16.7084 49.1915C17.4899 49.99 18.7463 50.0034 19.5447 49.2219C20.3432 48.4404 20.3566 47.184 19.5751 46.3855Z"
                            fill="white"></path>
                        <path
                            d="M27.2235 38.9002C26.4514 38.1113 25.1856 38.0883 24.3872 38.8698C23.5983 39.6419 23.5847 40.9173 24.3568 41.7062C25.1383 42.5046 26.4043 42.5087 27.1932 41.7365C27.9916 40.955 28.0051 39.6986 27.2235 38.9002Z"
                            fill="white"></path>
                        <path
                            d="M34.8903 31.3953C34.1182 30.6065 32.8428 30.5928 32.0539 31.3649C31.2651 32.137 31.2514 33.4124 32.0235 34.2013C32.8051 34.9997 34.0711 35.0038 34.8599 34.2317C35.6487 33.4595 35.6718 32.1938 34.8903 31.3953Z"
                            fill="white"></path>
                        <path
                            d="M42.5478 23.9002C41.7757 23.1113 40.4906 23.1071 39.7018 23.8792C38.9129 24.6513 38.8993 25.9267 39.6714 26.7156C40.4529 27.514 41.7189 27.5181 42.5078 26.746C43.2966 25.9738 43.3293 24.6986 42.5478 23.9002Z"
                            fill="white"></path>
                        <path
                            d="M50.1957 16.4148C49.4236 15.626 48.1482 15.6123 47.3593 16.3844C46.5705 17.1566 46.5568 18.432 47.329 19.2208C48.1105 20.0193 49.3765 20.0233 50.1653 19.2512C50.9542 18.4791 50.9772 17.2133 50.1957 16.4148Z"
                            fill="white"></path>
                        <path
                            d="M57.8534 8.91971C57.0813 8.13087 55.8059 8.1172 55.0074 8.89874C54.2186 9.67085 54.2049 10.9463 54.9771 11.7351C55.7586 12.5336 57.0246 12.5376 57.8134 11.7655C58.6119 10.984 58.635 9.71816 57.8534 8.91971Z"
                            fill="white"></path>
                        <path
                            d="M65.5011 1.43338C64.729 0.644539 63.4632 0.62146 62.6648 1.40299C61.8759 2.17511 61.8623 3.45052 62.6344 4.23936C63.4159 5.03782 64.6819 5.04186 65.4708 4.26975C66.2692 3.48822 66.2827 2.23184 65.5011 1.43338Z"
                            fill="white"></path>
                    </svg>
                </div>
                <div class="login-img">
                    <svg xmlns="http://www.w3.org/2000/svg" width="816" height="502" viewBox="0 0 816 502" fill="none">
                        <path
                            d="M751.682 14.9811C751.616 14.9811 751.548 14.9819 751.484 14.9819C751.419 14.9819 751.35 14.9811 751.285 14.9811C739.777 30.4349 719.78 36.7702 703.05 39.2777C703.024 54.1999 703.023 71.1649 703.124 78.9802C703.386 99.4025 751.484 137.011 751.484 137.011C751.484 137.011 799.582 99.4025 799.844 78.9802C799.945 71.1641 799.944 54.1999 799.918 39.2777C783.188 36.7711 763.19 30.4349 751.682 14.9811Z"
                            fill="#D3DAED" class="bg-primary" />
                        <path
                            d="M749.347 92.2172L737.55 69.9072C737.183 69.2148 737.448 68.3564 738.14 67.9908L738.931 67.5723C739.624 67.2059 740.482 67.4708 740.848 68.1633L749.653 84.8163L765.258 60.4314C765.681 59.772 766.557 59.5789 767.217 60.0014L767.971 60.4834C768.63 60.906 768.824 61.7825 768.401 62.4428L749.347 92.2172Z"
                            fill="white" />
                        <path
                            d="M751.483 134.408L750.366 133.535C750.254 133.447 739.048 124.658 727.964 113.669C712.836 98.6689 705.111 86.8467 705.004 78.5321C704.908 71.0809 704.914 54.4642 704.935 41.8355L704.937 40.2756L706.48 40.0445C720.437 37.9531 739.291 32.486 749.844 18.3148L750.388 17.5844H752.578L753.122 18.3148C763.675 32.486 782.528 37.9531 796.486 40.0445L798.029 40.2756L798.031 41.8355C798.062 60.2201 798.04 72.5665 797.962 78.5321C797.856 86.8475 790.13 98.6689 775.002 113.669C763.918 124.658 752.712 133.447 752.6 133.535L751.483 134.408ZM708.56 43.3905C708.534 60.6567 708.558 72.7737 708.632 78.4851C708.697 83.5222 712.543 93.2629 730.496 111.07C739.405 119.906 748.399 127.304 751.483 129.787C754.569 127.304 763.562 119.906 772.472 111.07C790.425 93.2629 794.271 83.5222 794.336 78.4851C794.411 72.706 794.435 60.9027 794.407 43.3905C780.499 41.1158 762.532 35.5579 751.484 22.1056C740.436 35.5588 722.468 41.1158 708.56 43.3905Z"
                            fill="white" />
                        <path
                            d="M295.519 49.2179L295.224 48.1524L308.746 40.9644L300.057 24.6143L286.538 31.8015L285.82 30.9629C283.75 28.5463 281.432 26.336 278.915 24.3791L278.703 24.5706H278.702C278.698 24.5656 278.693 24.5607 278.688 24.5549C278.65 24.5128 278.613 24.4707 278.574 24.4286C278.258 24.082 277.936 23.7386 277.609 23.4011C276.216 22.3933 274.751 21.4524 273.254 20.6031L272.292 20.0584L276.77 5.41676L259.06 0L254.582 14.6425L253.478 14.555C250.163 14.2909 246.782 14.3908 243.427 14.8521C241.379 15.1286 239.308 15.5537 237.272 16.1149L236.207 16.4079L229.02 2.88706L212.667 11.5796L219.855 25.1005L219.016 25.8185C214.846 29.384 211.359 33.6114 208.651 38.3811L208.106 39.3418L193.465 34.8643L188.048 52.5746L202.689 57.0521L202.604 58.1523C202.262 62.5671 202.544 67.0099 203.441 71.3562C203.654 72.3763 203.899 73.3882 204.169 74.3646L204.463 75.4301L190.942 82.6172L199.635 98.969L213.154 91.7819L213.873 92.6196C215.382 94.3784 216.996 96.0101 218.67 97.4677C219.149 97.8837 219.628 98.2856 220.098 98.6636L220.18 98.7288C220.959 99.3586 221.779 99.9743 222.688 100.612C223.894 101.458 225.156 102.255 226.438 102.978L227.402 103.522L222.924 118.165L240.634 123.582L245.112 108.94L246.214 109.027C251.669 109.454 257.122 108.929 262.422 107.467L263.487 107.174L270.674 120.694L287.021 112L279.835 98.4804L280.671 97.7624C281.24 97.2754 281.743 96.8239 282.215 96.3791C285.716 93.1058 288.685 89.3438 291.038 85.1981L291.584 84.2374L306.225 88.7149L311.641 71.0046L297.001 66.5271L297.086 65.4269C297.28 62.9137 297.274 60.408 297.069 57.9724C296.835 55.0366 296.315 52.091 295.519 49.2179ZM270.702 68.1704C267.178 79.6897 254.984 86.172 243.465 82.6486C231.946 79.126 225.463 66.9315 228.987 55.4122C232.509 43.8928 244.704 37.4105 256.223 40.9339C267.742 44.4565 274.224 56.651 270.702 68.1704Z"
                            fill="#6FD943" fill-opacity="0.5" class="bg-primary" />
                        <path
                            d="M366.311 31.383L365.865 31.0496L369.029 24.0184L360.529 20.1913L357.365 27.2216L356.82 27.1094C355.251 26.7858 353.647 26.6216 352.042 26.6191L352.017 26.7611C352.013 26.7602 352.01 26.7602 352.006 26.7594C351.978 26.7545 351.95 26.7495 351.922 26.7446C351.689 26.7041 351.455 26.667 351.221 26.6331C350.356 26.662 349.483 26.7388 348.625 26.8634L348.074 26.9435L345.34 19.7357L336.622 23.0429L339.356 30.2515L338.89 30.5568C337.489 31.4746 336.174 32.5567 334.982 33.7749C334.252 34.516 333.559 35.3249 332.921 36.1758L332.588 36.6207L325.558 33.4571L321.731 41.9598L328.763 45.1234L328.65 45.6681C328.09 48.3728 328.006 51.1311 328.399 53.8638L328.479 54.4143L321.272 57.1479L324.579 65.866L331.787 63.1325L332.092 63.5963C333.318 65.4583 334.8 67.1395 336.498 68.593C336.897 68.933 337.307 69.2607 337.715 69.5652L338.161 69.8987L334.996 76.929L343.499 80.7553L346.663 73.725L347.207 73.8364C348.35 74.0708 349.495 74.2227 350.611 74.2862C350.93 74.3044 351.245 74.3159 351.548 74.3217L351.601 74.3225C352.105 74.3333 352.621 74.325 353.18 74.2986C353.921 74.2631 354.669 74.1913 355.401 74.0832L355.953 74.0023L358.687 81.2109L367.406 77.9037L364.672 70.696L365.137 70.3906C367.44 68.8785 369.448 66.9877 371.106 64.7708L371.44 64.3259L378.47 67.4895L382.294 58.9876L375.264 55.824L375.376 55.2801C375.452 54.9112 375.513 54.5761 375.564 54.2534C375.948 51.8706 375.968 49.4581 375.627 47.0828L375.547 46.5323L382.754 43.7987L379.447 35.0797L372.24 37.8133L371.935 37.3495C371.237 36.2889 370.462 35.2935 369.629 34.3881C368.629 33.2929 367.513 32.281 366.311 31.383ZM362.28 46.5801C364.431 52.2511 361.578 58.5914 355.907 60.7423C350.236 62.8931 343.895 60.0399 341.744 54.3689C339.594 48.698 342.447 42.3577 348.118 40.2068C353.789 38.0559 360.129 40.9092 362.28 46.5801Z"
                            fill="#6FD943" fill-opacity="0.5" class="bg-primary" />
                        <path
                            d="M722.379 495.041H151.378C135.303 495.041 122.273 482.01 122.273 465.936V126.745C122.273 110.671 135.303 97.6403 151.378 97.6403H722.379C738.454 97.6403 751.484 110.671 751.484 126.745V465.935C751.484 482.01 738.454 495.041 722.379 495.041Z"
                            fill="#878787" class="bg-primary" />
                        <path
                            d="M100.889 474.209C94.4954 474.197 91.2278 481.875 95.6699 486.474L110.208 501.524C110.539 501.835 110.923 502 111.314 501.999H768.755C769.253 501.999 769.733 501.713 770.096 501.201L780.952 487.182C784.631 482.431 781.253 475.526 775.244 475.514L100.889 474.209Z"
                            fill="#222222" />
                        <path
                            d="M721.639 138.324V441.116C721.639 445.235 718.299 448.575 714.18 448.575H159.576C155.456 448.575 152.12 445.235 152.12 441.116V138.324C152.12 134.205 155.456 130.865 159.576 130.865H714.181C718.299 130.865 721.639 134.205 721.639 138.324Z"
                            fill="white" />
                        <path
                            d="M485.654 485.804H390.453C387.555 485.804 384.942 484.06 383.83 481.384L381.1 474.816H495.007L492.277 481.384C491.164 484.06 488.552 485.804 485.654 485.804Z"
                            fill="#5A7391" class="bg-primary" />
                        <path
                            d="M399.845 269.336H350.856C349.474 269.336 348.344 268.205 348.344 266.824C348.344 265.443 349.475 264.313 350.856 264.313H399.845C401.227 264.313 402.357 265.443 402.357 266.824C402.358 268.206 401.227 269.336 399.845 269.336Z"
                            fill="white" />
                        <path
                            d="M402.113 214.519C402.113 225.459 397.326 235.284 389.733 242.012C383.253 247.76 374.726 251.246 365.385 251.246C356.041 251.246 347.518 247.76 341.034 242.008C333.442 235.284 328.658 225.459 328.658 214.518C328.658 194.232 345.101 177.79 365.386 177.79C385.667 177.792 402.113 194.234 402.113 214.519Z"
                            fill="#1B3140" class="bg-primary" />
                        <path
                            d="M389.733 240.463V242.012C383.253 247.76 374.726 251.246 365.385 251.246C356.041 251.246 347.518 247.76 341.034 242.008V240.463C341.034 229.687 349.705 220.844 360.416 220.555C356.322 218.673 353.482 214.538 353.482 209.742C353.482 203.165 358.808 197.839 365.385 197.839C371.958 197.839 377.287 203.165 377.287 209.742C377.287 214.539 374.444 218.673 370.35 220.555C381.062 220.844 389.733 229.687 389.733 240.463Z"
                            fill="white" />
                        <path
                            d="M541.595 209.999H423.083C421.154 209.999 419.576 208.42 419.576 206.491C419.576 204.562 421.154 202.984 423.083 202.984H541.595C543.525 202.984 545.103 204.563 545.103 206.491C545.103 208.42 543.524 209.999 541.595 209.999Z"
                            fill="#58839E" class="bg-primary" />
                        <path
                            d="M478.508 229.198H423.406C421.299 229.198 419.574 227.474 419.574 225.368V224.367C419.574 222.26 421.299 220.536 423.406 220.536H478.508C480.615 220.536 482.338 222.261 482.338 224.367V225.368C482.339 227.474 480.615 229.198 478.508 229.198Z"
                            fill="#6FD943" class="bg-primary" />
                        <path d="M343.037 298.415V270.581H530.722V298.415H343.037Z" fill="#F6F6F6" stroke="#D9D9D9" />
                        <path opacity="0.3"
                            d="M356.173 284.498C356.173 286.66 354.421 288.413 352.258 288.413C350.096 288.413 348.344 286.661 348.344 284.498C348.344 282.337 350.096 280.583 352.258 280.583C354.421 280.583 356.173 282.336 356.173 284.498Z"
                            fill="#111111" />
                        <path opacity="0.3"
                            d="M369.514 284.498C369.514 286.66 367.762 288.413 365.6 288.413C363.437 288.413 361.685 286.661 361.685 284.498C361.685 282.337 363.437 280.583 365.6 280.583C367.762 280.583 369.514 282.336 369.514 284.498Z"
                            fill="#111111" />
                        <path opacity="0.3"
                            d="M382.855 284.498C382.855 286.66 381.103 288.413 378.94 288.413C376.778 288.413 375.026 286.661 375.026 284.498C375.026 282.337 376.778 280.583 378.94 280.583C381.102 280.583 382.855 282.336 382.855 284.498Z"
                            fill="#111111" />
                        <path opacity="0.3"
                            d="M396.194 284.498C396.194 286.66 394.442 288.413 392.279 288.413C390.117 288.413 388.365 286.661 388.365 284.498C388.365 282.337 390.117 280.583 392.279 280.583C394.441 280.583 396.194 282.336 396.194 284.498Z"
                            fill="#111111" />
                        <path opacity="0.3"
                            d="M409.534 284.498C409.534 286.66 407.782 288.413 405.62 288.413C403.457 288.413 401.705 286.661 401.705 284.498C401.705 282.337 403.457 280.583 405.62 280.583C407.782 280.583 409.534 282.336 409.534 284.498Z"
                            fill="#111111" />
                        <path opacity="0.3"
                            d="M422.874 284.498C422.874 286.66 421.121 288.413 418.959 288.413C416.797 288.413 415.044 286.661 415.044 284.498C415.044 282.337 416.797 280.583 418.959 280.583C421.121 280.583 422.874 282.336 422.874 284.498Z"
                            fill="#111111" />
                        <path opacity="0.3"
                            d="M436.215 284.498C436.215 286.66 434.463 288.413 432.3 288.413C430.138 288.413 428.386 286.661 428.386 284.498C428.386 282.337 430.138 280.583 432.3 280.583C434.462 280.583 436.215 282.336 436.215 284.498Z"
                            fill="#111111" />
                        <path
                            d="M481.989 401.518H391.772C388.355 401.518 385.586 398.749 385.586 395.332V370.404C385.586 366.988 388.355 364.219 391.772 364.219H481.989C485.405 364.219 488.175 366.988 488.175 370.404V395.332C488.175 398.749 485.405 401.518 481.989 401.518Z"
                            fill="#F15D59" class="bg-primary" />
                        <path
                            d="M452.176 386.236H421.584C420.291 386.236 419.233 385.178 419.233 383.885V381.851C419.233 380.558 420.291 379.5 421.584 379.5H452.176C453.469 379.5 454.527 380.558 454.527 381.851V383.885C454.527 385.178 453.469 386.236 452.176 386.236Z"
                            fill="white" />
                        <g opacity="0.3">
                            <path d="M343.037 345.446V317.612H530.722V345.446H343.037Z" fill="#F6F6F6"
                                stroke="#D9D9D9" />
                            <path
                                d="M356.173 331.529C356.173 333.69 354.421 335.443 352.258 335.443C350.096 335.443 348.344 333.691 348.344 331.529C348.344 329.367 350.096 327.614 352.258 327.614C354.421 327.614 356.173 329.367 356.173 331.529Z"
                                fill="#111111" />
                            <path
                                d="M369.514 331.529C369.514 333.69 367.762 335.443 365.6 335.443C363.437 335.443 361.685 333.691 361.685 331.529C361.685 329.367 363.437 327.614 365.6 327.614C367.762 327.614 369.514 329.367 369.514 331.529Z"
                                fill="#111111" />
                            <path
                                d="M382.855 331.529C382.855 333.69 381.103 335.443 378.94 335.443C376.778 335.443 375.026 333.691 375.026 331.529C375.026 329.367 376.778 327.614 378.94 327.614C381.102 327.614 382.855 329.367 382.855 331.529Z"
                                fill="#111111" />
                            <path
                                d="M396.194 331.529C396.194 333.69 394.442 335.443 392.279 335.443C390.117 335.443 388.365 333.691 388.365 331.529C388.365 329.367 390.117 327.614 392.279 327.614C394.441 327.614 396.194 329.367 396.194 331.529Z"
                                fill="#111111" />
                        </g>
                        <path
                            d="M696.668 233.955C696.668 245.999 687.111 270.003 679.935 276.666C672.76 283.329 705.55 278.032 705.55 278.032L724.312 261.631L716.312 233.955H696.668Z"
                            fill="#1E3747" />
                        <path
                            d="M638.134 482.018C629.32 482.446 618.732 482.106 612.849 481.678C610.556 481.511 606.838 481.398 602.444 480.909C592.418 479.794 578.876 476.711 570.738 466.471C558.945 451.633 565.356 439.649 577.529 440.861L597.703 444.889L602.337 446.96H602.34L624.466 456.849C624.466 456.849 646.951 481.59 638.134 482.018Z"
                            fill="#F9AA8F" />
                        <path
                            d="M602.444 480.909C592.418 479.794 578.876 476.711 570.738 466.471C558.945 451.633 565.356 439.649 577.529 440.861L597.703 444.889L602.337 446.96C590.471 447.765 586.626 453.66 586.112 459.552C585.602 465.448 587.139 475.024 600.463 479.975C601.317 480.29 601.97 480.602 602.444 480.909Z"
                            fill="#9DC2CF" />
                        <path
                            d="M602.258 399.33C585.949 388.638 580.826 386.651 567.624 382.88C551.997 378.415 533.732 395.926 541.267 413.169C546.663 425.519 563.604 434.634 574.239 439.308C587.197 445.003 623.101 456.051 623.101 456.051C623.101 456.051 630.618 479.285 638.135 482.019C644.855 481.905 650.436 481.449 657.953 480.082C665.47 478.716 694.789 480.391 706.781 483.597C718.773 486.802 753.625 488.853 773.443 472.451C793.26 456.051 802.828 433.841 789.844 404.968C776.86 376.096 602.258 399.33 602.258 399.33Z"
                            fill="#1B3140" />
                        <path
                            d="M715.015 252.235C691.951 253.26 677.088 262.144 668.887 285.207C666.224 292.696 663.051 301.296 659.775 313.225C653.846 334.82 653.853 358.328 653.853 358.328L691.41 328.89L693.317 332.702C693.317 332.702 691.619 356.961 690.538 366.184C688.277 385.473 681.968 398.305 681.968 398.305C681.968 398.305 757.724 415.39 789.843 404.968L780.276 369.946C780.276 369.946 799.064 335.542 807.781 330.148C809.832 330.148 813.22 330.148 814.957 330.148C815.999 291.666 814.786 266.415 782.668 254.797C750.55 243.181 715.015 252.235 715.015 252.235Z"
                            fill="#FFC727" />
                        <path
                            d="M659.776 313.226L686.01 318.837C686.01 318.837 688.975 324.845 691.411 328.891C693.921 333.062 672.988 375.014 672.988 375.014L630.448 377.293L659.776 313.226Z"
                            fill="#F9AA8F" />
                        <path
                            d="M693.318 333.157C693.114 333.157 692.928 333.019 692.876 332.812C692.578 331.618 691.704 330.218 690.598 328.447C688.057 324.376 684.578 318.799 684.578 310.151C684.578 303.054 686.548 296.816 689.275 288.183C691.094 282.425 693.358 275.258 695.603 265.967C695.663 265.722 695.909 265.571 696.153 265.631C696.397 265.69 696.548 265.936 696.489 266.18C694.237 275.503 691.968 282.686 690.144 288.457C687.441 297.013 685.489 303.195 685.489 310.151C685.489 318.539 688.889 323.987 691.372 327.965C692.52 329.805 693.427 331.258 693.761 332.592C693.822 332.836 693.674 333.083 693.43 333.144C693.391 333.153 693.354 333.157 693.318 333.157Z"
                            fill="#1D1D1B" />
                        <path d="M668.764 383.601H745.472L709.083 408.563H664.663L668.764 383.601Z" fill="#8D9393" />
                        <path
                            d="M777.173 332.751C777.173 335.817 778.91 364.488 778.91 364.488C778.91 364.488 761.74 367.905 753.796 369.956C745.852 372.006 729.9 375.95 726.942 376.719C723.984 377.488 734.832 392.611 734.832 392.611C734.832 392.611 743.126 391.066 745.254 390.618C750.122 389.593 756.273 390.021 765.243 390.276C774.212 390.532 798.386 391.899 804.537 380.88C810.687 369.861 810.858 330.148 810.858 330.148L777.173 332.751Z"
                            fill="#F9AA8F" />
                        <path
                            d="M726.943 376.718C721.934 377.487 716.809 376.718 712.709 375.437C708.608 374.156 705.533 375.95 701.433 378.513C697.332 381.075 685.031 392.156 685.031 392.156C685.031 392.156 691.694 406.958 694.513 407.727C697.332 408.497 700.578 406.258 702.372 404.208C704.165 402.158 710.516 395.752 714.103 394.982C717.691 394.214 718.602 394.036 723.623 394.719C726.924 395.168 731.362 394.436 734.832 392.612C738.303 390.787 726.943 376.718 726.943 376.718Z"
                            fill="#F9AA8F" />
                        <path
                            d="M727.307 488.044H727.304C722.86 487.968 717.819 487.154 712.452 485.805C693.488 481.049 684.855 464.812 688.248 456.05C690.7 449.729 717.065 448.019 724.239 450.069C726.827 450.811 730.149 451.415 733.384 452.724L733.396 452.727C739.133 455.045 744.6 459.567 745.253 470.926C745.989 483.673 738.56 488.235 727.307 488.044Z"
                            fill="#9DC2CF" />
                        <path
                            d="M727.306 488.044H727.303C716.791 485.268 712.195 480.053 713.477 468.648C714.756 457.243 725.981 450.531 733.383 452.724L733.395 452.727C739.132 455.045 744.599 459.567 745.252 470.926C745.988 483.673 738.559 488.235 727.306 488.044Z"
                            fill="#617184" />
                        <path
                            d="M692.122 404.456C691.997 404.456 691.871 404.404 691.781 404.303C691.614 404.115 691.631 403.827 691.819 403.66L705.658 391.375C705.846 391.209 706.134 391.226 706.301 391.413C706.467 391.602 706.451 391.89 706.263 392.056L692.424 404.341C692.338 404.418 692.229 404.456 692.122 404.456Z"
                            fill="#1D1D1B" />
                        <path
                            d="M667.328 434.71C667.294 434.71 667.259 434.706 667.225 434.698C658.256 432.635 645.909 425.364 635.017 418.95C628.196 414.933 622.304 411.463 618.498 410.026C618.263 409.938 618.144 409.674 618.233 409.439C618.321 409.204 618.584 409.085 618.82 409.173C622.7 410.638 628.622 414.126 635.48 418.164C646.316 424.546 658.598 431.778 667.431 433.81C667.676 433.866 667.829 434.111 667.773 434.356C667.723 434.568 667.536 434.71 667.328 434.71Z"
                            fill="#1D1D1B" />
                        <path
                            d="M689.274 397.704C689.141 397.704 689.01 397.647 688.92 397.536C688.762 397.34 688.791 397.054 688.987 396.896L701.573 386.677C701.767 386.518 702.055 386.548 702.213 386.744C702.372 386.939 702.342 387.226 702.146 387.384L689.561 397.603C689.476 397.671 689.375 397.704 689.274 397.704Z"
                            fill="#1D1D1B" />
                        <path
                            d="M562.585 330.374L593.681 407.508C593.938 408.146 594.556 408.563 595.244 408.563H706.488L674.656 328.725C673.472 325.755 670.596 323.805 667.398 323.805H567.018C563.631 323.806 561.318 327.231 562.585 330.374Z"
                            fill="#839AB8" class="bg-primary" />
                        <path
                            d="M787.11 449.9C786.768 430.765 770.367 401.38 753.967 396.938C737.565 392.496 720.937 394.547 695.425 414.365C669.912 434.182 640.868 451.609 623.101 456.051L658.654 479.973C678.253 474.632 733.978 451.609 745.254 445.458L787.11 449.9Z"
                            fill="#1B3140" />
                        <path
                            d="M715.044 235.989C716.29 240.288 718.682 253.594 716.262 259.791C714.848 263.415 721.734 273.11 731.649 271.32C741.565 269.53 751.208 267.753 755.874 255.967C760.539 244.181 749.43 211.135 749.43 211.135L715.044 235.989Z"
                            fill="#F9AA8F" />
                        <path
                            d="M777.03 330.604C776.801 330.604 776.604 330.431 776.578 330.198C776.565 330.077 775.253 318.01 774.374 304.814C773.192 287.053 773.32 275.81 774.755 271.398C774.832 271.159 775.088 271.028 775.329 271.106C775.569 271.184 775.699 271.441 775.621 271.68C772.275 281.975 777.431 329.62 777.483 330.099C777.511 330.349 777.33 330.575 777.08 330.602C777.063 330.603 777.047 330.604 777.03 330.604Z"
                            fill="#1D1D1B" />
                        <path
                            d="M623.099 456.506C622.895 456.506 622.71 456.367 622.658 456.161C622.597 455.917 622.745 455.669 622.99 455.609C639.648 451.444 667.97 435.114 695.144 414.006C707.336 404.536 718.082 398.683 727.998 396.114C736.598 393.886 744.887 394.008 754.085 396.499C761.772 398.581 770.106 406.299 776.951 417.675C783.43 428.444 787.398 440.487 787.565 449.893C787.57 450.144 787.37 450.352 787.118 450.356C787.116 450.356 787.113 450.356 787.11 450.356C786.862 450.356 786.659 450.158 786.654 449.909C786.489 440.657 782.57 428.783 776.17 418.146C769.446 406.97 761.309 399.4 753.847 397.38C740.055 393.644 723.466 393.161 695.703 414.726C668.436 435.906 639.981 452.301 623.21 456.495C623.173 456.501 623.136 456.506 623.099 456.506Z"
                            fill="#1D1D1B" />
                        <path
                            d="M658.653 480.428C658.453 480.428 658.269 480.295 658.214 480.092C658.148 479.85 658.291 479.599 658.533 479.533C678.696 474.039 734.341 450.891 745.036 445.058C745.257 444.938 745.533 445.018 745.654 445.24C745.774 445.461 745.693 445.737 745.472 445.858C734.753 451.705 678.98 474.906 658.773 480.412C658.733 480.423 658.693 480.428 658.653 480.428Z"
                            fill="#1D1D1B" />
                        <path
                            d="M708.647 157.797C700.749 158.688 683.492 172.685 684.396 190.344C685.3 208.003 688.066 241.149 712.281 242.99C736.496 244.829 746.196 224.645 750.24 213.404C754.283 202.164 754.994 185.962 742.743 172.219C730.492 158.475 721.148 156.388 708.647 157.797Z"
                            fill="#F9AA8F" />
                        <path
                            d="M695.891 206.862C695.996 208.911 694.992 210.629 693.649 210.697C692.306 210.766 691.133 209.161 691.028 207.111C690.923 205.062 691.927 203.344 693.269 203.276C694.612 203.207 695.786 204.813 695.891 206.862Z"
                            fill="#1E3747" />
                        <path
                            d="M723.297 205.966C723.409 208.161 722.334 210 720.897 210.074C719.459 210.148 718.202 208.428 718.09 206.233C717.977 204.038 719.052 202.2 720.49 202.126C721.927 202.053 723.184 203.772 723.297 205.966Z"
                            fill="#1E3747" />
                        <path
                            d="M704.208 218.762C701.65 218.762 700.093 217.416 699.466 216.046C698.741 214.462 699.126 212.659 700.448 211.453C702.329 209.737 702.178 208.281 702.033 206.873C702.006 206.614 701.981 206.365 701.968 206.123C701.955 205.872 702.149 205.658 702.4 205.645C702.649 205.629 702.866 205.825 702.879 206.077C702.89 206.303 702.915 206.537 702.94 206.779C703.093 208.259 703.283 210.1 701.063 212.127C700.024 213.075 699.729 214.432 700.295 215.667C700.862 216.905 702.406 218.115 705.045 217.799C705.294 217.769 705.521 217.948 705.551 218.197C705.581 218.447 705.403 218.673 705.153 218.704C704.823 218.743 704.509 218.762 704.208 218.762Z"
                            fill="#1E3747" />
                        <path
                            d="M709.719 231.224C708.657 231.224 707.554 230.892 706.425 230.231C706.208 230.104 706.134 229.825 706.261 229.608C706.387 229.391 706.667 229.317 706.884 229.445C708.234 230.235 709.518 230.487 710.702 230.194C710.947 230.133 711.193 230.282 711.254 230.526C711.314 230.771 711.165 231.017 710.921 231.078C710.527 231.174 710.126 231.224 709.719 231.224Z"
                            fill="#1D1D1B" />
                        <path
                            d="M710.81 231.091C710.605 231.091 710.42 230.952 710.368 230.745C710.307 230.501 710.456 230.254 710.7 230.193C713.74 229.438 715.395 225.814 716.602 223.123C712.062 226.277 704.793 227.414 702.981 227.028C702.735 226.976 702.577 226.734 702.63 226.488C702.682 226.242 702.923 226.084 703.171 226.137C704.714 226.466 713.464 225.217 717.548 221.168C717.708 221.01 717.958 220.992 718.14 221.126C718.321 221.259 718.377 221.504 718.273 221.703C718.024 222.177 717.757 222.774 717.475 223.404C716.187 226.275 714.425 230.207 710.921 231.077C710.884 231.086 710.846 231.091 710.81 231.091Z"
                            fill="#1D1D1B" />
                        <path
                            d="M688.709 199.055C688.173 199.055 687.665 198.738 687.446 198.213C687.156 197.516 687.486 196.716 688.183 196.426C689.66 195.812 694.906 195.544 696.438 196.004C697.161 196.221 697.571 196.982 697.353 197.705C697.136 198.428 696.375 198.839 695.652 198.621C694.735 198.346 690.116 198.582 689.233 198.949C689.061 199.021 688.884 199.055 688.709 199.055Z"
                            fill="#1D1D1B" />
                        <path
                            d="M716.646 197.103C716.154 197.103 715.679 196.837 715.434 196.372C715.084 195.703 715.34 194.877 716.009 194.526C717.01 194.001 721.945 192.003 724.819 192.161C725.572 192.203 726.149 192.848 726.107 193.601C726.065 194.355 725.417 194.929 724.667 194.89C722.678 194.776 718.304 196.408 717.28 196.946C717.078 197.052 716.861 197.103 716.646 197.103Z"
                            fill="#1D1D1B" />
                        <path
                            d="M684.569 193.727C676.601 188.433 681.825 157.373 702.777 154.505C713.307 148.577 735.269 143.946 752.878 159.467C770.488 174.989 776.209 214.435 779.453 224.336C782.697 234.238 752.875 214.755 748.895 202.155C744.914 189.555 738.862 188.858 723.886 178.828C713.216 171.681 709.795 165.179 709.795 165.179C709.795 165.179 686.425 169.825 684.569 193.727Z"
                            fill="#1E3747" />
                        <path
                            d="M790.869 281.449C783.181 283.243 776.486 283.649 766.633 285.195C767.775 274.604 763.07 259.579 762.939 259.162C764.312 265.532 761.91 278.376 761.627 286.063C757.172 286.902 749.525 286.371 742.122 285.664C737.49 285.221 730.363 281.449 733.752 274.957C739.97 263.047 743.98 252.825 747.048 234.552C749.392 220.596 749.618 211.06 750.89 203.263C750.89 203.263 768.034 186.46 774.187 205.687C780.062 224.041 812.668 275.974 790.869 281.449Z"
                            fill="#1E3747" />
                        <path
                            d="M760.697 146.788C761.171 156.044 754.052 163.93 744.797 164.404C735.541 164.877 727.655 157.759 727.182 148.503C726.708 139.248 733.826 131.362 743.082 130.888C752.336 130.414 760.223 137.533 760.697 146.788Z"
                            fill="#1E3747" />
                        <path
                            d="M756.325 206.568C755.683 210.622 752.67 213.513 749.595 213.026C746.52 212.539 744.547 208.858 745.189 204.804C745.831 200.75 748.845 197.859 751.92 198.346C754.996 198.833 756.968 202.514 756.325 206.568Z"
                            fill="#F9AA8F" />
                        <path
                            d="M716.486 243.095C722.073 242.808 730.483 241.197 736.117 235.093C736.117 235.093 729.983 247.113 716.974 246.828L716.486 243.095Z"
                            fill="#1D1D1B" />
                        <path
                            d="M677.777 237.287C677.609 237.287 677.44 237.232 677.299 237.117C676.973 236.853 676.924 236.375 677.188 236.049C685.826 225.406 684.903 217.217 683.834 207.735C683.229 202.365 682.542 196.277 683.588 189.152C683.649 188.737 684.033 188.451 684.449 188.511C684.865 188.572 685.151 188.958 685.091 189.373C684.074 196.303 684.719 202.028 685.343 207.565C686.45 217.387 687.407 225.869 678.367 237.006C678.217 237.192 677.998 237.287 677.777 237.287Z"
                            fill="#1E3747" />
                        <path
                            d="M741.181 237.721C741.074 237.721 740.964 237.698 740.86 237.649C740.48 237.471 740.316 237.019 740.494 236.639C748.192 220.193 740.008 199.513 730.754 191.927C729.999 191.309 729.069 190.593 727.992 189.763C720.576 184.052 708.162 174.493 708.514 163.387C708.527 162.968 708.876 162.637 709.297 162.653C709.716 162.666 710.045 163.017 710.033 163.436C709.706 173.765 722.205 183.39 728.92 188.561C730.007 189.398 730.946 190.121 731.718 190.753C736.845 194.956 741.242 202.404 743.48 210.677C746.041 220.147 745.47 229.596 741.872 237.285C741.741 237.558 741.467 237.721 741.181 237.721Z"
                            fill="#1E3747" />
                        <path
                            d="M756.063 350.134C745.328 350.134 732.331 346.298 726.647 341.18C726.461 341.011 726.445 340.723 726.614 340.537C726.782 340.35 727.069 340.335 727.257 340.503C733.433 346.065 748.528 350.07 759.566 349.072C759.814 349.053 760.039 349.234 760.061 349.484C760.083 349.735 759.898 349.956 759.648 349.98C758.493 350.084 757.293 350.134 756.063 350.134Z"
                            fill="#1D1D1B" />
                        <path
                            d="M592.264 404.453C592.015 404.453 591.811 404.252 591.809 404.002C591.806 403.75 592.008 403.545 592.26 403.542L704.25 402.507C704.251 402.507 704.252 402.507 704.254 402.507C704.503 402.507 704.707 402.709 704.709 402.959C704.712 403.21 704.51 403.416 704.258 403.418L592.268 404.453C592.268 404.453 592.266 404.453 592.264 404.453Z"
                            fill="#1D1D1B" />
                        <path
                            d="M137.065 69.2821C136.959 69.2821 136.847 69.2838 136.744 69.2838C136.64 69.2838 136.53 69.2829 136.424 69.2821C117.911 94.1432 85.7395 104.336 58.8249 108.369C58.7836 132.376 58.7828 159.668 58.9446 172.242C59.3672 205.096 136.745 265.6 136.745 265.6C136.745 265.6 214.123 205.096 214.546 172.242C214.707 159.668 214.707 132.376 214.665 108.369C187.748 104.336 155.578 94.1432 137.065 69.2821Z"
                            fill="#6FD943" class="bg-primary" />
                        <path
                            d="M136.745 261.413L134.947 260.008C134.767 259.867 116.739 245.727 98.9082 228.047C74.5704 203.915 62.1423 184.897 61.9707 171.52C61.8163 159.532 61.8254 132.799 61.8592 112.483L61.8634 109.974L64.3452 109.602C86.8004 106.238 117.132 97.4422 134.108 74.6437L134.984 73.4684H138.506L139.382 74.6437C156.359 97.4414 186.69 106.237 209.145 109.602L211.627 109.974L211.631 112.483C211.68 142.06 211.643 161.923 211.519 171.52C211.348 184.897 198.92 203.915 174.582 228.047C156.751 245.727 138.723 259.866 138.543 260.008L136.745 261.413ZM67.6903 114.986C67.6474 142.763 67.687 162.257 67.805 171.445C67.909 179.548 74.0958 195.219 102.979 223.866C117.312 238.081 131.781 249.982 136.744 253.977C141.707 249.981 156.177 238.081 170.509 223.866C199.392 195.219 205.579 179.547 205.683 171.445C205.803 162.147 205.841 143.159 205.797 114.986C183.421 111.326 154.517 102.386 136.743 80.7438C118.972 102.386 90.0663 111.326 67.6903 114.986Z"
                            fill="white" />
                        <path
                            d="M121.585 164.558V141.309C121.585 136.603 125.414 132.775 130.119 132.775H143.386C148.081 132.775 151.9 136.595 151.9 141.289V164.559H157.495V141.289C157.495 133.51 151.166 127.18 143.386 127.18H130.119C122.328 127.18 115.99 133.519 115.99 141.309V164.558H121.585Z"
                            fill="white" />
                        <path
                            d="M155.76 207.703H117.727C113.108 207.703 109.364 203.959 109.364 199.34V166.249C109.364 161.63 113.109 157.885 117.727 157.885H155.76C160.38 157.885 164.124 161.63 164.124 166.249V199.34C164.124 203.959 160.38 207.703 155.76 207.703Z"
                            fill="white" />
                        <path
                            d="M141.854 178.184C141.854 175.361 139.566 173.074 136.743 173.074C133.92 173.074 131.633 175.361 131.633 178.184C131.633 179.913 132.493 181.441 133.807 182.365L133.013 192.514H140.473L139.68 182.365C140.994 181.441 141.854 179.913 141.854 178.184Z"
                            fill="#F15D59" class="bg-primary" />
                        <path
                            d="M152.293 204.716H121.195C116.567 204.716 112.802 200.951 112.802 196.323V169.266C112.802 164.639 116.567 160.873 121.195 160.873H152.293C156.92 160.873 160.685 164.639 160.685 169.266V196.323C160.685 200.951 156.92 204.716 152.293 204.716ZM121.195 163.982C118.282 163.982 115.91 166.352 115.91 169.266V196.323C115.91 199.237 118.281 201.608 121.195 201.608H152.293C155.206 201.608 157.576 199.237 157.576 196.323V169.266C157.576 166.353 155.206 163.982 152.293 163.982H121.195Z"
                            fill="#FF7470" class="bg-primary" />
                        <g opacity="0.61">
                            <path
                                d="M20.926 476.43C20.926 477.204 20.9763 477.982 21.0712 478.755C21.1199 479.152 21.1794 479.547 21.2503 479.942C22.9167 489.256 30.4942 497.904 31.9716 499.207C33.9805 500.976 40.8177 502 46.9772 502C53.1368 502 64.0256 501.14 65.9198 499.207C67.3707 497.725 72.0207 489.937 74.0783 482.414C74.1864 482.022 74.2871 481.629 74.3787 481.239C74.8294 479.347 75.0919 477.493 75.077 475.785C75.0621 474.144 74.7444 472.409 74.2335 470.638C74.1386 470.306 74.0362 469.971 73.9265 469.636C71.5074 462.189 66.1055 454.374 65.9198 450.861C65.9198 450.861 58.5783 453.8 49.3443 453.8C40.1079 453.8 31.1091 450.861 31.1091 450.861C30.344 454.957 24.7242 461.913 22.1747 469.504C22.0641 469.836 21.9577 470.17 21.8594 470.506C21.28 472.457 20.926 474.444 20.926 476.43Z"
                                fill="#A9B4D1" class="bg-primary" />
                            <path
                                d="M29.5238 451.765C29.5238 453.656 37.9407 455.189 48.3236 455.189C58.7064 455.189 67.1233 453.656 67.1233 451.765C67.1233 449.874 58.7064 448.342 48.3236 448.342C37.9407 448.342 29.5238 449.874 29.5238 451.765Z"
                                fill="#D3DAED" class="bg-primary" />
                            <path
                                d="M32.1863 451.766C32.1863 452.663 38.0958 453.405 45.7814 453.53C46.1602 453.536 46.5424 453.541 46.9286 453.541C47.2992 453.546 47.6714 453.547 48.0478 453.547C48.1229 453.547 48.1997 453.547 48.2748 453.546C48.6619 453.546 49.0432 453.544 49.422 453.54C49.5739 453.54 49.7241 453.537 49.8743 453.536C50.2597 453.532 50.6394 453.524 51.0166 453.517C51.6207 453.504 52.2108 453.487 52.7878 453.466C53.1765 453.453 53.5578 453.438 53.9317 453.42C59.7793 453.158 63.9118 452.516 63.9118 451.766C63.9118 451.018 59.8181 450.379 54.0118 450.115C53.6395 450.097 53.2574 450.081 52.8711 450.068C52.2265 450.044 51.5638 450.026 50.8862 450.012C50.509 450.004 50.1293 449.998 49.7439 449.994C49.5169 449.991 49.2866 449.988 49.0572 449.988C48.7246 449.985 48.3878 449.984 48.0486 449.984H47.91C47.4494 449.984 46.9947 449.988 46.5457 449.992C46.1586 449.996 45.7773 450.002 45.3984 450.009C37.9002 450.148 32.1863 450.883 32.1863 451.766Z"
                                fill="#A9B4D1" class="bg-primary" />
                            <path
                                d="M52.7874 453.465C53.1761 453.452 53.5574 453.437 53.9313 453.419C53.9461 452.416 53.9734 451.31 54.0113 450.114C54.6122 430.825 57.9119 388.062 60.4746 376.224C63.2032 363.612 66.1382 360.338 66.1671 360.306L65.2938 359.638C65.1667 359.776 62.1377 363.153 59.353 376.024C56.7853 387.89 53.4757 430.711 52.8699 450.067C52.8311 451.301 52.8039 452.438 52.7874 453.465Z"
                                fill="#A9B4D1" class="bg-primary" />
                            <path
                                d="M46.214 364.903C46.2412 365.281 48.9789 402.809 48.9789 417.657C48.9789 427.099 49.4196 441.019 49.7457 449.993C49.791 451.285 49.8356 452.475 49.8761 453.535C50.2615 453.531 50.6411 453.524 51.0183 453.516C50.9779 452.467 50.9333 451.29 50.8879 450.011C50.5636 441.047 50.1212 427.105 50.1212 417.657C50.1212 402.774 47.381 365.213 47.353 364.835L46.214 364.903Z"
                                fill="#A9B4D1" class="bg-primary" />
                            <path
                                d="M45.9982 415.717C45.8711 429.601 47.0555 441.694 47.9114 449.982C47.9493 450.35 47.9865 450.708 48.0228 451.06C48.1144 451.944 48.1994 452.774 48.2778 453.546C48.6649 453.546 49.0462 453.544 49.425 453.54C49.3433 452.742 49.255 451.882 49.1609 450.965C49.1287 450.644 49.0941 450.319 49.0594 449.987C48.206 441.717 47.0159 429.615 47.1413 415.726C47.3501 392.609 46.6469 388.5 44.8708 384.051L43.797 384.405C45.3924 388.402 46.2153 391.611 45.9982 415.717Z"
                                fill="#A9B4D1" class="bg-primary" />
                            <path
                                d="M37.0304 421.877C37.1072 422.034 43.3938 435.022 45.3978 450.007C45.5546 451.171 45.6833 452.347 45.7815 453.529C46.1604 453.535 46.5425 453.54 46.9288 453.54C46.8306 452.349 46.7002 451.163 46.545 449.99C44.5311 434.79 38.1512 421.614 38.0745 421.456L37.0304 421.877Z"
                                fill="#A9B4D1" class="bg-primary" />
                            <path
                                d="M58.7163 356.862C61.1659 362.293 60.8919 362.047 63.6123 363.526C65.31 364.451 74.2229 358.344 77.4872 356.862C77.97 356.644 78.6592 355.791 79.4895 354.481C79.558 354.373 79.6281 354.26 79.6983 354.145C80.8992 352.199 82.3699 349.378 83.9307 346.176C83.981 346.072 84.0322 345.969 84.0825 345.865C85.068 343.832 86.0898 341.652 87.1 339.451C87.1471 339.349 87.1949 339.246 87.2403 339.143C88.1168 337.229 88.9834 335.302 89.8088 333.442C89.8542 333.341 89.9004 333.239 89.9442 333.136C90.7992 331.216 91.6089 329.372 92.3401 327.697C92.3855 327.595 92.4301 327.493 92.4738 327.392C93.3619 325.358 94.132 323.588 94.7196 322.248C94.7683 322.136 94.8162 322.03 94.8616 321.927C95.1942 321.17 95.4624 320.57 95.6498 320.164C96.1508 319.085 96.3381 317.478 96.2993 315.649C96.2977 315.547 96.2944 315.443 96.2911 315.34C96.2374 313.761 96.022 312.034 95.7018 310.349C95.682 310.244 95.6613 310.137 95.6399 310.032C94.7081 305.335 92.9765 301.053 91.6328 301.324C91.6765 305.724 89.2286 309.763 87.9427 312.386C87.9427 312.386 87.7892 312.64 87.5085 313.095C87.7991 310.633 87.0777 305.581 86.6031 302.686C84.6545 303.387 82.327 304.437 79.8138 306.037C79.7123 306.101 79.6116 306.166 79.5101 306.231C78.3662 306.976 77.1859 307.835 75.9867 308.825C75.8934 308.902 75.8026 308.979 75.7094 309.058C74.4557 310.113 73.1847 311.316 71.9161 312.686C71.8294 312.779 71.7411 312.874 71.6553 312.971C71.6206 313.008 71.5884 313.045 71.5538 313.081C70.2695 314.503 69.0389 315.917 67.8735 317.31C67.7819 317.417 67.6944 317.525 67.6061 317.631C65.9381 319.634 64.4021 321.59 63.0164 323.456C62.9281 323.575 62.8398 323.693 62.7539 323.812C61.3847 325.669 60.1689 327.434 59.124 329.06C59.039 329.19 58.9573 329.319 58.8756 329.448C57.6747 331.342 56.7165 333.039 56.0339 334.467V334.469C55.9539 334.631 55.8804 334.79 55.8103 334.946C55.5511 335.514 55.3415 336.036 55.1822 336.502C54.2124 339.35 56.2683 351.433 58.7163 356.862Z"
                                fill="#D3DAED" class="bg-primary" />
                            <path
                                d="M63.7174 362.738C63.7851 362.519 70.5059 340.723 74.7209 334.221C78.2303 328.808 85.032 317.746 87.7936 313.24L87.2233 312.952C84.4633 317.455 77.6641 328.513 74.158 333.92C72.3678 336.681 69.9611 342.345 67.0023 350.754C64.8027 357.008 63.1042 362.524 63.0876 362.58L63.7174 362.738Z"
                                fill="#A9B4D1" />
                            <path
                                d="M84.043 318.569L84.0644 318.864C85.8455 318.753 92.653 316.752 96.3002 315.649C96.2985 315.547 96.2952 315.443 96.2919 315.339C92.681 316.431 85.7811 318.461 84.043 318.569Z"
                                fill="#A9B4D1" />
                            <path
                                d="M81.079 323.653C81.2424 323.666 81.438 323.672 81.66 323.672C84.363 323.672 91.1119 322.763 94.722 322.248C94.7707 322.136 94.8185 322.03 94.8639 321.927C91.0318 322.473 83.234 323.527 81.1087 323.358L81.079 323.653Z"
                                fill="#A9B4D1" />
                            <path
                                d="M68.6897 347.163C68.8515 347.168 69.0289 347.169 69.2204 347.169C72.5853 347.169 80.2388 346.511 83.9306 346.175C83.9809 346.071 84.0321 345.968 84.0824 345.864C80.2734 346.213 71.7402 346.953 68.6996 346.867L68.6897 347.163Z"
                                fill="#A9B4D1" />
                            <path
                                d="M65.7118 355.602C66.2161 355.658 66.8103 355.683 67.4665 355.683C71.1649 355.683 76.83 354.888 79.4901 354.481C79.5586 354.373 79.6288 354.26 79.6989 354.145C76.7483 354.6 69.1081 355.683 65.753 355.308L65.7118 355.602Z"
                                fill="#A9B4D1" />
                            <path
                                d="M79.5118 306.232C80.1581 310.388 81.4704 317.996 82.7761 320.607L83.0749 320.485C81.7873 317.91 80.4552 310.147 79.8156 306.038C79.714 306.101 79.6134 306.166 79.5118 306.232Z"
                                fill="#A9B4D1" />
                            <path
                                d="M75.7101 309.059C76.6237 313.005 78.8373 322.299 79.9879 325.089L80.2932 324.985C79.1311 322.17 76.8771 312.66 75.9874 308.826C75.8941 308.904 75.8025 308.98 75.7101 309.059Z"
                                fill="#A9B4D1" />
                            <path
                                d="M58.876 329.449C59.3233 331.475 60.1635 335.15 61.1886 338.989C63.252 346.709 65.0455 351.381 66.5187 352.876L66.7622 352.678C63.8182 349.693 60.1487 333.733 59.1244 329.061C59.0394 329.191 58.9577 329.32 58.876 329.449Z"
                                fill="#A9B4D1" />
                            <path
                                d="M55.8105 334.946C56.2183 336.676 56.9256 339.557 57.864 342.88C59.2679 347.856 61.4906 354.872 64.102 360.035L64.3991 359.911C61.7976 354.768 59.5816 347.772 58.1809 342.808C57.1658 339.206 56.4197 336.125 56.035 334.469C55.9542 334.632 55.8807 334.79 55.8105 334.946Z"
                                fill="#A9B4D1" />
                            <path
                                d="M37.2556 353.324C41.0431 358.766 46.5688 366.786 46.5688 366.786C49.5665 365.641 57.7745 358.069 60.4569 348.25C62.8702 339.422 59.2123 309.428 56.0165 300.669C53.505 302.111 50.8061 304.103 50.3241 306.257C51.2237 302.439 52.1234 299.034 52.7374 296.793C49.7224 295.22 46.3022 296.356 44.6738 299.258C42.622 302.911 34.4139 339.082 33.468 342.838C32.5222 346.592 33.468 347.881 37.2556 353.324Z"
                                fill="#A9B4D1" class="bg-primary" />
                            <path
                                d="M46.8926 366.821C47.7113 360.777 47.6024 349.552 47.5058 339.648C47.453 334.223 47.4035 329.1 47.5083 325.344C47.628 321.049 48.6828 314.648 50.643 306.319C51.5533 302.456 52.4563 299.045 53.0538 296.864L52.4199 296.721C51.8216 298.906 50.917 302.324 50.0041 306.195C48.0349 314.56 46.9759 320.998 46.8546 325.329C46.749 329.095 46.7993 334.223 46.8521 339.653C46.9487 349.539 47.0577 360.744 46.243 366.75L46.8926 366.821Z"
                                fill="#A9B4D1" class="bg-primary" />
                            <path
                                d="M4.95351 341.066C4.95681 341.17 4.96341 341.277 4.97001 341.382C5.05337 342.674 5.30097 344.072 5.78298 345.555C5.81764 345.664 5.85313 345.774 5.89275 345.885C6.435 347.462 7.24054 349.133 8.38695 350.876C8.71626 351.378 9.06951 351.909 9.44092 352.466C9.50777 352.567 9.57462 352.668 9.64313 352.77C10.7854 354.478 12.0977 356.404 13.495 358.43V358.432C13.5652 358.534 13.6353 358.636 13.7071 358.74C14.9724 360.573 16.3004 362.482 17.6308 364.378C17.7043 364.482 17.7777 364.586 17.8512 364.69C19.147 366.537 20.4411 368.366 21.6767 370.094C21.7485 370.195 21.8203 370.295 21.8921 370.394C23.542 372.701 25.0779 374.821 26.3572 376.551C26.4356 376.657 26.5124 376.761 26.5892 376.863C27.9419 378.687 28.9851 380.041 29.5365 380.667C32.0612 383.531 39.6387 387.685 44.6907 385.25C46.3207 384.463 49.169 377.624 47.8517 368.954C47.8319 368.822 47.8105 368.691 47.7882 368.557V368.555C47.3863 366.134 46.6591 363.575 45.4855 360.971C45.4384 360.864 45.3889 360.758 45.3386 360.649V360.648C45.1364 360.21 44.9193 359.77 44.6907 359.328C43.6284 357.285 42.5637 355.422 41.523 353.729C41.4644 353.634 41.4058 353.539 41.3464 353.446C39.7972 350.951 38.2992 348.831 36.9233 347.049C36.8548 346.961 36.788 346.874 36.7195 346.788C35.4418 345.147 34.2731 343.799 33.2712 342.712C33.1961 342.63 33.1226 342.55 33.0491 342.474C31.5734 340.887 30.493 339.89 30.0102 339.371C29.6462 338.98 28.6699 338.419 27.3625 337.782C27.2676 337.738 27.1702 337.691 27.072 337.643C25.2975 336.797 22.9915 335.835 20.7886 334.971C20.6871 334.931 20.5881 334.893 20.4882 334.854C18.7888 334.192 17.1686 333.597 15.9248 333.167C14.9402 335.058 14.2222 337.856 14.7479 341.833C12.8876 338.494 12.0564 334.552 11.6842 331.804C9.74712 331.251 8.2095 331.147 7.12417 332.711C6.194 334.047 4.77193 337.028 4.95351 341.066Z"
                                fill="#D3DAED" class="bg-primary" />
                            <path
                                d="M44.374 385.317L45.0087 385.18C43.4538 379.287 25.8871 356.23 18.3855 346.383C17.4718 345.184 16.7356 344.218 16.233 343.551C15.8022 342.978 15.401 342.356 15.0404 341.702C13.1974 338.395 12.3745 334.475 12.0089 331.769L11.361 331.841C11.7332 334.594 12.5726 338.586 14.4577 341.969C14.8307 342.645 15.2467 343.291 15.6949 343.886C16.1975 344.554 16.9345 345.521 17.849 346.722C24.6854 355.694 42.8471 379.533 44.374 385.317Z"
                                fill="#A9B4D1" class="bg-primary" />
                            <path
                                d="M39.0581 425.183C43.0107 422.834 48.189 416.775 48.189 414.177C48.189 411.581 32.1071 400.025 30.335 398.074C30.335 398.074 29.1086 401.317 28.0183 401.811C26.928 402.306 28.0183 397.731 25.4292 395.875C22.8401 394.021 12.0734 385.735 9.48347 381.283C6.89436 376.831 7.23605 376.213 6.45198 377.079C5.6679 377.945 5.28328 379.923 5.28328 379.923C5.28328 379.923 4.71379 375.842 3.62268 374.729C2.5324 373.616 0.6242 374.358 0.215653 375.965C-0.192894 377.573 0.0794709 381.406 0.215653 383.385C0.351835 385.364 5.12234 389.241 8.66556 393.486C12.2088 397.73 28.2931 416.402 31.29 419C34.2885 421.596 39.0581 425.183 39.0581 425.183Z"
                                fill="#A9B4D1" class="bg-primary" />
                            <path
                                d="M55.834 412.217C55.834 412.217 71.92 407.491 76.4974 399.9C81.0748 392.31 92.439 376.556 97.3324 373.979C102.225 371.401 106.013 370.398 106.013 370.398C106.013 370.398 98.9105 367.821 97.9638 367.963C97.0172 368.107 92.5966 372.26 92.5966 372.26C92.5966 372.26 94.4916 366.245 93.3865 366.245C92.2813 366.245 88.1777 365.157 85.8098 367.205C83.4427 369.253 82.8847 375.554 82.8847 375.554L80.9229 368.823C80.9229 368.823 74.6948 373.407 71.1764 376.701C67.6579 379.995 60.8711 388.688 59.9236 396.729C58.9777 404.77 55.834 412.217 55.834 412.217Z"
                                fill="#D3DAED" class="bg-primary" />
                            <path
                                d="M47.1828 440.715C47.1828 440.715 37.7152 431.032 29.9801 428.927C22.2449 426.823 14.8771 424.818 11.853 431.979C8.8281 439.139 14.6683 443.292 17.9828 444.295C21.2974 445.298 24.1383 445.298 26.1909 444.295C28.2427 443.292 28.4029 443.508 29.9801 445.047C31.5573 446.586 35.0296 449.594 39.2917 448.735C43.5529 447.876 43.8682 442.004 47.1828 440.715Z"
                                fill="#D3DAED" class="bg-primary" />
                            <path
                                d="M47.1827 442.29C47.1827 442.29 44.8148 431.119 52.5491 424.675C60.2834 418.231 77.9607 414.793 81.5914 414.363L80.0134 419.519C80.0134 419.519 85.2221 418.087 85.8535 416.511C86.4849 414.936 87.7477 418.516 86.6426 422.527C85.5374 426.537 76.5411 437.134 70.701 439.569C64.8608 442.004 47.1827 442.29 47.1827 442.29Z"
                                fill="#A9B4D1" class="bg-primary" />
                            <path
                                d="M47.391 442.281C47.5676 442.096 65.1591 423.557 80.0451 419.618L79.9873 419.439C72.1011 421.526 63.4729 427.375 57.679 432.086C51.4129 437.181 46.942 441.847 46.8975 441.893L47.391 442.281Z"
                                fill="#A9B4D1" />
                            <path
                                d="M17.103 431.755C19.5485 432.66 21.9874 433.642 24.5451 434.345C25.8219 434.697 27.1243 434.994 28.4556 435.162L29.4427 435.285L29.9264 435.347L30.41 435.428L30.8929 435.511L31.3749 435.607C31.6959 435.673 32.0178 435.732 32.3364 435.808C34.8958 436.378 37.4189 437.105 39.8999 437.921C41.1379 438.335 42.3635 438.778 43.5669 439.26L44.4599 439.637C44.7562 439.765 45.0434 439.905 45.3356 440.039C45.4833 440.104 45.6245 440.176 45.764 440.252L46.1857 440.473C46.3302 440.543 46.4589 440.628 46.591 440.709L46.9871 440.952L47.3792 440.479L46.9516 440.218C46.8089 440.132 46.6677 440.041 46.5192 439.969L46.0784 439.741C45.9323 439.664 45.7854 439.589 45.6344 439.524C45.334 439.388 45.0368 439.245 44.7339 439.116L43.8228 438.736C42.5996 438.252 41.3591 437.811 40.1079 437.398C37.6013 436.588 35.0609 435.868 32.4685 435.304C32.1457 435.229 31.8181 435.17 31.4921 435.104L31.0026 435.009L30.5091 434.927L30.0147 434.846L29.5145 434.784L28.5315 434.666C27.2358 434.509 25.9573 434.224 24.6978 433.883C22.1731 433.202 19.749 432.242 17.2845 431.342L17.103 431.755Z"
                                fill="#A9B4D1" />
                            <path
                                d="M1.31775 382.49L10.659 392.997C13.7813 396.493 16.9011 399.991 20.0663 403.458C23.2835 406.884 26.3588 410.405 29.3969 413.96C30.9139 415.738 32.4152 417.527 33.8917 419.331C34.6296 420.234 35.3592 421.141 36.0772 422.055C36.4313 422.514 36.7903 422.972 37.1329 423.436L37.6446 424.133L38.1258 424.839L38.6895 424.54L38.1877 423.813L37.6644 423.109C37.3136 422.64 36.9505 422.183 36.5914 421.722C35.8643 420.808 35.1273 419.901 34.382 419C32.8914 417.2 31.3777 415.415 29.8475 413.643C26.7871 410.102 23.6781 406.583 20.4419 403.174C17.2593 399.727 14.1181 396.245 10.9751 392.764L1.57195 382.305L1.31775 382.49Z"
                                fill="#A9B4D1" />
                            <path
                                d="M102.226 370.436C99.7751 371.565 97.3956 372.803 95.0574 374.105C92.7233 375.413 90.4388 376.796 88.2318 378.278C87.125 379.015 86.0496 379.79 84.9873 380.581C83.9326 381.38 82.9017 382.206 81.9072 383.067C79.9296 384.799 78.0759 386.672 76.5828 388.79L76.4409 388.986L76.3105 389.19L76.0488 389.597L75.788 390.005L75.5553 390.427L74.635 392.086C73.9681 393.158 73.2509 394.208 72.4693 395.222C70.9201 397.259 69.2356 399.214 67.4925 401.122C65.746 403.028 63.9336 404.886 62.0567 406.687C60.1766 408.482 58.2395 410.239 56.1621 411.823L56.5781 412.279C58.686 410.655 60.6198 408.882 62.5016 407.068C64.3784 405.249 66.1876 403.375 67.9324 401.452C69.6739 399.527 71.3559 397.555 72.9067 395.494C73.6892 394.468 74.4105 393.401 75.0832 392.306L76.001 390.631L76.2255 390.218L76.478 389.819L76.7314 389.42L76.8577 389.22L76.9963 389.027C78.4465 386.946 80.2672 385.085 82.2183 383.361C83.1996 382.503 84.2181 381.678 85.2622 380.88C86.3129 380.09 87.3784 379.315 88.4761 378.576C90.6633 377.09 92.9321 375.703 95.2514 374.389C97.5731 373.082 99.9443 371.834 102.371 370.702L102.226 370.436Z"
                                fill="#A9B4D1" />
                            <path
                                d="M24.5994 355.228L24.885 355.374C24.9452 355.273 29.6671 347.623 33.2705 342.712C33.1954 342.63 33.122 342.55 33.0485 342.474C29.4847 347.31 24.8528 354.817 24.5994 355.228Z"
                                fill="#A9B4D1" />
                            <path
                                d="M28.5376 360.539L28.8331 360.662C28.89 360.55 33.3147 351.849 36.9231 347.048C36.8546 346.96 36.7878 346.873 36.7193 346.787C35.5357 348.346 34.1458 350.489 32.557 353.199C30.3459 356.974 28.5541 360.503 28.5376 360.539Z"
                                fill="#A9B4D1" />
                            <path
                                d="M36.58 371.706L36.8523 371.869C36.9208 371.776 41.2506 365.813 45.4863 360.969C45.4392 360.863 45.3897 360.757 45.3394 360.648C41.1433 365.422 36.8589 371.319 36.58 371.706Z"
                                fill="#A9B4D1" />
                            <path
                                d="M40.4862 376.834L40.7454 377.015C40.8007 376.95 44.5354 372.516 47.8516 368.953C47.8318 368.821 47.8103 368.69 47.7881 368.556C44.4867 372.086 40.7165 376.561 40.4862 376.834Z"
                                fill="#A9B4D1" />
                            <path
                                d="M9.44128 352.466C9.50814 352.567 9.57499 352.667 9.6435 352.77C15.6099 353.137 23.7264 354.274 23.8477 354.291L23.8981 353.998C23.4004 353.928 15.3508 352.801 9.44128 352.466Z"
                                fill="#A9B4D1" />
                            <path
                                d="M13.4941 358.432C13.5643 358.534 13.6345 358.636 13.7063 358.74C14.7586 358.809 15.9372 358.896 17.2561 359.004C22.7661 359.456 28.1127 360.066 28.1672 360.074L28.2076 359.779C27.6786 359.718 19.9492 358.839 13.4941 358.432Z"
                                fill="#A9B4D1" />
                            <path
                                d="M26.3564 376.55C26.4349 376.656 26.5116 376.76 26.5884 376.862C33.3224 377.349 41.2449 378.975 41.3538 378.998L41.4273 378.709C41.3167 378.686 33.1837 377.018 26.3564 376.55Z"
                                fill="#A9B4D1" />
                            <path
                                d="M67.1234 451.765C67.6896 452.75 68.3904 454.113 67.3339 455.189C65.7336 456.819 55.1559 458.044 47.4521 458.044C39.7491 458.044 31.258 456.547 29.3605 455.189C28.4889 454.564 28.5203 452.524 29.5239 451.765C29.5239 451.765 30.3592 455.186 47.8136 455.186C65.2681 455.185 67.1234 451.765 67.1234 451.765Z"
                                fill="#D3DAED" />
                            <path
                                d="M21.8595 470.506C25.1221 471.46 29.3561 472.052 32.8531 472.411C38.236 472.96 44.6729 473.248 51.3723 473.248C53.0353 473.248 54.7149 473.231 56.3994 473.194C59.5267 473.127 62.6391 472.594 65.6483 472.079C67.1347 471.825 68.674 471.56 70.1869 471.359C71.4827 471.187 72.8783 471.001 74.2327 470.638C74.1378 470.306 74.0355 469.972 73.9257 469.637C72.6349 469.984 71.2763 470.166 70.0202 470.334C68.4842 470.539 66.9342 470.804 65.4353 471.059C62.4715 471.567 59.4062 472.093 56.3722 472.158C41.7107 472.471 28.7313 471.414 22.1731 469.505C22.0634 469.837 21.9577 470.171 21.8595 470.506Z"
                                fill="#D3DAED" />
                            <path
                                d="M21.072 478.755C21.1207 479.152 21.1801 479.547 21.2511 479.943C25.6024 481.539 30.1475 482.674 34.5854 483.781C35.5272 484.016 40.5477 484.311 46.5191 484.375C47.205 484.383 47.9882 484.387 48.8466 484.387C53.4083 484.387 60.1052 484.246 65.5822 483.556C66.3984 483.452 67.2452 483.397 68.0632 483.343C69.1501 483.272 70.2751 483.196 71.3811 483.011C72.2881 482.86 73.191 482.66 74.0791 482.414C74.1872 482.022 74.2879 481.63 74.3795 481.24C73.3289 481.559 72.2559 481.812 71.1739 481.992C70.129 482.167 69.0379 482.239 67.9798 482.309C67.1446 482.364 66.2788 482.422 65.4254 482.528C53.9382 483.975 36.3253 483.142 34.8892 482.782C30.2788 481.63 25.5487 480.45 21.072 478.755Z"
                                fill="#D3DAED" />
                        </g>
                        <path d="M537.377 16.6794L474.458 6.71008L468.413 44.8612L531.332 54.8306L537.377 16.6794Z"
                            fill="#D3DAED" class="bg-primary" />
                        <path
                            d="M534.512 20.1104L509 31.709L507.885 32.2158L505.392 33.3482C504.396 33.8005 503.339 33.9375 502.329 33.7774C501.314 33.6164 500.347 33.1559 499.537 32.4106L497.542 30.5775L496.645 29.7521L476.104 10.8583L476.756 9.92566L497.756 29.2421L498.656 30.0683L500.188 31.478C501.533 32.7151 503.401 33.0139 505.063 32.2571L506.978 31.3863L508.094 30.8796L534.182 19.0218L534.512 20.1104Z"
                            fill="#E9EFF4" />
                        <path
                            d="M497.757 29.2422L498.656 30.0684L497.543 30.5784L471.603 42.4576L471.271 41.3707L496.646 29.7531L497.757 29.2422Z"
                            fill="#E9EFF4" />
                        <path
                            d="M529.679 50.6227L529.029 51.5561L507.885 32.2166L506.978 31.3871L508.095 30.8804L509 31.7098L529.679 50.6227Z"
                            fill="#E9EFF4" />
                        <path
                            d="M620.536 39.0332L597.74 87.1377L585.408 73.2067L576.62 82.0222L575.615 83.0267L574.953 73.8323L574.39 65.956L573.958 65.8355L552.861 60.191L620.536 39.0332Z"
                            fill="#FFC727" class="bg-primary" />
                        <path
                            d="M617.57 41.6304L583.134 69.9571L583.114 69.9736L576.62 82.022L575.615 83.0265L574.953 73.8321L574.39 65.9558L573.958 65.8353L617.57 41.6304Z"
                            fill="#A9B4D1" />
                        <path d="M585.408 73.2067L576.619 82.0222L583.113 69.9738L583.134 69.9573L585.408 73.2067Z"
                            fill="#323B52" class="bg-primary" />
                    </svg>
                </div>
            </div>
            <div class="col-lg-6 col-12">
                <div class="login-form-wrp">
                    <h2 class="mb-4 text-center">{{ __('Set a New Password') }}</h2>


                    <form method="POST" class="needs-validation create-form mb-0" novalidate
                        action="{{ route('password.update') }}">
                        <input type="hidden" name="token" value="{{ $request->route('token') }}">
                        @csrf
                        <div class="row">
                            <div class="form-group mb-3">
                                <label for="email" class="form-label d-flex">{{ __('Enter Email address') }}</label>
                                <input type="email" class="form-control {{ $errors->has('email') ? 'is-invalid' : '' }}"
                                    id="email" name="email" placeholder="{{ __('Enter your email') }}" required=""
                                    value="{{ old('email') }}">
                                <div class="invalid-feedback d-block">
                                    {{ $errors->first('email') }}
                                </div>
                            </div>

                            <div class="form-group mb-3">
                                <label for="email" class="form-label d-flex">{{ __('Enter Password') }}</label>
                                <input type="password"
                                    class="form-control {{ $errors->has('password') ? ' is-invalid' : '' }}"
                                    id="password" name="password" placeholder="{{ __('Enter Password') }}" required=""
                                    value="{{ old('password') }}">
                                <div class="invalid-feedback d-block">
                                    {{ $errors->first('password') }}
                                </div>
                            </div>

                            <div class="form-group mb-3">
                                <label for="email" class="form-label d-flex">{{ __('Enter Confirm Password') }}</label>
                                <input type="password"
                                    class="form-control {{ $errors->has('password_confirmation') ? ' is-invalid' : '' }}"
                                    id="password_confirmation" name="password_confirmation"
                                    placeholder="{{ __('Enter Confirm Password') }}" required="">
                                <div class="invalid-feedback d-block">
                                    {{ $errors->first('password_confirmation') }}
                                </div>
                            </div>

                            <div class="form-group mb-3 text-center">
                                <button
                                    class="btn btn-primary btn-submit btn-block">{{ __('Reset Password') }}</button>

                            </div>
                            <p class="text-center mb-0">
                                {{ __('Click here to') }}
                                <a href="{{ route('login') }}">{{ __('Login') }}</a>
                            </p>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        @include('layouts.footer')
    </div>
</div>
@endsection